<?php
/****************************************************************/
/*
/* Template archive
/*
/****************************************************************/

//Template Archive loop
function seatheme_interface_archive_loop(){
	seatheme_get_template_part('archive/loop', false);
}

//Template Archive Title
function seatheme_interface_archive_titlewrap(){
	seatheme_get_template_part('archive/content', 'title');
}

/****************************************************************/
/*
/* Template page
/*
/****************************************************************/

//Template Page content before
function seatheme_interface_page_content_before(){
	seatheme_get_template_part('page/content', 'before');
}

//Template Page content after
function seatheme_interface_page_content_after(){
	seatheme_get_template_part('page/content', 'after');
}

//Template page content
function seatheme_interface_page_content(){
	seatheme_get_template_part('page/content', false);
}

//Template Page content
function seatheme_interface_page_comment(){
	comments_template();
}

//Template Page Title
function seatheme_interface_page_title(){
	if(is_page()){
		$page_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_template');
		
		if($page_template == 'none-template'){
			seatheme_get_template_part('page/content', 'title');
		}
	}
}

/****************************************************************/
/*
/* Template single
/*
/****************************************************************/

//Template single content before
function seatheme_interface_single_content_before(){
	seatheme_get_template_part('single/content', 'before');
}

//Template single content after
function seatheme_interface_single_content_after(){
	seatheme_get_template_part('single/content', 'after');
}

//Template Single content
function seatheme_interface_single_content(){
	
	//Title
	seatheme_interface_content_titlewrap();

	//** post format
	if ( is_singular( 'post' ) ) {
		$post_format = !get_post_format() || get_post_format() == 'aside' || get_post_format() == 'status' || get_post_format() == 'chat' ? 'standard' : get_post_format();
		seatheme_get_template_part('single/format', $post_format);
	
	// ** post type attachment
	} elseif ( is_singular( 'attachment' ) ) { ?>
		<div class="entry"><?php the_content(); ?><div class="clear"><?php wp_link_pages(); ?></div></div><!--End entry-->
	<?php
	//** post type for ux-portfolio
	} elseif ( is_singular( 'ux-portfolio' ) ) {
		seatheme_get_template_part('single/type', get_post_type()); 
	} else { ?>
		<div class="entry"><?php the_content(); ?><div class="clear"><?php wp_link_pages(); ?></div></div><!--End entry-->
	<?php  
	}
}

//Template Single content
function seatheme_interface_single_comment(){
	comments_template();
}

//Template Single Navi
function seatheme_interface_single_navi(){
	$enable_navi = seatheme_get_option('theme_option_show_normal_post_navigation');
	if(is_singular('post') && $enable_navi){
		seatheme_get_template_part('single/content', 'navi');
	}
}

/****************************************************************/
/*
/* Template global
/*
/****************************************************************/

//Template jplayer
function seatheme_interface_jplayer(){
	seatheme_get_template_part('global/site', 'jplayer');
}

//Template Page Loading
function seatheme_interface_page_loading(){
	seatheme_get_template_part('global/page', 'loading');
}

//Template Wrap Outer before
function seatheme_interface_wrap_outer_before(){
	seatheme_get_template_part('global/wrapouter', 'before');
}

//Template Wrap Outer after
function seatheme_interface_wrap_outer_after(){
	seatheme_get_template_part('global/wrapouter', 'after');
}

//Template Content before
function seatheme_interface_content_before(){
	seatheme_get_template_part('global/content', 'before');
}

//Template Content after
function seatheme_interface_content_after(){
	seatheme_get_template_part('global/content', 'after');
}

//Template Content titlewrap
function seatheme_interface_content_titlewrap(){
	seatheme_get_template_part('global/content', 'titlewrap');
}

//Template Sidebar Weiget
function seatheme_interface_sidebar_widget(){
	seatheme_get_template_part('global/sidebar', 'widget');
}

//Template Header
function seatheme_interface_header(){
	$header_switch = true;
	
	if(is_page()){
		$page_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_template');
		$page_show_header = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_show_header');
		if($page_template == 'none-template' && $page_show_header){
			$header_switch = true;
		}else{
			$header_switch = false;
		}
	}

	if(is_singular('ux-portfolio')){
		$portfolio_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_template');
		$portfolio_show_header = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_show_header');
		if($portfolio_template === 'none' && $portfolio_show_header){
			$header_switch = true;
		}elseif($portfolio_template ==='on_left'||$portfolio_template ==='on_right'){
		}else{
			$header_switch = false;
		}
	}
	
	if($header_switch){
		seatheme_get_template_part('global/header', false);
	}
}

//Template 
function seatheme_interface_header_portfolio_icon(){
	$seatheme_sportfolio_icon = seatheme_get_option('theme_option_portfolio_icon');
	if($seatheme_sportfolio_icon) { 
		seatheme_get_template_part('global/header', 'icon');
	}
}

//Template social bar
function seatheme_interface_social_bar_and_navi($module_post = false){
	if(!is_singular('ux-portfolio')){
		$show_share = true;
		$show_navi = seatheme_get_option('theme_option_show_normal_post_navigation');
		$share_buttons = array('facebook', 'twitter', 'google-plus', 'pinterest', 'digg', 'reddit', 'linkedin', 'stumbleupon', 'tumblr', 'mail');
		$share_buttons = seatheme_get_option('theme_option_share_buttons');
		
		$enable_share_button_other = seatheme_get_option('theme_option_show_share_button_other');
		if(!$enable_share_button_other){
			$show_share = false;
		}
		
		if($show_navi || $show_share) {
		?>
		
		<div class="blog-unit-meta-bottom">
		
		<?php
		}
	
		if($show_share){  ?>
			
			<div class="social-bar">
				<ul class="post_social post-meta-social">
					<?php if(is_array($share_buttons)){
		
						$post_link = get_permalink();
						$post_link_pure = preg_replace('#^https?://#', '', rtrim($post_link,'/'));
						?>
	
					<?php
						//facebook
						if(in_array('facebook', $share_buttons)){ ?>
					
							<li class="post-meta-social-li">
								<a class="share postshareicon-facebook-wrap" href="javascript:void(0)" onclick="window.open('http://www.facebook.com/sharer.php?u=<?php echo esc_url($post_link); ?>','Facebook','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;">
								<span class="fa fa-facebook postshareicon-facebook"></span>
								</a>
							</li>
						
						<?php }
						
						//twitter
						if(in_array('twitter', $share_buttons)){ ?>
						
							<li class="post-meta-social-li">
								<a class="share postshareicon-twitter-wrap" href="javascript:void(0)" onclick="window.open('http://twitter.com/share?url=<?php echo esc_url($post_link); ?>&amp;text=<?php echo esc_attr(get_the_title()); ?>','Twitter share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" >
								<span class="fa fa-twitter postshareicon-twitter"></span>
								</a>
							</li>
						
						<?php }
						
						//pinterest
						if(in_array('pinterest', $share_buttons)){
							$image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
							$thumbnail = $image ? $image[0] : false; ?>
							
							<li class="post-meta-social-li">
								<a class="share postshareicon-pinterest-wrap" href="javascript:void(0)" onclick="javascript:window.open('http://pinterest.com/pin/create/bookmarklet/?url=<?php echo esc_url($post_link); ?>&amp;is_video=false&amp;media=<?php echo esc_url($thumbnail); ?>','', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
								<span class="fa fa-pinterest  postshareicon-pinterest"></span>
								</a>
							</li>
					
						<?php }
	
						//Digg
						if(in_array('digg', $share_buttons)){ ?>
				
							<li class="post-meta-social-li">
								<a class="share postshareicon-digg-wrap" href="javascript:void(0)" onclick="window.open('http://www.digg.com/submit?url=<?php echo esc_url($post_link); ?>','Digg','width=715,height=330,left='+(screen.availWidth/2-357)+',top='+(screen.availHeight/2-165)+''); return false;">
								<span class="fa fa-digg postshareicon-digg"></span>
								</a>
							</li>
						
						<?php }
	
						//Readdit
						if(in_array('reddit', $share_buttons)){ ?>
				
							<li class="post-meta-social-li">
								<a class="share postshareicon-reddit-wrap" href="javascript:void(0)" onclick="window.open('http://reddit.com/submit?url=<?php echo esc_url($post_link); ?>&amp;title=<?php echo esc_attr(get_the_title()); ?>','Reddit','width=617,height=514,left='+(screen.availWidth/2-308)+',top='+(screen.availHeight/2-257)+''); return false;">
								<span class="fa fa-reddit postshareicon-reddit"></span>
								</a>
							</li>
						
						<?php }
	
						//linkedin
						if(in_array('linkedin', $share_buttons)){ ?>
				
							<li class="post-meta-social-li">
								<a class="share postshareicon-linkedin-wrap" href="javascript:void(0)" onclick="window.open('http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url($post_link); ?>','Linkedin','width=863,height=500,left='+(screen.availWidth/2-431)+',top='+(screen.availHeight/2-250)+''); return false;">
								<span class="fa fa-linkedin postshareicon-linkedin"></span>
								</a>
							</li>
						
						<?php }
	
						//stumbleupon
						if(in_array('stumbleupon', $share_buttons)){ ?>
				
							<li class="post-meta-social-li">
								<a class="share postshareicon-stumbleupon-wrap" href="javascript:void(0)" onclick="window.open('http://www.stumbleupon.com/submit?url=<?php echo esc_url($post_link); ?>&amp;title=<?php echo esc_attr(get_the_title()); ?>','Stumbleupon','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;">
								<span class="fa fa-stumbleupon postshareicon-stumbleupon"></span>
								</a>
							</li>
						
						<?php }
	
						//tumblr
						if(in_array('tumblr', $share_buttons)){ ?>
				
							<li class="post-meta-social-li">
								<a class="share postshareicon-tumblr-wrap" href="javascript:void(0)" onclick="window.open('http://www.tumblr.com/share/link?url=<?php  echo esc_attr($post_link_pure); ?>&amp;name=<?php echo esc_attr(get_the_title()); ?>','Tumblr','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;">
								<span class="fa fa-tumblr postshareicon-tumblr"></span>
								</a>
							</li>
						
						<?php }
	
						//mail
						if(in_array('mail', $share_buttons)){  ?>
				
							<li class="post-meta-social-li">
								<a class="share postshareicon-mail-wrap" href="mailto:?Subject=<?php echo esc_attr(str_replace(' ', '-', get_the_title())); ?>&amp;Body=<?php echo esc_url($post_link); ?>" >
								<span class="fa fa-envelope-o postshareicon-mail"></span>
								</a>
							</li>
							
						<?php }
		
					} ?>
				</ul>
			</div>
	
	<?php
	
		} 
	
		seatheme_interface_single_navi();
	
		if($show_navi || $show_share) { ?>

            </div>
        
        <?php
		}
	}

}

//Template footer
function seatheme_interface_footer(){
	$footer_switch = false;
	
	if(is_page()){
		$page_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_template');
		$page_show_footer = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_show_footer');
		if($page_template == 'none-template' && $page_show_footer){
			$footer_switch = true;
		}else{
			$footer_switch = false;
		}
	}
	
	seatheme_get_template_part('global/footer', false);
	
}

//Template footer info
function seatheme_interface_footer_info(){
	seatheme_get_template_part('global/footer', 'info');
}

//Template footer social
function seatheme_interface_footer_social(){
	seatheme_get_template_part('global/footer', 'social');
}

//Template header social
function seatheme_interface_header_social(){
	seatheme_get_template_part('global/header', 'social');
}

//Template menu hidden panel
function seatheme_interface_menu_hidden_panel(){
	seatheme_get_template_part('global/menu-hidden', 'panel');
}

//Template photoswipe
function seatheme_interface_photoswipe(){
	$switch = false;
	
	if ( class_exists( 'UX_ContentBuilder' ) ) {
		$switch = true;
	}
	
	if ( $switch ) {
		seatheme_get_template_part('global/photoswipe', false);
	}
}

//Template cookie_consent_bar
function seatheme_interface_cookie_consent_bar(){
	seatheme_get_template_part('global/cookie', 'consent-bar');
}

//Template related portflio popup
function seatheme_interface_related_portfolio_popup() {
	$seatheme_sportfolio_icon = seatheme_get_option('theme_option_portfolio_icon');
	if($seatheme_sportfolio_icon) {
		echo '<div id="portfolio-panel" class="portfolio-panel">';
		seatheme_interface_ajax_portfolio_featured_projects();
		echo '</div>';
	}
}
?>