<?php
// Theme Text Domain 
if(!function_exists('seatheme_theme_lang_setup')){
	add_action('after_setup_theme', 'seatheme_theme_lang_setup');
	function seatheme_theme_lang_setup(){
		$lang = get_template_directory()  . '/languages';
		load_theme_textdomain('sea-theme', $lang);
	}
}

// Theme Get Template
function seatheme_get_template_part($key, $name){
	get_template_part('template/' . $key, $name);
}


//theme interface get post meta
function seatheme_get_post_meta($post_id, $key){
	$get_post_meta = get_post_meta($post_id, 'ux_theme_meta', true);
	$return = false;
	
	if($get_post_meta){
		if(isset($get_post_meta[$key])){
			if($get_post_meta[$key] != ''){
				switch($get_post_meta[$key]){
					case 'true': $return = true; break;
					case 'false': $return = false; break;
					default: $return = $get_post_meta[$key]; break;
				}
			}
		}else{
			$return = 'null';
		}
	}else{
		$return = seatheme_theme_post_meta_default($key);
	}
	
	return $return;
}

//seatheme_support_gutberg_wide_image
function seatheme_support_gutberg_wide_image(){
	add_theme_support( 'align-wide' );
}
add_action('after_setup_theme', 'seatheme_support_gutberg_wide_image');


//theme front scripts
function seatheme_front_enqueue_scripts(){
	global $wp_styles; 
	$seatheme_header = seatheme_get_option( 'theme_option_header_layout' );
	$seatheme_header_mobile = seatheme_get_option( 'theme_option_header_layout_mobile' );
	$seatheme_default_font = seatheme_get_option( 'theme_option_enable_default_fonts' );
	$portfolio_template = seatheme_get_post_meta( get_the_ID(), 'theme_meta_project_template' );
	$seatheme_menuicon_enable = true;
	$seatheme_headericon_enable = seatheme_get_option( 'theme_option_portfolio_icon' );
	$seatheme_menuicon_style = seatheme_get_option( 'theme_option_menu_icon_style' );
	$seatheme_headericon_style = seatheme_get_option( 'theme_option_header_icon_style' );

	if ( ( $seatheme_header_mobile == 'show-menu-item-mobile' || $seatheme_header_mobile == 'logo-centered-mobile' ) && ( $seatheme_header == 'horizon-menu-right' || $seatheme_header == 'horizon-menu-center' || $seatheme_header == 'logo-centered' || $seatheme_header == 'navi-justified' ) ) {
		$seatheme_menuicon_enable = false;
	}

	// Queue CSS files

	// Default font
	if ( $seatheme_default_font ) {
		wp_enqueue_style('google-font-roboto');
	}

	// Icon font
	if ( ! wp_style_is( 'ux-interface-font-awesome', 'enqueued' ) ) {
		wp_enqueue_style('font-awesome-min'); 
	}
	
	// Bootstrap CSS
	wp_enqueue_style('bootstrap');

	// Photoswipe CSS
	wp_enqueue_style('photoswipe');
	
	// Archive&Post&Widget CSS
	if ( ! is_singular( 'ux-portfolio' ) && ! is_page() ) {
		wp_enqueue_style('seatheme-archive-style');
	}

	// Single portfolio CSS
	if ( is_singular( 'ux-portfolio' ) ) {
		if ( $portfolio_template == 'on_left' || $portfolio_template == 'on_right' ) {
			wp_enqueue_style('seatheme-post-portfolio-style');
		}
	}
	
	$archivePageLayout = seatheme_get_option( 'fieldWooSingleProductSlider' ); 
	if ( class_exists( 'Woocommerce' ) ) {
		if ( $archivePageLayout == 'wooCommerce' && is_product() ) {
			wp_enqueue_style( 'seatheme-interface-wc-product-gallery-slider' );
		}
	}

	if ( $seatheme_menuicon_enable ) {
		if ( $seatheme_menuicon_style == 'menu-icon-hamburg' ) {
			wp_enqueue_style( 'seatheme-menuicon-hamburg' );
		} else {
			wp_enqueue_style( 'seatheme-menuicon-default' );
		}
	}

	if ( $seatheme_headericon_enable ) {
		if ( $seatheme_headericon_style == 'header-icon-classic' ) {
			wp_enqueue_style( 'seatheme-headericon-classic' );
		} else {
			wp_enqueue_style( 'seatheme-headericon-default' );
		}
	}
	
	// Theme cookie bar
	if ( $cookieConsentBar = seatheme_get_option( 'theme_option_cookie_consent_bar' ) ) {
		wp_enqueue_style( 'seatheme-cookie-bar' );
	}

	// Theme main css
	wp_enqueue_style( 'seatheme-interface-style' );

	// RTL css
	if ( is_rtl() ) { 
		wp_enqueue_style( 'seatheme-rtl' );
	}

	// For lower version IE
	wp_enqueue_style( 'seatheme-interface-ie', SEA_LOCAL_URL . "/styles/ie.css", array( 'seatheme-interface-style' )  );
    $wp_styles->add_data( 'seatheme-interface-ie', 'conditional', 'lte IE 9' );
	
	// Custom css
	if ( is_rtl() ) { 
		wp_add_inline_style( 'seatheme-rtl', seatheme_theme_custom_css() );
	} else {
		wp_add_inline_style( 'seatheme-interface-style', seatheme_theme_custom_css() );
	}
	
	$page_inline_style = '';

	if ( is_page() ) {
		$page_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_template');
		$page_background = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_background');
		$page_background_color = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_background_color');
		$page_text_color = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_text_color');
		
		if ( $page_template == 'none-template' && $page_background == 'static-color' ) {
			$page_inline_style = '
				body{--color-bg:'.esc_attr( $page_background_color ).';--color-header-bg:'.esc_attr( $page_background_color ).';--color-pageloader-bg:'.esc_attr($page_background_color).'; --color-footer-bg:'.esc_attr($page_background_color).'; --color-menu:'.esc_attr($page_text_color).'; --color-menu-light:'.esc_attr($page_text_color).';--color-menu-hover:'.esc_attr($page_text_color).';--color-menu-current:'.esc_attr($page_text_color).'; --color-title:'.esc_attr($page_text_color).';--color-content:'.esc_attr($page_text_color).'; --color-footer-text:'.esc_attr($page_text_color).';}
			';
		}
	}
	if ( is_rtl() ) { 
		wp_add_inline_style( 'seatheme-rtl', $page_inline_style );
	} else {
		wp_add_inline_style( 'seatheme-interface-style', $page_inline_style );
	}
	
	if ( function_exists( 'ux_cb_module_inline_style' ) ) {
		if ( is_rtl() ) { 
			wp_add_inline_style( 'seatheme-rtl', ux_cb_module_inline_style() );
		} else {
			wp_add_inline_style( 'seatheme-interface-style', ux_cb_module_inline_style() );
		}
	}

	// Queue JS files 
	//modernizr library
	wp_enqueue_script('modernizr-custom');

	//underscorejs
	wp_enqueue_script('underscore');

	//jplayer plugin
	wp_enqueue_script('jplayer');

	//imagesloaded  plugin
	wp_enqueue_script('imagesloaded');

	// waypoints plugin
	wp_enqueue_script('waypoints');

	// lazyload
	wp_enqueue_script('lazyload');

	//wp comment
	wp_enqueue_script( 'comment-reply' );

	if ( is_singular('ux-portfolio') ) {
		//single portfolio 2-col and columns sticky
		if ( $portfolio_template == 'on_left' || $portfolio_template == 'on_right' ) {
			wp_enqueue_script( 'seatheme-interface-portfolio-2col' );
		}

		// photoswipe lightbox plugin
		wp_enqueue_script('photoswipe-min');

		// photoswipe skin
		wp_enqueue_script('photoswipe-ui-default-min');
	}

	//theme js
	wp_enqueue_script('seatheme-interface-theme'); 
	
	//inline script
	wp_add_inline_script( 'jquery', 'var ajaxurl = "' .esc_url( admin_url( 'admin-ajax.php' ) ). '";' );
	wp_add_inline_script( 'jquery', 'var JS_PATH = "' .esc_url( SEA_LOCAL_URL. '/js' ). '";' );
	
}
add_action('wp_enqueue_scripts', 'seatheme_front_enqueue_scripts',101);

//require theme interface register
require_once get_template_directory() . '/functions/interface/interface-register.php';

//require theme interface style
require_once get_template_directory() . '/functions/interface/interface-style.php';

//require theme interface functions
require_once get_template_directory() . '/functions/interface/interface-functions.php';

//require theme interface hook
require_once get_template_directory() . '/functions/interface/interface-hook.php';

//require theme interface template
require_once get_template_directory() . '/functions/interface/interface-template.php';

//require theme interface condition
require_once get_template_directory() . '/functions/interface/interface-condition.php';

//require theme interface ajax
require_once get_template_directory() . '/functions/interface/interface-ajax.php';


?>