<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Grid shortcode.
 */
function ux_cb_module_grid_shortcode($atts) {
	$moduleID = 'grid';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_grid' );
	
	$html = ux_cb_get_module_template($moduleID, $atts);
	return $html;
}
add_shortcode('ux_cb_grid', 'ux_cb_module_grid_shortcode');

/**
 * UX Content Builder Module Grid container.
 */
function ux_cb_module_grid_container($module=array(), $moduleUnique=false) {
	$html = '';
	$echo = false;
	
	if(isset($_POST['action']) && $_POST['action'] == 'ux_cb_module_grid_container'){
		$moduleUnique = $_POST['moduleUnique'];
		$echo = true;
		
		$module = array();
		$module['id'] = 'grid';
		$module['ajax'] = true;
		$module['paged'] = 1;
		$module['postID'] = $_POST['postID'];
		$module['unique'] = $moduleUnique;
		$module['is_frontend'] = true;
	}
	
	$post_id = ux_cb_get_the_module_post_id($moduleUnique);
	
	//source
	$source = get_post_meta($post_id, '__ux_cb_module_grid_source', true);
	if(!$source){
		$source = 'ux-portfolio';
	}
	
	//taxonomy
	$taxonomy = get_post_meta($post_id, '__ux_cb_module_grid_category_' .$source. '_tax', true);
	if(!$taxonomy){
		$taxonomy = 'ux-portfolio-cat';
	}
	
	//category
	$category = get_post_meta($post_id, '__ux_cb_module_grid_category_' .$source, true);
	if($category){
		if($category == '0'){
			$category = false;
		}
	}
	
	if(isset($_POST['catID'])){
		if(intval($_POST['catID']) != 0){
			$category = $_POST['catID'];
		}
	}
	
	//per page
	$perPage = intval(esc_attr(get_post_meta($post_id, '__ux_cb_module_grid_post_number_perpage', true)));
	if(!$perPage || $perPage == ''){
		$perPage = -1;
	}
	if(isset($_POST['postNumber'])){
		$perPage = $_POST['postNumber'];
	}
	
	//post not in
	$post__not_in = array();
	if(isset($_POST['post__not_in'])){
		$post__not_in = $_POST['post__not_in'];
	}
	
	//orderby
	$orderby = get_post_meta($post_id, '__ux_cb_module_grid_orderby', true);
	if(!$orderby){
		$orderby = 'date';
	}
	
	//order
	$order = get_post_meta($post_id, '__ux_cb_module_grid_orderby_order', true);
	if(!$order){
		$order = 'DESC';
	}
	
	//paged
	$paged = 1;
	if(isset($module['paged'])){
		$paged = $module['paged'];
	}
	
	//query
	$query_args = array(
		'posts_per_page' => $perPage,
		'post__not_in' => $post__not_in,
		'orderby' => $orderby,
		'order' => $order,
		'post_type' => $source,
		'paged' => $paged,
		'post_status' => 'publish'
	);
	
	if($category){
		$query_args['tax_query'] = array(
			array(
				'taxonomy' => $taxonomy,
				'field' => 'term_id',
				'terms' => intval($category),
			)
		);
	}
	
	$the_query = new WP_Query($query_args);
	
	$max_num_pages = intval($the_query->max_num_pages);
	$found_posts = intval($the_query->found_posts);
	
	//media query
	$media_query = false;
	$post__in = array();
	if($source == 'attachment'){
		$media_images = get_post_meta($post_id, '__ux_cb_module_grid_media_images', true);
		$imageIndex = 0;
		$media_post_not_in = array();
		
		if($media_images){
			$post__in = $media_images;
			$found_posts = count($media_images);
			if($perPage == -1){
				$perPage = $found_posts;
			}
			
			$max_num_pages = ceil($found_posts/$perPage);
			$media_query = array();
			
			if(isset($_POST['catID'])){
				foreach($media_images as $num => $image){
					if(in_array($num, $post__not_in)){
						//array_push($media_post_not_in, $image);
						unset($media_images[$num]);
					}
				}
				
				//query
				$media_query_args = array(
					'posts_per_page' => -1,
					'post_type' => $source,
					'post_status' => 'inherit',
				);
				
				if($_POST['catID']){
					$media_query_args['tax_query'] = array(
						array(
							'taxonomy' => 'ux-attachment-cat',
							'field' => 'term_id',
							'terms' => intval($_POST['catID']),
						)
					);
				}
				
				$attachment_post = get_posts($media_query_args);
				
				foreach($media_images as $num => $image){
					if($attachment_post){
						foreach($attachment_post as $post){
							if($post->ID == $image){
								$imageIndex++;
								if($imageIndex <= $perPage){
									$media_query[$num] = $image;
								}
							}
						}
					}
				}
			}else{
				foreach($media_images as $num => $image){
					$imageIndex++;
					if($imageIndex <= $perPage){
						$media_query[$num] = $image;
					}
				}
			}
		}
	}
	
	//what thumb
	$whatThumb = ''; 
	if($source == 'ux-portfolio' || $source == 'post'){
		$whatThumb = get_post_meta($post_id, '__ux_cb_module_grid_style_image_what_thumb_does', true);
	}elseif($source == 'attachment'){
		$whatThumb = get_post_meta($post_id, '__ux_cb_module_grid_attachment_what_thumb_does', true); 
	}
	$open2ndLightbox = get_post_meta($post_id, '__ux_cb_module_grid_style_open_2nd_lighbox', true);

	//open in new window
	$openNewTabTarget = '';
	$rel = '';
	$openNewTab = get_post_meta($post_id, '__ux_cb_module_grid_what_thumb_does_new_tab', true); 
	if ( $whatThumb === 'open-the-portfolio-item' && $openNewTab === 'on' ) {
		$openNewTabTarget = 'target="_blank"';
		$rel .= 'noopener noreferrer';
	}
	if ( get_post_meta($post_id, '__ux_cb_module_grid_what_thumb_does_nofollow', true) == 'on' ) {
		$rel .= ' nofollow';
	}
	
	//image style
	$imageStyle = get_post_meta($post_id, '__ux_cb_module_grid_item_style', true);
	
	//mouseover effect
	$mouseoverEffect = false;
	switch($imageStyle){ 
		case 'image': 
			if ( $source == 'attachment' ) {
				$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mouseover_effect-attachment', true);
			} else {
				$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mouseover_effect', true);
			} 
		break;
		case 'image-text': 
			if ( $source == 'attachment' ) {
				$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_mouseover_effect-attachment', true);
			} else {
				$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_mouseover_effect', true); 
			}
		break;
				
	}

	//mouseover effect on touch screen
	$tapOnce = get_post_meta($post_id, '__ux_cb_module_grid_style_touch_once', true);
	$touchTabClass = false;
	
 	if ( $imageStyle == 'image' && ( $whatThumb == 'open-the-portfolio-item' || $source == 'product' ) ) {
		if ( $mouseoverEffect == 'static-color-mask-text' || $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text' ) {
			if ( $tapOnce === 'off' ) { 
				$touchTabClass = 'bm-touch-tab'; 
			}
		}
	}
		
	//text align
	$textAlign = false;
	switch($imageStyle){
		case 'image': $textAlign = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_align', true); break;
		case 'image-text': $textAlign = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_text_align', true); break;
	}

	$showText = false;
	if ( $source === 'post' || $source === 'ux-portfolio' ) {

		if ( $imageStyle === 'image-text' ) {

			$showText = 'on';

		} elseif( $imageStyle === 'image' ) {

			if ( $mouseoverEffect == 'static-color-mask-text' || $mouseoverEffect == 'second-featured-image-text' ) {
				$showText = 'on';
			}
		}

	} elseif ( $source === 'product' ) {

		if ( $imageStyle === 'image-text' ) {

			$showText = 'on';

		} elseif( $imageStyle === 'image' ) {

			if ( $mouseoverEffect == 'static-color-mask-text' || $mouseoverEffect == 'second-featured-image-text' ) {

				$showText = 'on';
			}
		}
	}

	//textGroup
	$textGroup = array();
	if( $source === 'post' || $source === 'ux-portfolio' ) {

		if ( $imageStyle === 'image-text' ) {
			$textGroup = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_text_group', true );
			
			
		} elseif ( $imageStyle === 'image' ) {
			$textGroup = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_group', true );
		}
		
	} elseif ( $source === 'product' ) {

		if ( $imageStyle === 'image-text' ) {
			$textGroup = get_post_meta( $post_id, '__ux_cb_module_grid_product_image_text_text_group', true );
		} elseif ( $imageStyle === 'image' ) {
			$textGroup = get_post_meta( $post_id, '__ux_cb_module_grid_product_text_group', true );
		}
	}
	
	if ( ! is_array( $textGroup ) ) { $textGroup = array( $textGroup ); }
	
	if(isset($module['ajax'])){
		if($source == 'attachment'){
			if($media_query){
				foreach($media_query as $num => $imagePost){
					$html .= ux_cb_module_grid_templates_attachment($imagePost, $post_id, $module, $num);
				}
			}
		} else {
			if ( $the_query->have_posts() ) {
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					global $product;
					
					$loop_post_id = get_the_ID();
					
					//post class
					$postClass = 'post--' .$loop_post_id;
					
					//classes
					$classes = array();
					$postTerms = get_the_terms($loop_post_id, $taxonomy);
					if($postTerms){
						foreach($postTerms as $term){
							$classes[] = sanitize_html_class('filter_' . $term->slug);
						}
					}
					$classes = array_unique($classes);
					
					//lightbox
					$whatThumbData = '';
					if($whatThumb == 'open-lightbox' && has_post_thumbnail()){
						$whatThumbData = 'data-lightbox="true"';
					}
					
					//padding left right
					$gridPadingClass = $textAlign !='grid-text-center' ? 'standard-text-padding' : false;
					
					//thumbnail
					$thumbWidth = 650;
					$thumbHeight = 490;
					$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
					$thumbUrl = $thumbBlank;
					$thumbCaption = '';
					$thumbSrcset = false;
					$thumbSizes = false;
					
					$columns = 2;
					$columns_m = 1;
					if ( $columns_num = get_post_meta( $post_id, '__ux_cb_module_grid_column', true ) ) {
						if ( ! is_array( $columns_num ) ) { $columns_num = array( $columns_num, 0 ); }
						$columns = $columns_num[0];
						$columns_m = $columns_num[1];
					}
					
					$imageSize = 'full';

					if ( has_post_thumbnail() ) {
						switch ( $columns ) {
							default: $imageSize = 'ux-standard-thumb-small'; break;
							case '4': $imageSize = 'ux-standard-thumb'; break;
							case '3': $imageSize = 'ux-standard-thumb'; break;
							case '2': $imageSize = 'ux-standard-thumb-medium'; break;
							case '1': $imageSize = 'ux-standard-thumb-big'; break; 
						} 
						$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), $imageSize); 
						$thumbSrcset = wp_get_attachment_image_srcset(get_post_thumbnail_id(), $imageSize);
						$thumbSizes = wp_get_attachment_image_sizes(get_post_thumbnail_id(), $imageSize);
						$thumbSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $thumbSizes;
						if ( $columns_m > 1 ) {
							$thumbSizes = '(max-width: 480px) 100px,(max-width: 767px) 200px,'. $thumbSizes;
						}
						if(!$thumb){
							$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
							$thumbSrcset = wp_get_attachment_image_srcset(get_post_thumbnail_id(), 'full');
							$thumbSizes = wp_get_attachment_image_sizes(get_post_thumbnail_id(), 'full');
						}
						$thumbWidth = $thumb[1];
						$thumbHeight = $thumb[2];
						$thumbUrl = $thumb[0];
						$thumbCaption = isset(get_post(get_post_thumbnail_id())->post_excerpt) ? get_post(get_post_thumbnail_id())->post_excerpt : '';
					}
					
					//lightbox-click title
					$titleClick = get_post_meta($post_id, '__ux_cb_module_grid_style_click_title_open_item', true);

					//active title link classNmae
					$titleActiveLink = '';
					if ( $whatThumb == 'open-lightbox' &&  $titleClick === 'on' ) {
						if ( $mouseoverEffect == 'static-color-mask-text' ||  $mouseoverEffect == 'second-featured-image-text' ) {
							$titleActiveLink = 'grid-active-titlelink';
						}
					}

					//title link
					$titleLinkBefore = '<a href="'.esc_url(get_permalink()).'" title="'.esc_attr(get_the_title()).'" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-tit-a" rel="'.esc_attr( $rel ).'">';
					$titleLinkAfter = '</a>';
	
					//lazyload
					$imageLazyload = get_post_meta($post_id, '__ux_cb_module_grid_image_lazy_load', true);
					
					//lazyload style 
					$imageLazyloadImgStyle = 'src="' .esc_attr( $thumbBlank ). '" data-src="' .esc_url( $thumbUrl ). '" data-srcset="'.wp_kses_post( $thumbSrcset ).'" data-sizes="'.wp_kses_post($thumbSizes).'"';
					$imageLazyloadImgClass = 'lazy';
					if($imageLazyload == 'off'){
						$imageLazyloadImgStyle = 'src="' .esc_url( $thumbUrl ). '" srcset="'.wp_kses_post( $thumbSrcset ).'" sizes="'.wp_kses_post( $thumbSizes ).'"';
						$imageLazyloadImgClass = '';
					}
					if ( ! $module['is_frontend'] ) {
						$imageLazyloadImgStyle = 'src="' .esc_url( $thumbUrl ). '"';
					}
	
					//2nd image
					$gridItem2ndClass = false;
					$thumbUrl2nd = false;
					$thumb2ndSrcset = false;
					$thumb2ndSizes = false;
					$uxBackgroundImg2nd = 'ux_background_img_hide';
					if ( $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text' ) {
						$gridItem2ndClass = 'grid_item_2nd_class';
						$uxBackgroundImg2nd = 'ux-background-img-2nd';
						$thumb2ndId = get_post_meta( $loop_post_id, '_alternative_featured_image', true );
						
						if($source == 'product'){
							$productAttachmentIds = $product->get_gallery_image_ids();
							if($productAttachmentIds){
								$thumb2ndId = $productAttachmentIds[0];
							}
						}
						
						switch($columns){
							default: $imageSize = 'ux-standard-thumb-small'; break;
							case '4': $imageSize = 'ux-standard-thumb'; break;
							case '3': $imageSize = 'ux-standard-thumb'; break;
							case '2': $imageSize = 'ux-standard-thumb-medium'; break;
							case '1': $imageSize = 'ux-standard-thumb-big'; break; 
						}

						$thumb2nd = wp_get_attachment_image_src($thumb2ndId, $imageSize);
						$thumb2ndSrcset = wp_get_attachment_image_srcset($thumb2ndId, $imageSize);
						$thumb2ndSizes = wp_get_attachment_image_sizes($thumb2ndId, $imageSize);
						$thumbUrl2nd = $thumb2nd[0];
					}
					
					//2nd image lazyload style
					$imageLazyloadImgStyle2nd = 'src="' .esc_attr( $thumbBlank ). '" data-src="' .esc_url( $thumbUrl2nd ). '" data-srcset="'.wp_kses_post($thumb2ndSrcset).'" data-sizes="'.wp_kses_post($thumb2ndSizes).'"';
			
					if($imageLazyload == 'off'){
						$imageLazyloadImgStyle2nd = 'src="' .esc_url( $thumbUrl2nd ). '" srcset="'.wp_kses_post($thumb2ndSrcset).'" sizes="'.wp_kses_post($thumb2ndSizes).'"';
					}
	
					$editLink = '';
					if( current_user_can('editor') || current_user_can('administrator') ) { 
						$editLink = '<a href="'.esc_url( get_edit_post_link() ).'" class="post-edit-link">'.esc_html__('Edit','bm-builder').'</a>'; 
					}

					//Thumb video embeded
					$videoThumbType = '';
					$videoThumbType = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_on_list');
					
					$videoThumbHideHoverClass = '';
					$videoThumb = '';
					$videoThumb = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_embed_video');
					$videoThumbHowplay = '';
					$videoThumbRatio = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_portfolio_video_ratio');
					//$videoThumbLightbox = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_portfolio_video_lightbox');
					if ( $videoThumbType == 'embeded-video' ) {
						$videoThumbHowplay = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_video_howplay');
						if ( $videoThumbHowplay == 'autoplay' || $videoThumbHowplay == 'lightbox' ) {
							$videoThumbHideHoverClass = '';
						} else {
							$videoThumbHideHoverClass = 'thumb-type-video-hide-hover';
						}
					} elseif ( $videoThumbType == 'hosted-video' )  {
						$videoThumbHowplay = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_video_howplay_hosted'); 
						if ( $videoThumbHowplay == 'autoplay' || $videoThumbHowplay == 'lightbox' ) {
							$videoThumbHideHoverClass = '';
						} else {
							$videoThumbHideHoverClass = 'thumb-type-video-hide-hover';
						}
					}
					
					$videoThumbRatio_key1 = $videoThumbRatio[1] && isset($videoThumbRatio[1]) ? intval( $videoThumbRatio[1] ) : 16;
					$videoThumbRatio_key2 = $videoThumbRatio[2] && isset($videoThumbRatio[2]) ? intval( $videoThumbRatio[2] ) : 9;
					$videoThumbVerDatasrc = $videoThumbHowplay === 'autoplay' ? true : false;
					$videoThumbVerAutopaly = $videoThumbHowplay === 'autoplay' ? true : false;
					$videoThumbTypeListClass = '';
					if ( $videoThumbType == 'embeded-video' || $videoThumbType == 'hosted-video' ) {
						if ( $videoThumbRatio[1] && $videoThumbRatio[2] ) {
							if ( $videoThumbHowplay != 'lightbox' ) {
								$videoThumbTypeListClass = 'with-video-ratio';
							}
						}
					}
					//Thumb video hosted
					$videoThumbMp4 = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_video_mp4');
					$videoThumbWebm = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_video_webm');
					$videoThumbOgg = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_video_ogg');
					if ( $videoThumbHowplay == 'autoplay' ) {
						$videoThumbVerHosted = 'loop autoplay muted playsinline';
					} else {
						$videoThumbVerHosted = 'controls';
					}
					$dataVideoSrc = 'data-src';
					if ( ! $module['is_frontend'] ) {
						$dataVideoSrc = 'src';
					}
					$videoThumbHtml = '';
					if ( $videoThumbType == 'hosted-video' ) {
						$videoThumbHtml .= '<div class="background-video"><video class="lazy" '.esc_attr( $videoThumbVerHosted ).'>';
						if ( $videoThumbMp4 ) {
							$videoThumbHtml .= '<source '.esc_attr($dataVideoSrc).'="'.esc_url($videoThumbMp4).'" type="video/mp4">';
						}
						if ( $videoThumbWebm ) {
							$videoThumbHtml .= '<source '.esc_attr($dataVideoSrc).'="'.esc_url($videoThumbWebm).'" type="video/webm">';
						}
						if ( $videoThumbOgg ) {
							$videoThumbHtml .= '<source '.esc_attr($dataVideoSrc).'="'.esc_url($videoThumbOgg).'" type="video/ogg">';
						}
						$videoThumbHtml .= '</video></div>';
					}

					//thumb padding top
					$thumbPaddingTop = false;
					if ( $thumbHeight > 0 && $thumbWidth > 0 ) {
						$thumbPaddingTop = 'padding-top: ' . (intval($thumbHeight) / intval($thumbWidth)) * 100 . '%;';
					}
					if ( $source =='ux-portfolio' ) {
						if ( $videoThumbType == 'embeded-video' || $videoThumbType == 'hosted-video' ) {
							if ( $videoThumbHowplay != 'lightbox' ) {
								$thumbPaddingTop = 'padding-top:'.(intval($videoThumbRatio_key2) / intval($videoThumbRatio_key1)) * 100 .'%';
							}
						}
					}

					//animation
					$animation_class = ux_cb_module_field_animation_class($module);
					$animation_end = ux_cb_module_field_animation_end($module);
					
					$html .= '<section class="grid-item ' .esc_attr(join(' ', $classes)). ' '.sanitize_html_class($gridItem2ndClass).'" data-postid="' .esc_attr($loop_post_id). '">';
					$html .=   '<div class="grid-item-inside  ' .esc_attr($animation_class). ' '.esc_attr($touchTabClass).' '.sanitize_html_class($titleActiveLink).'" data-animationend="' .esc_attr($animation_end). '">';
					
					switch($source){
						//source portfolio
						default:

							$html .= '<div class="grid-item-con ' .sanitize_html_class($postClass). '" ' .wp_kses_post( $whatThumbData ). '>';
								if( $imageStyle == 'image' ) {
									if ( $whatThumb == 'open-lightbox' ) {
									
										$thumbFull = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
										if ( ( $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text' ) && $open2ndLightbox == 'on' && $thumb2ndId ) {
											$thumbFull = wp_get_attachment_image_src($thumb2ndId, 'full');
										}
										$data_video  = '';
										$video_playbtn = '';
										if( $videoThumbType =='embeded-video' || $videoThumbType == 'hosted-video' ) { 
											$data_video ='video';
											$thumbCaption = get_the_title(); 
											$video_playbtn = '<span class="video-play-btn fa fa-play"></span>';
										}
		
										$dataSize = $thumbFull[1]. 'x' .$thumbFull[2];
										$html .= '<a data-title="' .esc_attr($thumbCaption). '" title="' .esc_attr($thumbCaption). '" class="lightbox-item grid-item-mask-link" href="' .esc_url($thumbFull[0]). '" data-size="' .esc_attr($dataSize). '" data-type="'.esc_attr($data_video).'"><img class="lightbox-img-hide" width="' .esc_attr($thumbWidth). '" height="' .esc_attr($thumbHeight). '" src="' .$thumbBlank. '" alt="' .esc_attr( get_the_title() ). '" />';
										$html .= wp_kses_post($video_playbtn);
										if( $videoThumbType =='embeded-video' && $videoThumb ) {
											$html .= '<div class="hidden"><div class="videoWrapper video-wrap video-post-wrap">';
											$html .= wp_kses( ux_cb_embed_html( $videoThumb, false, true ), ux_cb_kses_allowed_html() );
											$html .= '</div></div>';
										} elseif ( $videoThumbType == 'hosted-video' ) {
											$html .= '<div class="hidden"><div class="videoWrapper">';
											$html .= '<video class="pswp__video" loop autoplay muted playsinline controls>';
											if ( $videoThumbMp4 ) {
												$html .= '<source src="'.esc_url($videoThumbMp4).'" type="video/mp4">';
											}
											if ( $videoThumbWebm ) {
												$html .= '<source src="'.esc_url($videoThumbWebm).'" type="video/webm">';
											}
											if ( $videoThumbOgg ) {
												$html .= '<source src="'.esc_url($videoThumbOgg).'" type="video/ogg">';
											}
											$html .= '</video>';
											$html .= '</div></div>';
										}
										$html .= '</a>';
									} else {
										$html .= '<a href="' .esc_url(get_permalink()). '" title="' .esc_attr( get_the_title() ). '" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-mask-link"></a>';
									}
								} else {
									$html .= '<a href="' .esc_url(get_permalink()). '" title="' .esc_attr( get_the_title() ). '" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-mask-link"></a>';
								}
							if ( $imageStyle == 'image' ) {
								$html .= '<div class="grid-item-con-text">';
								
								if ( $showText === 'on' ) {
									foreach ( $textGroup as $groupValue ) {
										if ( $groupValue == 'title' ) {
											$html .= '<h2 class="grid-item-tit">' .wp_kses_post( $titleLinkBefore ). '' .esc_html( get_the_title() ). '' .wp_kses_post( $titleLinkAfter ). '</h2>';
										}
										
										if ( $groupValue == 'category' ){
											$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a', 'ux-portfolio-cat' ) ). '</span>';
										}
										
										if ( has_excerpt() && $groupValue == 'excerpt' ){
											$html .= '<div class="grid-item-des">'.esc_html( get_the_excerpt() ).'</div>';
										}

										if ( $groupValue == 'date' ){
											$html .= '<div class="grid-item-date">' .esc_html( get_the_date() ). '</div>';
										}
									}
								}
								
								$html .= '</div>';
							}
							$html .= '</div>';
							
							$html .= '<div class="brick-content ux-lazyload-wrap ' .sanitize_html_class( $videoThumbTypeListClass ) .' '. sanitize_html_class( $videoThumbHideHoverClass ).'" style=" ' .esc_attr( $thumbPaddingTop ). '">';
								
								if ( $videoThumbType === 'embeded-video' && $videoThumbHowplay != 'lightbox' ) {
									$html .= '<div class="video-wrap">';
									$html .= wp_kses( ux_cb_embed_html( $videoThumb, $videoThumbVerDatasrc, $videoThumbVerAutopaly ), ux_cb_kses_allowed_html() );
									$html .= '</div>';
								} else if ( $videoThumbType === 'hosted-video' && $videoThumbHowplay != 'lightbox' ) {
									$html .= wp_kses( $videoThumbHtml, ux_cb_kses_allowed_html() );
								} 
								$html .= '<img class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle ).' alt="'.esc_attr( get_the_title() ).'">';
								$html .= '<img class="grid-item-img '.sanitize_html_class( $uxBackgroundImg2nd ).' '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle2nd ).'  alt="'.esc_attr( get_the_title() ).'">';
								
							$html .= '</div>';
							  
							//grid title
							if( $imageStyle == 'image-text' ) {
								$html .= '<div class="grid-item-con-text-tit-shown ' .sanitize_html_class($textAlign). ' ' .sanitize_html_class($gridPadingClass). '">';
								if ( $textGroup ) {
									foreach ( $textGroup as $groupValue ) {
										if ( $groupValue === 'title' ) {
											$html .= '<h2 class="grid-item-tit">' .esc_html( get_the_title() ). '</h2>';
										}
										
										if ( $groupValue === 'category' ){
											$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a', 'ux-portfolio-cat' ) ). '</span>';
										}
										
										if ( has_excerpt() && $groupValue === 'excerpt' ){
											$html .= '<div class="grid-item-des">'.esc_html( get_the_excerpt() ).'</div>';
										}
	
										if ( $groupValue == 'date' ){
											$html .= '<div class="grid-item-date">' .esc_html( get_the_date() ). '</div>';
										}
									}
								}
								
								$html .= '</div>';
							}
						break;
						
						//source post
						case 'post':
							$video_post_embeded_code = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_video_embeded_code');
							$video_post_embeded_ratio = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_video_ratio');
							$video_post_embeded_ratio_custom = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_video_custom_ratio');
							switch($video_post_embeded_ratio){
								case '16:9': $video_post_embeded_ratio_class = 'video-16-9'; break;
								case '4:3': $video_post_embeded_ratio_class = 'video-4-3'; break;
								case 'custom':
									$video_post_embeded_ratio_custom_key_1 = $video_post_embeded_ratio_custom && isset($video_post_embeded_ratio_custom[1]) ? $video_post_embeded_ratio_custom[1] : 16;
									$video_post_embeded_ratio_custom_key_2 = $video_post_embeded_ratio_custom && isset($video_post_embeded_ratio_custom[2]) ? $video_post_embeded_ratio_custom[2] : 9;
									$video_post_embeded_ratio_class = false;
								break;
							}
							$video_post_embeded_ratio_custom_style = $video_post_embeded_ratio == 'custom' && $video_post_embeded_ratio_custom ? 'padding-top:'.(intval($video_post_embeded_ratio_custom_key_2) / intval($video_post_embeded_ratio_custom_key_1)) * 100 .'%' : false;
							

							$data_video  = '';
							if(has_post_format('video') && $video_post_embeded_code){
								$data_video ='video';
								$thumbCaption = get_the_title();
								$video_playbtn = '<span class="video-play-btn fa fa-play"></span>';
							}
							if($imageStyle == 'image'){
	
								$html .= '<div class="grid-item-con ' .sanitize_html_class($postClass). '" ' .wp_kses_post($whatThumbData). '>';
	
								if ( $whatThumb == 'open-lightbox' ) {
									$thumbFull = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
									if ( ( $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text' ) && $open2ndLightbox == 'on' && $thumb2ndId ) {
										$thumbFull = wp_get_attachment_image_src($thumb2ndId, 'full');
									}
									$dataSize = $thumbFull[1]. 'x' .$thumbFull[2];
									$html .= '<a data-title="' .esc_attr($thumbCaption). '" title="' .esc_attr($thumbCaption). '" class="lightbox-item grid-item-mask-link" href="' .esc_url ($thumbFull[0] ). '" data-size="' .esc_attr( $dataSize ). '" data-type="'.esc_attr( $data_video ).'"><img class="lightbox-img-hide" width="' .esc_attr( $thumbWidth ). '" height="' .esc_attr( $thumbHeight ). '" src="' .esc_attr( $thumbBlank ). '" alt="' .esc_attr( get_the_title() ). '" />';
									if(has_post_format('video') && $video_post_embeded_code){
										$html .= wp_kses_post($video_playbtn);
										$html .= '<div class="hidden"><div class="videoWrapper video-wrap video-post-wrap">';
										$html .= wp_kses( ux_cb_embed_html( $video_post_embeded_code, false, true ), ux_cb_kses_allowed_html() );
										$html .= '</div></div>';
									}
									$html .= '</a>';
								} else {
									if ( has_post_format( 'link' ) ) {
										$image_link = ux_cb_get_theme_meta( get_the_ID(), 'theme_meta_link_item' );
										if ( $image_link ) {
											$permalink = $image_link['url'][0];
										}
										$html .= '<a href="' .esc_url( $permalink ). '" title="' .esc_attr( get_the_title() ). '" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-mask-link" rel="'.esc_attr( $rel ).'"></a>';
									} else {
										$html .= '<a href="' .esc_url( get_permalink() ). '" title="' .esc_attr( get_the_title() ). '" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-mask-link"></a>';
									}
								}
								
								$html .= '<div class="grid-item-con-text">';
									foreach ( $textGroup as $groupValue ) {
										if ( $showText == 'on' && $groupValue == 'title' ) {
											$html .= '<h2 class="grid-item-tit">' .wp_kses_post( $titleLinkBefore ). '' .esc_attr( get_the_title() ). '' .wp_kses_post( $titleLinkAfter ). '</h2>';
										}
										if ( $showText == 'on' && $groupValue == 'category' ){
											$html .= '<span class="grid-item-cate">' .ux_cb_get_the_category( ' ', 'grid-item-cate-a' ). '</span>';
										}
									}
								$html .= '</div>';
								$html .= '</div>';
								$html .= '<div class="brick-content ux-lazyload-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';
								$html .= '<img class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle ).' alt="' .esc_attr( get_the_title() ). '">';
								$html .= '<img class="grid-item-img '.sanitize_html_class( $uxBackgroundImg2nd ).' '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle2nd ).' alt="' .esc_attr( get_the_title() ). '">';
								$html .= '</div>';
	
							} else { // Image + Text
	
								//link
								if ( has_post_format( 'link' ) ) {
									$linkItem = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_link_item');
									$linkItemTarget = false;
									$linkItemRel = '';
									if ( ux_cb_get_theme_meta($loop_post_id, 'theme_meta_link_item_target_blank') ) {
										$linkItemTarget = ' target="_blank"';
										$linkItemRel .= 'noopener noreferrer ';
									}
									if ( ux_cb_get_theme_meta($loop_post_id, 'theme_meta_link_item_nofollow') ) {
										$linkItemRel .= 'nofollow ';
									}
									$html .= '<div class="grid-text-wrap">';
									if ( $linkItem ) {
										$html .= '<ul class="blog-unit-link">';
										foreach($linkItem['name'] as $i => $name){
											$url = $linkItem['url'][$i];
											$html .=  '<li class="blog-unit-link-li"><a href="' .esc_url( $url ). '" title="' .esc_attr( $name ). '" class="blog-unit-link-li-a" rel="'.esc_attr( $linkItemRel ).'"'.sanitize_text_field( $linkItemTarget ).'>' .esc_html( $name ). '</a></li>';
										}
										$html .= '</ul>';
									}
									$html .= '</div>';
								
								//quote
								}elseif(has_post_format('quote')){
									$quote = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_quote');
									$quoteCite = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_quote_cite');
									
									$html .= '<div class="grid-text-wrap">';
									$html .=   '<div class="blog-unit-quote">' .wp_kses_post( $quote );
									if($quoteCite) {
										$html .= '<cite><span class="cite-line"></span> ' .wp_kses_post( $quoteCite ). '</cite>';
									}
									$html .=   '</div>';
									$html .= '</div>';
								
								//audio
								} elseif ( has_post_format( 'audio' ) ) {
									$audioType = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_audio_type');
									$audioSoundcloud = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_audio_soundcloud');
									if($audioType == 'soundcloud' && $audioSoundcloud){
										$html .= '<div class="grid-iframe">';
										$html .=   '<iframe width="100%" height="400" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=' .esc_url( $audioSoundcloud ). '&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true"></iframe>';
										$html .= '</div>';
									} else {
										$audioArtist = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_audio_artist');
										$audioMp3    = ux_cb_get_theme_meta($loop_post_id, 'theme_meta_audio_mp3');
										$firstName   = $audioMp3['name'][0];
										$firstUrl    = $audioMp3['url'][0]; 
										
										if($audioMp3){
											$html .= '<div class="grid-audio-bar">';
											$html .=   '<ul class="audio_player_list blog-list-audio">';
											$html .=     '<li class="audio-unit"><span id="audio-' .esc_attr( $loop_post_id ). '-0" class="audiobutton pause" rel="' .esc_url( $firstUrl ). '"></span><span class="songtitle" title="' .esc_attr( $firstName ). '">' .esc_attr( $firstName ). '</span></li>';
											$html .=   '</ul>';
											$html .= '</div>';
										}
									}
									
									$html .= '<div class="grid-blog '.sanitize_html_class( $textAlign ).' '.sanitize_html_class( $gridPadingClass ).'">';
									
									foreach ( $textGroup as $groupValue ) {
										if ( $groupValue == 'title' ) {
											$html .= '<h2 class="grid-item-tit"><a href="'.esc_url( get_permalink() ).'" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-tit-a" title="' .esc_attr( get_the_title() ). '">' .esc_html( get_the_title() ). '</a></h2>';
										}
										
										if ( $groupValue == 'category' ){
											$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a' ) ). '</span>';
										}
										
										if ( has_excerpt() && $groupValue == 'excerpt' ){
											$html .= '<div class="grid-item-des"><p>' .wp_kses_post( wp_trim_words( get_the_excerpt(), 20, '...' ) ). '</p></div>';
										}
										
										if ($groupValue == 'date' ){
											$html .= '<div class="grid-item-date">' .esc_html( get_the_date() ). '</div>';
										}
									}
									
									$html .= '</div>';
								
								//video
								} elseif ( has_post_format( 'video' ) ){
									
									$thumbPaddingTop = $video_post_embeded_ratio_custom_style;
									$dataAttrSrc = false;
										$html .= '<div class="embed-wrap-has-cover '.sanitize_html_class( $video_post_embeded_ratio_class ).'" style="' .wp_kses_post( $thumbPaddingTop ). '">';
									if(has_post_thumbnail()){
										$dataAttrSrc = true;
										$html .= ' <div class="embed-video-cover " ' .wp_kses_post( $whatThumbData ). '>';
									
											$html .= '  <img class="embed-video-cover-img '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle ).' alt="' .esc_attr( get_the_title() ). '">';
											$html .= '  <span class="fa fa-play video-play-btn"></span>';
										
										$html .= ' </div>';
									} 
										if ( $video_post_embeded_code ) {
											$html .= wp_kses( ux_cb_embed_html( $video_post_embeded_code, $dataAttrSrc, false ), ux_cb_kses_allowed_html() );
										} 
										
										$html .= '</div>';
									$html .= '<div class="grid-blog '.sanitize_html_class( $textAlign ).' '.sanitize_html_class( $gridPadingClass ).'">';
									
									if ( $textGroup ) {
										foreach ( $textGroup as $groupValue ) {
											if ( $groupValue == 'title' ) {
												$html .= '<h2 class="grid-item-tit"><a href="'.esc_url( get_permalink() ).'" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-tit-a" title="' .esc_attr( get_the_title() ). '">' .esc_html( get_the_title() ). '</a></h2>';
											}
											
											if ( $groupValue == 'category' ){
												$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a' ) ). '</span>';
											}
											
											if ( has_excerpt() && $groupValue == 'excerpt' ){
												$html .= '<div class="grid-item-des"><p>' .wp_trim_words( get_the_excerpt(), 20, '...' ). '</p></div>';
											}
											
											if ( $groupValue == 'date' ){
												$html .= '<div class="grid-item-date">' .esc_html( get_the_date() ). '</div>';
											}
										}
									}
									
									$html .= '</div>';
								
								//standard, image, gallery
								} else {
									if ( has_post_thumbnail() ) { 
										$html .= '<div class="ux-lazyload-wrap" style="' .wp_kses_post( $thumbPaddingTop ). '" ' .wp_kses_post( $whatThumbData ). '>';
										if ( $whatThumb == 'open-lightbox' ) {
											$thumbFull = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
											$dataSize = $thumbFull[1]. 'x' .$thumbFull[2];
											$html .= '<a data-title="' .esc_attr($thumbCaption). '" title="' .esc_attr( $thumbCaption ). '" class="lightbox-item grid-item-mask-link" href="' .esc_url( $thumbFull[0] ). '" data-size="' .esc_attr( $dataSize ). '" data-type="'.esc_attr( $data_video ).'"><img class="lightbox-img-hide" width="' .esc_attr( $thumbWidth ). '" height="' .esc_attr( $thumbHeight ). '" src="' .esc_attr( $thumbBlank ). '" alt="' .esc_attr( get_the_title() ). '" />';
											$html .= '</a>';
										} else {
											$html .= '<a class="grid-item-mask-link" title="' .esc_attr( get_the_title() ). '" '.wp_kses_post( $openNewTabTarget ).' href="' .esc_url( get_permalink() ). '"></a>';
										}
										$html .= '<img class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle ).' alt="' .esc_html( $thumbCaption ). '">';
										$html .= '<img class="grid-item-img '.sanitize_html_class( $uxBackgroundImg2nd ).' '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle2nd ).'  alt="'.esc_attr( get_the_title() ).'">';
										$html .= '</div>';
									} 
							
									$html .= '<div class="grid-blog '.sanitize_html_class( $textAlign ).' '.sanitize_html_class( $gridPadingClass ).'">';
									
									if ( $textGroup ) {
										foreach ( $textGroup as $groupValue ) {
											if ( $groupValue == 'title' ) {
												$html .= '<h2 class="grid-item-tit"><a href="'.esc_url( get_permalink() ).'" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-tit-a" title="' .esc_attr( get_the_title() ). '">' .esc_html( get_the_title() ). '</a></h2>';
											}
											
											if ( $groupValue == 'category' ){
												$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a' ) ). '</span>';
											}
											
											if ( has_excerpt() && $groupValue == 'excerpt' ){
												$html .= '<div class="grid-item-des"><p>' .wp_kses_post( wp_trim_words( get_the_excerpt(), 20, '...' ) ). '</p></div>';
											}
											
											if ( $groupValue == 'date' ){
												$html .= '<div class="grid-item-date">' .esc_html( get_the_date() ). '</div>';
											}
										}
									}
									
									$html .= '</div>';
								}
	
							} // End if $imageStyle
							
						break;
						
						//woo product
						case 'product':
							if($product->is_on_sale()){
								$html .= '<span class="onsale">' .esc_html__('Sale!','bm-builder'). '</span>';
							}
							$sold_out_text = apply_filters('ux-get-soldout-text', esc_html__( 'Sold Out', 'bm-builder' ));
							if ( !$product->is_in_stock() ) {
						        $html .= '<span class="sold-out"><span class="sold-out-inn">' . esc_html( $sold_out_text ) . '</span></span>';
						    }
							
							$html .= '<div class="grid-item-con post--' .esc_attr( $loop_post_id ). '">';
							$html .=   '<a href="' .esc_url( get_permalink() ). '" class="grid-item-mask-link"></a>';
							
							if ( $imageStyle == 'image' ) {

								$html .=   '<div class="grid-item-con-text">';
								
								foreach ( $textGroup as $groupValue ) {

									if ( $showText === 'on' && $groupValue == 'price' && $priceHtml = $product->get_price_html() ) {
										$html .= '<span class="price">' .wp_kses_post( $priceHtml ). '</span>';
									}
									
									if ( $showText == 'on' && $groupValue == 'title' ) {
										$html .= '<h2 class="grid-item-tit"><a href="' .esc_url( get_permalink() ). '" title="' .esc_attr( get_the_title() ). '" class="grid-item-tit-a">' .esc_html( get_the_title() ). '</a></h2>';
									}

								}
							
							$html .=   '</div>';
							}
							$html .= '</div>';
							
							$html .= '<div class="brick-content ux-lazyload-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';
							
							$html .= '<img class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle ).' alt="' .esc_attr( get_the_title() ). '">';
							
							$html .= '<img class="grid-item-img '.sanitize_html_class( $uxBackgroundImg2nd ).' '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle2nd ).' alt="' .esc_attr( get_the_title() ). '">';
							
							$html .= '</div>';
	
							//grid title
							if( $imageStyle == 'image-text' ) {

								$html .= '<div class="grid-item-con-text-tit-shown ' .esc_attr( $textAlign ). ' ' .sanitize_html_class( $gridPadingClass). '">';
								
								foreach ( $textGroup as $groupValue ) { 
								
									if( $groupValue == 'title' ) {
										$html .= '<h2 class="grid-item-tit">' .esc_html( get_the_title() ). '</h2>'; 
									}
									if ( $groupValue == 'price' && $priceHtml = $product->get_price_html() ) {
										$html .= '<span class="price">' .wp_kses_post( $priceHtml ). '</span>';
									}
								}

								$html .= '</div>';
							}
	
						break;
					}

					$html .=   '</div>';
					
					$html .= '</section>';
				}
				
				wp_reset_postdata();
			}
		}
	}else{
		//pagination
		$pagination = get_post_meta($post_id, '__ux_cb_module_grid_pagination', true);
		
		//pagination class
		$pagePaginationTag = '';
		$pagepaginationClass = '';
		if($pagination == 'scroll'){
			$pagePaginationTag = 'data-paged="2" data-postid="' .esc_attr($module['postID']). '" data-max="' .esc_attr($max_num_pages). '"';
			$pagepaginationClass = 'infiniti-scroll';
		}
		
		//columns
		$columns = '2';
		$columnsMobile = '2';
		if ( $columns_num = get_post_meta( $post_id, '__ux_cb_module_grid_column', true ) ) {
			if ( ! is_array( $columns_num ) ) { $columns_num = array( $columns_num, 0 ); }
			$columns = $columns_num[0];
			$columnsMobile = $columns_num[1];
		}
		
		//columns class
		$columnsClass = 'ux-portfolio-2col';
		switch ( $columns ) {
			case '1': $columnsClass = 'ux-portfolio-1col'; break;
			case '2': $columnsClass = 'ux-portfolio-2col'; break;
			case '3': $columnsClass = 'ux-portfolio-3col'; break;
			case '4': $columnsClass = 'ux-portfolio-4col'; break;
			case '5': $columnsClass = 'ux-portfolio-5col'; break;
			case '6': $columnsClass = 'ux-portfolio-6col'; break;
			case '7': $columnsClass = 'ux-portfolio-7col'; break;
			case '8': $columnsClass = 'ux-portfolio-8col'; break;
			case '9': $columnsClass = 'ux-portfolio-9col'; break;
			case '10': $columnsClass = 'ux-portfolio-10col'; break;
			case '11': $columnsClass = 'ux-portfolio-11col'; break;
			case '12': $columnsClass = 'ux-portfolio-12col'; break;
		}

		//columns class
		$columnsClassMobile = '';
		switch ( $columnsMobile ) { 
			case '2': $columnsClassMobile = 'ux-portfolio-2col-mobile'; break;
			case '3': $columnsClassMobile = 'ux-portfolio-3col-mobile'; break;
			case '4': $columnsClassMobile = 'ux-portfolio-4col-mobile'; break;
			case '5': $columnsClassMobile = 'ux-portfolio-5col-mobile'; break;
			case '6': $columnsClassMobile = 'ux-portfolio-6col-mobile'; break;
			case '7': $columnsClassMobile = 'ux-portfolio-7col-mobile'; break;
			case '8': $columnsClassMobile = 'ux-portfolio-8col-mobile'; break;
			case '9': $columnsClassMobile = 'ux-portfolio-9col-mobile'; break;
			case '10': $columnsClassMobile = 'ux-portfolio-10col-mobile'; break;
			case '11': $columnsClassMobile = 'ux-portfolio-11col-mobile'; break;
			case '12': $columnsClassMobile = 'ux-portfolio-12col-mobile'; break;
		}
		
		//list width
		$listWidthClass = 'ux-portfolio-full';
		
		//show filter
		$showFilter = false; $hasFilter = '';
		$filter_align = get_post_meta( $post_id, '__ux_cb_module_grid_filter_align', true );
		$filter_align_class = false;
		if ( $showFilter = get_post_meta( $post_id, '__ux_cb_module_grid_show_filter', true) == 'on' ) {
			$showFilter = true;
			$hasFilter = 'ux-has-filter';
			switch ( $filter_align ) {
				case 'filter_center':
					$filter_align_class = 'filter-center';
					break;
				case 'filter_right':
					$filter_align_class = 'filter-right';
					break;
			}
		}
		
		//ratio
		$ratio = get_post_meta($post_id, '__ux_cb_module_grid_image_ratio', true);
 
		//spacing horizontal
		$spacingHorizontal = 0;
		if ( $getSpacingHorizontal = get_post_meta( $post_id, '__ux_cb_module_grid_item_spacing_horizontal', true ) ) {
			if ( ! is_array( $getSpacingHorizontal ) ) { $getSpacingHorizontal = array( $getSpacingHorizontal, 0 ); }
			$spacingHorizontal = $getSpacingHorizontal[0];
		}

		//spacing vertical
		$spacingVertical = 0;
		if ( $getSpacingVertical = get_post_meta( $post_id, '__ux_cb_module_grid_item_spacing_vertical', true ) ) {
			if ( ! is_array( $getSpacingVertical ) ) { $getSpacingVertical = array( $getSpacingVertical, 0 ); }
			$spacingVertical = $getSpacingVertical[0];
		}

		$noSpacingClass = '';
		if( !$spacingHorizontal || !$spacingVertical ) {
			$noSpacingClass = 'bm-grid-no-spacing';
		}
		
		//grid ratio
		$gridRatioData = '';
		$gridRatioClass = ''; 
		switch ( $ratio ) {
			case '4_3':  $gridRatioData = '0.75'; $gridRatioClass = 'ux-ratio-43'; break;
			case '3_2':  $gridRatioData = '0.6667'; $gridRatioClass = 'ux-ratio-32'; break;
			case '16_9':  $gridRatioData = '0.5625'; $gridRatioClass = 'ux-ratio-169'; break;
			case '2_1':  $gridRatioData = '0.5'; $gridRatioClass = 'ux-ratio-12'; break;
			case '2_3':  $gridRatioData = '1.5'; $gridRatioClass = 'ux-ratio-23'; break;
			case '3_4':  $gridRatioData = '1.3333'; $gridRatioClass = 'ux-ratio-34'; break;
			case '1_1':  $gridRatioData = '1'; $gridRatioClass = 'ux-ratio-11'; break;
			case '1_2':  $gridRatioData = '2'; $gridRatioClass = 'ux-ratio-21'; break; 
		}

		//fit image into grid
		$fit_img_into_grid = false; 
		$fit_img_into_grid_class = false;
		if($fit_img_into_grid = get_post_meta($post_id, '__ux_cb_module_grid_img_fit_grid', true) == 'on'){
			$fit_img_into_grid_class = 'image-fit-grid';
		}
		
		//enable masonry
		$listGridType ='regular_grid';
		$masonryAutoClass ='';
		if($listGridType = get_post_meta($post_id, '__ux_cb_module_grid_type', true) == 'masonry_grid'){
			$masonryAutoClass ='masonry-auto';
		}

		//filter align
		$filterAlign = 'filter-left';
		
		//what thumb class
		$whatThumbClass = '';
		if($whatThumb == 'open-lightbox'){
			$whatThumbClass = 'lightbox-photoswipe';
		}

		//mouseover effect class
		$mouseoverEffectClass = '';
		if($imageStyle == 'image-text' && $mouseoverEffect == 'enlarge-image'){
			$mouseoverEffectClass = 'img-zoom-in';
		}
		if($mouseoverEffect == 'no-effect') {
			$mouseoverEffectClass = 'mouseover-no-effect';
		}
		
		//style
		if(!$module['is_frontend']){
			$html .= '<style type="text/css">' .sanitize_text_field( ux_cb_module_grid_style( $post_id, $moduleUnique, $html ) ). '</style>';
		}
		
		//no ajax output
		$html .= '<div class="container-masonry ' .sanitize_html_class( $columnsClass ). ' ' .sanitize_html_class( $columnsClassMobile ). ' ' .sanitize_html_class( $listWidthClass ). ' ' .sanitize_html_class( $hasFilter ). ' ' .sanitize_html_class( $gridRatioClass ). ' ' .sanitize_html_class( $filterAlign ). ' '.sanitize_html_class( $noSpacingClass ).'" data-ratio="' .esc_attr( $gridRatioData ). '" data-col="' .esc_attr( $columns ). '" data-found="' .esc_attr( $found_posts ). '" data-number="' .esc_attr( $perPage ). '" data-mod="' .esc_attr( $module['id'] ). '">';
		
		$filterData = array(
			'filterAlignClass' => $filter_align_class,
			'foundPosts' => $found_posts,
			'source' => $source,
			'taxonomy' => $taxonomy,
			'category' => $category,
			'mediaQuery' => $media_query,
			'postIn' => $post__in,
			'modulePostID' => $module['postID']
		);
		
		if ( $showFilter && $filter_align != 'filter_left_in_grid' ) {
			$html = wp_kses( ux_cb_module_grid_templates_filter( $html, $filterData ), ux_cb_kses_allowed_html() );
		}

		$textAlignClass = '';
		$gridListTitShownClass = 'grid-list-tit-shown';
		if($imageStyle == 'image'){ 
			$textAlignClass = 'grid-text-'.esc_attr($textAlign);
			$gridListTitShownClass = '';
		}
		
		$html .=   '<div class="masonry-list grid-list clearfix grid-list-' .esc_attr($moduleUnique). ' ' . sanitize_html_class($gridListTitShownClass) . ' ' . sanitize_html_class($textAlignClass). ' ' .sanitize_html_class($whatThumbClass). ' ' .sanitize_html_class($pagepaginationClass). ' '.sanitize_html_class($masonryAutoClass).' '.sanitize_html_class($mouseoverEffectClass).' '.sanitize_html_class($fit_img_into_grid_class).'" ' .balanceTags($pagePaginationTag). ' data-unique="' .esc_attr($moduleUnique). '" data-source="' .esc_attr($source). '">';
		
			if($the_query->have_posts() || $media_query){
				$module['ajax'] = true;
				$module['paged'] = 1;
				
				if ( $showFilter && $filter_align == 'filter_left_in_grid' ) {
					$classes = array();
					
					if ( $source == 'attachment' && $media_query ) {
						$get_categories = wp_get_object_terms( $post__in, 'ux-attachment-cat' );
					} else {
						$get_category = get_term( $category, $taxonomy );
						if ( ! is_wp_error( $get_category ) ) {
							$classes[] = sanitize_html_class( 'filter_' . $get_category->slug );
						}
						
						$get_categories = get_terms( $taxonomy, array(
							'parent' => $category
						) );
					}
					
					if ( $get_categories ) {
						foreach ( $get_categories as $sub_cat ) {
							$classes[] = sanitize_html_class( 'filter_' . $sub_cat->slug );
						}
					}
					
					$classes = array_unique( $classes );
					
					$html .= '<section class="grid-item grid-item--width2 ' .esc_attr( join( ' ', $classes ) ). '">';
					$html .=   '<div class="grid-item-inside">';
					$html  =     wp_kses( ux_cb_module_grid_templates_filter( $html, $filterData ), ux_cb_kses_allowed_html() );
					$html .=   '</div>';
					$html .= '</section>';
				}
				
				$html .= ux_cb_module_grid_container( $module, $moduleUnique );
			}
		
		$html .=   '</div>';
		
		if(($the_query->have_posts() || $media_query) && $pagination == 'load-more' && $max_num_pages > 1){
			$paginationText = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_loadmore_text', true) ? get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_loadmore_text', true) : esc_html__('Load More','bm-builder');
			$loadingText = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_loading_text', true) ? get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_loading_text', true) : esc_html__('Loading','bm-builder');
			
			$html .= '';
			$html .= '<div class="clearfix pagenums tw_style page_twitter" data-pagetext="' .esc_attr( $paginationText ). '" data-loadingtext="' .esc_attr( $loadingText ). '">';
			$html .=   '<a class="tw-style-a ux-btn" data-postid="' .esc_attr( $module['postID'] ). '" data-max="' .esc_attr( $max_num_pages ). '" data-paged="2" href="#">' .esc_html( $paginationText ). '</a>';
			$html .= '</div>';
		}
		
		$html .= '</div>';
	}
	
	if($echo){
		echo $html;
		die('');
	}else{
		return $html;
	}
}
add_filter( 'ux_cb_module_container_grid', 'ux_cb_module_grid_container', 10, 2 );
add_action( 'wp_ajax_ux_cb_module_grid_container', 'ux_cb_module_grid_container', 10, 0 );
add_action( 'wp_ajax_nopriv_ux_cb_module_grid_container', 'ux_cb_module_grid_container', 10, 0 );

//Source: Attachement 
function ux_cb_module_grid_templates_attachment($imagePost, $post_id, $module, $num){
	$loop_post_id = $imagePost;
	
	//sourse
	$source = get_post_meta($post_id, '__ux_cb_module_grid_source', true);

	//post class
	$postClass = 'post--' .$loop_post_id;
	
	//what thumb
	$openNewTab = '';
	$openNewTabTarget = '';
	$rel = '';
	$whatThumb = get_post_meta($post_id, '__ux_cb_module_grid_attachment_what_thumb_does', true);
	$openNewTab = get_post_meta($post_id, '__ux_cb_module_grid_attachment_what_thumb_does_new_tab', true); 
	if($whatThumb === 'open-custom-url' && $openNewTab === 'on'){
		$openNewTabTarget = 'target="_blank"';
		$rel .= 'noopener noreferrer';
	}
	if ( get_post_meta($post_id, '__ux_cb_module_grid_attachment_what_thumb_does_nofollow', true) == 'on' ) {
		$rel .= ' nofollow';
	}

	//lightbox
	$whatThumbData = '';
	if($whatThumb == 'open-lightbox'){
		$whatThumbData = 'data-lightbox="true"';
	}
	
	//caption
	$thumbCaption = isset(get_post($imagePost)->post_excerpt) ? get_post($imagePost)->post_excerpt : '';
	
	//image style
	$imageStyle = get_post_meta($post_id, '__ux_cb_module_grid_item_style', true);
	
	//mouseover effect
	$mouseoverEffect = false;
	switch($imageStyle){
		case 'image': $mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mouseover_effect-attachment', true); break;
		case 'image-text': $mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_mouseover_effect-attachment', true); break;
	}
	
	//show title
	$showTitle = false;
	switch($imageStyle){
		case 'image': 
			if( $mouseoverEffect == 'static-color-mask-text' ) { 
				$showTitle = 'on';
			}
		break;
		case 'image-text': $showTitle = 'on';
		break;
	}
	
	//thumb
	$columns = 2;
	$columns_m = 1;
	if ( $columns_num = get_post_meta( $post_id, '__ux_cb_module_grid_column', true ) ) {
		if ( ! is_array( $columns_num ) ) { $columns_num = array( $columns_num, 0 ); }
		$columns = $columns_num[0];
		$columns_m = $columns_num[1];
	}
	
	$imageSize = 'full';
	switch($columns){
		default: $imageSize = 'ux-standard-thumb-small'; break;
		case '4': $imageSize = 'ux-standard-thumb'; break;
		case '3': $imageSize = 'ux-standard-thumb'; break;
		case '2': $imageSize = 'ux-standard-thumb-medium'; break;
		case '1': $imageSize = 'ux-standard-thumb-big'; break; 
	} 
	$thumb = wp_get_attachment_image_src($imagePost, $imageSize); 
	$thumbSrcset = wp_get_attachment_image_srcset($imagePost, $imageSize);
	$thumbSizes = wp_get_attachment_image_sizes($imagePost, $imageSize);
	$thumbSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $thumbSizes;
	if ( $columns_m > 1 ) {
		$thumbSizes = '(max-width: 480px) 100px,(max-width: 767px) 200px,'. $thumbSizes;
	}
	$thumbFull = wp_get_attachment_image_src($imagePost, 'full');
	$dataSize = $thumbFull[1]. 'x' .$thumbFull[2];
	$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
	
	//thumb padding top
	$thumbPaddingTop = false;
	if($thumbFull[1] > 0 && $thumbFull[2] > 0){
		$thumbPaddingTop = 'padding-top: ' . (intval($thumbFull[2]) / intval($thumbFull[1])) * 100 . '%;';
	}
	
	//title link
	$titleLinkBefore = false;
	$titleLinkAfter = false;
	$permalink = get_permalink($imagePost);
	if ( $whatThumb == 'open-custom-url' ) {
		$permalink = $thumbFull[0];
		
		$customUrl = get_post_meta($imagePost, 'what_thumbnail_does', true);
		if ( esc_url( $customUrl ) ) {
			$permalink = esc_url( $customUrl );
		}
		
		$titleLinkBefore = '<a href="'.esc_url( $permalink ).'" title="'.esc_attr( get_the_title( $imagePost ) ).'" class="grid-item-tit-a">';
		$titleLinkAfter = '</a>';
	}

	//mouseover effect on touch screen
	$touchTapOnce = get_post_meta($post_id, '__ux_cb_module_grid_attachment_touch_once', true);
	$touchTabClass = false;
	if($imageStyle == 'image' && $whatThumb == 'open-custom-url') {
		if($mouseoverEffect == 'static-color-mask-text'){
			if ( $touchTapOnce === 'off' ) { 
				$touchTabClass = 'bm-touch-tab';
			}
		}
	}
	
	//lazyload
	$imageLazyload = get_post_meta($post_id, '__ux_cb_module_grid_image_lazy_load', true);
	
	//lazyload style
	$imageLazyloadImgStyle = 'data-srcset="'.wp_kses_post( $thumbSrcset ).'" data-sizes="'.wp_kses_post( $thumbSizes ).'" src="' .esc_attr( $thumbBlank ). '" data-src="' .esc_url( $thumb[0] ). '"';
	$imageLazyloadImgClass = 'lazy';
	if($imageLazyload == 'off'){
		$imageLazyloadImgStyle = 'src="' .esc_url( $thumb[0] ). '"';
		$imageLazyloadImgClass = '';
	}
	if ( !$module['is_frontend'] ) {
		$imageLazyloadImgStyle = 'src="' .esc_url( $thumb[0] ). '"';	
	}
	//animation
	$animation_class = ux_cb_module_field_animation_class($module);
	$animation_end = ux_cb_module_field_animation_end($module);
	
	//classes
	$classes = array();
	$postTerms = get_the_terms($imagePost, 'ux-attachment-cat');
	if($postTerms){
		foreach($postTerms as $term){
			$parents = get_ancestors( $term->term_id, 'ux-attachment-cat', 'taxonomy' );
			if($parents){
				foreach($parents as $parent){
					$parent = get_term( $parent, 'ux-attachment-cat' );
					$classes[] = sanitize_html_class('filter_' . $parent->slug);
				}
			}
			$classes[] = sanitize_html_class('filter_' . $term->slug);
		}
	}
	$classes = array_unique($classes);
	
	//text align
	$textAlign = false;
	switch($imageStyle){
		case 'image': $textAlign = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_align', true); break;
		case 'image-text': $textAlign = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_text_align', true); break;
	}
	
	//padding left right
	$gridPadingClass = $textAlign !='grid-text-center' ? 'standard-text-padding' : false;

	//Caption text on image+text for attachment
	$textImageText = get_the_title($loop_post_id);
	if($source == 'attachment') {
		$textImageText = $thumbCaption ? $thumbCaption : get_the_title($loop_post_id);
	}
	
	$html = '<section class="grid-item ' .esc_attr( join(' ', $classes) ). '" data-postid="' .esc_attr( $num ). '">';
	$html .=   '<div class="grid-item-inside  ' .esc_attr( $animation_class ). ' '.sanitize_html_class( $touchTabClass ).'" data-animationend="' .esc_attr( $animation_end ). '">';
	
		$html .= '<div class="grid-item-con ' .sanitize_html_class( $postClass ). '" ' .wp_kses_post( $whatThumbData ). '>';
			if ( $whatThumb == 'open-lightbox' ) {
				$html .= '<a data-title="' .wp_kses_post( $thumbCaption ). '" title="' .esc_attr( $thumbCaption ). '" class="lightbox-item grid-item-mask-link" href="' .esc_url( $thumbFull[0] ). '" data-size="' .esc_attr( $dataSize ). '"><img class="lightbox-img-hide" width="' .esc_attr( $thumbFull[1] ). '" height="' .esc_attr( $thumbFull[2] ). '" src="' .esc_attr( $thumbBlank ). '" alt="' .esc_attr( get_the_title( $loop_post_id ) ). '" /></a>';
			} else {
				$maskLink = 'grid-item-mask-link';
				if($whatThumb == 'none') {
					$maskLink = false;
				}
				$html .= '<a href="' .esc_url( $permalink ). '" title="' .esc_html(get_the_title( $loop_post_id) ). '" class="' .sanitize_html_class($maskLink). '" '.wp_kses_post($openNewTabTarget).' rel="'.esc_attr( $rel ).'"></a>';
			}
			
			if ( $imageStyle == 'image' ) {
				$html .= '<div class="grid-item-con-text">';
				if($showTitle == 'on'){ $html .= '<h2 class="grid-item-tit">' .wp_kses_post( $titleLinkBefore ). '' .esc_html( get_the_title($loop_post_id) ). '' .wp_kses_post( $titleLinkAfter ). '</h2>'; }
				$html .= '</div>';
			}
		$html .= '</div>';
		
		$html .= '<div class="brick-content ux-lazyload-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';
		$html .= '<img class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadImgClass ).'" '.wp_kses_post( $imageLazyloadImgStyle ).' alt="' .esc_attr( get_the_title( $loop_post_id ) ). '">';
		$html .= '</div>';
		  
		//grid title
		if( $imageStyle == 'image-text' && $showTitle == 'on' ) {
			$html .= '<div class="grid-item-con-text-tit-shown ' .esc_attr( $textAlign ). ' ' .sanitize_html_class( $gridPadingClass ). '">';
			if($showTitle == 'on'){
				$html .= '<h2 class="grid-item-tit">' .wp_kses_post( $textImageText ). '</h2>';
			}
			$html .= '</div>';
		}
		
	$html .=   '</div>';
	$html .= '</section>';
	
	return $html;
}

function ux_cb_module_grid_templates_filter( $html='', $data=array() ) {
	$data = wp_parse_args( $data, array(
		'filterAlignClass' => false,
		'foundPosts' => 0,
		'source' => 'ux-portfolio',
		'taxonomy' => 'ux-portfolio-cat',
		'category' => false,
		'mediaQuery' => false,
		'postStatus' => 'publish',
		'postIn' => array(),
		'modulePostID' => false
	) );
	
	$html .= '<div class="clearfix grid-list-filter filters ' .sanitize_html_class( $data['filterAlignClass'] ). '">';
	$html .=   '<ul class="filters-ul">';
	$html .=     '<li class="filters-li active"><a id="all" class="filters-a" href="#" data-filter="*">' .esc_html__( 'All', 'bm-builder' ). '<span class="filter-num">' .esc_html( $data['foundPosts'] ). '</span></a></li>';
		$terms = get_terms( array( 'taxonomy' => $data['taxonomy'], 'parent' => $data['category'] ) );
		
		$data['postStatus'] = 'publish';
		if ( $data['source'] == 'attachment' && $data['mediaQuery'] ) {
			$data['postStatus'] = 'inherit';
			$data['taxonomy'] = 'ux-attachment-cat';
			
			$terms = wp_get_object_terms( $data['postIn'], $data['taxonomy'] );
			foreach ( $terms as $num => $category ) {
				if ( $category->parent != 0 ) {
					unset( $terms[$num] ) ;
				}
			}
		}
		
		if ( $terms ) {
			foreach ( $terms as $num => $category ) {
				$get_posts = get_posts(array(
					'posts_per_page' => -1,
					'post_type' => $data['source'],
					'post_status' => $data['postStatus'],
					'post__in' => $data['postIn'],
					'tax_query' => array(
						array(
							'taxonomy' => $data['taxonomy'],
							'field' => 'term_id',
							'terms' => intval( $category->term_id )
						),
					)
				));
				$category_count = count( $get_posts );
				
				if ( $data['source'] == 'attachment' ) {
					$category_count = 0;
					foreach ( $data['mediaQuery'] as $imagePost ) {
						$get_terms = get_the_terms( $imagePost, $data['taxonomy'] );
						if ( $get_terms && ! is_wp_error( $terms ) ) {
							foreach ( $get_terms as $term ) {
								if ( $term->term_id == $category->term_id ) {
									$category_count++;
								}
							}
						}
					}
				}
				
				$html .= sprintf( '<li class="filters-li"><a class="filters-a" data-filter=".filter_%1$s" href="%2$s" data-catid="%5$s" data-postid="%6$s">%3$s<span class="filter-num">%4$s</span></a></li>',
					esc_attr( $category->slug ),
					esc_url( get_category_link( $category->term_id ) ),
					esc_html( $category->name ),
					esc_html( $category_count ),
					esc_attr( $category->term_id ),
					esc_attr( $data['modulePostID'] )
				);
			}
		}
	$html .=   '</ul>';
	$html .= '</div>';
	
	return $html;
}