<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Button shortcode.
 */
function ux_cb_module_button_shortcode( $atts ) {
	$moduleID = 'button';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_button' );
	
	$html = ux_cb_get_module_template( $moduleID, $atts );
	return $html;
}
add_shortcode( 'ux_cb_button', 'ux_cb_module_button_shortcode' );

/**
 * UX Content Builder Module Button container.
 */
function ux_cb_module_button_container( $module, $moduleUnique ) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	
	//align
	$buttonAlignClass = 'btn-left';
	if ( $buttonAlign = get_post_meta( $post_id, '__ux_cb_module_button_align', true ) ) {
		$buttonAlignClass = $buttonAlign;
	}
	$buttonArrangeClassMobile = 'ux-horizontal';
	if ( $buttonArrangeMobile = get_post_meta( $post_id, '__ux_cb_module_button_arrange_mobile', true ) ) {
		$buttonArrangeClassMobile = $buttonArrangeMobile;
	}
	$buttonAlignClassMobile = 'btn-left-m';
	if ( $buttonAlignMobile = get_post_meta( $post_id, '__ux_cb_module_button_align_mobile', true ) ) {
		$buttonAlignClassMobile = $buttonAlignMobile;
	}
	
	//button
	$buttonCount = 1;
	$buttonItems = false;
	if ( $buttonItems = get_post_meta( $post_id, '_ux_cb_module_button_items', true ) ) {
		$buttonCount = count( $buttonItems );
		$itemFields = array();
		foreach ( $buttonItems as $num => $item_row ) {
			foreach ( $item_row as $field ) {
				$itemFields[$num][$field['name']] = $field['value'];
			}
		}
		$buttonItems = $itemFields;
	}
	
	//animation
	$animationClass = ux_cb_module_field_animation_class( $module );
	$animationEnd = ux_cb_module_field_animation_end( $module );
	
	//style
	if ( ! $module['is_frontend'] ) {
		$html .= '<style type="text/css">' . sanitize_text_field( ux_cb_module_button_style( $post_id, $moduleUnique, $html ) ). '</style>';
	}
	
	$html .= '<div class="btn-mod-wrap btn-'.esc_attr( $moduleUnique ).' ' .sanitize_html_class( $buttonAlignClass ). ' '.sanitize_html_class( $buttonAlignClassMobile ). ' ' .sanitize_html_class($buttonArrangeClassMobile).' ' .esc_attr( $animationClass ). '" data-animationend="' .esc_attr( $animationEnd ). '">';
	
	for( $i = 0; $i < $buttonCount; $i++ ) {
		$btnText = 'Botton ' .( $i + 1);
		$btnLink = '#';
		$btnLinkTarget = '_self';
		$btnClass = 'fadeInM';
		$btnShowIcon = false;
		$btnClass = array();
		$btnRel = '';
		$btnDownload = false;
		
		if ( $buttonItems ) {
			$btnText = $buttonItems[$i]['__ux_cb_module_button_item_text'];
			$btnLink = $buttonItems[$i]['__ux_cb_module_button_item_link'];
			if ( $buttonItems[$i]['__ux_cb_module_button_item_link_target'] == 'on' ) {
				$btnLinkTarget = '_blank';
				$btnRel.= 'noopener noreferrer ';
			}
			if ( isset( $buttonItems[$i]['__ux_cb_module_button_item_link_nofollow'] ) ):
				if ( $buttonItems[$i]['__ux_cb_module_button_item_link_nofollow'] == 'on' ) {
					$btnRel .= 'nofollow ';
				}
			endif;
			if ( isset( $buttonItems[$i]['__ux_cb_module_button_item_link_download'] ) ):
				if ( $buttonItems[$i]['__ux_cb_module_button_item_link_download'] == 'on' ) {
					$btnDownload = ' download';
				}
			endif;
			$btnClass[] = $buttonItems[$i]['__ux_cb_module_button_item_bg_color_mouseover_effect'];
			if ( $buttonItems[$i]['__ux_cb_module_button_items_show_icon'] == 'on' ) {
				$btnShowIcon = true;
				$btnClass[] = $buttonItems[$i]['__ux_cb_module_button_items_icon_position'];
				$btnIconEffect = $buttonItems[$i]['__ux_cb_module_button_items_icon_mouseover_effect'];
				if ( $btnIconEffect == 'mouseover' ) {
					$btnClass[] = 'on-mouseover';
				}
			}
		}

		if( $btnShowIcon && !$btnText ) {
			$btnClass[] = 'ux-cb-btn-only-icon';
		}
		
		$html .= '<a class="ux-btn ux-cb-btn-' .esc_attr( $moduleUnique ). '_' .esc_attr( $i ). ' ' .esc_attr( join( ' ', $btnClass ) ). '" href="' .esc_url( $btnLink ). '" target="' .esc_attr( $btnLinkTarget  ). '" rel="'.esc_attr( $btnRel ).'"'.esc_attr( $btnDownload ).'>';
		
		if ( $btnShowIcon ) {
			$btnSvgID = $buttonItems[$i]['__ux_cb_module_button_items_icon_svg'];
			$html .= '<span class="ux-btn-icon-wrap">';
			$html .=   ux_cb_get_svg_html( 'id', $btnSvgID );
			$html .= '</span>';
		}
		if( $btnText ) {
			$html .=   '<span class="ux-btn-text-wrap">';
			$html .=     '<span class="ux-btn-text">' .esc_html( $btnText ). '</span>';
			$html .=   '</span>';
		}
		$html .= '</a>';
	}
	
	$html .= '</div>';
	
	return $html;
}
add_filter( 'ux_cb_module_container_button', 'ux_cb_module_button_container', 10, 2 );
