<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder module add inline style.
 */
if ( ! function_exists( 'ux_cb_hosted_font_inline_style' ) ) {
	function ux_cb_hosted_font_inline_style() {
		$styleBefore = apply_filters( 'ux_cb_module_inline_style_before', '' );
		wp_add_inline_style( 'ux-cb-modules-style', $styleBefore );
	}
	add_action( 'wp_enqueue_scripts', 'ux_cb_hosted_font_inline_style', 9 );
	add_action( 'load-post.php', 'ux_cb_hosted_font_inline_style' );
	add_action( 'load-post-new.php', 'ux_cb_hosted_font_inline_style' );
}
if ( ! function_exists( 'ux_cb_module_add_inline_style' ) ) {
	function ux_cb_module_add_inline_style() {
		wp_add_inline_style( 'ux-cb-modules-style', ux_cb_module_inline_style() );
	}
	add_action( 'wp_enqueue_scripts', 'ux_cb_module_add_inline_style', 10 );
}

/**
 * UX Content Builder module inline style.
 */
if ( ! function_exists( 'ux_cb_module_inline_style' ) ) {
	/**
	 * Module Inline Style
	 */
	function ux_cb_module_inline_style() {
		$postID = ux_cb_get_the_post_id();
		
		$hasModules = get_post_meta($postID, 'modules', true);
		$style = '';
		$moduleStyle = '';
		
		$hasModules = apply_filters( 'ux_cb_page_has_modules', $hasModules );
		
		//$styleBefore = apply_filters( 'ux_cb_module_inline_style_before', '' );
		
		if($hasModules && is_array($hasModules)){
			foreach($hasModules as $moduleUnique){ 
				$post_id = ux_cb_get_the_module_post_id($moduleUnique);
				$moduleID = get_post_meta($post_id, 'module_id', true);
				
				$moduleStyle .= ' ';
				
				//padding
				$paddingStyle = '';
				$paddingTop = 0;
				if ( $paddingTop = get_post_meta( $post_id, '__ux_cb_module_top_padding', true ) ) { 
					if ( $paddingTop == 'zero' ){
						$paddingTop = 0;
					}
					$paddingStyle .= 'margin-top: ' .intval( $paddingTop ). 'px;';
				}
				$paddingBottom = 0;
				if ( $paddingBottom = get_post_meta( $post_id, '__ux_cb_module_bottom_padding', true ) ) {
					if ( $paddingBottom == 'zero' ) {
						$paddingBottom = 0;
					}
					$paddingStyle .= 'margin-bottom: ' .intval( $paddingBottom ). 'px;';
				}
				
				if ( $paddingStyle ) {
					$moduleStyle .= '.module-id-'.esc_attr( $moduleUnique ).'>.module-inside{' . esc_attr( $paddingStyle ) . '}';
				}
				
				//module group custom height
				$heightStyle = '';
				$spacingForScreenHeight = '';
				$spacingForScreenHeightDouble = '';
				if ( $moduleID == 'group' && !is_admin() ) {
					//Custom height
					$heightCustom = get_post_meta( $post_id, '__ux_cb_module_group_height_type', true );
					$heightCustomValue = '';
					$heightCustomValueMobile = '';
					if( $heightCustom == 'screen_height' ) {

						if ( $heightCustomValueGet = get_post_meta( $post_id, '__ux_cb_module_group_screen_height', true ) ) {
							if ( ! is_array( $heightCustomValueGet ) ) { $heightCustomValueGet = array( $heightCustomValueGet, 0 ); }
							$heightCustomValue = intval( $heightCustomValueGet[0] ).'vh';
							$heightCustomValueMobile = intval( $heightCustomValueGet[1] ).'vh';
						}
						if ( $heightCustomValue ) {
							$heightStyle = 'min-height: '.esc_attr( $heightCustomValue ).'; ';
						}
						if ( $heightCustomValueMobile ) {
							$heightStyle .= '--minheight-group-m: '.esc_attr( $heightCustomValueMobile ).'; ';
						}
					}
					
					//module group background color
					$background = get_post_meta( $post_id, '__ux_cb_module_group_background', true );
					if ( $background == 'background_color' ) {
						$bgColor = get_post_meta( $post_id, '__ux_cb_module_group_bg_color', true );
					} 
				}
				
				if ( $heightStyle ) {
					$moduleStyle .=  '.module-id-'. esc_attr( $moduleUnique ). '>.module-inside {'. esc_attr( $heightStyle ) . '}';
				}

				//module group inner padding left right
				if ( $moduleID == 'group' && !is_admin()  ) {
					$groupPadingLRStyle = '';
					$getGroupPadingLR = get_post_meta( $post_id, '__ux_cb_module_group_inner_padding_left_right', true );
					if ( ! is_array( $getGroupPadingLR ) ) { $getGroupPadingLR = array( $getGroupPadingLR, 0 ); }
					$groupPadingLR = intval( $getGroupPadingLR[0] );
					$groupPadingLRMobile = intval( $getGroupPadingLR[1] );
					if ( $groupPadingLR ) {
						$groupPadingLRStyle = 'padding-left:'.esc_attr($groupPadingLR).'px!important;padding-right:'.esc_attr($groupPadingLR).'px!important;';
					}
					if ( $groupPadingLRMobile ) {
						$groupPadingLRStyle .= '--padding-lr-group-mobile:'.esc_attr($groupPadingLRMobile).'px;';
					}

					//$groupPadingLRforContainer = intval( $groupPadingLR ) + 20;
					$groupPadingLRforContainer = intval( $groupPadingLR );
					if ( $groupPadingLRStyle ) {
						$moduleStyle .= '.module-id-'.esc_attr( $moduleUnique ).'>.module-inside,.module-id-'.esc_attr( $moduleUnique ).'>.module-inside>.module.col-0:not(.item){'.esc_attr($groupPadingLRStyle).'}';
						$moduleStyle .= '.container-class.container .col-0.module-id-'.esc_attr( $moduleUnique ).'>.module-inside{padding-left:'.esc_attr($groupPadingLRforContainer).'px!important;padding-right:'.esc_attr($groupPadingLRforContainer).'px!important;}';
					
					}
				}
				
				if ( $moduleID == 'group' && !is_admin()  ) {
					if ( $heightStyle ) {
						$moduleStyle .= 'div[data-module-unique="'.esc_attr( $moduleUnique ).'"] .module-inside,.module-id-'.esc_attr( $moduleUnique ).'>.module-inside { ';
						$moduleStyle .= esc_attr( $heightStyle );
						$moduleStyle .= ' }';
					}
					if ( $heightCustom == 'screen_height' ) {
						if ( $heightCustomValue ) { 
							$moduleStyle .= '.admin-bar .module-id-'.esc_attr( $moduleUnique ).'>.module-inside{min-height:calc('.esc_attr( $heightCustomValue ).' - 32px);}';
						}
					}
				}
				
				switch($moduleID){
					case 'button':       $moduleStyle .= ux_cb_module_button_style($post_id, $moduleUnique, $style);       break;
					case 'grid':         $moduleStyle .= ux_cb_module_grid_style($post_id, $moduleUnique, $style);         break;
					case 'masonry-grid': $moduleStyle .= ux_cb_module_masonry_grid_style($post_id, $moduleUnique, $style); break;
					case 'single-image': $moduleStyle .= ux_cb_module_single_image_style($post_id, $moduleUnique, $style); break;
					case 'slider':       $moduleStyle .= ux_cb_module_slider_style($post_id, $moduleUnique, $style);       break;
					case 'social-media': $moduleStyle .= ux_cb_module_social_media_style($post_id, $moduleUnique, $style); break;
					case 'text': 		 $moduleStyle .= ux_cb_module_text_style($post_id, $moduleUnique, $style); 		   break;
					case 'social-media': $moduleStyle .= ux_cb_module_social_media_style($post_id, $moduleUnique, $style); break;
					case 'contact-form': $moduleStyle .= ux_cb_module_contact_form_style($post_id, $moduleUnique, $style); break;
					case 'post-navi':    $moduleStyle .= ux_cb_module_post_navi_style($post_id, $moduleUnique, $style);    break;
					case 'embed':    	 $moduleStyle .= ux_cb_module_embed_style($post_id, $moduleUnique, $style);        break;
				}
			}

			//padding mobile
			//$moduleStyle .= '@media (max-width:767px) { ';
			foreach($hasModules as $moduleUnique){
				$post_id = ux_cb_get_the_module_post_id($moduleUnique);
				$paddingTop = 0;
				$paddingBottom = 0;
				$paddingTop = get_post_meta($post_id, '__ux_cb_module_top_padding', true);
				$paddingBottom = get_post_meta($post_id, '__ux_cb_module_bottom_padding', true);
				$paddingMobileStyle = '';
				$paddingTopMobile = intval($paddingTop) / 2;
				if($paddingTopMobile = get_post_meta($post_id, '__ux_cb_module_top_padding_mobile', true)){
					if($paddingTopMobile == 'zero'){
						$paddingTopMobile = 0;
					}
					$paddingMobileStyle .= '--top-mod-m:' .intval($paddingTopMobile). 'px;';
				}
				$paddingBottomMobile = intval($paddingBottom) / 2;
				if($paddingBottomMobile = get_post_meta($post_id, '__ux_cb_module_bottom_padding_mobile', true)){
					if($paddingBottomMobile == 'zero'){
						$paddingBottomMobile = 0;
					}
					$paddingMobileStyle .= '--bottom-mod-m:' .intval($paddingBottomMobile). 'px;';
				}
				if(esc_attr($paddingMobileStyle)) {
					$moduleStyle .= '.module-id-'.esc_attr( $moduleUnique ).'{'.esc_attr($paddingMobileStyle).'}';
				}
				
			}
			//$moduleStyle .= ' }';
		}

		$style = apply_filters( 'ux_cb_module_inline_style', $moduleStyle );
		//$styles = $styleBefore;
		$styles = $style;
		
		return $styles;
	}
}

/**
 * UX Content Builder fonts assignment inline style.
 */
if ( ! function_exists( 'ux_cb_fonts_assignment_inline_style' ) ) {
	function ux_cb_fonts_assignment_inline_style( $custom_css ) {
		//$custom_css = '';
		
		$fontAssignment = get_option( 'ux-font-assignment' );
		if ( $fontAssignment ) {
//			$tags = false;
//			if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_tag'] ) ) {
//				$tags = $fontAssignment['__ux_cb_module_custom_font_group_tag'];
//			}
//			
//			foreach( array( 'family', 'size', 'spacing', 'm-size', 'line_height' ) as $key ) { print_r($key);
//				$name = '__ux_cb_module_custom_font_group_' .$key;
//				if ( isset( $fontAssignment[$name] ) ) {
//					if ( is_array( $fontAssignment[$name] ) ) {
//						foreach ( $fontAssignment[$name] as $num => $g ) {
//							$tag = false;
//							if ( isset ( $tags[$num] ) ) { $tag = $tags[$num]; }
//							$custom_css .= ux_cb_fonts_get_font_assignment( '__ux_cb_module_custom_font_group', $key, $tag );
//						}
//					}
//				}
//			}
			
			if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_tag'] ) ) {
				$tags = $fontAssignment['__ux_cb_module_custom_font_group_tag'];
				if ( is_array( $tags ) ) {
					foreach ( $tags as $num => $selector ) {
						$custom_css .= $selector ? $selector. ' { ' : false;
						
						if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_family'][$num] ) ) {
							$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_family'][$num];
							if ( function_exists ( 'ux_cb_fonts_load_font_data' ) ) {
								$fontData = ux_cb_fonts_load_font_data( $fontValue );
								if ( $fontData != '' ) { 
									$custom_css .= $fontData; 
								}
							}
						}
						if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_size'][$num] ) ) {
							$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_size'][$num];
							if ( $fontValue && $fontValue != 'Size' ) { $custom_css .= 'font-size: ' .$fontValue. '; '; }
						}
						
						if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_spacing'][$num] ) ) {
							$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_spacing'][$num];
							if ( $fontValue && $fontValue !='Spacing' ) { $custom_css .= 'letter-spacing: ' .$fontValue. '; ';}
						}
						
						if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_line_height'][$num] ) ) {
							$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_line_height'][$num];
							if ( $fontValue && $fontValue != 'Line Height' ) { $custom_css .= 'line-height: ' .$fontValue. '; '; }
						}
						
						$custom_css .= $selector ? "}\n" : false;
						
						if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_m-size'][$num] ) ) {
							$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_m-size'][$num];
							if ( $fontValue && $fontValue != 'Mobile Size' ) {
								$custom_css .= '@media (max-width: 767px) { ';
								$custom_css .= $selector ? $selector. ' { ' : false;
								$custom_css .= 'font-size: ' .$fontValue. '; ';
								$custom_css .= $selector ? "} }\n" : false;
							}
						}
					}
				} else {
					$selector = $tags;
					$custom_css .= $selector ? $selector. ' { ' : false;
					
					if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_family'] ) ) {
						$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_family'];
						if ( function_exists ( 'ux_cb_fonts_load_font_data' ) ) {
							$fontData = ux_cb_fonts_load_font_data( $fontValue );
							if ( $fontData != '' ) { 
								$custom_css .= $fontData; 
							}
						}
					}
					if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_size'] ) ) {
						$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_size'];
						if ( $fontValue && $fontValue != 'Size' ) { $custom_css .= 'font-size: ' .$fontValue. '; '; }
					}
					
					if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_spacing'] ) ) {
						$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_spacing'];
						if ( $fontValue && $fontValue !='Spacing' ) { $custom_css .= 'letter-spacing: ' .$fontValue. '; ';}
					}
					
					if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_line_height'] ) ) {
						$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_line_height'];
						if ( $fontValue && $fontValue != 'Line Height' ) { $custom_css .= 'line-height: ' .$fontValue. '; '; }
					}
					
					$custom_css .= $selector ? "}\n" : false;
					
					if ( isset( $fontAssignment['__ux_cb_module_custom_font_group_m-size'] ) ) {
						$fontValue = $fontAssignment['__ux_cb_module_custom_font_group_m-size'];
						if ( $fontValue && $fontValue != 'Mobile Size' ) {
							$custom_css .= '@media (max-width: 767px) { ';
							$custom_css .= $selector ? $selector. ' { ' : false;
							$custom_css .= 'font-size: ' .$fontValue. '; ';
							$custom_css .= $selector ? "} }\n" : false;
						}
					}
				}
			}
		}
		return $custom_css;
	}
}
add_filter( 'ux_cb_module_inline_style', 'ux_cb_fonts_assignment_inline_style' );

if ( ! function_exists( 'ux_cb_module_button_style' ) ) {
	/**
	 * Module Style for module button
	 */
	function ux_cb_module_button_style( $post_id, $moduleUnique, $style) {

		$buttonsStyle = '';
		$buttonsStyleMobile = '';
		$buttonsTextStyle = ''; 
		if($buttonsStyleFont = get_post_meta($post_id, '__ux_cb_module_button_text_font_font', true)){
			$buttonsStyle .= ux_cb_fonts_load_font_data($buttonsStyleFont);
		}
		if($buttonsStyleFontSize = get_post_meta($post_id, '__ux_cb_module_button_text_font_size', true)){
		$buttonsStyle .= 'font-size: ' .$buttonsStyleFontSize. ';';
		}
		if($buttonsStyleFontSizeMobile = get_post_meta($post_id, '__ux_cb_module_button_text_font_msize', true)){
			$buttonsStyleMobile .= $buttonsStyleFontSizeMobile;
		}
		if($buttonsStyleFontLineheight = get_post_meta($post_id, '__ux_cb_module_button_text_font_lineheight', true)){
			$buttonsStyle .= 'line-height: ' .$buttonsStyleFontLineheight. ';';
		}
		if($buttonsStyleFontLetterSpacing = get_post_meta($post_id, '__ux_cb_module_button_text_font_letter_spacing', true)){
			$buttonsStyle .= 'letter-spacing: ' .intval( esc_attr( $buttonsStyleFontLetterSpacing ) ). 'px;';
		}
		// text micro posi
		if ( $btnTextVeticalPosi = get_post_meta( $post_id,'__ux_cb_module_button_item_text_vertical_posi', true ) ) { 
			if( $btnTextVeticalPosi != '0' ) {
				$buttonsTextStyle .= 'margin-top: ' .esc_attr( $btnTextVeticalPosi ). 'px;';
			}
		}
		//left-right spacing 
		$getButtonLeftSpacing = get_post_meta( $post_id, '__ux_cb_module_button_item_left_spacing', true );
		if( ! is_array( $getButtonLeftSpacing ) ) { $getButtonLeftSpacing = array( $getButtonLeftSpacing, 0 ); }
		$buttonLeftSpacing = $getButtonLeftSpacing[0];
		$buttonLeftSpacingMobile = $getButtonLeftSpacing[1];
		if( $buttonLeftSpacing ) {
			$buttonsStyle .= 'margin-left:'.esc_attr( intval ( $buttonLeftSpacing ) ).'px;';
		}
		if( $buttonLeftSpacingMobile ) {
			$buttonsStyle .= '--marginleft-button:'.esc_attr( $buttonLeftSpacingMobile ).'px;';
		}
		$getButtonRightSpacing = get_post_meta( $post_id, '__ux_cb_module_button_item_right_spacing', true );
		if( ! is_array( $getButtonRightSpacing ) ) { $getButtonRightSpacing = array( $getButtonRightSpacing, 0 ); }
		$buttonRightSpacing = $getButtonRightSpacing[0];
		$buttonRightSpacingMobile = $getButtonRightSpacing[1];
		if ( $buttonRightSpacing ) {
			$buttonsStyle .= 'margin-right:'.esc_attr( intval( $buttonRightSpacing ) ).'px;';
		}
		if( $buttonRightSpacingMobile ) {
			$buttonsStyle .= '--marginright-button:'.esc_attr( $buttonRightSpacingMobile ).'px;';
		}

		//Bottom spacing mobile
		if ( $getButtonBottomSpacingMobile = get_post_meta( $post_id, '__ux_cb_module_button_item_bottom_spacing_m', true ) ) {
			$buttonsStyle .= '--marginbottom-button:'.esc_attr( $getButtonBottomSpacingMobile ).'px;';
		}
		
	 	$style .= '.btn-'.esc_attr($moduleUnique ).' .ux-btn { '.sanitize_text_field( $buttonsStyle ).'}';
	 	if ( $buttonsStyleMobile ) {
	 		$style .= '.btn-'.esc_attr( $moduleUnique ).' { --msize-btn: '.esc_attr( $buttonsStyleMobile ).' }';
	 	}
	 	if ( $buttonsTextStyle ) {
	 		$style .= '.btn-'.esc_attr( $moduleUnique ).' .ux-btn-text-wrap{ '.esc_attr( $buttonsTextStyle ).' }';
	 	}

		//buttons
		$buttonCount = 4;
		$buttonItems = false;
		if ( $buttonItems = get_post_meta( $post_id, '_ux_cb_module_button_items', true ) ) {
			$buttonCount = count( $buttonItems );
			$itemFields = array( );
			foreach ( $buttonItems as $num => $item_row ) {
				foreach ( $item_row as $field ) {
					$itemFields[$num][$field['name']] = $field['value'];
				}
			}
			$buttonItems = $itemFields;
		}
		
		for( $i = 0; $i < $buttonCount; $i++ ) {
			if ( $buttonItems ) {
				$btnStyle = array();
				$btnHoverStyle = array();
				$btnBorderStyle = array();
				$btnBorderHoverStyle = array();
				$btnTextStyle = array();
				$btnIconStyle = array();
				$btnIconSpaceStyle = array();
				$btnIconColorStyle = array();
				$btnIconHoverColorStyle = array();

				$btnTextColor = $buttonItems[$i]['__ux_cb_module_button_item_text_color'];
				if ( $btnTextColor != '' ) {
					$btnStyle['color'] = 'color: ' .esc_attr( $btnTextColor ). ';';
					$btnIconColorStyle['color'] = 'fill: ' .esc_attr( $btnTextColor ). ';';
				}
				
				$btnBorderColor = $buttonItems[$i]['__ux_cb_module_button_item_border_color'];
				if ( $btnBorderColor != '' ) {
					$btnBorderStyle['border-color'] = 'border-color: ' .esc_attr( $btnBorderColor ). ';';
				}
				
				$btnWidthType = $buttonItems[$i]['__ux_cb_module_button_item_width_type'];
				if ( $btnWidthType == 'fixed-width') {
					$btnWidth = intval( $buttonItems[$i]['__ux_cb_module_button_item_width'] );
					if ( $btnWidth ) {
						$btnStyle['width'] = 'width: ' .esc_attr( $btnWidth ). 'px;';
					}
				} else if ( $btnWidthType == 'spacing-left-right' ) {
					$btnSpacing = intval( $buttonItems[$i]['__ux_cb_module_button_item_spacing'] );
					if ( $btnSpacing ) {
						$btnStyle['padding-left'] = 'padding-left:' .esc_attr( $btnSpacing ). 'px;';
						$btnStyle['padding-right'] = 'padding-right:' .esc_attr( $btnSpacing ). 'px;';
					}
				}
				
				$btnHeight = intval( $buttonItems[$i]['__ux_cb_module_button_item_height'] );
				if ( $btnHeight ) {
					$btnStyle['height'] = 'height:' .esc_attr( $btnHeight ). 'px;';
					$btnStyle['line-height'] = 'line-height:' .esc_attr( $btnHeight ).'px;';
				}
				
				$btnBorderWidth = explode( ',', $buttonItems[$i]['__ux_cb_module_button_item_border_width'] );
				if ( $btnBorderWidth ) {
					if ( ! is_array( $btnBorderWidth ) ) { $btnBorderWidth = array( $btnBorderWidth ); }
					foreach ( $btnBorderWidth as $borderNum => $borderWidth ) {
						if ( $borderWidth == '' ) {
							$btnBorderWidth[$borderNum] = 0;
						}
					}
					$btnBorderStyle['border-width'] = 'border-width:' .esc_attr( join( 'px ', $btnBorderWidth ) ). 'px;';
				}
				
				$btnBorderRadius = intval( $buttonItems[$i]['__ux_cb_module_button_item_border_radius'] );
				if ( $btnBorderRadius ) {
					$btnBorderStyle['border-radius'] = 'border-radius:' .esc_attr( $btnBorderRadius ). 'px;';
				}
				
				$btnTextColorMouseover = $buttonItems[$i]['__ux_cb_module_button_item_text_color_mouseover'];
				if ( $btnTextColorMouseover != '' ) {
					$btnHoverStyle['color'] = 'color: ' .esc_attr( $btnTextColorMouseover ). ';';
					$btnIconHoverColorStyle['color'] = 'fill: ' .esc_attr( $btnTextColorMouseover ). ';';
				}
				
				$btnBorderColorMouseover = $buttonItems[$i]['__ux_cb_module_button_item_border_color_mouseover'];
				if ( $btnBorderColorMouseover != '' ) {
					$btnBorderHoverStyle['border-color'] = 'border-color:' .esc_attr( $btnBorderColorMouseover ). ';';
				}
				
				$btnBorderWidthMouseover = explode( ',', $buttonItems[$i]['__ux_cb_module_button_item_border_width_mouseover'] );
				if ( $btnBorderWidthMouseover ) {
					if ( ! is_array( $btnBorderWidthMouseover ) ) { $btnBorderWidthMouseover = array( $btnBorderWidthMouseover ); }
					foreach ( $btnBorderWidthMouseover as $borderNum => $borderWidth ) {
						if ( $borderWidth == '' ) {
							$btnBorderWidthMouseover[$borderNum] = 0;
						}
					}
					$btnBorderHoverStyle['border-width'] = 'border-width: ' .esc_attr( join( 'px ', $btnBorderWidthMouseover ) ). 'px;';
				}
				
				if ( $buttonItems[$i]['__ux_cb_module_button_items_show_icon'] == 'on' ) {
					$btnIconWidth = intval( $buttonItems[$i]['__ux_cb_module_button_items_icon_width'] );
					$btnIconPosition = $buttonItems[$i]['__ux_cb_module_button_items_icon_position'];
					if ( $btnIconWidth ) {
						if ( $buttonItems[$i]['__ux_cb_module_button_items_icon_mouseover_effect'] == 'mouseover' ) {
							if($btnIconPosition === 'on-right') {
								$btnTextStyle['translateX'] = 'transform:translateX(' .esc_attr( intval( $btnIconWidth ) ). 'px);';
							} else {
								$btnTextStyle['translateXn'] = 'transform:translateX(-' .esc_attr( intval( $btnIconWidth) ). 'px);';
							}
						}
					
						$btnIconStyle['width'] = 'width: ' .esc_attr( $btnIconWidth ). 'px;';
					}
					if ( isset( $buttonItems[$i]['__ux_cb_module_button_items_icon_spacing_and_text'] ) ) {
						$btnIconSpacing = intval( $buttonItems[$i]['__ux_cb_module_button_items_icon_spacing_and_text'] );
						if ( $btnIconSpacing ) {
							if($btnIconPosition === 'on-right') {
								$btnIconStyle['margin-left'] = 'margin-left:'.esc_attr( $btnIconSpacing ).'px;'; 
							} else {
								$btnIconStyle['margin-right'] = 'margin-right:'.esc_attr( $btnIconSpacing ).'px;'; 
							}
						}
					}
				}
				
				if ( $moduleUnique ) {
					$style .= "\r\n";
					$btnItemClassName = '.btn-mod-wrap .ux-cb-btn-' .esc_attr( $moduleUnique ). '_' .esc_attr( $i );
					
					if ( count( $btnStyle ) ) {
						$style .= $btnItemClassName. '{' .join( ' ', $btnStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count( $btnIconColorStyle ) ) {
						$style .= $btnItemClassName. ' svg *{' .join( ' ', $btnIconColorStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count( $btnHoverStyle ) ) {
						$style .= $btnItemClassName. ':hover{' .join( ' ', $btnHoverStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count( $btnIconHoverColorStyle ) ) {
						$style .= $btnItemClassName. ':hover svg *{' .join( ' ', $btnIconHoverColorStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count( $btnBorderStyle ) ) {
						$style .= $btnItemClassName. ':before,'.$btnItemClassName.':after{' .join( ' ', $btnBorderStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count( $btnBorderHoverStyle ) ) {
						$style .= $btnItemClassName. ':hover:before,'.$btnItemClassName. ':hover:after{' .join( ' ', $btnBorderHoverStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count ( $btnTextStyle ) ) {
						$style .= $btnItemClassName. ' .ux-btn-text-wrap{' .join( ' ', $btnTextStyle ). ' }';
						//$style .= "\r\n";
					}
					if ( count ( $btnIconStyle ) ) {
						$style .= $btnItemClassName. ' .ux-btn-icon-wrap{' .join( ' ', $btnIconStyle ). ' }';
						//$style .= "\r\n";
					}

					if ( count ( $btnIconSpaceStyle ) ) {
						$style .= $btnItemClassName. '.on-mouseover:hover .ux-btn-icon-wrap,'.$btnItemClassName. ':not(.on-mouseover) .ux-btn-icon-wrap {' .join( ' ', $btnIconSpaceStyle ). ' }';
					}
				
					$btnBgColor = $buttonItems[$i]['__ux_cb_module_button_item_bg_color'];
					if ( $btnBgColor != '' ) {
						$style .= $btnItemClassName. ':after,'.$btnItemClassName.':before{background-color:' .esc_attr( $btnBgColor ). '!important;}';
					}
				
					$btnBgColorMouseover = $buttonItems[$i]['__ux_cb_module_button_item_bg_color_mouseover'];
					if ( $btnBgColorMouseover != '' ) {
						$style .= $btnItemClassName. ':hover:after{background-color: ' .esc_attr( $btnBgColorMouseover ). '!important;}';
					}
				}
			}
		}//End for
		
		return $style;
	}
}

if ( ! function_exists( 'ux_cb_module_grid_style' ) ) {
	/**
	 * Module Style for module grid
	 */
	function ux_cb_module_grid_style($post_id, $moduleUnique, $style) {
		//source
		$source = get_post_meta($post_id, '__ux_cb_module_grid_source', true);
		if(!$source){
			$source = 'ux-portfolio';
		}

		//image style
		$imageStyle = get_post_meta($post_id, '__ux_cb_module_grid_item_style', true);
		if(!$imageStyle){
			$imageStyle = 'image';
		}

		//source
		$source = get_post_meta($post_id, '__ux_cb_module_grid_source', true);
		if(!$source){
			$source = 'ux-portfolio';
		}

		//mouseover effect
		$mouseoverEffect = false;
		switch ( $imageStyle ) {
			case 'image': 
				if($source == 'attachment'){
					$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mouseover_effect-attachment', true); break;
				}else{
					$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mouseover_effect', true); break;
				}
			case 'image-text': $mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_mouseover_effect', true); break;
		}

		//showText
		$showText = false;

		if ( $imageStyle === 'image-text' ) {

			$showText = 'on';

		} else {

			if ( $mouseoverEffect === 'static-color-mask-text' || $mouseoverEffect == 'second-featured-image-text' ) {
				$showText = 'on';
			}

		}

		//transparent mask
		//transparent mask color
		switch ($source) {
			case 'attachment':
				$transparentMask = get_post_meta($post_id, '__ux_cb_module_grid_style_image_transparent_mask_attachment', true);
				$transparentMaskColor = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mask_color_attachment', true);
				break;
			
			default:
				$transparentMask = get_post_meta($post_id, '__ux_cb_module_grid_style_image_transparent_mask', true);
				$transparentMaskColor = get_post_meta($post_id, '__ux_cb_module_grid_style_image_mask_color', true);
				break;
		}
		
		//transparent mask style
		$opacityStyle = false; 
		$backgroundColorStyle = false;
		if ( $imageStyle == 'image' ) {
			if ( $mouseoverEffect == 'static-color-mask-text' ) {
				$opacityStyle = 'opacity: ' .esc_attr( $transparentMask ). ';';
				$backgroundColorStyle = '';
				
				if ( $mouseoverEffect == 'static-color-mask-text' && $transparentMaskColor ) {
					$backgroundColorStyle = 'background-color: ' .esc_attr( $transparentMaskColor ). ';';
				}
			}
		}

		//spacing horizontal
		$getSpacingHorizontal = get_post_meta( $post_id, '__ux_cb_module_grid_item_spacing_horizontal', true );
		if ( ! is_array( $getSpacingHorizontal ) ) { $getSpacingHorizontal = array( $getSpacingHorizontal, 0 ); }
		$spacingHorizontal = $getSpacingHorizontal[0];
		$spacingHorizontalMobile = $getSpacingHorizontal[1]; 

		//spacing vertical
		$getSpacingVertical = get_post_meta( $post_id, '__ux_cb_module_grid_item_spacing_vertical', true );
		if ( ! is_array( $getSpacingVertical ) ) { $getSpacingVertical = array( $getSpacingVertical, 0 ); }
		$spacingVertical = $getSpacingVertical[0];
		$spacingVerticalMobile = $getSpacingVertical[1]; 

		//title style
		$textGroupName = '';
		$titleStyle = '';
		$titleStyleMobile = '';

		if ( $showText === 'on' ) { 
			
			if ( $source === 'post' || $source === 'ux-portfolio' || $source === 'product' ) {

				//Get textGroup
				$textGroupMod = 'title'; //title, category, excerpt, date 
			
				if ( $source === 'product') {

					if ( $imageStyle === 'image-text' ) {

						$textGroupName =  '__ux_cb_module_grid_product_image_text_text_group_' .$textGroupMod;

					} elseif ( $imageStyle === 'image' ) {

						$textGroupName =  '__ux_cb_module_grid_product_text_group_' .$textGroupMod;
					}

				}  else {

					if ( $imageStyle === 'image-text' ) {

						$textGroupName = '__ux_cb_module_grid_style_image_text_text_group_' .$textGroupMod;

					} elseif ( $imageStyle === 'image' ) {

						$textGroupName = '__ux_cb_module_grid_style_image_text_group_' .$textGroupMod;
					}
				}

				//font
				if ( $titleStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$titleStyle .= ux_cb_fonts_load_font_data( $titleStyleFont );
				}
				
				//font size
				if ( $titleStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$titleStyle .= 'font-size: ' .$titleStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $titleStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$titleStyle .= '--fontsize-grid-title-m: ' .$titleStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $titleStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$titleStyle .= 'line-height: ' .$titleStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $titleStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$titleStyle .= 'letter-spacing: ' .intval( esc_attr( $titleStyleFontLetterSpacing ) ). 'px;';
				}

				//color
				if ( $titleStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$titleStyle .= 'color: ' .esc_attr($titleStyleColor). ';'; 
				}

			}
			
			
			if ( $source === 'attachment' ) {

				if ( $imageStyle === 'image') {

						if( $titleStyleFont = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_title_text_font_attachment_font', true ) ) {	
							$titleStyle .= ux_cb_fonts_load_font_data($titleStyleFont);
						}
						if( $titleStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_title_text_font_attachment_size', true ) ) {
							$titleStyle .= 'font-size: ' .$titleStyleFontSize. ';';
						}
						if( $titleStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_title_text_font_attachment_msize', true ) ) {
							$titleStyle .= '--fontsize-grid-title-m: ' .$titleStyleFontSizeMobile. ';';
						}
						if( $titleStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_title_text_font_attachment_lineheight', true ) ) {
							$titleStyle .= 'line-height: ' .$titleStyleFontLineheight. ';';
						}
						if( $titleStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_title_text_font_letter_attachment_spacing', true ) ) {
							$titleStyle .= 'letter-spacing: ' .intval(esc_attr($titleStyleFontLetterSpacing)). 'px;';
						}
					
				} elseif ( $imageStyle === 'image-text') {

					if( $titleStyleFont = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_caption_text_font_font', true ) ) {
						$titleStyle .= ux_cb_fonts_load_font_data($titleStyleFont);
					}
					if( $titleStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_caption_text_font_size', true ) ) {
						$titleStyle .= 'font-size: ' .$titleStyleFontSize. ';';
					}
					if( $titleStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_caption_text_font_msize', true ) ) {
						$titleStyle .= '--fontsize-grid-title-m: ' .$titleStyleFontSizeMobile. ';';
					}
					if( $titleStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_caption_text_font_lineheight', true ) ) {
						$titleStyle .= 'line-height: ' .$titleStyleFontLineheight. ';';
					}
					if( $titleStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_caption_text_font_letter_spacing', true ) ) {
						$titleStyle .= 'letter-spacing: ' .intval(esc_attr($titleStyleFontLetterSpacing)). 'px;';
					}
				}

			} 

		} //End showText

		//title top spacing 
		$titleTopSpacingStyle = '';
  
		if( $showText === 'on' ) {
		
			if ( $source === 'post' || $source === 'ux-portfolio' || $source === 'product' ) {

				$textGroupMod = 'title'; 

				if ( $source === 'product') { 

					if ( $imageStyle === 'image-text' ) { 
						$textGroupName =  '__ux_cb_module_grid_product_image_text_text_group_' .$textGroupMod;
					} elseif ( $imageStyle === 'image' ) {
						$textGroupName =  '__ux_cb_module_grid_product_text_group_' .$textGroupMod;
					}

				}  else {

					if ( $imageStyle === 'image-text' ) {
						$textGroupName = '__ux_cb_module_grid_style_image_text_text_group_' .$textGroupMod; 
					} elseif ( $imageStyle === 'image' ) {
						$textGroupName = '__ux_cb_module_grid_style_image_text_group_' .$textGroupMod;
					}
				}
				
				if ( $titleTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {

					$titleTopSpacing = explode( ',', $titleTopSpacing );
					$titleTopSpacingStyle .= 'margin-top: ' .intval( esc_attr( $titleTopSpacing[0] ) ). 'px;';
					$titleTopSpacingStyle .= '--margintop-grid-title-m: ' .intval( esc_attr( $titleTopSpacing[1] ) ). 'px;';
				
				}

			}

			if ( $source === 'attachment' ) {

				if ( $titleTopSpacing =  get_post_meta( $post_id, '__ux_cb_module_grid_item_caption_spacing_top', true ) )  {

					if ( ! is_array( $titleTopSpacing ) ) { $titleTopSpacing = array( $titleTopSpacing, 0 ); }
					$titleTopSpacingDesktop = intval( $titleTopSpacing[0] );
					$titleTopSpacingMobile = intval( $titleTopSpacing[1] );

					if ( $titleTopSpacingDesktop ) {
						$titleTopSpacingStyle .= 'margin-top: ' .esc_attr( $titleTopSpacingDesktop ). 'px;';
					}

					if ( $titleTopSpacingMobile ) {
						$titleTopSpacingStyle .= '--margintop-grid-title-m: ' .esc_attr( $titleTopSpacingMobile ). 'px;';
					}
				}
			}

		} //End showText
		
		//category style when Image + Text
		$categoryStyle = ''; 
		$categoryColorStyle = '';
		$cateTopSpacingStyle = ''; 

		if($source == 'post' || $source == 'ux-portfolio'){
			
			if ( $showText === 'on' ) {

				$textGroupMod = 'category'; 

				if ( $imageStyle === 'image-text' ) {

					$textGroupName = '__ux_cb_module_grid_style_image_text_text_group_' .$textGroupMod; 

				} elseif ( $imageStyle === 'image' ) {

					$textGroupName = '__ux_cb_module_grid_style_image_text_group_' .$textGroupMod;
				}
				
				//font
				if ( $categoryStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$categoryStyle .= ux_cb_fonts_load_font_data( $categoryStyleFont );
				}
				
				//font size
				if ( $categoryStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$categoryStyle .= 'font-size: ' .$categoryStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $categoryStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$categoryStyle .= '--fontsize-grid-cate-m: ' .$categoryStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $categoryStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$categoryStyle .= 'line-height: ' .$categoryStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $categoryStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$categoryStyle .= 'letter-spacing: ' .intval( esc_attr( $categoryStyleFontLetterSpacing ) ). 'px;';
				}

				//color
				if ( $categoryStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$categoryColorStyle .= 'color: ' .esc_attr($categoryStyleColor). ';'; 
				}

				//top spacing
				if ( $categoryStyleTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$categoryStyleTopSpacing = explode( ',', $categoryStyleTopSpacing );
					
					$cateTopSpacingStyle .= 'margin-top: ' .intval( esc_attr( $categoryStyleTopSpacing[0] ) ). 'px;';
					$cateTopSpacingStyle .= '--margintop-grid-cate-m: ' .intval( esc_attr( $categoryStyleTopSpacing[1] ) ). 'px;';
				}
			}
		}

		//excerpt top spacing
		//excerpt style
		$excerptTopSpacingStyle = ''; 
		$excerptStyle = '';
		$excerptStyleMobile = '';

		if ($source == 'post' || $source == 'ux-portfolio') {

			if ( $showText == 'on' ) {

				$textGroupMod = 'excerpt'; 
				if ( $imageStyle === 'image-text' ) {
					$textGroupName = '__ux_cb_module_grid_style_image_text_text_group_' .$textGroupMod; 
				} elseif ( $imageStyle === 'image' ) {
					$textGroupName = '__ux_cb_module_grid_style_image_text_group_' .$textGroupMod;
				}
				
				//font
				if ( $excerptStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$excerptStyle .= ux_cb_fonts_load_font_data( $excerptStyleFont );
				}
				
				//font size
				if ( $excerptStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$excerptStyle .= 'font-size: ' .$excerptStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $excerptStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$excerptStyle .= '--fontsize-grid-des-m: ' .$excerptStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $excerptStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$excerptStyle .= 'line-height: ' .$excerptStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $excerptStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$excerptStyle .= 'letter-spacing: ' .intval( esc_attr( $excerptStyleFontLetterSpacing ) ). 'px;';
				}

				//color
				if ( $excerptStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$excerptStyle .= 'color: ' .esc_attr($excerptStyleColor). ';'; 
				}

				//top spacing
				if ( $excerptStyleTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$excerptStyleTopSpacing = explode( ',', $excerptStyleTopSpacing );
					
					$excerptTopSpacingStyle .= 'margin-top: ' .intval( esc_attr( $excerptStyleTopSpacing[0] ) ). 'px;';
					$excerptTopSpacingStyle .= '--margintop-grid-excerpt-m: ' .intval( esc_attr( $excerptStyleTopSpacing[1] ) ). 'px;';
				}

			} 
		}

		//date style
		$dateStyle = '';

		if ($source == 'post' || $source == 'ux-portfolio') {

			if ( $showText === 'on' ) {
					
				$textGroupMod = 'date'; 

				if ( $imageStyle === 'image-text' ) {

					$textGroupName = '__ux_cb_module_grid_style_image_text_text_group_' .$textGroupMod;

				} elseif ( $imageStyle === 'image' ) {

					$textGroupName = '__ux_cb_module_grid_style_image_text_group_' .$textGroupMod;
				}
				
				//font
				if ( $dateStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$dateStyle .= ux_cb_fonts_load_font_data( $dateStyleFont );
				}
				
				//font size
				if ( $dateStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$dateStyle .= 'font-size: ' .$dateStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $dateStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$dateStyle .= '--fontsize-grid-date-m: ' .$dateStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $dateStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$dateStyle .= 'line-height: ' .$dateStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $dateStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$dateStyle .= 'letter-spacing: ' .intval( esc_attr( $dateStyleFontLetterSpacing ) ). 'px;';
				}

				//Top spacing
				if ( $dateTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$dateTopSpacing = explode( ',', $dateTopSpacing );
					
					$dateStyle .= 'margin-top: ' .intval( esc_attr( $dateTopSpacing[0] ) ). 'px;';
					$dateStyle .= '--margintop-grid-date-m: ' .intval( esc_attr( $dateTopSpacing[1] ) ). 'px;';
				}

				//color
				if ( $dateStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$dateStyle .= 'color: ' .esc_attr($dateStyleColor). ';'; 
				}
			}
			
		}
		
		//price style
		$priceStyle = '';
		$priceStyleMobile = '';
		$priceTopSpacingStyle = '';

		if ( $source == 'product' ) {

			if ( $showText === 'on') {

				$textGroupMod = 'price'; 
				if ( $imageStyle === 'image-text' ) {
					$textGroupName = '__ux_cb_module_grid_product_image_text_text_group_' .$textGroupMod; 
				} elseif ( $imageStyle === 'image' ) {
					$textGroupName = '__ux_cb_module_grid_product_text_group_' .$textGroupMod;
				}

				//font
				if ( $priceStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$priceStyle .= ux_cb_fonts_load_font_data( $priceStyleFont );
				}
				
				//font size
				if ( $priceStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$priceStyle .= 'font-size: ' .$priceStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $priceStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$priceStyle .= '--fontsize-grid-price-m: ' .$priceStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $priceStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$priceStyle .= 'line-height: ' .$priceStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $priceStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$priceStyle .= 'letter-spacing: ' .intval( esc_attr( $priceStyleFontLetterSpacing ) ). 'px;';
				}

				//Top spacing
				if ( $priceTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$priceTopSpacing = explode( ',', $priceTopSpacing );
					
					$priceTopSpacingStyle = 'margin-top: ' .intval( esc_attr( $priceTopSpacing[0] ) ). 'px;';
					$priceStyle .= '--margintop-grid-price-m: ' .intval( esc_attr( $priceTopSpacing[1] ) ). 'px;';
				}

				//color
				if ( $priceStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$priceStyle .= 'color: ' .esc_attr($priceStyleColor). ';'; 
				}
			}
			
		}

		//Attachment Text color 

		if ( $source === 'attachment' )  {

			if ( $showText === 'on' ) {

				if ( $imageStyle === 'image' ) {

					$titleStyleColor = get_post_meta( $post_id, '__ux_cb_module_grid_attachment_style_image_text_color', true );
					if ( $titleStyleColor) {
						$titleStyle .= 'color: ' .esc_attr( $titleStyleColor ). ';';
					}

				} elseif ( $imageStyle === 'image-text' ) {
					if ( $titleStyleColor = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_caption_color', true ) ) {
						$titleStyle .= 'color: ' .esc_attr($titleStyleColor). ';'; 
					}
				}
			}

		}

		//Text Padding Image style
		$gridItemConTextPaddingStyle = '';
		$gridItemConTextPaddingLeftRight = '0';
		$gridItemConTextPaddingTopBottom = '0';
		$gridImageTextAlign = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_text_align', true);
				
		if ( $imageStyle == 'image' ) {

			//Grid Text Left/Right
			$gridItemConTextPaddingLeftRightGet = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_padding_leftright', true );
			
			if ( ! is_array( $gridItemConTextPaddingLeftRightGet ) ) { $gridItemConTextPaddingLeftRightGet = array( $gridItemConTextPaddingLeftRightGet, 0 ); }
			
			$gridItemConTextPaddingLeftRightDesktop = intval( $gridItemConTextPaddingLeftRightGet[0] );
			$gridItemConTextPaddingLeftRightmobile = intval( $gridItemConTextPaddingLeftRightGet[1] );
			
			if ( $gridItemConTextPaddingLeftRightDesktop ) {
				$gridItemConTextPaddingStyle .= 'padding-left:'.esc_attr( $gridItemConTextPaddingLeftRightDesktop ).'px; padding-right:'.esc_attr( $gridItemConTextPaddingLeftRightDesktop ).'px;';
			}
			
			if ( $gridItemConTextPaddingLeftRightmobile ) {
				$gridItemConTextPaddingStyle .= '--padding-lr-grid-text-m: '.esc_attr( $gridItemConTextPaddingLeftRightmobile ).'px;';
			}

			//Grid Text Top space
			$gridItemConTextPaddingTopBottomGet = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_padding_topbottom', true );
			
			if ( ! is_array( $gridItemConTextPaddingTopBottomGet ) ) { $gridItemConTextPaddingTopBottomGet = array( $gridItemConTextPaddingTopBottomGet, 0 ); }
			
			$gridItemConTextPaddingTopBottomDesktop = intval( $gridItemConTextPaddingTopBottomGet[0] );
			$gridItemConTextPaddingTopBottommobile = intval( $gridItemConTextPaddingTopBottomGet[1] );
			
			if ( $gridItemConTextPaddingTopBottomDesktop ) {
				$gridItemConTextPaddingStyle .= 'padding-top:'.esc_attr( $gridItemConTextPaddingTopBottomDesktop ).'px;';
			}
			
			if ( $gridItemConTextPaddingTopBottommobile ) {
				$gridItemConTextPaddingStyle .= '--padding-tb-grid-text-m: '.esc_attr( $gridItemConTextPaddingTopBottommobile ).'px;';
			}

			//Grid Text Bottom space
			$gridItemConTextPaddingBottomGet = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_padding_bottom', true );
			
			if ( ! is_array( $gridItemConTextPaddingBottomGet ) ) { $gridItemConTextPaddingBottomGet = array( $gridItemConTextPaddingBottomGet, 0 ); }
			
			$gridItemConTextPaddingBottomDesktop = intval( $gridItemConTextPaddingBottomGet[0] );
			$gridItemConTextPaddingBottommobile = intval( $gridItemConTextPaddingBottomGet[1] );
			
			if ( $gridItemConTextPaddingBottomDesktop ) {
				$gridItemConTextPaddingStyle .= 'padding-bottom:'.esc_attr( $gridItemConTextPaddingBottomDesktop ).'px;';
			}
			
			if ( $gridItemConTextPaddingBottommobile ) {
				$gridItemConTextPaddingStyle .= '--padding-bottom-grid-text-m: '.esc_attr( $gridItemConTextPaddingBottommobile ).'px;';
			}


		} elseif ( $imageStyle == 'image-text' ) {

			$gridItemConTextPaddingLeftRightGet = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_text_text_padding_leftright', true );
			
			if ( ! is_array( $gridItemConTextPaddingLeftRightGet ) ) { $gridItemConTextPaddingLeftRightGet = array( $gridItemConTextPaddingLeftRightGet, 0 ); }
			
			$gridItemConTextPaddingLeftRightDesktop = intval( $gridItemConTextPaddingLeftRightGet[0] );
			$gridItemConTextPaddingLeftRightmobile = intval( $gridItemConTextPaddingLeftRightGet[1] );
			
			if ( $gridItemConTextPaddingLeftRightDesktop ) {
				$gridItemConTextPaddingStyle .= 'padding-left:'.esc_attr( $gridItemConTextPaddingLeftRightDesktop ).'px; padding-right:'.esc_attr( $gridItemConTextPaddingLeftRightDesktop ).'px;';
			}
			
			if ( $gridItemConTextPaddingLeftRightmobile ) {
				$gridItemConTextPaddingStyle .= '--padding-lr-grid-text-m: '.esc_attr( $gridItemConTextPaddingLeftRightmobile ).'px;';
			}

		}

		//Play button
		$playBtnStyle = '';
		$whatThumb = get_post_meta($post_id, '__ux_cb_module_grid_style_image_what_thumb_does');
		if( $playBtnColor = get_post_meta($post_id, '__ux_cb_module_grid_style_videoplay_color', true) ) {	
			//if ( $whatThumb == 'open-lightbox' ) {
				$playBtnStyle = 'color:' .esc_attr($playBtnColor).';';
			//}
		}


		//Filter style
		//filter color style
		//filter bottom spacing
		$filterStyle = ''; 
		$filterBottomSpacingStyle = '';
		$filterLeftRightSpacingStyle = ''; 

		if ( 'on' === get_post_meta($post_id, '__ux_cb_module_grid_show_filter', true ) ) {
			if( $filterStyleFont = get_post_meta($post_id, '__ux_cb_module_grid_style_image_filter_text_font_font', true) ) { 
				$filterStyle .= ux_cb_fonts_load_font_data($filterStyleFont);
			}
			if( $filterStyleFontSize = get_post_meta($post_id, '__ux_cb_module_grid_style_image_filter_text_font_size', true) ) {
				$filterStyle .= 'font-size: ' .$filterStyleFontSize. ';';
			}
			if( $filterStyleFontSizeMobile = get_post_meta($post_id, '__ux_cb_module_grid_style_image_filter_text_font_msize', true) ) {
				$filterStyle .= '--fontsize-grid-filter: ' .$filterStyleFontSizeMobile. ';';
			}
			if( $filterStyleFontLineheight = get_post_meta($post_id, '__ux_cb_module_grid_style_image_filter_text_font_lineheight', true) ) {
				$filterStyle .= 'line-height: ' .$filterStyleFontLineheight. ';';
			}
			if( $filterStyleFontLetterSpacing = get_post_meta($post_id, '__ux_cb_module_grid_style_image_filter_text_font_letter_spacing', true) ) {
				$filterStyle .= 'letter-spacing: ' .intval(esc_attr($filterStyleFontLetterSpacing)). 'px;';
			}
			if( $filterStyleColor = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_filter_color', true) ) {
				$filterStyle .= 'color: ' .esc_attr($filterStyleColor). ';';
			}

			//Bottom spacing
			$filterBottomSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_item_filter_spacing_bottom', true );
			if ( ! is_array( $filterBottomSpacing ) ) { $filterBottomSpacing = array( $filterBottomSpacing, 0 ); }
			$filterBottomSpacingDesktop =  intval( $filterBottomSpacing[0] );
			$filterBottomSpacingMobile =  intval( $filterBottomSpacing[1] );
			
			if ( $filterBottomSpacingDesktop ) {
				$filterBottomSpacingStyle .= 'margin-bottom: ' .esc_attr( $filterBottomSpacingDesktop ). 'px;';
			}

			if ( $filterBottomSpacingMobile ) {
				$filterBottomSpacingStyle .= '--marginbottom-grid-filter: ' .esc_attr( $filterBottomSpacingMobile ). 'px;';
			}
			
			//Left Spacing
			$filterLeftSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_item_filter_spacing_left', true );
			if ( ! is_array( $filterLeftSpacing ) ) { $filterLeftSpacing = array( $filterLeftSpacing, 0 ); }
			$filterLeftSpacingDesktop = intval( $filterLeftSpacing[0] );
			$filterLeftSpacingMobile = intval( $filterLeftSpacing[1] );
			
			if ( $filterLeftSpacingDesktop ) {
				$filterLeftRightSpacingStyle .= 'margin-left: ' .esc_attr( $filterLeftSpacingDesktop ). 'px;';
			}
			
			if ( $filterLeftSpacingMobile ) {
				$filterLeftRightSpacingStyle .= '--marginleft-grid-filter-item: ' .esc_attr( $filterLeftSpacingMobile ). 'px;';
			}

			//Right spacing
			$filterRightSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_item_filter_spacing_right', true ); 
			if ( ! is_array( $filterRightSpacing ) ) { $filterRightSpacing = array( $filterRightSpacing, 0 ); }
			$filterRightSpacingDesktop = intval( $filterRightSpacing[0] );
			$filterRightSpacingMobile = intval( $filterRightSpacing[1] );
			
			if ( $filterRightSpacingDesktop ) {
				$filterLeftRightSpacingStyle .= 'margin-right: ' .esc_attr( $filterRightSpacingDesktop ). 'px;';
			}
			
			if ( $filterRightSpacingMobile ) {
				$filterLeftRightSpacingStyle .= '--marginright-grid-filter-item: ' .esc_attr( $filterRightSpacingMobile ). 'px;';
			}
			
		}

		//Load more style
		$loadmoreStyle = '';
		$loadmoreBorderStyle = '';
		$loadmoreBorderStyleHover = '';
		$loadmoreTopSpacingStyle = '';
		$loadmoreWidthType = get_post_meta($post_id, '__ux_cb_module_grid_style_loadmore_width_type', true);
		if('load-more' === get_post_meta($post_id, '__ux_cb_module_grid_pagination', true)){
			if($loadmoreStyleFont = get_post_meta($post_id, '__ux_cb_module_grid_style_image_loadmore_text_font_font', true ) ) {
				$loadmoreStyle .= ux_cb_fonts_load_font_data($loadmoreStyleFont);
			}
			if($loadmoreStyleFontSize = get_post_meta($post_id, '__ux_cb_module_grid_style_image_loadmore_text_font_size', true ) ) {
				$loadmoreStyle .= 'font-size: ' .esc_attr($loadmoreStyleFontSize). ';';
			}
			if($loadmoreStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_grid_style_image_loadmore_text_font_msize', true ) ) {
				$loadmoreStyle .= '--fontsize-grid-loadmore-m: ' .esc_attr( $loadmoreStyleFontSizeMobile ). ';';
			}
			if($loadmoreStyleFontLineheight = get_post_meta($post_id, '__ux_cb_module_grid_style_image_loadmore_text_font_lineheight', true ) ) {
				$loadmoreStyle .= 'line-height: ' .esc_attr( $loadmoreStyleFontLineheight ). '; height: inherit; max-height: none;';
			}
			if($loadmoreStyleFontLetterSpacing = get_post_meta($post_id, '__ux_cb_module_grid_style_image_loadmore_text_font_letter_spacing', true ) ) {
				$loadmoreStyle .= 'letter-spacing: ' .intval( esc_attr( $loadmoreStyleFontLetterSpacing ) ). 'px;';
			}
			//loadmore color style
			if($loadmoreStyleColor = get_post_meta($post_id, '__ux_cb_module_grid_style_image_text_loadmore_color', true ) ) {
				$loadmoreStyle .= 'color: ' .esc_attr($loadmoreStyleColor). ';';
			}

			//Loadmore width
			if ( $loadmoreWidth = get_post_meta($post_id, '__ux_cb_module_loadmore_width_value', true ) ) {

				if ( $loadmoreWidthType === 'fixed-width') { 
					
					if ( ! is_array( $loadmoreWidth ) ) { $loadmoreWidth = array( $loadmoreWidth, 0 ); }
					$loadmoreWidthDesktop = intval( $loadmoreWidth[0] );
					$loadmoreWidthMobile = intval( $loadmoreWidth[1] );

					if ( $loadmoreWidthDesktop ) {
						$loadmoreStyle .= 'width: ' .esc_attr( $loadmoreWidthDesktop ). 'px;';
					}

					if ( $loadmoreWidthMobile ) {
						$loadmoreStyle .= '--width-grid-loadmore-m: ' .esc_attr( $loadmoreWidthMobile ). 'px;';
					}
 					
				}
			}

			//Loadmore left / right padding
			if ( $loadmoreLeftRightPadding = get_post_meta( $post_id, '__ux_cb_module_loadmore_leftright_padding', true ) ) {
				
				if ( $loadmoreWidthType === 'left-right-padding' ) {

					if ( ! is_array( $loadmoreLeftRightPadding ) ) { $loadmoreLeftRightPadding = array( $loadmoreLeftRightPadding, 0 ); }
					$loadmoreLeftRightPaddingDesktop = intval( $loadmoreLeftRightPadding[0] );
					$loadmoreLeftRightPaddingMobile = intval( $loadmoreLeftRightPadding[1] );

					if ( $loadmoreLeftRightPaddingDesktop ) {
						$loadmoreStyle .= 'padding-left: ' .esc_attr( $loadmoreLeftRightPaddingDesktop ). 'px; padding-right: ' .esc_attr( $loadmoreLeftRightPaddingDesktop ). 'px;';
					}

					if ( $loadmoreLeftRightPaddingMobile ) {
						$loadmoreStyle .= '--paddingLR-grid-loadmore-m: '.esc_attr( $loadmoreLeftRightPaddingMobile ). 'px;';
					}

				}
			}

			//Load more height
			if ( $loadmoreHeight = get_post_meta( $post_id, '__ux_cb_module_loadmore_height_value', true ) ) {
				
				if ( ! is_array( $loadmoreHeight ) ) { $loadmoreHeight = array( $loadmoreHeight, 0 ); }
				$loadmoreHeightDesktop = intval( $loadmoreHeight[0] );
				$loadmoreHeightMobile = intval( $loadmoreHeight[1] );
				
				if ( $loadmoreHeightDesktop ) {
					$loadmoreStyle .= 'line-height: ' .esc_attr( $loadmoreHeightDesktop ). 'px;';
				}

				if ( $loadmoreHeightMobile ) {
					$loadmoreStyle .= '--lineheight-grid-loadmore-m: ' .esc_attr( $loadmoreHeightMobile ). 'px;';
				}
				
			}

			///Loadmore Border
			if ( $loadmoreBorderWidth = get_post_meta( $post_id, '__ux_cb_module_grid_style_loadmore_border_width', true ) ) {
				$loadmoreBorderStyle .= 'border-width: ' .esc_attr( join( 'px ', $loadmoreBorderWidth ) ). 'px;';
			}

			//Loadmore Border hover
			if ( $loadmoreBorderWidthHover = get_post_meta( $post_id, '__ux_cb_module_grid_style_loadmore_border_width_mouseover', true ) ) {
				$loadmoreBorderStyleHover .= 'border-width: ' .esc_attr( join( 'px ', $loadmoreBorderWidthHover ) ). 'px;';
			}
			//Loadmore top spacing
			if ( $loadmoreTopSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_item_loadmore_spacing_top', true ) ) {

				if ( ! is_array( $loadmoreTopSpacing ) ) { $loadmoreTopSpacing = array( $loadmoreTopSpacing, 0 ); }
				$loadmoreTopSpacingDesktop = intval( $loadmoreTopSpacing[0] );
				$loadmoreTopSpacingMobile = intval( $loadmoreTopSpacing[1] );

				if ( $loadmoreTopSpacingDesktop ) {
					$loadmoreTopSpacingStyle .= 'margin-top: ' .esc_attr( $loadmoreTopSpacingDesktop ). 'px;';
				}

				if ( $loadmoreTopSpacingMobile ) {
					$loadmoreTopSpacingStyle .= '--margintop-grid-loadmore-m: ' .esc_attr( $loadmoreTopSpacingMobile ). 'px;';
				}
				
			} 
		}

		//List BG and padding
		$innerSpacingStyle = '';
		$getInnerSpacing = get_post_meta( $post_id, '__ux_cb_module_grid_style_inner_padding', true );
		if ( !is_array( $getInnerSpacing ) ) { $getInnerSpacing = array( $getInnerSpacing, 0 ); }
		$innerSpacing = intval( $getInnerSpacing[0] );
		$innerSpacingMobile = intval( $getInnerSpacing[1] );
		if( $innerSpacing ) {
			 $innerSpacingStyle = 'padding:'.esc_attr( $innerSpacing ). 'px;';
		}
		if( $innerSpacingMobile ) {
			$innerSpacingStyle .= '--innner-padding-grid:'.esc_attr( $innerSpacingMobile ).'px;';
		}
		$listBackgroundColorStyle = false;
		if($listBackgroundColor = get_post_meta($post_id, '__ux_cb_module_grid_style_list_bg_color', true)){
			 $listBackgroundColorStyle = 'background-color:'.esc_attr($listBackgroundColor). ';';
		}

		if($moduleUnique) {
			if ( $spacingHorizontal ) {
				$style .= '.grid-list-' .esc_attr( $moduleUnique ).  ' { margin-left: -' .esc_attr( $spacingHorizontal / 2 ). 'px; margin-right: -' .esc_attr( $spacingHorizontal / 2 ). 'px; }';
				$style .= '.grid-list-' .esc_attr( $moduleUnique ).  ' .grid-item-inside { margin-left: ' .esc_attr( $spacingHorizontal / 2 ). 'px; margin-right: ' .esc_attr( $spacingHorizontal / 2 ). 'px; }';
			}
			if ( $spacingVertical ) {
				$style .= '.grid-list-' .esc_attr( $moduleUnique ).  ' { margin-top: -' .esc_attr($spacingVertical / 2). 'px; margin-bottom: -' .esc_attr($spacingVertical / 2). 'px;}';
				$style .= '.grid-list-' .esc_attr( $moduleUnique ).  ' .grid-item-inside { margin-top: ' .esc_attr($spacingVertical / 2). 'px; margin-bottom: ' .esc_attr($spacingVertical / 2). 'px;}';
			}
			if ( $spacingHorizontalMobile ) { 
				$style .= '.grid-list-' .esc_attr( $moduleUnique ). '{--spacingH-grid: ' .esc_attr( $spacingHorizontalMobile / 2 ). 'px;}';
			}
			if ( $spacingVerticalMobile ) { 
				$style .= '.grid-list-' .esc_attr( $moduleUnique ). '{--spacingV-grid: ' .esc_attr( $spacingVerticalMobile / 2 ). 'px;}';
			}
			if ( $opacityStyle || $backgroundColorStyle ) {
				$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-con:hover:after { ' .esc_attr($opacityStyle). ' ' .sanitize_text_field($backgroundColorStyle). ' }';
				$style .= ' .grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-con.bm-hover:after { ' .esc_attr($opacityStyle). ' ' .sanitize_text_field($backgroundColorStyle). ' }';
			}

			if ( $showText === 'on') {

				if ( $titleStyle ) {
					$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-tit, #poststuff .grid-list-'.esc_attr( $moduleUnique ).' .grid-item-tit, .grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-tit-a{' .sanitize_text_field($titleStyle). '}';
				}
				if ( $titleTopSpacingStyle ) {
					$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-tit, #poststuff .grid-list-'.esc_attr( $moduleUnique ).' .grid-item-tit {'.esc_attr($titleTopSpacingStyle).'}';
				}
				if ( $categoryStyle ) {
					$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-cate{ ' .sanitize_text_field($categoryStyle). ' }';
				}
				if ( $categoryColorStyle ) {
					$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-cate, .grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-cate-a {' .sanitize_text_field($categoryColorStyle). '}';
				}
				if( $gridItemConTextPaddingStyle ) {

					if ( $imageStyle === 'image' ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ).' .grid-item-con-text{'.esc_attr($gridItemConTextPaddingStyle).'}';
					}
					if ( $imageStyle === 'image-text' ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ).' .standard-text-padding{'.esc_attr($gridItemConTextPaddingStyle).'}';
					}
				}
				if ( $cateTopSpacingStyle ) {
					$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-cate{ '.esc_attr( $cateTopSpacingStyle ).'}';
				}
			
				if ( $source === 'post' || $source === 'ux-portfolio' ) {
					if ( $excerptStyle ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-des, .grid-list-' .esc_attr( $moduleUnique ). ' .songtitle, .grid-list-' .esc_attr( $moduleUnique ). ' .blog-unit-link-li-a { ' .sanitize_text_field($excerptStyle). ' }';
					}
					if( $excerptTopSpacingStyle ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-des { ' .esc_attr( $excerptTopSpacingStyle ). ' }';
					}
					if( $dateStyle ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .grid-item-date { ' .sanitize_text_field( $dateStyle ). ' }';
					}
					//if ( $playBtnStyle && $imageStyle === 'image' ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .video-play-btn { ' .sanitize_text_field( $playBtnStyle ). ' }';
					//}
				}
				if( $source == 'product' ) {
					if( $priceStyle || $priceTopSpacingStyle ) {
						$style .= '.grid-list-' .esc_attr( $moduleUnique ). ' .price { ' .sanitize_text_field($priceStyle).esc_attr($priceTopSpacingStyle). ' }';
					}
				}

			}//End showText

			if( $filterBottomSpacingStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .filters { ' .esc_attr($filterBottomSpacingStyle) . ' }';
			}
			if( $filterLeftRightSpacingStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .filters-li { ' . esc_attr($filterLeftRightSpacingStyle) . ' }';
			}
			if( $filterStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .filters-a { ' .sanitize_text_field($filterStyle). '}';
			}
			if( $loadmoreTopSpacingStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .pagenums.tw_style { ' .esc_attr($loadmoreTopSpacingStyle). '}';
			}
			if( $loadmoreStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .tw-style-a.ux-btn { ' .sanitize_text_field( $loadmoreStyle ). '}';
			}
			if ( $loadmoreBorderStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .tw-style-a.ux-btn { ' .sanitize_text_field($loadmoreBorderStyle). '}';
			}
			if ( $loadmoreBorderStyleHover ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .tw-style-a.ux-btn:hover { ' .sanitize_text_field($loadmoreBorderStyleHover). '}';
			}
			if ( $innerSpacingStyle || $listBackgroundColorStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .container-masonry, .bm-builder .col-0.module-id-' .esc_attr( $moduleUnique ).' .container-masonry { ' .esc_attr($innerSpacingStyle).esc_attr($listBackgroundColorStyle). ' }';
			}
		}
		
		return $style;
	}
}

if ( ! function_exists( 'ux_cb_module_masonry_grid_style' ) ) {
	/**
	 * Module Style for module masonry grid
	 */
	function ux_cb_module_masonry_grid_style($post_id, $moduleUnique, $style) {
		//source
		$source = get_post_meta($post_id, '__ux_cb_module_masonry_grid_source', true);
		if(!$source){
			$source = 'ux-portfolio';
		}
		//image style
		$imageStyle = get_post_meta($post_id, '__ux_cb_module_masonry_grid_item_style', true);
		if(!$imageStyle){
			$imageStyle = 'image';
		}

		//mouseover effect
		$mouseoverEffect = false;
		switch ( $imageStyle ) {

			case 'image': 

				if ( $source === 'attachment' ) {
					$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_mouseover_effect-attachment', true); 
				} else {
					$mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_mouseover_effect', true); 
				}
				
			break;
			case 'image-text':
				$mouseoverEffect = 'no-effect'; 
			break;
		
		}

		//transparent mask
		$transparentMask = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_transparent_mask', true);
		
		//transparent mask color
		$transparentMaskColor = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_mask_color', true);
		
		//transparent mask style
		$opacityStyle = false; 
		$backgroundColorStyle = false;
		if($imageStyle == 'image'){
			if($mouseoverEffect == 'static-color-mask-text'){
				$opacityStyle = 'opacity: ' .esc_attr($transparentMask). ';';
				$backgroundColorStyle = '';
				
				if($mouseoverEffect == 'static-color-mask-text' && $transparentMaskColor){
					$backgroundColorStyle = 'background-color: ' .esc_attr($transparentMaskColor). ';';
				}
			}
		}

		//Show Text rule
		$showText = false;

		switch( $imageStyle ) {

			case 'image': 
				if ( $mouseoverEffect === 'static-color-mask-text' || $mouseoverEffect == 'second-featured-image-text' ) { 
					$showText = 'on';
				}
			break;

			case 'image-text':
				$showText = 'on'; 
			break;

		}
		
		//title style
		$titleStyle = '';
		$titleColorStyle = '';
		$textGroupName = '';
		$textGroupMod = 'title';

		if( $showText === 'on' ) { 

			if ( $source === 'product' || $source === 'post' || $source ==='ux-portfolio' ) {

				//Get text group
				if ( $source === 'product' ) { 

					if ( $imageStyle === 'image-text' ) { 

						$textGroupName =  '__ux_cb_module_masonry_grid_product_style_image_text_text_group_' .$textGroupMod;

					} elseif ( $imageStyle === 'image' ) {

						$textGroupName =  '__ux_cb_module_masonry_grid_product_style_image_text_group_' .$textGroupMod;
					}

				}  else {

					if ( $imageStyle === 'image-text' ) {

						$textGroupName = '__ux_cb_module_masonry_grid_style_image_text_text_group_' .$textGroupMod;

					} elseif ( $imageStyle === 'image' ) {

						$textGroupName = '__ux_cb_module_masonry_grid_style_image_text_group_' .$textGroupMod;
					}
				}

				if ( $titleStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$titleStyle .= ux_cb_fonts_load_font_data( $titleStyleFont );
				}
				
				//font size
				if ( $titleStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$titleStyle .= 'font-size: ' .$titleStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $titleStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$titleStyle .= '--fontsize-mgrid-title: ' .$titleStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $titleStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$titleStyle .= 'line-height: ' .$titleStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $titleStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$titleStyle .= 'letter-spacing: ' .intval( esc_attr( $titleStyleFontLetterSpacing ) ). 'px;';
				}

				//color
				if ( $titleStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$titleColorStyle .= 'color: ' .esc_attr($titleStyleColor). ';'; 
				}

				//top spacing
				if ( $titleTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$titleTopSpacing = explode( ',', $titleTopSpacing );
					$titleTopSpacingDesktop = $titleTopSpacing[0];
					$titleTopSpacingMobile = $titleTopSpacing[1];
					
					if ( $titleTopSpacingDesktop ) {
						$titleStyle .= 'margin-top: ' .intval( esc_attr( $titleTopSpacingDesktop ) ). 'px;';
					}

					if ( $titleTopSpacingMobile ) {
						$titleStyle .= '--margintop-mgrid-title-m: ' .intval( esc_attr( $titleTopSpacingMobile ) ). 'px;';
					}
				} 
			}

			if ( $source == 'attachment' ) {

				if($titleStyleFont = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_font_font', true)){
					$titleStyle .= ux_cb_fonts_load_font_data($titleStyleFont);
				}
				if($titleStyleFontSize = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_font_size', true)){
					$titleStyle .= 'font-size: ' .$titleStyleFontSize. ';';
				}
				if($titleStyleFontSizeMobile = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_font_msize', true)){
					$titleStyle .= '--fontsize-mgrid-title: ' .$titleStyleFontSizeMobile. ';';
				}
				if($titleStyleFontLineheight = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_font_lineheight', true)){
					$titleStyle .= 'line-height: ' .$titleStyleFontLineheight. ';';
				}
				if($titleStyleFontLetterSpacing = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_font_letter_spacing', true)){
					$titleStyle .= 'letter-spacing: ' .intval(esc_attr($titleStyleFontLetterSpacing)). 'px;';
				}

			}

		} //End showText
			
		
		//category style
		$categoryStyle = '';
		$categoryTopSpacingStyle = '';
		$textGroupMod = 'category';

		if ( $showText === 'on') {

			if ( $source === 'post' || $source ==='ux-portfolio' ) {
 
				if ( $imageStyle === 'image-text' ) {

					$textGroupName = '__ux_cb_module_masonry_grid_style_image_text_text_group_' .$textGroupMod;

				} elseif ( $imageStyle === 'image' ) {

					$textGroupName = '__ux_cb_module_masonry_grid_style_image_text_group_' .$textGroupMod;
				}

				if ( $categoryStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$categoryStyle .= ux_cb_fonts_load_font_data( $categoryStyleFont );
				}
				
				//font size
				if ( $categoryStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$categoryStyle .= 'font-size: ' .$categoryStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $categoryStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$categoryStyle .= '--fontsize-mgrid-cate: ' .$categoryStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $categoryStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$categoryStyle .= 'line-height: ' .$categoryStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $categoryStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$categoryStyle .= 'letter-spacing: ' .intval( esc_attr( $categoryStyleFontLetterSpacing ) ). 'px;';
				}

				//color
				if ( $categoryStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$categoryStyle .= 'color: ' .esc_attr($categoryStyleColor). ';'; 
				}

				//top spacing
				if ( $categoryTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$categoryTopSpacing = explode( ',', $categoryTopSpacing );
					$categoryTopSpacingDesktop = $categoryTopSpacing[0];
					$categoryTopSpacingMobile = $categoryTopSpacing[1];
					
					if ( $categoryTopSpacingDesktop ) {
						$categoryTopSpacingStyle .= 'margin-top: ' .intval( esc_attr( $categoryTopSpacingDesktop ) ). 'px;';
					}

					if ( $categoryTopSpacingMobile ) {
						$categoryTopSpacingStyle .= '--margintop-mgrid-cate-m: ' .intval( esc_attr( $categoryTopSpacingMobile ) ). 'px;';
					}
				}
				 
			}
		} //End showText
		
		
		//price style
		$priceStyle = '';
		$textGroupMod = 'price';

		if ( $showText === 'on') {
 		
 			if ( $source == 'product') {

				if ( $imageStyle === 'image-text' ) {

					$textGroupName = '__ux_cb_module_masonry_grid_product_style_image_text_text_group_' .$textGroupMod;

				} elseif ( $imageStyle === 'image' ) {

					$textGroupName = '__ux_cb_module_masonry_grid_product_style_image_text_group_' .$textGroupMod;
				}

				if ( $priceStyleFont = get_post_meta( $post_id, $textGroupName. '_font', true ) ) {
					$priceStyle .= ux_cb_fonts_load_font_data( $priceStyleFont );
				}
				
				//font size
				if ( $priceStyleFontSize = get_post_meta( $post_id, $textGroupName. '_size', true ) ) {
					$priceStyle .= 'font-size: ' .$priceStyleFontSize. ';';
				}
				
				//mobile font size
				if ( $priceStyleFontSizeMobile = get_post_meta( $post_id, $textGroupName. '_msize', true ) ) {
					$priceStyle .= '--fontsize-mgrid-price: ' .$priceStyleFontSizeMobile. ';';
				}
				
				//line height
				if ( $priceStyleFontLineheight = get_post_meta( $post_id, $textGroupName. '_lineheight', true ) ) {
					$priceStyle .= 'line-height: ' .$priceStyleFontLineheight. ';';
				}
				
				//letter spacing
				if ( $priceStyleFontLetterSpacing = get_post_meta( $post_id, $textGroupName. '_letter_spacing', true ) ) {
					$priceStyle .= 'letter-spacing: ' .intval( esc_attr( $priceStyleFontLetterSpacing ) ). 'px;';
				}

				//color
				if ( $priceStyleColor = get_post_meta( $post_id, $textGroupName. '_color', true ) ) {
					$priceStyle .= 'color: ' .esc_attr($priceStyleColor). ';'; 
				}

				//top spacing
				if ( $priceTopSpacing = get_post_meta( $post_id, $textGroupName. '_spacing', true ) ) {
					$priceTopSpacing = explode( ',', $priceTopSpacing );
					$priceTopSpacingDesktop = $priceTopSpacing[0];
					$priceTopSpacingMobile = $priceTopSpacing[1];
					
					if ( $priceTopSpacingDesktop ) {
						$priceStyle .= 'margin-top: ' .intval( esc_attr( $priceTopSpacingDesktop ) ). 'px;';
					}

					if ( $priceTopSpacingMobile ) {
						$priceStyle .= '--margintop-mgrid-price-m: ' .intval( esc_attr( $priceTopSpacingMobile ) ). 'px;';
					}
				}
			}
		}

		//Text Padding Image style - Masonry Grid
		$masonryGridItemConTextPaddingStyle = '';
		$masonryGridItemConTextPaddingLeftRight = '0';
		$masonryGridItemConTextPaddingTopBottom = '0';
		$masonryGridItemConTextPaddingTop = '0';
		$masonryGridItemConTextPaddingBottom = '0';
		$masonryGridImageTextAlign = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_text_align', true );
				
		if ( $imageStyle == 'image' ) {

			$masonryGridItemConTextPaddingLeftRight = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_left_right_padding', true );
			$masonryGridItemConTextPaddingTopBottom = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_top_bottom_padding', true );

			if ( ! is_array( $masonryGridItemConTextPaddingTopBottom ) ) { $masonryGridItemConTextPaddingTopBottom = array( $masonryGridItemConTextPaddingTopBottom, 0 ); }
			$masonryGridItemConTextPaddingTopBottomDesktop = intval( $masonryGridItemConTextPaddingTopBottom[0] );
			$masonryGridItemConTextPaddingTopBottomMobile = intval( $masonryGridItemConTextPaddingTopBottom[1] );

			if ( $masonryGridItemConTextPaddingTopBottomDesktop ) {
				$masonryGridItemConTextPaddingStyle .= 'padding-top: '.esc_attr( $masonryGridItemConTextPaddingTopBottomDesktop ).'px; padding-bottom: '.esc_attr( $masonryGridItemConTextPaddingTopBottomDesktop ).'px;';
			}
			if ( $masonryGridItemConTextPaddingTopBottomMobile ) {
				$masonryGridItemConTextPaddingStyle .= '--padding-tb-mgrid-text: '.esc_attr( $masonryGridItemConTextPaddingTopBottomMobile ).'px;';
			}
			
		} elseif( $imageStyle == 'image-text' ) {

			$masonryGridItemConTextPaddingLeftRight = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_show_text_left_right_padding', true );
			$masonryGridItemConTextPaddingTop = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_top_spacing', true );
			$masonryGridItemConTextPaddingBottom = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_bottom_spacing', true );			
			
			if ( ! is_array( $masonryGridItemConTextPaddingTop ) ) { $masonryGridItemConTextPaddingTop = array( $masonryGridItemConTextPaddingTop, 0 ); }
			$masonryGridItemConTextPaddingTopDesktop = intval( $masonryGridItemConTextPaddingTop[0] );
			$masonryGridItemConTextPaddingTopMobile = intval( $masonryGridItemConTextPaddingTop[1] );

			if ( $masonryGridItemConTextPaddingTopDesktop ) {
				$masonryGridItemConTextPaddingStyle .= 'padding-top: '.esc_attr( $masonryGridItemConTextPaddingTopDesktop ).'px;';
			}

			if ( $masonryGridItemConTextPaddingTopMobile ) {
				$masonryGridItemConTextPaddingStyle .= '--padding-top-mgrid-text: '.esc_attr( $masonryGridItemConTextPaddingTopMobile ).'px;';

			}

			if( ! is_array( $masonryGridItemConTextPaddingBottom ) ) { $masonryGridItemConTextPaddingBottom = array( $masonryGridItemConTextPaddingBottom, 0 ); }

			$masonryGridItemConTextPaddingBottomDesktop = intval( $masonryGridItemConTextPaddingBottom[0] );
			$masonryGridItemConTextPaddingBottomMobile = intval( $masonryGridItemConTextPaddingBottom[1] );

			if ( $masonryGridItemConTextPaddingBottomDesktop ) {
				$masonryGridItemConTextPaddingStyle .= 'padding-bottom: '.esc_attr( $masonryGridItemConTextPaddingBottomDesktop ).'px;';
			}

			if ( $masonryGridItemConTextPaddingBottomMobile ) {
				$masonryGridItemConTextPaddingStyle .= '--padding-bottom-mgrid-text: '.esc_attr( $masonryGridItemConTextPaddingBottomMobile ).'px;';

			}

		}

		if ( !is_array( $masonryGridItemConTextPaddingLeftRight ) ) { $masonryGridItemConTextPaddingLeftRight = array( $masonryGridItemConTextPaddingLeftRight, 0 ); }
		$masonryGridItemConTextPaddingLeftRightDesktop = intval( $masonryGridItemConTextPaddingLeftRight[0] );
		$masonryGridItemConTextPaddingLeftRightMobile = intval( $masonryGridItemConTextPaddingLeftRight[1] );

		if ( $masonryGridItemConTextPaddingLeftRightDesktop ) {
			$masonryGridItemConTextPaddingStyle .= 'padding-left: '.esc_attr( $masonryGridItemConTextPaddingLeftRightDesktop ).'px; padding-right: '.esc_attr( $masonryGridItemConTextPaddingLeftRightDesktop ).'px;';
		}

		if ( $masonryGridItemConTextPaddingLeftRightMobile ) {
			$masonryGridItemConTextPaddingStyle .= '--padding-lr-mgrid-text: '.esc_attr( $masonryGridItemConTextPaddingLeftRightMobile ).'px;';

		}

		//Play button
		$playBtnStyle = ''; 
		if( $playBtnColor = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_videoplay_color', true) ) {	
			$playBtnStyle = 'color:' .esc_attr($playBtnColor).';';
		}

		//Filter style
		//filter bottom spacing
		$filterStyle = ''; ;
		$filterBottomSpacingStyle = '';
		$filterLeftRightSpacingStyle = ''; 

		if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_masonry_grid_show_filter', true ) ) {

			if ( $filterStyleFont = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_filter_text_font_font', true) ) {
				$filterStyle .= ux_cb_fonts_load_font_data($filterStyleFont);
			}
			if ( $filterStyleFontSize = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_filter_text_font_size', true) ) {
				$filterStyle .= 'font-size: ' .$filterStyleFontSize. ';';
			}
			if ( $filterStyleFontSizeMobile = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_filter_text_font_msize', true) ) {
				$filterStyle .= '--fontsize-mgrid-filter: ' .$filterStyleFontSizeMobile. ';';
			}
			if ( $filterStyleFontLineheight = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_filter_text_font_lineheight', true) ) {
				$filterStyle .= 'line-height: ' .$filterStyleFontLineheight. ';';
			}
			if ( $filterStyleFontLetterSpacing = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_filter_text_font_letter_spacing', true) ) {
				$filterStyle .= 'letter-spacing: ' .intval( esc_attr( $filterStyleFontLetterSpacing ) ). 'px;';
			}
			//Bottom spacing
			$filterBottomSpacing = get_post_meta($post_id, '__ux_cb_module_masonry_grid_item_filter_spacing_bottom', true);
			if ( ! is_array( $filterBottomSpacing ) ) { $filterBottomSpacing = array( $filterBottomSpacing, 0 ); }
			$filterBottomSpacingDesktop =  intval( $filterBottomSpacing[0] );
			$filterBottomSpacingMobile =  intval( $filterBottomSpacing[1] );
			
			if ( $filterBottomSpacingDesktop ) {
				$filterBottomSpacingStyle .= 'margin-bottom: ' .esc_attr( $filterBottomSpacingDesktop ). 'px;';
			}
			if ( $filterBottomSpacingMobile ) {
				$filterBottomSpacingStyle .= '--marginbottom-mgrid-filter: ' .esc_attr( $filterBottomSpacingMobile ). 'px;';
			}
			
			//Left spacing
			$filterLeftSpacing = get_post_meta($post_id, '__ux_cb_module_masonry_grid_item_filter_spacing_left', true );
			if ( ! is_array( $filterLeftSpacing ) ) { $filterLeftSpacing = array( $filterLeftSpacing, 0 ); }
			$filterLeftSpacingDesktop = intval( $filterLeftSpacing[0] );
			$filterLeftSpacingMobile = intval( $filterLeftSpacing[1] );
			if ( $filterLeftSpacingDesktop ) {
				$filterLeftRightSpacingStyle .= 'margin-left: ' .esc_attr( $filterLeftSpacingDesktop ). 'px;';
			}
			if ( $filterLeftSpacingMobile ) {
				$filterLeftRightSpacingStyle .= '--marginleft-mgrid-filter-item: ' .esc_attr( $filterLeftSpacingMobile ). 'px;';
			}

			//Right spacing
			$filterRightSpacing = get_post_meta($post_id, '__ux_cb_module_masonry_grid_item_filter_spacing_right', true );
			if ( ! is_array( $filterRightSpacing ) ) { $filterRightSpacing = array( $filterRightSpacing, 0 ); }
			$filterRightSpacingDesktop = intval( $filterRightSpacing[0] );
			$filterRightSpacingMobile = intval( $filterRightSpacing[1] );
			if ( $filterRightSpacingDesktop ) {
				$filterLeftRightSpacingStyle .= 'margin-right: ' .esc_attr( $filterRightSpacingDesktop ). 'px;';
			}
			if ( $filterRightSpacingMobile ) {
				$filterLeftRightSpacingStyle .= '--marginright-mgrid-filter-item: ' .esc_attr( $filterRightSpacingMobile ). 'px;';
			}
			
			//Color style
			if ( $filterStyleColor = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_filter_color', true) ) {
				$filterStyle .= 'color: ' .esc_attr($filterStyleColor). ';';
			}

		}

		if ($source == 'attachment'){ 

			switch($imageStyle){
			
				case 'image': 

					if ( $titleStyleColor = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_attachment_style_image_text_color', true ) ) {
						$titleStyle .= 'color: ' .esc_attr( $titleStyleColor ). ';';
					}
					
				break;
				
				case 'image-text': 
					
					$titleStyleColor = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_color', true);
					
					if($titleStyleColor){
						$titleStyle .= 'color: ' .esc_attr( $titleStyleColor ). ';'; 
					}

				break;
			}
		}

		//List BG 
		$innerSpacingStyle = '';
		$getInnerSpacing = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_inner_padding', true );
		if ( ! is_array( $getInnerSpacing ) ) { $getInnerSpacing = array( $getInnerSpacing, 0 ); }
		$innerSpacing = intval( $getInnerSpacing[0] );
		$innerSpacingMobile = intval( $getInnerSpacing[1] );
		if ( $innerSpacing ) {
			 $innerSpacingStyle = 'padding:' .esc_attr( $innerSpacing ). 'px;';
		}
		if ( $innerSpacingMobile ) {
			$innerSpacingStyle .= '--innner-padding-mgrid-m:' .esc_attr( $innerSpacingMobile ). 'px;';
		}
		$listBackgroundColorStyle = false;
		if($listBackgroundColor = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_list_bg_color', true)){
			 $listBackgroundColorStyle = 'background-color:'.esc_attr($listBackgroundColor). ';';
		}

		//Spacing Mobile
		$getSpacing = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_item_spacing', true );
		if ( ! is_array( $getSpacing ) ) { $getSpacing = array( $getSpacing, 0 ); }
		$spacingMobile = intval( $getSpacing[1] );

		if($moduleUnique) {
			if(esc_attr($opacityStyle) || sanitize_text_field($backgroundColorStyle)) {
				$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-con:hover:after { ' .esc_attr($opacityStyle). ' ' .sanitize_text_field($backgroundColorStyle). ' }';
				$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-con.bm-hover:after { ' .esc_attr($opacityStyle). ' ' .sanitize_text_field($backgroundColorStyle). ' }';
			}
			if ( $showText === 'on') { 
				if ( $titleStyle ) {
					$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-tit, #poststuff .grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-tit{ ' .sanitize_text_field($titleStyle). ' }';
				}
				if ( $titleColorStyle ) { 
					$style .= ' .grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-tit-a {'.esc_attr( $titleColorStyle ).'}';
				}
				if ( $categoryStyle ) {
					$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-cate-a { ' .sanitize_text_field( $categoryStyle ). ' }';
				}
				if ( $categoryTopSpacingStyle ) {
					$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-cate { ' .sanitize_text_field( $categoryTopSpacingStyle ). ' }';
				}
				if( $priceStyle ) {
					$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .price { ' .sanitize_text_field( $priceStyle ). ' }';
				}
			
				if ( $masonryGridItemConTextPaddingStyle ) {

					if ( $imageStyle == 'image' ) {
						$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-con-text {'.sanitize_text_field( $masonryGridItemConTextPaddingStyle ).'}';
					} elseif($imageStyle == 'image-text') {
						$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .grid-item-con-text-show {'.sanitize_text_field( $masonryGridItemConTextPaddingStyle ).'}';
					}
				}
			}

			if ( $playBtnStyle && $imageStyle == 'image' ) {
				if ( $source == 'post' || $source == 'ux-portfolio' ) {
					$style .= '.grid-stack-' .esc_attr( $moduleUnique ). ' .video-play-btn { ' .sanitize_text_field( $playBtnStyle ). ' }';
				}
			}
			if( $filterBottomSpacingStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .filters { ' .esc_attr( $filterBottomSpacingStyle ). ' }';
			}
			if( $filterLeftRightSpacingStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .filters-li { ' .sanitize_text_field( $filterLeftRightSpacingStyle ). ' }';
			}
			if( $filterStyle ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .filters-a { ' .sanitize_text_field( $filterStyle ). ' }';
			}
			if(esc_attr($innerSpacingStyle) || esc_attr($listBackgroundColorStyle)) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .bm-masonry-grid, .col-0.module-id-' .esc_attr( $moduleUnique ).' .bm-masonry-grid { ' .esc_attr($innerSpacingStyle).esc_attr($listBackgroundColorStyle). ' }';
			} 
			if ( $spacingMobile ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' { --spacing-masonrygrid-m: '.esc_attr( $spacingMobile ).'px; }';
			}
		}
		
		return $style;
	}
}

if ( ! function_exists( 'ux_cb_module_single_image_style' ) ) {
	/**
	 * Module Style for module single image
	 */
	function ux_cb_module_single_image_style( $post_id, $moduleUnique, $style ) {
		//file type
		$fileType = get_post_meta($post_id, '__ux_cb_module_single_image_file_type', true);

		if ( $fileType == 'svg' ) {
			if ( $svgWidth = intval( get_post_meta( $post_id, '__ux_cb_module_single_image_svg_width', true ) ) ) {
				$style .= '.module-id-' .esc_attr( $moduleUnique ). ' svg { width: ' .esc_attr($svgWidth). 'px; }';
			}
		}
		/* Get Left and Right padding */
		$singleImagePaddingLeftStyle = '';
		$singleImagePaddingRightStyle = '';
		$getSingleImagePaddingLeft = get_post_meta( $post_id, '__ux_cb_module_single_image_padding_left', true );
		if ( ! is_array( $getSingleImagePaddingLeft ) ) { $getSingleImagePaddingLeft = array( $getSingleImagePaddingLeft, 0 ); }
		$singleImagePaddingLeft = intval( $getSingleImagePaddingLeft[0] );
		$singleImagePaddingLeftMobile = intval( $getSingleImagePaddingLeft[1] );
		if ( $singleImagePaddingLeft ) {
			$singleImagePaddingLeftStyle = 'padding-left: '.esc_attr( $singleImagePaddingLeft ).'px;';
		}
		if ( $singleImagePaddingLeftMobile ) {
			$singleImagePaddingLeftStyle .= '--paddingleft-singimage-m: '.esc_attr( $singleImagePaddingLeftMobile ).'px;';
		}
		$getSingleImagePaddingRight = get_post_meta( $post_id, '__ux_cb_module_single_image_padding_right', true );
		if ( ! is_array( $getSingleImagePaddingRight ) ) { $getSingleImagePaddingRight = array( $getSingleImagePaddingRight, 0 ); }
		$singleImagePaddingRight = intval( $getSingleImagePaddingRight[0] );
		$singleImagePaddingRightMobile = intval( $getSingleImagePaddingRight[1] );
		if ( $singleImagePaddingRight ) {
			$singleImagePaddingRightStyle = 'padding-right: '.esc_attr( $singleImagePaddingRight ).'px;';
		}
		if ( $singleImagePaddingRightMobile ) {
			$singleImagePaddingRightStyle .= '--paddingright-singimage-m: '.esc_attr( $singleImagePaddingRightMobile ).'px;';
		}
		//Export CSS
		if ( $singleImagePaddingLeftStyle || $singleImagePaddingRightStyle ) {
			$style = '.module-id-' .esc_attr( $moduleUnique ). ' .single-image-out { '.esc_attr($singleImagePaddingLeftStyle) . esc_attr($singleImagePaddingRightStyle).' }';
		}
		
		return $style;
	}
}

if ( ! function_exists( 'ux_cb_module_social_media_style' ) ) {
	/**
	 * Module Style for module Social Media
	 */
	function ux_cb_module_social_media_style( $post_id, $moduleUnique, $style ) {
		$socialMediaIconSizeStyle = ''; 
		$socialMediaIconSpacevStyle = '';
		$socialMediaIconSpacehStyle = '';
		$socialMediaIconSizeMobileStyle = '';
		$socialMediaIconSpacehMobileStyle = '';
		$socialMediaIconSpacevMobileStyle = '';
		
		$socialNameStyle = '';
		$socialNameStyleMobile = '';
		
		//social type
		$socialType = get_post_meta( $post_id, '__ux_cb_module_social_media_type', true );
		if ( $socialType == 'social-link' ) {
			if ( $socialNameStyleFont = get_post_meta( $post_id, '__ux_cb_module_social_name_font_font', true ) ) {
				$socialNameStyle .= ux_cb_fonts_load_font_data( $socialNameStyleFont );
			}
			if ( $socialNameStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_social_name_font_size', true ) ) {
				$socialNameStyle .= 'font-size: ' .$socialNameStyleFontSize. ';';
			}
			if ( $socialNameStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_social_name_font_msize', true ) ) {
				$socialNameStyleMobile .='--socialname-fontsize:' .$socialNameStyleFontSizeMobile.';';
			}
			if ( $socialNameStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_social_name_font_lineheight', true ) ) {
				$socialNameStyle .= 'line-height: ' .$socialNameStyleFontLineheight. ';';
			}
			if ( $socialNameStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_social_name_font_letter_spacing', true ) ) {
				$socialNameStyle .= 'letter-spacing: ' .intval( esc_attr( $socialNameStyleFontLetterSpacing ) ). 'px;';
			}
		}

		//Get icon size 
		$getSocialMediaIconSize = get_post_meta($post_id, '__ux_cb_module_social_media_share_icons_size', true);
		if( ! is_array($getSocialMediaIconSize) ){
			$getSocialMediaIconSize = array($getSocialMediaIconSize, 0);
		}
		$socialMediaIconSize = intval( $getSocialMediaIconSize[0] );
		$socialMediaIconSizeMobile = intval( $getSocialMediaIconSize[1] );
		if($socialMediaIconSize) {
			$socialMediaIconSizeStyle = 'font-size:'.esc_attr($socialMediaIconSize).'px;';
		}
		if($socialMediaIconSizeMobile) {
			$socialMediaIconSizeMobileStyle = '--iconsize-social-m:'.esc_attr($socialMediaIconSizeMobile).'px;';
		}

		//Get Space Horizontal
		$getSocialMediaIconSpaceh = get_post_meta( $post_id, '__ux_cb_module_social_media_share_space_h', true );
		if ( ! is_array( $getSocialMediaIconSpaceh ) ) { $getSocialMediaIconSpaceh = array( $getSocialMediaIconSpaceh, 0 ); }
		$socialMediaIconSpaceh = intval( $getSocialMediaIconSpaceh[0] );
		$socialMediaIconSpacehMobile = intval( $getSocialMediaIconSpaceh[1] );
		if ( $socialMediaIconSpaceh ) {
			$socialMediaIconSpacehStyle = esc_attr( $socialMediaIconSpaceh ).'px';
		} 
		if ( $socialMediaIconSpacehMobile ) {
			$socialMediaIconSpacehMobileStyle = '--spacingh-social-m:'.esc_attr( $socialMediaIconSpacehMobile ).'px';
		}

		//Get Space vertical
		$getSocialMediaIconSpacev = get_post_meta($post_id, '__ux_cb_module_social_media_share_space_v', true);
		if ( ! is_array( $getSocialMediaIconSpacev ) ) { $getSocialMediaIconSpacev = array( $getSocialMediaIconSpacev, 0 ); }
		$socialMediaIconSpacev = intval( $getSocialMediaIconSpacev[0] );
		$socialMediaIconSpacevMobile = intval( $getSocialMediaIconSpacev[1] );
		if ( $socialMediaIconSpacev ) {
			$socialMediaIconSpacevStyle = esc_attr($socialMediaIconSpacev).'px';
		} 
		if ( $socialMediaIconSpacevMobile) {
			$socialMediaIconSpacevMobileStyle = '--spacingv-social-m:'.esc_attr( $socialMediaIconSpacevMobile ).'px';
		}

		//Get social name
		$socialNameSpacingStyle = '';
		$socialNameSpacingMobileStyle = '';
		$getSocialNameSpacing = get_post_meta($post_id, '__ux_cb_module_social_media_share_name_spacing', true);
		if( ! is_array($getSocialNameSpacing) ){
			$getSocialNameSpacing = array($getSocialNameSpacing, 0);
		}
		$socialNameSpacing = intval( $getSocialNameSpacing[0] );
		$socialNameSpacingMobile = intval( $getSocialNameSpacing[1] );
		if ( $socialNameSpacing && $socialType == 'social-link' ) {
			$socialNameSpacingStyle = 'margin-left:'.esc_attr($socialNameSpacing).'px;';
		}
		if ( $socialNameSpacingMobile && $socialType == 'social-link' ) {
			$socialNameSpacingMobileStyle = '--socialname-spacing:'.esc_attr($socialNameSpacingMobile).'px;';
		}

		//Export style
		if ( $socialMediaIconSizeStyle ) {
			$style = '.module-id-' .esc_attr( $moduleUnique ). ' .social-li .fa{'.esc_attr($socialMediaIconSizeStyle).esc_attr($socialNameSpacingStyle).'}';
		}
		if ( $socialNameSpacingStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .social-name{'.esc_attr($socialNameSpacingStyle).'}';
		}
		if ( $socialMediaIconSizeMobileStyle || $socialNameSpacingMobileStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' {'.esc_attr($socialMediaIconSizeMobileStyle).esc_attr($socialNameSpacingMobileStyle).'}';
		}
		if ( $socialMediaIconSpacehStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .module-social .social-li{margin-left:'.esc_attr($socialMediaIconSpacehStyle).'}';
		}
		if ( $socialMediaIconSpacehMobileStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). '{'.esc_attr($socialMediaIconSpacehMobileStyle).'}';
		}
		if ( $socialMediaIconSpacevStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .social-li{margin-bottom:'.esc_attr($socialMediaIconSpacevStyle).'}';
		}
		if ( $socialMediaIconSpacehMobileStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). '{'.esc_attr( $socialMediaIconSpacehMobileStyle ).'}';
		}
		if ( $socialMediaIconSpacevMobileStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). '{'.esc_attr( $socialMediaIconSpacevMobileStyle ).'}';
		}
		if ( $socialNameStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .social-li .share .social-name{' .esc_attr( $socialNameStyle ). '}';
		}

		if ( $socialNameStyleMobile ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). '{' .esc_attr( $socialNameStyleMobile ). '}';
		}

		return $style;
	}
}

if ( ! function_exists( 'ux_cb_module_contact_form_style' ) ) {
	/**
	 * Module Style for module Contact Form
	 */
	function ux_cb_module_contact_form_style( $post_id, $moduleUnique, $style ) {

		//Default value
		$formButtonHeightStyle = '';
		$formButtonHeightMobileStyle = '';
		$formButtonWidthFixedStyle = '';
		$formButtonWidthLRpaddingStyle = '';
		$formButtonWidthFixedMobileStyle ='';
		$formButtonWidthLRpaddingMobileStyle ='';
		$formButtonBorderStyle ='';
		$formButtonBorderHoverStyle ='';
		$formButtonTopSpaceStyle = '';
		$formButtonTopSpaceMobileStyle = '';
		$formInputBorderStyle ='';

		//Input box border
		$getFormInputBorder = get_post_meta( $post_id, '__ux_cb_module_contact_form_border', true );
		if ( $getFormInputBorder ) {
			$formInputBorderStyle = 'border-bottom-width:'.esc_attr( $getFormInputBorder ).'px;';
		}

		//Button width
		$getFormButtonWidthType = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_width_type', true );
		$getFormButtonWidthFixed = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_height_value', true );
		$getFormButtonWidthLRpadding = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_leftright_padding', true );
		if ( $getFormButtonWidthType === 'fixed-width' ) {
			if ( ! is_array( $getFormButtonWidthFixed ) ) { $getFormButtonWidthFixed = array( $getFormButtonWidthFixed, 0 ); }
			$formButtonWidthFixed = intval( $getFormButtonWidthFixed[0] );
			$formButtonWidthFixedMobile = intval( $getFormButtonWidthFixed[1] );
			if ( $formButtonWidthFixed ) {
				$formButtonWidthFixedStyle = 'width:'.esc_attr( $formButtonWidthFixed ).'px;';
			} 
			if ( $formButtonWidthFixedMobile ) {
				$formButtonWidthFixedMobileStyle = '--contactform-button-width-fixed-m:'.esc_attr( $formButtonWidthFixedMobile ).'px;';
			}
		}
		if ( $getFormButtonWidthType === 'left-right-padding' ) {
			if ( ! is_array( $getFormButtonWidthLRpadding ) ) { $getFormButtonWidthLRpadding = array( $getFormButtonWidthLRpadding, 0 ); }
			$formButtonWidthLRpadding = intval( $getFormButtonWidthLRpadding[0] );
			$formButtonWidthLRpaddingMobile = intval( $getFormButtonWidthLRpadding[1] );
			if ( $formButtonWidthLRpadding ) {
				$formButtonWidthLRpaddingStyle = 'padding-left:'.esc_attr( $formButtonWidthLRpadding ).'px; padding-right:'.esc_attr( $formButtonWidthLRpadding ).'px;';
			} 
			if ( $formButtonWidthLRpaddingMobile ) {
				$formButtonWidthLRpaddingMobileStyle = '--contactform-button-padding-lr-m:'.esc_attr( $formButtonWidthLRpaddingMobile ).'px;';
			}
		}

		//Button height
		$getFormButtonHeight = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_height_value', true );
		if ( ! is_array( $getFormButtonHeight ) ) { $getFormButtonHeight = array( $getFormButtonHeight, 0 ); }
		$formButtonHeight = intval( $getFormButtonHeight[0] );
		$formButtonHeightMobile = intval( $getFormButtonHeight[1] );
		if ( $formButtonHeight ) {
			$formButtonHeightStyle = 'height:'.esc_attr( $formButtonHeight ).'px;';
		} 
		if ( $formButtonHeightMobile ) {
			$formButtonHeightMobileStyle = '--contactform-button-height-m:'.esc_attr( $formButtonHeightMobile ).'px;';
		}

		//Button Top spacing
		$getFormButtonTopSpace = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_spacing_top', true );
		if ( ! is_array( $getFormButtonTopSpace ) ) { $getFormButtonTopSpace = array( $getFormButtonTopSpace, 0 ); }
		$formButtonTopSpace = intval( $getFormButtonTopSpace[0] );
		$formButtonTopSpaceMobile = intval( $getFormButtonTopSpace[1] );
		if ( $formButtonTopSpace ) {
			$formButtonTopSpaceStyle = 'margin-top:'.esc_attr( $formButtonTopSpace ).'px;';
		} 
		if ( $formButtonTopSpaceMobile ) {
			$formButtonTopSpaceMobileStyle = '--contactform-top-space-m:'.esc_attr( $formButtonTopSpaceMobile ).'px;';
		}

		//Button Border
		if ( $formButtonBorderWidth = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_border_width', true ) ) {
			$formButtonBorderStyle .= 'border-width: ' .esc_attr( join( 'px ', $formButtonBorderWidth ) ). 'px;';
		}
		if ( $formButtonBorderHoverWidth = get_post_meta( $post_id, '__ux_cb_module_contact_form_button_border_width_mouseover', true ) ) {
			$formButtonBorderHoverStyle .= 'border-width: ' .esc_attr( join( 'px ', $formButtonBorderHoverWidth ) ). 'px;';
		}

		//Bind CSS format
		$style .= '.module-id-' .esc_attr( $moduleUnique ). ' input[type="submit"] {'.esc_attr($formButtonWidthFixedStyle) . esc_attr($formButtonWidthLRpaddingStyle).esc_attr( $formButtonHeightStyle ).esc_attr($formButtonBorderStyle).esc_attr($formButtonTopSpaceStyle).';}';
		$style .= '.module-id-' .esc_attr( $moduleUnique ). ' {'.esc_attr($formButtonWidthFixedMobileStyle).esc_attr($formButtonWidthLRpaddingMobileStyle) . esc_attr( $formButtonHeightMobileStyle ).esc_attr($formButtonTopSpaceMobileStyle).'}';
		if ( $formButtonBorderHoverStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' input[type="submit"]:hover {'.esc_attr($formButtonBorderHoverStyle).';}';
		}
		if ( $formInputBorderStyle ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' .requiredField {'.esc_attr($formInputBorderStyle).';}';
		}

		return $style;

	}
}

if ( ! function_exists( 'ux_cb_module_text_style' ) ) {
	/**
	 * Module Style for module Text
	 */
	function ux_cb_module_text_style( $post_id, $moduleUnique, $style ) {
		$textStyle = '';
		$paddingLeft = 0;
		$paddingRight = 0;
		$paddingTopBottom = 0;

		$getCenteredWidth = get_post_meta($post_id, '__ux_cb_module_text_center_width', true);
		if( ! is_array($getCenteredWidth) ) { $getCenteredWidth = array($getCenteredWidth, 0); }
		$centeredWidth = $getCenteredWidth[0];
		$centeredWidthMobile = $getCenteredWidth[1];
		if($centeredWidth) {
			$textStyle .= 'width:' .esc_attr($centeredWidth). ';'; 
		}
		if($centeredWidthMobile) {
			$textStyle .= '--width-text-m:' .esc_attr($centeredWidthMobile).';';
		}
		
		//Get top padding
		$getPaddingTop = get_post_meta( $post_id, '__ux_cb_module_text_top_padding', true );
		if ( ! is_array( $getPaddingTop ) ) { $getPaddingTop = array( $getPaddingTop, 0 ); }
		$paddingTop = $getPaddingTop[0];
		$paddingTopMobile = $getPaddingTop[1];
		if( $paddingTop ) {
			$textStyle .= 'padding-top: ' .esc_attr($paddingTop). 'px;';
		}
		if( $paddingTopMobile ) {
			$textStyle .= '--paddingtop-text-m: ' .esc_attr($paddingTopMobile). 'px;';
		}
		//Get bottom padding
		$getPaddingBottom = get_post_meta( $post_id, '__ux_cb_module_text_bottom_padding', true );
		if ( ! is_array( $getPaddingBottom ) ) { $getPaddingBottom = array( $getPaddingBottom, 0 ); }
		$paddingBottom = $getPaddingBottom[0];
		$paddingBottomMobile = $getPaddingBottom[1];
		if( $paddingBottom ) {
			$textStyle .= 'padding-bottom: ' .esc_attr($paddingBottom). 'px;';
		}
		if( $paddingBottomMobile ) {
			$textStyle .= '--paddingbottom-text-m: ' .esc_attr($paddingBottomMobile). 'px;';
		}
		//Get left padding
		$getPaddingLeft = get_post_meta($post_id, '__ux_cb_module_text_left_padding', true);
		if( ! is_array($getPaddingLeft)) {$getPaddingLeft = array($getPaddingLeft ,0); }
		$paddingLeft = intval($getPaddingLeft[0]);
		$paddingLeftMobile = intval($getPaddingLeft[1]);
		if($paddingLeft){
			$textStyle .= 'padding-left: ' .esc_attr($paddingLeft). 'px;';
		}
		if($paddingLeftMobile){
			$textStyle .= '--paddingleft-text-m: ' .esc_attr($paddingLeftMobile). 'px;';
		}
		//Get right padding
		$getPaddingRight = get_post_meta($post_id, '__ux_cb_module_text_right_padding', true);
		if( ! is_array($getPaddingRight)) {$getPaddingRight = array($getPaddingRight ,0); }
		$paddingRight = intval($getPaddingRight[0]);
		$paddingRightMobile = intval($getPaddingRight[1]);
		if($paddingRight){
			$textStyle .= 'padding-right: ' .esc_attr( $paddingRight ). 'px;';
		}
		if( $paddingRightMobile ){
			$textStyle .= '--paddingright-text-m: ' .esc_attr( $paddingRightMobile ). 'px;';
		}

		//Get Container height mobile
		$ConHeightMobileStyle = '';
		$conHeightType = get_post_meta( $post_id, '__ux_cb_module_text_container_height', true );
		$conHeightMobile = intval( get_post_meta( $post_id, '__ux_cb_module_text_container_height_mobile', true ) );
		if( $conHeightMobile ) {
			$ConHeightMobileStyle = '--minheight-text-m:' .esc_attr( $conHeightMobile ). 'vh;';
		}


		//Expert css
		if( $textStyle ) {
			$style = '.module-id-' .esc_attr( $moduleUnique ). ' .text_block_centered {'.esc_attr( $textStyle ).'}';
		}
		if( $conHeightType === 'fullscreen-ux' ) {
			$style .= '.module-id-' .esc_attr( $moduleUnique ). ' {' .esc_attr( $ConHeightMobileStyle ). '}';
		}
		 

		return $style;
	}
}

if ( ! function_exists( 'ux_cb_module_embed_style' ) ) {
	/**
	 * Module Style for module Embed
	 */
	function ux_cb_module_embed_style( $post_id, $moduleUnique, $style ) {
		$name = '__ux_cb_module_embed';

		//Play icon
		$playIcoStyle = '';
		$playIcoHoverStyle = '';
		if ( $playIcoColor = get_post_meta( $post_id, $name. '_playbutton_color', true ) ) {
			$playIcoStyle .= 'color:'.esc_attr( $playIcoColor ).';';
		}
		if ( $playIcoHoverColor = get_post_meta( $post_id, $name. '_playbutton_color_mouseover', true ) ) {
			$playIcoHoverStyle .= 'color:'.esc_attr( $playIcoHoverColor ).';';
		}

		if ( $moduleUnique ) {
			$moduleUniqueClass = '.module-id-' .esc_attr( $moduleUnique );
			if ( $playIcoStyle != '' ) { $style .= $moduleUniqueClass. ' .video-play-btn:before{ ' .esc_attr( $playIcoStyle ). ' }'; }
			if ( $playIcoHoverStyle != '' ) { $style .= $moduleUniqueClass. ' .video-play-btn:hover:before{ ' .esc_attr( $playIcoHoverStyle ). ' }'; }
		}
		
		return $style;

	}
}

if ( ! function_exists( 'ux_cb_module_post_navi_style' ) ) {
	/**
	 * Module Style for module Post Navigation
	 */
	function ux_cb_module_post_navi_style( $post_id, $moduleUnique, $style ) {
		$name = '__ux_cb_module_post_navi';
		
		//title style
		$titleStyle = ux_cb_module_output_fonts_group_style( $post_id, $name. '_title_font' );
		if ( $titleColor = get_post_meta( $post_id, $name. '_title_font_color', true ) ) { $titleStyle .= 'color: ' .esc_attr( $titleColor ). ';'; }
		$titleUnderline = get_post_meta( $post_id, $name. '_title_underline', true );
		if ( $titleUnderline == 'on' ) { $titleStyle .= 'text-decoration: underline;'; }
		
		//title hover style
		$titleHoverStyle = '';
		if ( $titleColor = get_post_meta( $post_id, $name. '_title_font_color_hover', true ) ) { $titleHoverStyle .= 'color: ' .esc_attr( $titleColor ). ';'; }
		
		$titleHoverUnderline = get_post_meta( $post_id, $name. '_title_underline_hover', true );
		if ( $titleHoverUnderline == 'on' ) { $titleHoverStyle .= 'text-decoration: underline;'; }
		
		//label style
		$labelStyle = ux_cb_module_output_fonts_group_style( $post_id, $name. '_label_font' );
		if ( $labelPaddingBottom = intval( get_post_meta( $post_id, $name. '_label_padding_bottom', true ) ) ) {
			$labelStyle .= 'padding-bottom: ' .$labelPaddingBottom. 'px;';
		}
		
		//title wrap style
		$titleWrapStyle = '';
		$titleWrapPadding = ux_cb_module_output_multiple_input_style( $post_id, $name. '_padding' );
		if ( $titleWrapPadding[0] ) {
			$titleWrapStyle .= 'padding-top: ' .esc_attr( $titleWrapPadding[0] ). 'px; padding-bottom: ' .esc_attr( $titleWrapPadding[0] ). 'px;';
		}
		if ( $titleWrapPadding[1] ) {
			$titleWrapStyle .= '--paddingtop-text-m: ' .esc_attr( $titleWrapPadding[1] ). 'px; --paddingbottom-text-m: ' .esc_attr( $titleWrapPadding[1] ). 'px;';
		}
		
		//padding left
		$titleWrapPaddingL = ux_cb_module_output_multiple_input_style( $post_id, $name. '_padding_left' );
		if ( $titleWrapPaddingL[0] ) { $titleWrapStyle .= 'padding-left: ' .esc_attr( $titleWrapPaddingL[0] ). 'px;'; }
		if ( $titleWrapPaddingL[1] ) { $titleWrapStyle .= '--paddingleft-text-m: ' .esc_attr( $titleWrapPaddingL[1] ). 'px;'; }
		
		//padding right
		$titleWrapPaddingR = ux_cb_module_output_multiple_input_style( $post_id, $name. '_padding_right' );
		if ( $titleWrapPaddingR[0] ) { $titleWrapStyle .= 'padding-right: ' .esc_attr( $titleWrapPaddingR[0] ). 'px;'; }
		if ( $titleWrapPaddingR[1] ) { $titleWrapStyle .= '--paddingright-text-m: ' .esc_attr( $titleWrapPaddingR[1] ). 'px;'; }
		
		if ( $moduleUnique ) {
			$moduleUniqueClass = '.module-id-' .esc_attr( $moduleUnique );
			if ( $labelStyle != '' ) { $style .= esc_attr( $moduleUniqueClass ). ' .post-navi-tag { ' .esc_attr( $labelStyle ). ' }'; }
			if ( $titleStyle != '' ) { $style .= esc_attr( $moduleUniqueClass ). ' .post-navi-tit-a,'.esc_attr( $moduleUniqueClass ).' .bm-tab-slider-trigger-tilte { ' .esc_attr( $titleStyle ). ' }'; }
			if ( $titleHoverStyle != '' ) { $style .= esc_attr( $moduleUniqueClass ). ' .post-navi-tit-a:hover,'.esc_attr( $moduleUniqueClass ).' .bm-tab-slider-trigger-tilte:hover { ' .esc_attr( $titleHoverStyle ). ' }'; }
			if ( $titleWrapStyle != '' ) { $style .= esc_attr( $moduleUniqueClass ). ' .post-navi-tit-wrap,'.esc_attr( $moduleUniqueClass ).' .bm-tab-slider-trigger{ ' .esc_attr( $titleWrapStyle ). ' }'; }
		}
		
		return $style;
	}
}
?>