<?php
if ( ! function_exists( 'ux_cb_fonts_export' ) ) {
	/**
	 * export theme options fonts
	 */
	function ux_cb_fonts_export( $wp_filesystem, $time ) {
		$content = false;
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		
	}
	add_action( 'ux_tools_export_data', 'ux_cb_fonts_export', 15, 2 );
}

if ( ! function_exists( 'ux_cb_fonts_import_process' ) ) {
	/**
	 * import process theme option fonts
	 */
	function ux_cb_fonts_import_process( $importData, $importDir ) {
		global $wp_filesystem;
		if ( $fontLists = $wp_filesystem->get_contents( $importDir. '/options/font-lists.json' ) ) {
			$fontLists = json_decode( $fontLists, true );
			update_option( 'ux-font-lists', $fontLists );
			
			if ( $fontLists = get_option( 'ux-font-lists' ) ) {
				foreach ( $fontLists as $fontItem ) {
					$unique = trim( $fontItem[ 'value' ] );
					if ( $fontFields = $wp_filesystem->get_contents( $importDir. '/options/fonts/' .$unique. '.json' ) ) {
						$fontFields = json_decode( $fontFields, true );
						update_option( 'ux-font-' .$unique, $fontFields );
						
						if ( $fontFields = get_option( 'ux-font-' .$unique ) ) {
							switch( $fontFields[ 1 ][ 'value' ] ) {
								case 'adobe-typekit':
									$kitID = '';
									$fontFamily = '';
									foreach ( $fontFields as $field ) {
										if ( $field[ 'name' ] == '__ux_cb_module_fonts_resource_adobe-typekit-id' ) {
											$kitID = $field[ 'value' ];
										} else if ( $field[ 'name' ] == '__ux_cb_module_fonts_resource_adobe-typekit_family' ) {
											$fontFamily = $field[ 'value' ];
										} 
									}
									
									if ( $typekitFonts = $wp_filesystem->get_contents( $importDir. '/options/typekit-fonts/' .$kitID. '.json' ) ) {
										$typekitFonts = json_decode( $typekitFonts, true );
										update_option( 'ux_theme_typekit_font_' .$kitID, $typekitFonts );
									}
									
									if ( $typekitFontFamily = $wp_filesystem->get_contents( $importDir. '/options/typekit-fonts/' .$kitID. '_' .$fontFamily. '.json' ) ) {
										$typekitFontFamily = json_decode( $typekitFontFamily, true );
										update_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily, $typekitFontFamily );
										
									}
									
									if ( $typekitFontLanguage = $wp_filesystem->get_contents( $importDir. '/options/typekit-fonts/' .$kitID. '_' .$fontFamily. '_language.json' ) ) {
										$typekitFontLanguage = json_decode( $typekitFontLanguage, true );
										update_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily. '_language', $typekitFontLanguage );
										
									}
								break;
							}
						}
					}
				}
			}
		}
		
		if ( $fontAssignment = $wp_filesystem->get_contents( $importDir. '/options/font-assignment.json' ) ) {
			$fontAssignment = json_decode( $fontAssignment, true );
			update_option( 'ux-font-assignment', $fontAssignment );
		}
	}
	add_action( 'ux_tools_import_option', 'ux_cb_fonts_import_process', 15, 2 );
}

if ( ! function_exists( 'ux_cb_import_posttytyt' ) ) {
	/**
	 * import module meta
	 */
	function ux_cb_import_post_paeson( $importData, $post_id, $post, $home_url ) {
		if ( $post[ 'post_type' ] == 'ux-cb-modules' ) {
			//media library layouts
			if ( $layouts = get_post_meta( $post_id, '_ux_cb_module_layouts_-1', true ) ) {
				foreach ( $layouts as $num => $layout ) {
					if ( isset( $layout[ 'post_id' ] ) ) {
						if ( $getNewPostID = ux_tools_import_replace_post_id( $layout[ 'post_id' ], 'attachment', $importData, $home_url ) ) {
							$layouts[ $num ][ 'post_id' ] = $getNewPostID;
						}
					}
				}
				update_post_meta( $post_id, '_ux_cb_module_layouts_-1', $layouts );
			}
			
			if ( $media_images = get_post_meta( $post_id, '__ux_cb_module_grid_media_images', true ) ) {
				foreach ( $media_images as $num => $image ) {
					if ( $getNewPostID = ux_tools_import_replace_post_id( $image, 'attachment', $importData, $home_url ) ) {
						$media_images[ $num ] = $getNewPostID;
					}
				}
				update_post_meta( $post_id, '__ux_cb_module_grid_media_images', $media_images );
			}
		}
	}
	//add_action( 'ux_tools_import_post', 'ux_cb_import_post', 10, 4 );
}
?>