<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder register post type for attachment.
 */
if ( ! function_exists( 'ux_cb_register_attachment_post' ) ) {
	function ux_cb_register_attachment_post() {
		$labels = array(   
			'name' => 'Categories', 
			'singular_name' => 'Categories', 
			'menu_name' => 'Categories',   
		);  
		
		register_taxonomy(   
			'ux-attachment-cat',   
			array( 'attachment' ),   
			array(   
				'hierarchical' => true,   
				'labels' => $labels,   
				'show_ui' => true,   
				'query_var' => true,
				'show_admin_column' => true,
				'rewrite' => array( 'slug' => 'ux-attachment-cat' ),   
			)   
		); 
	}
	add_action( 'ux_cb_after_init', 'ux_cb_register_attachment_post' );
}

/**
 * UX Content Builder add attachment meta fields.
 */
if ( ! function_exists( 'ux_cb_add_attachment_meta_fields' ) ) {
	function ux_cb_add_attachment_meta_fields( $form_fields, $post ) {
		$field_value = get_post_meta( $post->ID, 'what_thumbnail_does', true );
		$form_fields[ 'what_thumbnail_does' ] = array(
			'value' => $field_value ? $field_value : '',
			'label' => esc_html__( 'Custom URL', 'bm-builder' ),
			'helps' => esc_html__( 'For what thumbnail does of Gird & Custom Grid', 'bm-builder' )
		);
		
		if ( $post->post_mime_type == 'image/svg+xml' ) {
			$form_fields[ 'ux_svg_color' ] = array(
				'value' => '#000000',
				'label' => esc_html__( 'Svg Color', 'bm-builder' ),
			);
			$form_fields[ 'ux_svg_width' ] = array(
				'value' => '24',
				'label' => esc_html__( 'Svg Width', 'bm-builder' ),
			);
		}
		
		return $form_fields;
	}
	add_filter( 'attachment_fields_to_edit', 'ux_cb_add_attachment_meta_fields', 10, 2 );
}

/**
 * UX Content Builder save attachment meta fields.
 */
if ( ! function_exists( 'ux_cb_save_attachment_meta_fields' ) ) {
	function ux_cb_save_attachment_meta_fields( $attachment_id ) {
		if ( isset( $_REQUEST['attachments'][$attachment_id]['what_thumbnail_does'] ) ) {
			$location = $_REQUEST['attachments'][$attachment_id]['what_thumbnail_does'];
			update_post_meta( $attachment_id, 'what_thumbnail_does', $location );
		}
	}
	add_action( 'edit_attachment', 'ux_cb_save_attachment_meta_fields' );
}

/**
 * UX Content Builder attachment cat column.
 */
if ( ! function_exists( 'ux_cb_attachment_cat_column' ) ) {
	function ux_cb_attachment_cat_column( $columns, $column, $id ) {
		if ( $column == 'count' ) {
			$posts = get_posts( array(
				'posts_per_page' => -1,
				'post_type' => 'attachment',
				'post_status' => 'inherit',
				'tax_query' => array(
					array(
						'taxonomy' => 'ux-attachment-cat',
						'terms'    => $id,
					),
				)
			) );
			$tag = get_term( $id, 'ux-attachment-cat' );
			$args = array( 'ux-attachment-cat' => $tag->slug, 'post_type' => 'attachment' );
			$columns = '<a href="' . esc_url ( add_query_arg( $args, 'upload.php' ) ) . '">' .number_format_i18n( count( $posts ) ). '</a>';
		}
		return $columns;
	}
	add_filter( 'manage_ux-attachment-cat_custom_column', 'ux_cb_attachment_cat_column', 10, 3 );
}

/**
 * UX Content Builder attachment cat columns.
 */
if ( ! function_exists( 'ux_cb_attachment_cat_columns' ) ) {
	function ux_cb_attachment_cat_columns( $columns ) {
		if ( isset( $columns[ 'posts' ] ) ) {
			unset( $columns[ 'posts' ] );
		}
		
		$columns[ 'count' ] = __( 'Count', 'bm-builder' );
		return $columns;
	}
	add_filter( 'manage_edit-ux-attachment-cat_columns', 'ux_cb_attachment_cat_columns' );
}

/**
 * UX Content Builder attachment mime type svg icon.
 */
if ( ! function_exists( 'ux_cb_attachment_mime_type_svg_icon' ) ) {
	function ux_cb_attachment_mime_type_svg_icon( $icon, $mime, $post_id ){
		if ( $mime == 'image/svg+xml' ) {
			$icon = wp_get_attachment_url( $post_id );
		}
		return $icon;
	}
	add_filter( 'wp_mime_type_icon', 'ux_cb_attachment_mime_type_svg_icon', 10, 3 );
}
?>