<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Current content builder page options
 */
if ( ! defined( 'UX_CB_PAGE_CUSTOMIZE' ) ) {
	/**
	 *
	 */
	define( 'UX_CB_PAGE_CUSTOMIZE', 'true' );
}

/**
 * UX Content Builder Page Option customize.
 */
if ( ! function_exists( 'ux_cb_page_customize' ) ) {
	function ux_cb_page_customize( $post ) {
		$switch = false;
		
		if ( current_filter() == 'in_admin_header' ) {
			if ( function_exists( 'use_block_editor_for_post' ) ) {
				global $post, $pagenow;
				if ( use_block_editor_for_post( $post ) ) {
					if ( $pagenow == 'post-new.php' || $pagenow == 'post.php' ) {
						$switch = true;
					}
				}
			}
		} else {
			$switch = true;
		}
		
		if ( $switch ) {
			if ( $post->post_type == 'page' || $post->post_type == 'post' || $post->post_type == 'ux-portfolio' ) {
				ux_cb_include_template( 'pages/page-customize-interface.php' );
				do_action( 'ux_cb_page_customize', $post );
			}
		}
	}
	add_action( 'edit_page_form', 'ux_cb_page_customize' );
	add_action( 'edit_form_advanced', 'ux_cb_page_customize' );
	add_action( 'in_admin_header', 'ux_cb_page_customize' );
}

/**
 * UX Content Builder Page Option customize template button.
 */
if ( ! function_exists( 'ux_cb_page_customize_template_button' ) ) {
	function ux_cb_page_customize_template_button() {
		echo '<button id="ux-cb-page-options-template" type="button" class="active ux-cb-button">' .esc_html__( 'Template', 'bm-builder' ). '</button>';
	}
	//add_action( 'ux_cb_customize_tools', 'ux_cb_page_customize_template_button' );
}

/**
 * UX Content Builder Page Option customize settings button.
 */
if ( ! function_exists( 'ux_cb_page_customize_settings_button' ) ) {
	function ux_cb_page_customize_settings_button() {
		echo '<button id="ux-cb-page-options-settings" type="button" class="ux-cb-button">' .esc_html__( 'Settings', 'bm-builder' ). '</button>';
	}
	//add_action( 'ux_cb_customize_tools', 'ux_cb_page_customize_settings_button' );
}

/**
 * UX Content Builder Page Option customize save layouts button.
 */
if ( ! function_exists( 'ux_cb_page_customize_save_layouts_button' ) ) {
	function ux_cb_page_customize_save_layouts_button() { ?>
		<button id="ux-cb-page-options-save-layouts" type="button"><?php esc_html_e( 'Save Layout as Template', 'bm-builder' ); ?></button>
		<script type="text/template" id="tmpl-save-layouts">
			<button class="save-layout" type="button"><?php esc_html_e( 'Save', 'bm-builder' ); ?></button>
			<h3 class="module-layout-title"><?php esc_attr_e( 'Save Elements to Section', 'bm-builder' ); ?></h3>
			<div class="module-layout-content">
				<table class="form-table">
					<tbody>
						<tr class="ux-cb-page-options-save-layouts-form-name">
							<th><?php esc_html_e( 'Name', 'bm-builder' ); ?></th>
							<td><input type="text" name="module-template-name" class="regular-text"></td>
						</tr>
						<tr>
							<th></th>
							<td>
								<?php
								if ( $categories = ux_cb_ins_mod_tpl_cat() ) {
									echo '<select class="form-control" name="module-template-category">';
									foreach ( $categories as $value => $name ) {
										$disabled = false;
										if ( $value != 'user' ) {
											$disabled = true;
										}
										echo '<option value="' .sanitize_text_field( $value ). '" ' .selected( 'user', $value, false ). ' ' .disabled( true, $disabled, false ). '>' .esc_html( $name ). '</option>';
									}
									echo '</select>';
								} ?>
							</td>
						</tr>
						<tr class="ux-cb-page-options-save-layouts-form-screenshot">
							<th><?php esc_html_e( 'Screenshot', 'bm-builder' ); ?></th>
							<td><button type="button" name="upload-screenshot"><?php esc_html_e( 'Upload Image', 'bm-builder' ); ?></button></td>
						</tr>
						<tr class="saved-locally hidden">
							<th><?php esc_html_e( 'Saved locally?', 'bm-builder' ); ?></th>
							<td><input type="checkbox" name="saved-locally" value="yes"></td>
						</tr>
					</tbody>
				</table>
			</div>
		</script>
	<?php
    }
	add_action( 'ux_cb_customize_tools', 'ux_cb_page_customize_save_layouts_button' );
}

/**
 * UX Content Builder Page Option customize save layouts ajax.
 */
if ( ! function_exists( 'ux_cb_page_customize_save_layout_ajax' ) ) {
	function ux_cb_page_customize_save_layout_ajax() {
		$method = 'direct';
		$url = wp_nonce_url( 'post.php' );
		if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
			return true;
		}
		
		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( $url, $method, true, false, false );
			return true;
		}
		
		$dirUnique = 'false';
		
		global $wp_filesystem;
		if ( isset( $_POST['moduleArray'] ) ) {
			if ( is_array( $moduleArray = $_POST['moduleArray'] ) ) {
				if ( isset( $_POST['templateCategory'] ) ) {
					$templateCategory = $_POST['templateCategory'];
					list( $t1, $t2 ) = explode( ' ', microtime() ); 
					$dirUnique = $t2 .  ceil( ( $t1 * 1000 ) );
					$dirPath = ux_cb_path_dir( 'PLACEHOLD_DIR', $templateCategory. '/' .$dirUnique );
					if ( defined( 'INS_TPL_PLACEHOLD_DIR' ) ) {
						$dirPath = INS_TPL_PLACEHOLD_DIR. '/'. $templateCategory. '/' .$dirUnique;
					}
					
					if ( $templateCategory == 'user' ) {
						$uploadDir = wp_upload_dir();
						$dirPath = $uploadDir['basedir']. '/ux-cb/palcehold/' .$templateCategory. '/' .$dirUnique;
						
						if ( ! $wp_filesystem->is_dir( $uploadDir['basedir']. '/ux-cb' ) ) { $wp_filesystem->mkdir( $uploadDir['basedir']. '/ux-cb' ); }
						if ( ! $wp_filesystem->is_dir( $uploadDir['basedir']. '/ux-cb/palcehold' ) ) { $wp_filesystem->mkdir( $uploadDir['basedir']. '/ux-cb/palcehold' ); }
						if ( ! $wp_filesystem->is_dir( $uploadDir['basedir']. '/ux-cb/palcehold/' .$templateCategory ) ) { $wp_filesystem->mkdir( $uploadDir['basedir']. '/ux-cb/palcehold/' .$templateCategory ); }
						
					}
					
					if ( ! $wp_filesystem->is_dir( $dirPath ) ) {
						$wp_filesystem->mkdir( $dirPath );
					}
					
					$moduleData = array();
					foreach ( $moduleArray as $num => $module ) {
						$moduleUnique = $module['unique'];
						if ( ! $wp_filesystem->is_dir( $dirPath. '/' .$moduleUnique ) ) {
							$wp_filesystem->mkdir( $dirPath. '/' .$moduleUnique );
						}
						$moduleData[$moduleUnique] = ux_cb_page_customize_save_layout_data( $module, $dirPath, $wp_filesystem, $templateCategory );
						
						if ( isset( $module['items'] ) ) {
							foreach ( $module['items'] as $subModule ) {
								$subModuleUnique = $subModule['unique'];
								if ( ! $wp_filesystem->is_dir( $dirPath. '/' .$subModuleUnique ) ) {
									$wp_filesystem->mkdir( $dirPath. '/' .$subModuleUnique );
								}
								$moduleData[$subModuleUnique] = ux_cb_page_customize_save_layout_data( $subModule, $dirPath, $wp_filesystem, $templateCategory );
							}
						}
					}
					
					if ( isset( $_POST['templateName'] ) ) {
						$moduleData['name'] = $_POST['templateName'];
						$aray['uq'] = $_POST['templateName'];
					}
					
					if ( isset( $_POST['shortcodeHtml'] ) ) {
						$moduleData['shortcodeHtml'] = $_POST['shortcodeHtml'];
					}
					
					//data 
					$content = json_encode( $moduleData );
					$wp_filesystem->put_contents( $dirPath. '/data.json', $content, FS_CHMOD_FILE );
					
					//index
					$content = json_encode( $moduleArray );
					$wp_filesystem->put_contents( $dirPath. '/index.json', $content, FS_CHMOD_FILE );
					
					if ( isset( $_POST['uploadScreenshot'] ) ) {
						$uploadScreenshot = $_POST['uploadScreenshot'];
						$pathinfo = pathinfo( $uploadScreenshot );
						
						$wp_filesystem->copy( $uploadScreenshot, $dirPath. '/screenshot.'. $pathinfo['extension'] );
					}
				}
			}
		}
		
		echo $dirUnique;
		exit;
	}
	add_action( 'wp_ajax_ux_cb_page_customize_save_layout_ajax', 'ux_cb_page_customize_save_layout_ajax' );
}

/**
 * UX Content Builder Page Option customize save layout data.
 */
if ( ! function_exists( 'ux_cb_page_customize_save_layout_data' ) ) {
	function ux_cb_page_customize_save_layout_data( $module, $dirPath, $wp_filesystem ) {
		$metaFields = 'false';
		$moduleUnique = $module['unique'];
		$modulePostID = ux_cb_get_the_module_post_id( $moduleUnique );
		if ( $modulePostID ) {
			$moduleFields = get_post_custom( $modulePostID );
			$metaFields = array();
			$fileOutput = array();
			
			foreach ( $moduleFields as $key => $value ) {
				$metaFields[$key] = get_post_meta( $modulePostID, $key, true );
			}
			
			//mod single image
			if ( $fileType = get_post_meta( $modulePostID, '__ux_cb_module_single_image_file_type', true ) ) {
				switch ( $fileType ) {
					case 'svg': $fileOutput[] = get_post_meta( $modulePostID, '__ux_cb_module_single_image_svg-url', true ); break;
					case 'image': $fileOutput[] = get_post_meta( $modulePostID, '__ux_cb_module_single_image_image-url', true ); break;
				}
			}
			
			//mod button
			if ( $buttonItems = get_post_meta( $modulePostID, '_ux_cb_module_button_items', true ) ) {
				foreach ( $buttonItems as $num => $item_row ) {
					foreach ( $item_row as $field ) {
						if ( $field['name'] == '__ux_cb_module_button_items_icon_svg-url' ) {
							$fileOutput[] = array( $num, $field['value'] );
						}
					}
				}
			}
			
			//mod slider
			if ( $mediaImages = get_post_meta( $modulePostID, '__ux_cb_module_slider_media_images', true ) ) {
				if ( ! is_array( $mediaImages ) ) { $mediaImages = array( $mediaImages ); }
				foreach ( $mediaImages as $num => $image ) {
					$fileOutput[] = array( $num, wp_get_attachment_url( $image ) );
				}
			}
			
			//mod grid
			if ( $source = get_post_meta( $modulePostID, '__ux_cb_module_grid_source', true ) ) {
				if ( $source == 'attachment' ) {
					if ( $mediaImages = get_post_meta( $modulePostID, '__ux_cb_module_grid_media_images', true ) ) {
						foreach ( $mediaImages as $num => $image ) {
							$fileOutput[] = array( $num, wp_get_attachment_url( $image ) );
						}
					}
				}
			}
			
			//mod masonry grid
			if ( $source = get_post_meta( $modulePostID, '__ux_cb_module_masonry_grid_source', true ) ) {
				//taxonomy
				$taxonomy = get_post_meta( $modulePostID, '__ux_cb_module_masonry_grid_category_' .$source. '_tax', true );
				if ( !$taxonomy ) { $taxonomy = 'ux-portfolio-cat'; }
				
				//category
				$category = get_post_meta( $modulePostID, '__ux_cb_module_masonry_grid_category_' .$source, true );
				if ( $category ) { if ( $category == '0' ) { $category = false; } }
				
				if ( $source == 'attachment' ) {
					if ( $mediaImages = get_post_meta( $modulePostID, '__ux_cb_module_masonry_grid_media_images', true ) ) {
						foreach ( $mediaImages as $num => $image ) {
							$fileOutput[] = array( $num, wp_get_attachment_url( $image ) );
						}
					}
					$layouts = get_post_meta( $post_id, '_ux_cb_module_layouts_-1', true );
				} else {
					$catID = $category;
					if ( $category == '' ) { $catID = '0'; }
					$layouts = get_post_meta($post_id, '_ux_cb_module_layouts_' .$catID, true);
				}
			}
			
			foreach ( array(
				'__ux_cb_module_embed_image', //mod embed
				'__ux_cb_module_group_bg_image', //mod group
				'__ux_cb_module_slider_style_1_left_arrow', //mod slider
				'__ux_cb_module_slider_style_1_right_arrow', //mod slider
				'__ux_cb_module_slider_style_3_left_arrow', //mod slider
				'__ux_cb_module_slider_style_3_right_arrow', //mod slider
				'__ux_cb_module_text_bg_image', //mod text
			) as $fieldName ) {
				if ( $uploadImageID = get_post_meta( $modulePostID, $fieldName, true ) ) {
					if ( $uploadImageUrl = wp_get_attachment_url( $uploadImageID ) ) {
						$fileOutput[] = $uploadImageUrl;
					}
				}
			}
			
			$templateCategory = $_POST['templateCategory'];
			if ( $fileOutput && $templateCategory != 'user' ) {
				foreach ( $fileOutput as $file ) {
					$fileUrl = $file;
					$fileSlug = '';
					if ( is_array( $file ) ) {
						$fileUrl = $file[1];
						$fileSlug = $file[0]. '-mod-';
					}
					
					$pathinfo = pathinfo( $fileUrl );
					$fileName = str_replace( '-mod-', '', $pathinfo['basename'] );
					$fileName = $fileSlug .$fileName;
					$wp_filesystem->copy( $fileUrl, $dirPath. '/' .$moduleUnique. '/' .$fileName );
				}
			}
		}
		
		return $metaFields;
	}
}

/**
 * UX Content Builder Page Option customize insert layouts button.
 */
if ( ! function_exists( 'ux_cb_page_customize_insert_layouts_button' ) ) {
	function ux_cb_page_customize_insert_layouts_button() {
		global $wp_filesystem; ?>
		<button id="ux-cb-page-options-insert-layouts" type="button"><?php esc_html_e( 'Insert Template', 'bm-builder' ); ?></button>
		<script type="text/template" id="tmpl-insert-layouts">
			<h3 class="module-layout-title"><?php esc_attr_e( 'Insert Sections', 'bm-builder' ); ?></h3>
			<div class="module-layout-content">
				<div class="module-layout-sidebar">
					<?php if ( $cats = ux_cb_ins_mod_tpl_cat() ) {
						$i = 0;
						echo '<ul>';
						foreach ( $cats as $val => $name ) {
							$act = $i == 0 ? 'active' : false; $i++;
							echo '<li class="' .sanitize_html_class( $act ). '" data-id="' .sanitize_html_class( $val ). '">' .esc_html( $name ). '</li>';
						}
						echo '</ul>';
					} ?>
				</div>
				<?php if ( $cats = ux_cb_ins_mod_tpl_cat() ) {
					$i = 0;
					foreach ( $cats as $val => $name ) {
						$act = $i == 0 ? 'active' : false; $i++;
						echo '<div class="module-layout-section ' .sanitize_html_class( $act ). '" data-id="' .sanitize_html_class( $val ). '">';
						
						ux_cb_ins_load_mod_tpl( $val, $name );
						
						echo '</div>';
					}
				} ?>
			</div>
		</script>
	<?php
	}
	add_action( 'ux_cb_customize_tools', 'ux_cb_page_customize_insert_layouts_button' );
}

/**
 * UX Content Builder Page customize remove layouts ajax.
 */
if ( ! function_exists( 'ux_cb_remove_layout_ajax' ) ) {
	function ux_cb_remove_layout_ajax() {
		$method = 'direct';
		$url = wp_nonce_url( 'post.php' );
		if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
			return true;
		}
		
		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( $url, $method, true, false, false );
			return true;
		}
		
		global $wp_filesystem;
		if ( isset( $_POST['dirUq'] ) && isset( $_POST['tplCat'] ) ) {
			$dirUq = $_POST['dirUq'];
			$tplCat = $_POST['tplCat'];
			
			$ulDir = wp_upload_dir();
			$dir = $ulDir['basedir']. '/ux-cb/palcehold/' .$tplCat. '/' .$dirUq;
			
			if ( $wp_filesystem->rmdir( $dir, true ) ) {
				echo 'ok';
			}
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_remove_layout_ajax', 'ux_cb_remove_layout_ajax' );
}

/**
 * UX Content Builder Page customize insert layouts ajax.
 */
if ( ! function_exists( 'ux_cb_ins_layout_ajax' ) ) {
	function ux_cb_ins_layout_ajax() {
		$method = 'direct';
		$url = wp_nonce_url( 'post.php' );
		if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
			return true;
		}
		
		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( $url, $method, true, false, false );
			return true;
		}
		
		global $wp_filesystem;
		if ( isset( $_POST['dirUq'] ) && isset( $_POST['tplCat'] ) ) {
			$dirUq = $_POST['dirUq'];
			$tplCat = $_POST['tplCat'];
			$dir = ux_cb_path_dir( 'PLACEHOLD_DIR', $tplCat. '/' .$dirUq );
			if ( defined( 'INS_TPL_PLACEHOLD_DIR' ) ) {
				$dir = INS_TPL_PLACEHOLD_DIR. '/'. $tplCat. '/' .$dirUq;
			}
			
			if ( $tplCat == 'user' ) {
				$ulDir = wp_upload_dir();
				$dir = $ulDir['basedir']. '/ux-cb/palcehold/' .$tplCat. '/' .$dirUq;
			}
			
			if ( ( $index = $wp_filesystem->get_contents( $dir. '/index.json' ) ) && ( $data = $wp_filesystem->get_contents( $dir. '/data.json' ) ) ) {
				$modShortcode = '';
				
				$modAray = json_decode( $index, true );
				$modData = json_decode( $data, true );
				
				if ( isset( $modData['shortcodeHtml'] ) ) {
					$modShortcode = stripslashes_deep( $modData['shortcodeHtml'] );
					$modShortcode = str_replace( '[ux_cb_wrap]', '', $modShortcode );
					$modShortcode = str_replace( '[/ux_cb_wrap]', '', $modShortcode );
				}
				
				if ( is_array( $modAray ) ) {
					foreach ( $modAray as $mod ) {
						$mod = ux_cb_ins_layout_mod( $mod, $modData, $tplCat, $dirUq, $dir, $wp_filesystem );
						if ( $mod['moduleID'] ) {
							$modShortcode = str_replace( $mod['unique'], $mod['newUnique'], $modShortcode );
							if ( isset( $mod['items'] ) ) {
								foreach ( $mod['items'] as $subMod ) {
									$subMod = ux_cb_ins_layout_mod( $subMod, $modData, $tplCat, $dirUq, $dir, $wp_filesystem );
									if ( $mod['moduleID'] ) {
										$modShortcode = str_replace( $subMod['unique'], $subMod['newUnique'], $modShortcode );
									}
								}
							}
						}
					}
				}
				
				if ( $modShortcode != '' ) {
					echo do_shortcode( $modShortcode );
				}
			}
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_ins_layout_ajax', 'ux_cb_ins_layout_ajax' );
}

/**
 * UX Content Builder Page customize insert layouts module.
 */
if ( ! function_exists( 'ux_cb_ins_layout_mod' ) ) {
	function ux_cb_ins_layout_mod( $mod, $modData, $tplCat, $dirUq, $dir, $wp_filesystem ) {
		if ( is_array( $modData ) ) {
			foreach ( $modData as $uq => $fields ) {
				if ( $mod['unique'] == $uq ) {
					if ( $fields != 'false' ) {
						list( $t1, $t2 ) = explode( ' ', microtime() ); 
						$newModUq = $t2 .  ceil( ( $t1 * 1000 ) );
						//$newModUq = 123 .$uq;
						
						$mod['moduleID'] = $fields['module_id'];
						$mod['newUnique'] = $newModUq;
						
						//if ( ! post_exists( $newModUq ) ) {
							$postFields = array(
								'post_title' => $newModUq,
								'post_name' => $newModUq,
								'post_status' => 'publish',
								'post_type' => 'ux-cb-modules',
								'post_content' => ''
							);
							
							if ( $post_id = wp_insert_post( $postFields ) ) {								
								foreach ( $fields as $name => $val ) {
									update_post_meta( $post_id, $name, $val );
								}
								//originalFields
								update_post_meta( $post_id, 'originalFields', $fields );
								
								if ( $tplCat != 'user' ) {
									
									foreach ( $fields as $fieldName => $fieldValue ) {
										$moduleID = $fields['module_id'];
										$fieldType = ux_cb_get_mod_config( $moduleID, $fieldName, 'type' );
										switch ( $fieldType ) { 
											case 'upload':
												if ( ! empty( $fieldValue ) ) {
													if ( isset( $fields[$fieldName. '-url'] ) ) {
														$fieldUploadUrl = $fields[$fieldName. '-url'];
														if ( ! empty( $fieldUploadUrl ) ) {
															if ( is_array( $fieldUploadUrl ) ) {
																$imgIDs = array();
																$imgSrcs = array();
																foreach ( $fieldUploadUrl as $modNum => $uploadUrl ) {
																	$pathinfo = pathinfo( $uploadUrl );
																	
																	$baseName = $modNum. '-mod-' .$pathinfo['basename'];
																
																	$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$baseName );
																	if ( $wp_filesystem->get_contents( $imgUrl ) ) {
																		$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$baseName, $imgUrl );
																		if ( $imgSrc = wp_get_attachment_url( $imgID ) ) {
																			$imgIDs[$modNum] = $imgID;
																			$imgSrcs[$modNum] = $imgSrc;
																		}
																	}
																}
																if ( count( $imgIDs ) > 0 ) {
																	update_post_meta( $post_id, $fieldName, $imgIDs );
																}
																if ( count( $imgSrcs ) > 0 ) {
																	update_post_meta( $post_id, $fieldName. '-url', $imgSrcs );
																}
															} else {
																$pathinfo = pathinfo( $fieldUploadUrl );
																
																$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$pathinfo['basename'] );
																if ( $wp_filesystem->get_contents( $imgUrl ) ) {
																	$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$pathinfo['basename'], $imgUrl );
																	if ( $imgSrc = wp_get_attachment_url( $imgID ) ) {
																		update_post_meta( $post_id, $fieldName, $imgID );
																		update_post_meta( $post_id, $fieldName. '-url', $imgSrc );
																	}
																}
															}
														}
													}
												}
											break;
											
											case 'items':
												$itemsName = $fieldName;
												if ( ! empty( $fieldValue ) ) {
													if ( is_array( $fieldValue ) ) {
														foreach ( $fieldValue as $fieldNum => $fields ) {
															if ( is_array( $fields ) ) {
																foreach ( $fields as $fieldValue ) {
																	if ( isset( $fieldValue['name'] ) ) {
																		$fieldName = $fieldValue['name'];
																		$fieldType = ux_cb_get_mod_config( $moduleID, $fieldName, 'type' );
																		switch ( $fieldType ) {
																			case 'upload':
																				foreach ( $fields as $fieldValue ) {
																					if ( $fieldValue['name'] == $fieldName. '-url' ) {
																						$fieldUploadUrl = $fieldValue['value'];
																						
																						if ( ! empty( $fieldUploadUrl ) ) {
																							$pathinfo = pathinfo( $fieldUploadUrl );
																							$baseName = $fieldNum. '-mod-' .$pathinfo['basename'];
																		
																							$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$baseName );
																							if ( $wp_filesystem->get_contents( $imgUrl ) ) {
																								$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$pathinfo['basename'], $imgUrl );
																								if ( $imgSrc = wp_get_attachment_url( $imgID ) ) {
																									if ( $items = get_post_meta( $post_id, $itemsName, true ) ) {
																										if ( is_array( $items ) ) {
																											foreach ( $items as $itemNum => $itemArray ) {
																												if ( $itemNum == $fieldNum ) {
																													$itemsChangeArray = array();
																													foreach ( $itemArray as $itemValue ) {
																														$itemsChangeArray[$itemValue['name']] = $itemValue['value'];
																													}
																													
																													if ( isset( $itemsChangeArray[$fieldName] ) ) {
																														$itemsChangeArray[$fieldName] = $imgID;
																													}
																													
																													if ( isset( $itemsChangeArray[$fieldName] ) ) {
																														$itemsChangeArray[$fieldName. '-url'] = $imgSrc;
																													}
																													
																													$itemsArrayTo = array();
																													foreach ( $itemsChangeArray as $itemName => $itemValue ) {
																														$itemsArrayTo[] = array( 'name' => $itemName, 'value' => $itemValue );
																													}
																													
																													if ( count( $itemsArrayTo) ) {
																														$items[$itemNum] = $itemsArrayTo;
																													}
																												}
																											}
																											update_post_meta( $post_id, $itemsName, $items );
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			break;
																		}
																	}
																}
															}
														}
													}
												}
											break;
										}
									}
									
									/*$moduleID = $fields['module_id'];
									foreach ( $fields as $fieldName => $fieldValue ) {
										$fieldType = ux_cb_get_mod_config( $moduleID, $fieldName, 'type' );
										switch ( $fieldType ) {
											case 'upload':
												if ( is_array( $fieldValue ) ) {
													$imgSrc = array();
													$imgIDs = array();
													foreach ( $fields[$fieldName. '-url'] as $modNum => $value ) {
														$pathinfo = pathinfo( $value );
														
														$modFileName = $modNum. '-mod-' .$pathinfo['basename'];
														
														$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$modFileName );
														$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$modFileName, $imgUrl );
														$imgIDs[$modNum] = $imgID;
														$imgSrc[$modNum] = wp_get_attachment_url( $imgID );
													}
													$fields[$fieldName. '-url'] = $imgSrc;
													$fields[$fieldName] = $imgIDs;
												} else {
													$pathinfo = pathinfo( $fields[$fieldName. '-url'] );
													$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$pathinfo['basename'] );
													$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$pathinfo['basename'], $imgUrl );
													$imgSrc = wp_get_attachment_url( $imgID );
													$fields[$fieldName] = $imgID;
													$fields[$fieldName. '-url'] = $imgSrc;
												}
											
											break;
										}
									}*/
									
									//mod single image
									/*if ( isset( $fields['__ux_cb_module_single_image_file_type'] ) ) {
										$fileType = $fields['__ux_cb_module_single_image_file_type'];
										if ( $dirlist = $wp_filesystem->dirlist( $dir. '/' .$uq ) ) {
											$imgID = 0;
											$imgSrc = '';
											$i = 0;
											foreach ( $dirlist as $fileSlug => $file ) {
												if ( $i == 0 ) {
													$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$fileSlug );
													$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$fileSlug, $imgUrl );
													$imgSrc = wp_get_attachment_url( $imgID );
												}
												$i++;
											}
											switch ( $fileType ) {
												case 'svg': $fields['__ux_cb_module_single_image_svg'] = $imgID; $fields['__ux_cb_module_single_image_svg-url'] = $imgSrc; break;
												case 'image': $fields['__ux_cb_module_single_image_image'] = $imgID; $fields['__ux_cb_module_single_image_image-url'] = $imgSrc; break;
											}
										}
									}*/
									
									//mod slider
									/*if ( isset( $fields['__ux_cb_module_slider_media_images'] ) ) {
										$mediaImgs = $fields['__ux_cb_module_slider_media_images'];
										if ( ! is_array( $mediaImgs ) ) { $mediaImgs = array( $mediaImgs ); }
										if ( $dirlist = $wp_filesystem->dirlist( $dir. '/' .$uq ) ) {
											$imgSrc = array();
											$imgIDs = array();
											foreach ( $dirlist as $fileSlug => $file ) {
												$modFile = explode( '-mod-', $fileSlug );
												$modNum = $modFile[0];
												
												$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$fileSlug );
												$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$fileSlug, $imgUrl );
												$imgIDs[$modNum] = $imgID;
												$imgSrc[$modNum] = wp_get_attachment_url( $imgID );
											}
											$fields['__ux_cb_module_slider_media_images-url'] = $imgSrc;
											$fields['__ux_cb_module_slider_media_images'] = $imgIDs;
										}
									}*/
									
									//mod grid && masonry grid
									$gridAray = array( 'grid', 'masonry_grid' );
									foreach ( $gridAray as $gridSlug ) {
										if ( isset( $fields['__ux_cb_module_' .$gridSlug. '_source'] ) ) {
											$src = $fields['__ux_cb_module_' .$gridSlug. '_source'];
											$setCat = false;
											if ( $src != 'attachment' ) {
												$tax = 'ux-portfolio-cat';
												if ( isset( $fields['__ux_cb_module_' .$gridSlug. '_category_' .$src. '_tax'] ) ) {
													$tax = $fields['__ux_cb_module_' .$gridSlug. '_category_' .$src. '_tax'];
												}
												$cat = false;
												if ( isset( $fields['__ux_cb_module_' .$gridSlug. '_category_' .$src] ) ) {
													$cat = $fields['__ux_cb_module_' .$gridSlug. '_category_' .$src];
												}
												$term = get_term( $cat, $tax );
												if ( $term ) {
													if ( is_wp_error( $term ) ) {
														$setCat = true;
													}
												} else {
													$setCat = true;
												}
											}else{
												if ( isset( $fields['__ux_cb_module_' .$gridSlug. '_media_images'] ) ) {
													$mediaImgs = $fields['__ux_cb_module_' .$gridSlug. '_media_images'];
													if ( ! is_array( $mediaImgs ) ) { $mediaImgs = array( $mediaImgs ); }
													if ( $dirlist = $wp_filesystem->dirlist( $dir. '/' .$uq ) ) {
														$imgIDs = array();
														foreach ( $dirlist as $fileSlug => $file ) {
															$modFile = explode( '-mod-', $fileSlug );
															$modNum = $modFile[0];
															
															$imgUrl = ux_cb_placehold_url( $tplCat. '/' .$dirUq. '/' .$uq. '/' .$fileSlug );
															if ( $wp_filesystem->get_contents( $imgUrl ) ) {
																$imgID = ux_cb_ins_set_record_data( $uq. '-' .$dirUq. '-' .$fileSlug, $imgUrl );
																if ( $imgSrc = wp_get_attachment_url( $imgID ) ) {
																	$imgIDs[$modNum] = $imgID;
																}
															}
														}
														if ( count( $imgIDs ) > 0 ) {
															update_post_meta( $post_id, '__ux_cb_module_' .$gridSlug. '_media_images', $imgIDs );
														}
													}
												}
											}
											if ( $setCat ) {
												$postsCount = 0;
												$countPosts = wp_count_posts( $src );
												
												if ( isset( $countPosts->publish ) ) {
													$postsCount = intval( $countPosts->publish );
												}
												
												if ( $postsCount ) {
													update_post_meta( $post_id, '__ux_cb_module_' .$gridSlug. '_category_' .$src, '' );
												} else {
													$countPosts = wp_count_posts();
													if ( isset( $countPosts->publish ) ) {
														update_post_meta( $post_id, '__ux_cb_module_' .$gridSlug. '_source', 'post' );
														update_post_meta( $post_id, '__ux_cb_module_' .$gridSlug. '_category_post', '' );
													}
												}
											}
										}
									}
								}
								$mod['post_id'] = $post_id;
							}
						//}
					} else {
						$mod['moduleID'] = false;
					}
				}
			}
		}
		return $mod;
	}
}

/**
 * UX Content Builder Page Option customize module template category.
 */
if ( ! function_exists( 'ux_cb_ins_mod_tpl_cat' ) ) {
	function ux_cb_ins_mod_tpl_cat() {
		$categories = array(
			'homepage' => __( 'Home Page', 'bm-builder' ),
			'project' => __( 'Single Project', 'bm-builder' ),
			'staticpage' => __( 'About/Contact', 'bm-builder' ),
			'blog' => __( 'Blog', 'bm-builder' ),
			'sections' => __( 'Sections', 'bm-builder' ),
			'user' => __( 'User', 'bm-builder' )
		);
		
		return $categories;
	}
}

/**
 * UX Content Builder Page Option customize load local template.
 */
if ( ! function_exists( 'ux_cb_ins_load_mod_tpl' ) ) {
	function ux_cb_ins_load_mod_tpl( $slug, $name ) {
		$method = 'direct';
		$url = wp_nonce_url( 'post.php' );
		if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
			return true;
		}
		
		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( $url, $method, true, false, false );
			return true;
		}
		
		global $wp_filesystem;
		$dirPath = ux_cb_path_dir( 'PLACEHOLD_DIR', $slug );
		$placeholdUrl = ux_cb_placehold_url( $slug );
		
		if ( defined( 'INS_TPL_PLACEHOLD_DIR' ) ) {
			$dirPath = INS_TPL_PLACEHOLD_DIR. '/'. $slug;
		}
		
		if ( $slug == 'user' ) {
			$uploadDir = wp_upload_dir();
			$dirPath = $uploadDir['basedir']. '/ux-cb/palcehold/' .$slug;
			$placeholdUrl = $uploadDir['baseurl']. '/ux-cb/palcehold/' .$slug;
		}
		
		if ( $dirlist = $wp_filesystem->dirlist( $dirPath ) ) {
			$i = 0;
			echo '<ul class="module-template-section">';
			
			if ( isset( $dirlist['.DS_Store'] ) ) {
				unset( $dirlist['.DS_Store'] );
			}
			ksort($dirlist);
			foreach ( $dirlist as $templateSlug => $template ) { $i++;
				$screenshot = $dataFile = $indexFile = false;
				$templateName = $name. ' ' .$i;
				
				if ( $fileList = $wp_filesystem->dirlist( $dirPath. '/' .$templateSlug ) ) {
					foreach ( $fileList as $fileSlug => $file ) {
						if ( $file['type'] == 'f' ) {
							$screenshotFile = $placeholdUrl. '/' .$templateSlug. '/' .$fileSlug;
							$mimeType = wp_check_filetype( $screenshotFile );
							
							if ( $mimeType['type'] == 'image/jpeg' || $mimeType['type'] == 'image/png' ) {
								if ( ! $screenshot ) {
									$screenshot = $screenshotFile;
								}
							}
							
							if ( $fileSlug == 'data.json' ) {
								$dataFile = $dirPath. '/' .$templateSlug. '/' .$fileSlug;
							}
							
							if ( $fileSlug == 'index.json' ) {
								$indexFile = $dirPath. '/' .$templateSlug. '/' .$fileSlug;
							}
						}
					}
				}
				
				if ( $dataFile ) {
					if ( $data = $wp_filesystem->get_contents( $dataFile ) ) {
						$dataFile = json_decode( $data, true );
						if ( isset( $dataFile['name'] ) ) {
							if ( $dataFile['name'] != '' ) {
								$templateName = $dataFile['name'];
							}
						}
					}
				}
				
				echo '<li data-id="' .esc_attr( $templateSlug ). '">';
				echo   '<div class="item">';
				
					  if ( $screenshot ) { echo '<img src="' .esc_url( $screenshot ). '" />'; }
				
				echo     '<div class="item-name">' .$templateName. '</div>';
				echo     '<button type="button" class="insert-template">' .esc_html__( 'Insert', 'bm-builder' ). '</button>';
				echo   '</div>';
				echo   '<span class="insert-completed hidden">' .esc_html__( 'Completed!', 'bm-builder' ). '</span>';
				
				if ( $slug == 'user' ) {
					echo   '<button type="button" class="remove-template"><span class="dashicons dashicons-no-alt"></span></button>';
				}
				echo '</li>';
			}
			echo '</ul>';
		}
		
		
		//return $categories;
	}
}

/**
 * UX Content Builder Page Option customize tools setting button.
 */
if ( ! function_exists( 'ux_cb_page_customize_tools_setting_button' ) ) {
	function ux_cb_page_customize_tools_setting_button() {
		global $post;
		
		$switch = false;
		
		if ( function_exists( 'use_block_editor_for_post' ) ) {
			global $post, $pagenow;
			if ( use_block_editor_for_post( $post ) ) {
				if ( $post->post_type == 'page' ) {
					$switch = true;
				}
			}
		}
		
		if ( $switch ) { ?>
            <button id="ux-cb-page-customize-tools-setting" type="button"><span class="dashicons dashicons-admin-generic"></span></button>
        <?php
		}
	}
	add_action( 'ux_cb_customize_tools_setting', 'ux_cb_page_customize_tools_setting_button' );
}

/**
 * UX Content Builder Page Option customize textarea content.
 */
if ( ! function_exists( 'ux_cb_page_customize_textarea_content' ) ) {
	function ux_cb_page_customize_textarea_content( $post ) {
		$content = '';
		
		if ( $uxCBContent = get_post_meta( $post->ID, 'ux-cb-content', true ) ) {
			$content = $uxCBContent;
			update_post_meta( $post->ID, 'ux_has_cb', 'G' );
		} else {
			if ( ! ( false === strpos( $post->post_content, 'ux_cb_wrap' ) ) ) {
				$content = $post->post_content;
				update_post_meta( $post->ID, 'ux_has_cb', 'C' );
			}
		} ?>
        <textarea id="ux-cb-page-customize-textarea-content"><?php echo $content; ?></textarea>
    <?php
	}
	add_action( 'ux_cb_customize_float_sidebar', 'ux_cb_page_customize_textarea_content' );
}