<?php
require_once ux_cb_path_dir( 'TEMPLATES_DIR', 'modules/module-wrap.php' );

/**
 * UX Content Builder module spacing.
 */
if ( ! function_exists( 'ux_cb_module_spacing_interface' ) ) {
	function ux_cb_module_spacing_interface() { ?>
		<div class="padding" tabindex="0"><?php echo esc_html__('Spacing','bm-builder'); ?>
            <div class="ux-cb-module-field-padding-arrow"></div>
            <div class="ux-cb-module-field-padding">
                <div class="padding-row">
                    <div class="row-title"><?php echo esc_html__('Top Spacing','bm-builder'); ?></div>
                    <div class="col-two">
                        <label for="__ux_cb_module_top_padding">
                            <input name="__ux_cb_module_top_padding" type="text" id="__ux_cb_module_top_padding" value="0" class="regular-text ico-desktop">
                        </label>
                    </div>
                    <div class="col-two">
                        <label for="__ux_cb_module_top_padding_mobile">
                            <input name="__ux_cb_module_top_padding_mobile" type="text" id="__ux_cb_module_top_padding_mobile" value="0" class="regular-text ico-mobile">
                        </label>
                    </div>
                </div>
                <div class="padding-row">
                    <div class="row-title"><?php echo esc_html__('Bottom Spacing','bm-builder'); ?></div>
                    <div class="col-two">
                        <label for="__ux_cb_module_bottom_padding">
                            <input name="__ux_cb_module_bottom_padding" type="text" id="__ux_cb_module_bottom_padding" value="0" class="regular-text ico-desktop">
                        </label>
                    </div>
                    <div class="col-two">
                        <label for="__ux_cb_module_bottom_padding_mobile">
                            <input name="__ux_cb_module_bottom_padding_mobile" type="text" id="__ux_cb_module_bottom_padding_mobile" value="0" class="regular-text ico-mobile">
                        </label>
                    </div>
                </div>
            </div>
        </div>
	<?php
    }
	add_action( 'ux_cb_customize_modal_header', 'ux_cb_module_spacing_interface' );
}
?>