<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field select icons.
 */
if ( ! function_exists( 'ux_cb_module_field_select_icons' ) ) {
	function ux_cb_module_field_select_icons( $item, $post_id, $item_val ) {
		if ( $item['type'] == 'selectIcons' ) {
			$iconFields = ux_cb_get_fontawesome_social_fields();
			
			echo '<div class="ux-cb-module-field-select-icons">';
			foreach ( $iconFields as $icon ) {
				$current = false;
				if ( $item_val == '$icon' ) { $current = 'current'; }
?>
				<a href="#" class="fontawesome <?php echo esc_attr( $current ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
			<?php }
			echo '</div>';
			echo '<input type="hidden" name="' .esc_attr( $item['name'] ). '" value="' .esc_attr( $item_val ). '" />';
			
		}
	}
	add_action( 'ux_cb_module_fields_field', 'ux_cb_module_field_select_icons', 10, 3 );
}