<?php
/**
 * UX Content Builder Module Group Config.
 */

//group config fields
function ux_cb_module_group_fields($fields){
	$fields['group'] = array(
		'id'           => 'group',
		'title'        => esc_html__('Group','bm-builder'),
		'shortcodeTag' => 'ux_cb_group', 
		'shortcode'    => '[ux_cb_group unique="" col="12"][/ux_cb_group]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									//Object Align
									array('title'   => esc_html__('Align on Vertical','bm-builder'),
										  'desc'    => esc_html__('Align the modules in this group','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_group_object_align',
										  'default' => 'top',
										  'fields'  => array(
											  array(esc_html__('Top','bm-builder'), 'top'),
											  array(esc_html__('Middle','bm-builder'), 'middle'),
											  array(esc_html__('Bottom','bm-builder'), 'bottom'),
											  array(esc_html__('Equal Spacing','bm-builder'),'equal_spacing_v')
										  )),

									array('title'   => esc_html__('Align on Horizontal','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_group_object_align_h',
										  'default' => 'top',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'), 'left'),
											  array(esc_html__('Center','bm-builder'), 'center'),
											  array(esc_html__('Right','bm-builder'), 'right'),
											  array(esc_html__('Equal Spacing','bm-builder'),'equal_spacing_h')
										  )),
										  
									//Height Type
									array('title'   => esc_html__('Height Type','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_group_height_type',
										  'default' => 'screen_height',
										  'fields'  => array(
											  array(esc_html__('Auto','bm-builder'), 'auto'),
											  array(esc_html__('Screen Height','bm-builder'), 'screen_height')
										  )),

									array('title'   => esc_html__('Height','bm-builder'),
										  'desc'    => esc_html__( 'The mobile height value will work on portrait mode only.', 'bm-builder' ),
										  'type'    => 'multipleSelect', 
										  'style'   => 'min-width: 12em; margin-right: 1em;',
										  'name'    => '__ux_cb_module_group_screen_height',
										  'ctrl'    => '__ux_cb_module_group_height_type,screen_height',
										  'col'     => 2, 
										  'fields'  => array(
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  ),
										  'default' => array('100', '100'),
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )),
										  
									//Force Content to fit Fullwidth
									array('title'   => esc_html__('Force Content to fit Fullwidth','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_group_fullwidth',
										  'default' => 'off'),

									//Disable Gap
									array('title'   => esc_html__('Disable Gap','bm-builder'),
										  'desc'    => esc_html__('Disable Gap of Modules within this Group','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_disable_gap'),

									//Inner Padding on left/Right
									array('title'   => esc_html__( 'Inner Padding on Left/Right','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_group_inner_padding_left_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									), 
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									//Background
									array('title'   => esc_html__('Background','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_group_background',
										  'default' => 'none',
										  'fields'  => array(
											  array(esc_html__('None','bm-builder'),         'none'),
											  array(esc_html__('Color','bm-builder'),        'background_color'),
											  array(esc_html__('Image','bm-builder'),        'background_image'),
											  array(esc_html__('Hosted Video','bm-builder'), 'hosted_video')
										  )),

									//BG color
									array('title'   => esc_html__('Background Color','bm-builder'),
										  'desc'    => esc_html__('Select the Background Color for Text Block.','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_group_bg_color',
										  'ctrl'    => '__ux_cb_module_group_background,background_color'),

									//video url
									array('title'   => esc_html__('MP4 format video URL','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'url',
										  'ctrl'    => '__ux_cb_module_group_background,hosted_video',
										  'place' => esc_html__('.mp4 video url','bm-builder'),
										  'name'    => '__ux_cb_module_embed_video_mp4'),

									array('title'   => esc_html__('WEBM format video URL','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'url',
										  'ctrl'    => '__ux_cb_module_group_background,hosted_video',
										  'place' => esc_html__('.webm video url','bm-builder'),
										  'name'    => '__ux_cb_module_embed_video_webm'),

									array('title'   => esc_html__('OGG format video URL','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'url',
										  'ctrl'    => '__ux_cb_module_group_background,hosted_video',
										  'place' => esc_html__('.ogg .ogv video url','bm-builder'),
										  'name'    => '__ux_cb_module_embed_video_ogg'),

									//BG image
									array('title'   => esc_html__('Background Image','bm-builder'),
										  'desc'    => esc_html__('Please upload jpb, png or gif format','bm-builder'),
										  'type'    => 'upload',
										  'ctrl'    => '__ux_cb_module_group_background,hosted_video|background_image',
										  'name'    => '__ux_cb_module_group_bg_image'),

									//BG image background fixed
									array('title'   => esc_html__('Background Image Fixed','bm-builder'),
										  'desc'    => esc_html__('It is disable on iOS device','bm-builder'),
										  'type'    => 'switch',
										  'ctrl'    => '__ux_cb_module_group_background,background_image',
										  'name'    => '__ux_cb_module_group_bg_image_fixed',
										  'default' => 'off'),
								)
							),
							array( //Shadow
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_group_background,background_color|background_image|hosted_video',
								'items' => array(
									array('title'   => esc_html__('Shadow','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch', 
										  'name'    => '__ux_cb_module_group_shadow',
										  'default' => 'off'),

									array('title'   => esc_html__('Shadow Color','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_group_shadow_color',
										  'default' => '#cccccc',
										  'ctrl'    => '__ux_cb_module_group_shadow,on'),

									array('title'   => esc_html__('Vertical Offset','bm-builder'),
										  'desc'    => esc_html__('Enter a number, negative values allowed','bm-builder'),
										  'inputType' => 'number',
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_group_shadow_y',
										  'default' => '10',
										  'ctrl'    => '__ux_cb_module_group_shadow,on'),

									array('title'   => esc_html__('Blur Radius','bm-builder'),
										  'desc'    => esc_html__('Enter a number','bm-builder'),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_group_shadow_blur',
										  'default' => '50',
										  'ctrl'    => '__ux_cb_module_group_shadow,on'),
								)
							),
							array( //Border Radius
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_group_background,background_color|background_image|hosted_video',
								'items' => array(
									
									array('title'   => esc_html__('Border Radius','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch', 
										  'name'    => '__ux_cb_module_group_border_radius',
										  'default' => 'off'),

									array('title'   => esc_html__('Radius Number','bm-builder'),
										  'desc'    => esc_html__('Enter a number','bm-builder'),
										  'inputType' => 'number',
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_group_border_radius_bumber',
										  'default' => '10',
										  'ctrl'    => '__ux_cb_module_group_border_radius,on'),
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_group_background,hosted_video',
								'items' => array(
									//Enable Mix Blend Mode
									array('title'   => esc_html__('Enable Mix Blend Mode','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_enable_mix_blend_mode'),

									//Choose Color for Video
									array('title'   => esc_html__('Choose Color for Video','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_group_video_color',
										  'ctrl'    => '__ux_cb_module_group_enable_mix_blend_mode,on')
								)
							),
							array(
								'items' => array(
									//Change Universe Color when Scroll In
									array('title'   => esc_html__('Change Universe Color when Scroll In','bm-builder'),
										  'desc'    => esc_html__('BG/Text Color Transition Effect when Scrolling','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_group_change_color_scroll_in',
										  'default' => 'off'),
										  
									//Foreground Color
									array('title'   => esc_html__('Foreground Color','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_group_change_frontcolor',
										  'ctrl'    => '__ux_cb_module_group_change_color_scroll_in,on',
										  'default' => '#ffffff'),
										  
									//Background Color
									array('title'   => esc_html__('Background Color','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_group_change_backcolor',
										  'ctrl'    => '__ux_cb_module_group_change_color_scroll_in,on',
										  'default' => '#000000'),

									//Logo Color
									array('title'   => esc_html__('Logo Color','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_group_change_logocolor',
										  'fields'  => array(
											  array(esc_html__('Default','bm-builder'), 'default-logo-univer'),
											  array(esc_html__('Alternative','bm-builder'), 'alt-logo-univer')
										  ),
										  'ctrl'    => '__ux_cb_module_group_change_color_scroll_in,on',
										  'default' => 'default-logo-univer'),

									//Change Universe Color Position
									// array('title'   => esc_html__('The Position to Activate Universe Color','bm-builder'),
									// 	  'desc'    => esc_html__("A percentage value refers to a percentage of the window's height. The '50%' will trigger when the top of the element is 50% of the way from the top of the window, or simply put, hits the middle of the window.","bm-builder"),
									// 	  'type'    => 'select',
									// 	  'name'    => '__ux_cb_module_group_change_univ_position',
									// 	  'ctrl'    => '__ux_cb_module_group_change_color_scroll_in,on',
									// 	  'default' => '0.5',
									// 	  'fields'  => array(
									// 		  array(esc_html__('10%','bm-builder'), '0.1'),
									// 		  array(esc_html__('20%','bm-builder'), '0.2'),
									// 		  array(esc_html__('30%','bm-builder'), '0.3'),
									// 		  array(esc_html__('40%','bm-builder'), '0.4'),
									// 		  array(esc_html__('50%','bm-builder'), '0.5'),
									// 		  array(esc_html__('60%','bm-builder'), '0.6'),
									// 		  array(esc_html__('70%','bm-builder'), '0.7'),
									// 		  array(esc_html__('80%','bm-builder'), '0.8'),
									// 		  array(esc_html__('90%','bm-builder'), '0.9')
									// 	  )),

									//Remove Universe Color Position
									// array('title'   => esc_html__('The Position to Remove Universe Color','bm-builder'),
									// 	  'desc'    => esc_html__("A percentage value refers to a percentage of the window's height. The '50%' will trigger when the bottom of the element is 50% of the way from the top of the window, or simply put, hits the middle of the window.","bm-builder"),
									// 	  'type'    => 'select',
									// 	  'name'    => '__ux_cb_module_group_change_univ_position_out',
									// 	  'ctrl'    => '__ux_cb_module_group_change_color_scroll,on',
									// 	  'default' => '0.5',
									// 	  'fields'  => array(
									// 		  array(esc_html__('10%','bm-builder'), '0.1'),
									// 		  array(esc_html__('20%','bm-builder'), '0.2'),
									// 		  array(esc_html__('30%','bm-builder'), '0.3'),
									// 		  array(esc_html__('40%','bm-builder'), '0.4'),
									// 		  array(esc_html__('50%','bm-builder'), '0.5'),
									// 		  array(esc_html__('60%','bm-builder'), '0.6'),
									// 		  array(esc_html__('70%','bm-builder'), '0.7'),
									// 		  array(esc_html__('80%','bm-builder'), '0.8'),
									// 		  array(esc_html__('90%','bm-builder'), '0.9')
									// 	  )),
										  
									//Auto Goto Top When Scroll In
									array('title'   => esc_html__('Auto Goto Top When Scroll In','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_auto_goto_top'),
										  
									//Top Spacing to The Edge
									array('title'   => esc_html__('Top Spacing to The Edge','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_group_scroll_top_spacing',
										  'ctrl'    => '__ux_cb_module_group_auto_goto_top,on'),

									//Make Groups Contour on The Current Row
									array('title'   => esc_html__('Make Groups Contour on The Current Row','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_same_height_current_row'),

									array('title'   => esc_html__('Hide for Desktop','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_hide_desktop'),

									array('title'   => esc_html__('Hide for Mobile','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_hide_mobile'),

									array('title'   => esc_html__('Keep Original Layout on Mobile','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_group_keep_origin_on_mobile'),
											
								)
							)
						)
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_group_fields'); 

?>