<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Social Media shortcode.
 */
function ux_cb_module_social_media_shortcode( $atts, $content=false ) {
	$moduleID = 'social-media';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_social_media' );
	
	$html = ux_cb_get_module_template( $moduleID, $atts, $content );
	return $html;
}
add_shortcode( 'ux_cb_social_media', 'ux_cb_module_social_media_shortcode' );

/**
 * UX Content Builder Module Social Media container.
 */
function ux_cb_module_social_media_container( $module, $moduleUnique ) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	
	//social type
	$socialType = get_post_meta( $post_id, '__ux_cb_module_social_media_type', true );
	
	//social media share
	$socialMediaShare = get_post_meta( $post_id, '__ux_cb_module_social_media_share', true );

	//Arrange
	$socialMediaShareArrangeDesktop = '';
	$socialMediaShareArrangeMobile = '';
	if ( $socialMediaShareArrange = get_post_meta( $post_id, '__ux_cb_module_social_media_share_arrange', true ) ) {

		if ( ! is_array( $socialMediaShareArrange ) ) { $socialMediaShareArrange = array( $socialMediaShareArrange, 0 ); }
		$socialMediaShareArrangeDesktop = $socialMediaShareArrange[0];
		$socialMediaShareArrangeMobile = $socialMediaShareArrange[1];

		if ( $socialMediaShareArrangeDesktop ) {
			$socialMediaShareArrangeDesktop = $socialMediaShareArrangeDesktop;
		}

		if ( $socialMediaShareArrangeMobile ) {
			$socialMediaShareArrangeMobile = $socialMediaShareArrangeMobile . '-m';
		}
		
	}
	
	//Align
	$socialMediaShareAlignDesktop = ''; 
	$socialMediaShareAlignMobile = ''; 
	if ( $socialMediaShareAlign = get_post_meta( $post_id, '__ux_cb_module_social_media_share_align', true ) ) {

		if ( ! is_array( $socialMediaShareAlign ) ) { $socialMediaShareAlign = array( $socialMediaShareAlign, 0 ); }
		$socialMediaShareAlignDesktop = $socialMediaShareAlign[0];
		$socialMediaShareAlignMobile = $socialMediaShareAlign[1];
		
		if ( $socialMediaShareAlignDesktop ) {
			$socialMediaShareAlignDesktop = $socialMediaShareAlignDesktop;
		}
		if ( $socialMediaShareAlignMobile ) {
			$socialMediaShareAlignMobile = $socialMediaShareAlignMobile . '-m';
		}

	}

	//animation
	$animationClass = ux_cb_module_field_animation_class( $module );
	$animationEnd = ux_cb_module_field_animation_end( $module );
	
	//style
	if ( ! $module['is_frontend'] ) {
		$html .= '<style type="text/css">' . sanitize_text_field( ux_cb_module_social_media_style( $post_id, $moduleUnique, $html ) ). '</style>';
	}
	
	$html .= '<div class="social-media-wrap ' .esc_attr( $animationClass ). ' '.sanitize_html_class( $socialMediaShareAlignDesktop ).' '.sanitize_html_class( $socialMediaShareAlignMobile ). ' ' .sanitize_html_class( $socialMediaShareArrangeDesktop ).' '.sanitize_html_class( $socialMediaShareArrangeMobile ).'" data-animationend="' .esc_attr( $animationEnd ). '">';

	if ( $socialType == 'social-link' ) {
		$linkCount = 1;
		$socialMediaLinks = false;
		
		//social show name
		$socialShowName = get_post_meta( $post_id, '__ux_cb_module_social_show_name', true );
		
		if ( $socialMediaLinks = get_post_meta( $post_id, '__ux_cb_module_social_media_link_items', true ) ) {
			$linkCount = count( $socialMediaLinks );
			$itemFields = array();
			
			foreach ( $socialMediaLinks as $num => $item_row ) {
				foreach ( $item_row as $field ) {
					$itemFields[$num][$field['name']] = $field['value'];
				}
			}
			$socialMediaLinks = $itemFields;
		}
		
		if ( $socialMediaLinks ) {
			$html .= '<ul class="module-social module-social-link">';
			for( $i = 0; $i < $linkCount; $i++ ) {
				$btnText = 'Link ' .( $i + 1);
				$btnLink = '#';
				$btnIcon = '';
				$btnLinkTarget = '_self';
				$btnClass = 'fadeInM';
				$btnLinkRel = '';
				
				if ( $socialMediaLinks ) {
					$btnText = $socialMediaLinks[$i]['__ux_cb_module_social_media_item_name'];
					$btnLink = $socialMediaLinks[$i]['__ux_cb_module_social_media_item_link'];
					$btnIcon = $socialMediaLinks[$i]['__ux_cb_module_social_media_item_select_icon'];
					if ( $socialMediaLinks[$i]['__ux_cb_module_button_item_link_target'] == 'on' ) {
						$btnLinkTarget = '_blank';
						$btnLinkRel = ' noopener noreferrer';
					}
				}
				
				$html .= '<li class="social-li">';
				$html .=   '<a class="share" href="' .esc_url( $btnLink ). '" target="'.esc_attr( $btnLinkTarget ).'" rel="nofollow'.esc_attr( $btnLinkRel ).'">';  
				$html .=     '<span class="' .esc_attr( $btnIcon ). '"></span>';
				if ( $socialShowName == 'on' ) {
					$html .= '<span class="social-name">' .esc_html( $btnText ). '</span>';
				}
				$html .=   '</a>';
				$html .= '</li>';
			}
			$html .= '</ul>';
		} else {
			$html .= esc_html__( 'No data selected', 'bm-builder' );
		}
	} else {
		if ( $socialMediaShare ) {
			$post_link = get_permalink( $module['postID'] );
			$post_link_pure = preg_replace('#^https?://#', '', rtrim( $post_link, '/' ) );
			$post_title = get_the_title( $module['postID'] );
	
			$thumbnail_url = false;
			if ( $image = wp_get_attachment_image_src( get_post_thumbnail_id( $module['postID'] ), 'full') ) {
				$thumbnail_url= $image[0];
			}
			$href = '#';
	
			$html .= '<ul class="module-social">';
			foreach ( $socialMediaShare as $share ) {
				$onclick = false;
				$shareIcon = $share;
	
				if ( ! empty( $share ) ) {
					switch ( $share ) {
						case 'facebook':
							$onclick = "window.open('http://www.facebook.com/sharer.php?u=" .esc_url( $post_link ). "', 'Facebook', 'width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;";
						break;
	
						case 'twitter':
							$onclick = "window.open('http://twitter.com/share?url=" .esc_url( $post_link ). "&amp;text=" .esc_attr( $post_title ). "', 'Twitter','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;";
						break;
	
						case 'pinterest':
							$onclick = "javascript:window.open('http://pinterest.com/pin/create/bookmarklet/?url=" .esc_url( $post_link ). "&amp;is_video=false&amp;media=" .esc_url( $thumbnail_url ). "','', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;";
						break;
	
						case 'digg':
							$onclick = "window.open('http://www.digg.com/submit?url=" .esc_url( $post_link ). "','Digg','width=715,height=330,left='+(screen.availWidth/2-357)+',top='+(screen.availHeight/2-165)+''); return false;";
						break;
	
						case 'reddit':
							$onclick = "window.open('http://reddit.com/submit?url=" .esc_url( $post_link ). "&amp;title=" .esc_attr( $post_title ). "','Reddit','width=617,height=514,left='+(screen.availWidth/2-308)+',top='+(screen.availHeight/2-257)+''); return false;";
						break;
	
						case 'linkedin':
							$onclick = "window.open('http://www.linkedin.com/shareArticle?mini=true&amp;url=" .esc_url( $post_link ). "','Linked In','width=863,height=500,left='+(screen.availWidth/2-431)+',top='+(screen.availHeight/2-250)+''); return false;";
						break;
	
						case 'stumbleupon':
							$onclick = "window.open('http://www.stumbleupon.com/submit?url=" .esc_url( $post_link ). "&amp;title=" .esc_attr( $post_title ). "','Stumbleupon','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;";
						break;
	
						case 'tumblr':
							$onclick = "window.open('http://www.tumblr.com/share/link?url=" .esc_url( $post_link_pure). "&amp;name=" .esc_attr( $post_title ). "','Tumblr','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;";
						break;
	
						case 'mail':
							$href = "mailto:?Subject=" .esc_attr( str_replace( ' ', '-', $post_title ) ). "&amp;Body=" .esc_url( $post_link ). "";
							$shareIcon = 'envelope-o';
						break;
					}
	
					$html .= '<li class="social-li">';
					if ( $share === 'mail' ) {
						$html .=   '<a class="share postshareicon-' .sanitize_html_class( $share ). '-wrap" href="' .esc_url( $href ). '" >';
					} else {
						$html .=   '<a class="share postshareicon-' .sanitize_html_class( $share ). '-wrap" href="javascript:void(0)" onclick="' .esc_attr( $onclick ). '">';
					}
					$html .=     '<span class="fa fa-' . sanitize_html_class( $shareIcon ) . ' postshareicon-' .sanitize_html_class( $share ). '"></span>';
					$html .=   '</a>';
					$html .= '</li>';
	
				}
			}
			$html .= '</ul>';
		}else{
			$html .= esc_html__( 'No data selected', 'bm-builder' );
		}
	}
	$html .= '</div>';
	
	return $html;
}
add_filter( 'ux_cb_module_container_social-media', 'ux_cb_module_social_media_container', 10, 2 );
?>