<?php
if ( ! defined( 'WP_LOAD_IMPORTERS' ) ) {
	return;
}

/**
 * UX Content Builder Import manager.
 */
if ( ! function_exists( 'ux_cb_import_process_portfolio_post_featured_image' ) ) {
	/**
	 * UX CB import process portfolio post featured image.
	 */
	function ux_cb_import_process_portfolio_post_featured_image() {
		
		$get_posts = get_posts(array(
			'posts_per_page' => -1,
			'post_type' => array('ux-portfolio', 'post'),
			'meta_query' => array(
				'relation' => 'OR',
				array(
					'key' => '_alternative_featured_image',
					'compare' => 'EXISTS',
				),
				array(
					'key' => '_cover_image',
					'compare' => 'EXISTS',
				)
			)
		));
		
		if($get_posts){
			foreach($get_posts as $post){
				$_alternative_featured_image = get_post_meta( $post->ID, '_alternative_featured_image', true );
				if($_alternative_featured_image){
					$_alternative_featured_image = ux_cb_import_process_attachment_replace( 'id', $_alternative_featured_image );
					update_post_meta( $post->ID, '_alternative_featured_image', $_alternative_featured_image );
				}
				
				$_cover_image = get_post_meta( $post->ID, '_cover_image', true );
				if($_cover_image){
					$_cover_image = ux_cb_import_process_attachment_replace( 'id', $_cover_image );
					update_post_meta( $post->ID, '_cover_image', $_cover_image );
				}
			}
		}
	}
	add_action( 'import_end', 'ux_cb_import_process_portfolio_post_featured_image', 11 );
}
if ( ! function_exists( 'ux_cb_import_process_module_taxonomy' ) ) {
	/**
	 * UX CB import process module taxonomy.
	 */
	function ux_cb_import_process_module_taxonomy() {
		
		$get_posts = get_posts(array(
			'posts_per_page' => -1,
			'post_type' => 'ux-cb-modules',
			'meta_query' => array(
				'relation' => 'OR',
				array(
					'key' => '__ux_cb_module_grid_category_ux-portfolio',
					'compare' => 'EXISTS',
				),
				array(
					'key' => '__ux_cb_module_grid_category_post',
					'compare' => 'EXISTS',
				),
				array(
					'key' => '__ux_cb_module_masonry_grid_category_ux-portfolio',
					'compare' => 'EXISTS',
				),
				array(
					'key' => '__ux_cb_module_masonry_grid_category_post',
					'compare' => 'EXISTS',
				)
			)
		));
		
		if($get_posts){
			foreach($get_posts as $post){
				$category_uxportfolio = get_post_meta( $post->ID, '__ux_cb_module_grid_category_ux-portfolio', true );
				if($category_uxportfolio){
					$category_uxportfolio = ux_cb_import_process_taxonomy_replace( 'ux-portfolio-cat', $category_uxportfolio );
					update_post_meta( $post->ID, '__ux_cb_module_grid_category_ux-portfolio', $category_uxportfolio );
				}
				
				$category_post = get_post_meta( $post->ID, '__ux_cb_module_grid_category_post', true );
				if($category_post){
					$category_post = ux_cb_import_process_taxonomy_replace( 'category', $category_post );
					update_post_meta( $post->ID, '__ux_cb_module_grid_category_post', $category_post );
				}
				
				$category_uxportfolio = get_post_meta( $post->ID, '__ux_cb_module_masonry_grid_category_ux-portfolio', true );
				if($category_uxportfolio){
					$category_uxportfolio = ux_cb_import_process_taxonomy_replace( 'ux-portfolio-cat', $category_uxportfolio );
					update_post_meta( $post->ID, '__ux_cb_module_grid_category_ux-portfolio', $category_uxportfolio );
				}
				
				$category_post = get_post_meta( $post->ID, '__ux_cb_module_masonry_grid_category_post', true );
				if($category_post){
					$category_post = ux_cb_import_process_taxonomy_replace( 'category', $category_post );
					update_post_meta( $post->ID, '__ux_cb_module_grid_category_post', $category_post );
				}
			}
		}
	}
	add_action( 'import_end', 'ux_cb_import_process_portfolio_post_featured_image', 11 );
}
if ( ! function_exists( 'ux_cb_import_process_portfolio_post_gallery' ) ) {
	/**
	 * UX CB import process portfolio post gallery.
	 */
	function ux_cb_import_process_portfolio_post_gallery() {
		global $wpdb;
		
		// gallery library
		$get_posts = $wpdb->get_results($wpdb->prepare("
			SELECT 
			`$wpdb->postmeta`.`post_id` as 'ID',
			`$wpdb->postmeta`.`meta_key` as 'meta_key',
			`$wpdb->postmeta`.`meta_value` as 'meta_value',
			`$wpdb->posts`.`post_type` as 'post_type'
			
			FROM $wpdb->postmeta, $wpdb->posts
			
			WHERE ((`$wpdb->postmeta`.`post_id` = `$wpdb->posts`.`ID`)
			AND (`$wpdb->posts`.`post_type` = '%s')
			AND (`meta_key` LIKE '%s')
			AND (`meta_value` LIKE '%s'))
			", 'ux-portfolio', 'ux_theme_meta', '%theme_meta_portfolio%'
		));
		
		if($get_posts){
			foreach($get_posts as $post){
				$post_id = $post->ID;
				$get_post_meta = get_post_meta($post_id, 'ux_theme_meta', true);
				if($get_post_meta){
					foreach($get_post_meta as $meta_key => $meta_value){
						if($meta_key == 'theme_meta_portfolio'){
							if(is_array($meta_value)){
								foreach($meta_value as $num => $image){
									$attachment_id = ux_cb_import_process_attachment_replace('id', $image);
									$get_post_meta['theme_meta_portfolio'][$num] = $attachment_id;
								}
							}
						}
					}
					update_post_meta($post_id, 'ux_theme_meta', $get_post_meta);
				}
			}
		}
	}
}
if ( ! function_exists( 'ux_cb_import_process_attachment_replace' ) ) {
	/**
	 * UX CB import attachment replace.
	 */
	function ux_cb_import_process_attachment_replace($key, $val) {
		global $import_xmlcache;
		
		if($import_xmlcache){
			$get_attachment = get_posts(array(
				'posts_per_page' => -1,
				'post_type' => 'attachment'
			));
			
			if(isset($import_xmlcache['attachments'])){
				$post = false;
				foreach($import_xmlcache['attachments'] as $attachment){
					$post_id = $attachment['post_id'];
					$attachment_url = $attachment['attachment_url'];
					
					switch($key){
						case 'url':
							if($attachment_url == $val){
								$post = $attachment;
							}
						break;
						
						case 'id':
							if($post_id == $val){
								$post = $attachment;
							}
						break;
					}
				}
				
				if($post){
					$post_title = $post['post_title'];
					$post_date = $post['post_date'];
					foreach($get_attachment as $attachment){
						if($attachment->post_date == $post_date && $attachment->post_title == $post_title){
							$attachment_image_src = wp_get_attachment_image_src($attachment->ID, 'full');
							$val = $key == 'url' ? $attachment_image_src[0] : $attachment->ID;
						}
					}
				} 
			}
		}
		
		return $val;
	}
}

if ( ! function_exists( 'ux_cb_import_process_taxonomy_replace' ) ) {
	/**
	 * UX CB import taxonomy replace.
	 */
	function ux_cb_import_process_taxonomy_replace($taxonomy, $val){
		global $import_xmlcache;
		
		if($import_xmlcache){
			$post_type = 'post';
			
			switch($taxonomy){
				case 'ux-portfolio-cat': $post_type = 'ux-portfolio'; break;
			}
			
			$cat_name = false;
			$cat_slug = false;
			
			switch($taxonomy){
				case 'category':
					if(isset($import_xmlcache['categories'])){
						$categories = $import_xmlcache['categories'];
						if($categories){
							foreach($categories as $cat){
								if((int) $cat['term_id'] == (int) $val){
									$cat_name = $cat['cat_name'];
									$cat_slug = $cat['category_nicename'];
								}
							}
						}
						
					}
				
				break;
				
				default:
					if(isset($import_xmlcache['taxonomies'])){
						$taxonomies = $import_xmlcache['taxonomies'];
						if($taxonomies){
							foreach($taxonomies as $term){
								if((int) $term['term_id'] == (int) $val){
									$cat_name = $term['term_name'];
									$cat_slug = $term['term_slug'];
								}
							}
						}
					}
				break;
			}
			
			$categories = get_categories(array(
				'type' => $post_type,
				'hide_empty' => 0,
				'taxonomy' => $taxonomy
			));
			
			if($categories){
				foreach($categories as $category){
					if($cat_slug == $category->slug && $cat_name == $category->name){
						$val = $category->term_id;
					}
				}
			}
		}
		
		return $val;
	}
}
?>