<?php
if ( ! function_exists( 'ux_cb_tools_import_process_term' ) ) {
	/**
	 * import process term
	 */
	function ux_cb_tools_import_process_term( $term ) {
		$return = false;
		
		$processed = get_option( 'ux_cb_tools_term_' .$term[ 'term_id' ] );
		if ( ! $processed ) {
			if ( (int) $term[ 'term_id' ] == 1 ) {
				wp_update_term( $term[ 'term_id' ], $term[ 'taxonomy' ], array(
					'parent' => $term[ 'parent' ],
					'name' => $term[ 'name' ],
					'slug' => $term[ 'slug' ]
				) );
				$return = $term[ 'term_id' ];
			} else {
				$termID = term_exists( $term[ 'slug' ], $term[ 'taxonomy' ] );
				if ( $termID ) {
					if ( is_array( $termID ) ) {
						$termID = $termID[ 'term_id' ];
					}
					if ( isset( $term[ 'term_id' ] ) ) {
						$return = (int) $termID;
					}
				} else {
					$term = wp_slash( $term );
					$description = isset( $term[ 'description' ] ) ? $term[ 'description' ] : '';
					$termArr = array( 'slug' => $term[ 'slug' ], 'description' => $description );
		
					$newTermID = wp_insert_term( $term[ 'name' ], $term[ 'taxonomy' ], $termArr );
					if ( ! is_wp_error( $newTermID ) ) {
						if ( is_array( $newTermID ) ) {
							$newTermID = $newTermID[ 'term_id' ];
							$return = (int) $newTermID;
						}
					}
				}
			}
			
			if ( $return ) {
				update_option( 'ux_cb_tools_term_' .$term[ 'term_id' ], $return );
			}
		} else {
			$return = $processed;
		}
		
		return $return;
	}
	
}

if ( ! function_exists( 'ux_cb_tools_import_process_set_term' ) ) {
	/**
	 * import process set term
	 */
	function ux_cb_tools_import_process_set_term( $term, $importDir, $fileSlug ) {
		global $wp_filesystem;
		
		$return = false;
		
		$termID = $term[ 'term_id' ];
		if ( $processTerm = ux_cb_tools_import_process_term( $term ) ) {
			$termID = $processTerm;
		}
		
		if ( intval( $term[ 'parent' ] ) != 0 ) {
			$termParent = $term[ 'parent' ];
			
			if ( $targetTermParent = ux_cb_tools_import_get_term( $term[ 'parent' ], $importDir ) ) {
				$termParent = $targetTermParent;
			}
		
			if ( (int) $termParent != (int) $term[ 'parent' ] ) {
				$termdata = array( 'parent' => $termParent );
				$updateTerm = wp_update_term( $termID, $term[ 'taxonomy' ], $termdata );
				if ( ! is_wp_error( $updateTerm ) ) {
					if ( is_array( $updateTerm ) ) {
						$updateTerm = $updateTerm[ 'term_id' ];
						$return = (int) $updateTerm;
					}
				}
			}
		} else {
			$return = 'no parent';
		}
		
		return $return;
	}
	
}

if ( ! function_exists( 'ux_cb_tools_import_get_term' ) ) {
	/**
	 * import get term
	 */
	function ux_cb_tools_import_get_term( $termID, $importDir, $fileSlug = 'terms' ) {
		global $wp_filesystem;
		
		$return = false;
		
		if ( $termList = $wp_filesystem->dirlist( $importDir. '/' .$fileSlug ) ) {
			foreach ( $termList as $termSlug => $termFile ) {
				if ( $targetTerm = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$termSlug ) ) {
					$targetTerm = json_decode( $targetTerm, true );
					if ( $targetTerm[ 'term_id' ] == $termID ) {
						if ( $processTerm = ux_cb_tools_import_process_term( $targetTerm ) ) {
							$return = $processTerm;
						}
					}
				}
			}
		}
		
		return $return;
	}
	
}

?>