<?php
if ( ! function_exists( 'ux_cb_tools_export_options' ) ) {
	/**
	 * export theme options
	 */
	function ux_cb_tools_export_options( $wp_filesystem, $uq, $exportDir ) {
		$content = false;
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		if ( ! $wp_filesystem->is_dir( $exportDir. '/options' ) ) {
			$wp_filesystem->mkdir( $exportDir. '/options' );
		}
		
		if ( $exportData == 'theme-option' ) { 
			$themeOption = get_option( 'ux_theme_option' );
			if ( $themeOption ) {
				$themeOption[ 'home_url' ] = home_url();
				
				$showOnFront = get_option( 'show_on_front' ); 
				if ( $showOnFront ) {
					$themeOption[ 'show_on_front' ] = $showOnFront;
				}
				
				$pageOnFront = get_option( 'page_on_front' );
				if ( $pageOnFront || $pageOnFront == '0' ) {
					$themeOption[ 'page_on_front' ] = $pageOnFront;
				}
				
				$themeMods = get_theme_mods();
				if ( $themeMods ) {
					$themeOption[ 'theme_mods' ] = $themeMods;
				}
				
				$filename = $exportDir. '/options/options.json';
				$content = json_encode( $themeOption );
				if ( ! $wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE ) ) {
					echo 'error saving file!';
				} else {
					echo 'ok';
				}
				
				$images = array();
				foreach ( $themeOption as $option ) {
					if ( ! is_array( $option ) ) {
						array_push( $images, $option );
					}
				}
				
				$images = array_unique( $images );
				foreach ( $images as $image ) {
					if ( $wp_filesystem->get_contents( $image ) ) {
						$extTypes = wp_get_ext_types();
						$mimeType = wp_check_filetype( $image );
						if( in_array( $mimeType['ext'], $extTypes['image'] ) ){
							if ( ! $wp_filesystem->is_dir( $exportDir. '/options/images/' ) ) {
								$wp_filesystem->mkdir( $exportDir. '/options/images/' );
							}
							$newImage = $exportDir. '/options/images/' .basename( $image );
							$wp_filesystem->copy( $image, $newImage );
						}
					}
				}
			} else {
				echo 'ok';
			}
		}
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_options', 10, 3 );
}

if ( ! function_exists( 'ux_cb_tools_export_option_widgets' ) ) {
	/**
	 * export theme widgets
	 */
	function ux_cb_tools_export_option_widgets( $wp_filesystem, $uq, $exportDir ) {
		$exportData = sanitize_text_field( $_POST['exportData'] );
		$widgets = array();
		
		if ( $exportData == 'theme-option' ) { 
			$data = array(
				'sidebars_widgets',
				'widget_text',
				'widget_rss',
				'widget_search',
				'widget_recent-posts',
				'widget_recent-comments',
				'widget_archives',
				'widget_meta',
				'widget_calendar',
				'widget_uxconatactform',
				'widget_nav_menu',
				'widget_pages',
				'widget_uxsocialinons',
				'widget_tag_cloud'
			);
			
			foreach ( $data as $name ) { 
				$widget = get_option( $name );
				if ( $widget ) {
					$widgets[ $name ] = $widget;
				}
			}
			
			if ( count( $widgets ) != 0 ) {
				$filename = $exportDir. '/options/widgets.json';
				$content = json_encode( $widgets );
				$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
			}
		}
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_option_widgets', 11, 3 );
}

if ( ! function_exists( 'ux_cb_tools_export_option_googlefonts' ) ) {
	/**
	 * export theme googlefonts
	 */
	function ux_cb_tools_export_option_googlefonts( $wp_filesystem, $uq, $exportDir ) {
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		if ( $exportData == 'theme-option' ) { 
			if ( $googlefonts = get_option( 'ux_theme_googlefont' ) ) {
				$filename = $exportDir. '/options/googlefonts.json';
				$content = json_encode( $googlefonts );
				$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
			}
		}
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_option_googlefonts', 12, 3 );
}

if ( ! function_exists( 'ux_cb_tools_export_option_icons_custom' ) ) {
	/**
	 * export theme icons custom
	 */
	function ux_cb_tools_export_option_icons_custom( $wp_filesystem, $uq, $exportDir ) {
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		if ( $exportData == 'theme-option' ) { 
			if ( $iconsCustom = get_option( 'ux_theme_option_icons_custom' ) ) {
				$filename = $exportDir. '/options/icons.json';
				$content = json_encode( $iconsCustom );
				$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
			}
		}
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_option_icons_custom', 12, 3 );
}

if ( ! function_exists( 'ux_cb_tools_export_option_font_assignment' ) ) {
	/**
	 * export theme font assignment
	 */
	function ux_cb_tools_export_option_font_assignment( $wp_filesystem, $uq, $exportDir ) {
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		if ( $exportData == 'theme-option' ) { 
			if ( $fontLists = get_option( 'ux-font-lists' ) ) {
				$filename = $exportDir. '/options/font-lists.json';
				$content = json_encode( $fontLists );
				$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
				
				if ( ! $wp_filesystem->is_dir( $exportDir. '/options/fonts/' ) ) {
					$wp_filesystem->mkdir( $exportDir. '/options/fonts/' );
				}
				
				foreach ( $fontLists as $fontItem ) {
					$unique = trim( $fontItem[ 'value' ] );
					$fontFields = get_option( 'ux-font-' .$unique );
					if ( $fontFields ) {
						$filename =  $exportDir. '/options/fonts/' .$unique. '.json';
						$content = json_encode( $fontFields );
						$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
					}
					
					switch( $fontFields[ 1 ][ 'value' ] ) {
						case 'adobe-typekit':
							if ( ! $wp_filesystem->is_dir( $exportDir. '/options/typekit-fonts' ) ) {
								$wp_filesystem->mkdir( $exportDir. '/options/typekit-fonts' );
							}
							
							$kitID = '';
							$fontFamily = '';
							foreach ( $fontFields as $field ) {
								if ( $field[ 'name' ] == '__ux_cb_module_fonts_resource_adobe-typekit-id' ) {
									$kitID = $field[ 'value' ];
								} else if ( $field[ 'name' ] == '__ux_cb_module_fonts_resource_adobe-typekit_family' ) {
									$fontFamily = $field[ 'value' ];
								} 
							}
							
							$typekitFonts = get_option( 'ux_theme_typekit_font_' .$kitID );
							if ( $typekitFonts ) {
								$filename = $exportDir. '/options/typekit-fonts/' .$kitID. '.json';
								$content = json_encode( $typekitFonts );
								$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
							}
							
							$typekitFontFamily = get_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily );
							if ( $typekitFontFamily ) {
								$filename = $exportDir. '/options/typekit-fonts/' .$kitID. '_' .$fontFamily. '.json';
								$content = json_encode( $typekitFontFamily );
								$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
							}
							
							$typekitFontLanguage = get_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily. '_language' );
							if ( $typekitFontLanguage ) {
								$filename = $exportDir. '/options/typekit-fonts/' .$kitID. '_' .$fontFamily. '_language.json';
								$content = json_encode( $typekitFontLanguage );
								$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
							}
						break;
					}
				}
			}
			
			$fontAssignment = get_option( 'ux-font-assignment' );
			if ( $fontAssignment ) {
				$filename = $exportDir. '/options/font-assignment.json';
				$content = json_encode( $fontAssignment );
				$wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE );
			}
		}
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_option_font_assignment', 12, 3 );
}
?>