<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field text group after title.
 */
if ( ! function_exists( 'ux_cb_module_fields_text_group_after_title' ) ) {
	function ux_cb_module_fields_text_group_after_title( $item ) {
		if ( $item['type'] == 'textGroup' ) {
			$item = wp_parse_args( $item, array(
				'fields' => false,
			) );
			
			if ( $item['fields'] ) {
				if ( ! is_array( $item['fields'] ) ) { $item['fields'] = array( $item['fields'] ); }
				echo '<div class="ux-cb-module-field-text-group">';
				foreach ( $item['fields'] as $field ) {
					echo '<button type="button" data-value="' .esc_attr( $field[1] ). '">' .esc_html( $field[0] ). '</button>';
				}
				echo '</div>';
			}
		}
	}
	//add_action( 'ux_cb_module_fields_after_title', 'ux_cb_module_fields_text_group_after_title' );
}

/**
 * UX Content Builder Module field text group.
 */
if ( ! function_exists( 'ux_cb_module_field_text_group' ) ) {
	function ux_cb_module_field_text_group( $item, $post_id, $item_val ) {
		if ( $item['type'] == 'textGroup' ) {
			if ( ! is_array( $item_val ) ) { $item_val = array( $item_val ); }
			
			echo '<div class="ux-cb-module-field-text-group-wrap">';
			echo   '<ul class="ux-cb-module-field-items" data-set-name="' .esc_attr( $item['name'] ). '" data-type="textGroup">';
			
				foreach ( $item_val as $value ) {
					if ( $item['fields'] ) {
						foreach ( $item['fields'] as $field ) {
							$disabledValue = str_replace( '_disabled', '', $value );
							if ( $disabledValue == $field[1] ) {
								$isDisabled = explode( '_disabled', $value );
								
								$normalButton = '';
								$nudoButton = 'hidden';
								if ( count( $isDisabled ) == 2 ) {
									$normalButton = 'hidden';
									$nudoButton = '';
								}
								
								echo '<li>';
								echo   '<h6>' .esc_html( $field[0] ). '</h6>';
								echo   '<button type="button" class="button edit ' .sanitize_html_class( $normalButton ). '"><span class="dashicons dashicons-edit"></span></button>';
								echo   '<button type="button" class="button remove ' .sanitize_html_class( $normalButton ). '"><span class="dashicons dashicons-no-alt"></span></button>';
								echo   '<button type="button" class="button undo ' .sanitize_html_class( $nudoButton ). '"><span class="dashicons dashicons-undo"></button>';
								echo   '<input type="hidden" name="' .esc_attr( $item['name'] ). '" value="' .$value. '">';
								
								$fontSelect = array(
									'font' => '0',
									//'weight' => 'normal'
									'size' => '14px',
									'lineheight' => '24px',
									'letter_spacing' => 'normal',
									'msize' => '14px',
									'spacing' => array('', ''),
									'color' => ''
								);
								foreach ( $fontSelect as $inputName => $inputVal ) {
									$inputName = $item['name']. '_' .$field[1]. '_' .$inputName;
									
									if ( $getInputVal = get_post_meta( $post_id, $inputName, true ) ) {
										$inputVal = $getInputVal;
									}
									
									if ( is_array( $inputVal ) ) {
										$inputVal = join(',', $inputVal);
									}
									
									echo '<input type="hidden" name="' .esc_attr( $inputName ). '" value="' .$inputVal. '">';
								}
								
								echo '</li>';
							}
						}
					}
				}
			
			echo   '</ul>';
			echo   '<div class="ux-cb-module-field-text-group">';
			echo     '<table class="form-table"><tbody>';
			echo       '<tr><th scope="row"><span></span> ' .esc_html__( 'Text Font', 'bm-builder' ). '</th><td>';
			
						//title, category, excerpt, date
						$item['name'] = 'textGroupFontsGroup'; $item['type'] = 'selectFontsGroup';
						ux_cb_module_field_select_font( $item, $post_id );
			
			echo       '</td></tr>';
			echo       '<tr><th scope="row"><span></span> ' .esc_html__( 'Top Spacing', 'bm-builder' ). '</th><td>';
			
						//top spacing
						$item['name'] = 'textGroupFontsGroup_spacing';
						$item['id'] = 'textGroupFontsGroup_spacing';
						$item['type'] = 'multipleInput';
						$item['col'] = 2;
						$item['style'] = 'width: 12em; margin-right: 1em;';
						$item['place'] = array( esc_html__('Desktop', 'bm-builder'), esc_html__('Mobile',  'bm-builder') );
						ux_cb_module_field_multiple_input( $item, $post_id, array( '', '' ), '' );
			
			echo       '</td></tr>';
			echo       '<tr><th scope="row"><span></span> ' .esc_html__( 'Color', 'bm-builder' ). '</th><td>';
			
						//top spacing
						$item['name'] = 'textGroupFontsGroup_color'; $item['type'] = 'colorPicker';
						ux_cb_module_field_color_picker( $item, $post_id, '', '' );
			
			echo       '</td></tr>';
			echo       '<tr><th scope="row"></th><td><button class="textGroupApply" type="button">' .esc_html__( 'Apply', 'bm-builder' ). '</button></td></tr>';
			echo     '</tbody></table>';
			echo   '</div>';
			echo '</div>';
		}
	}
	add_action( 'ux_cb_module_fields_field', 'ux_cb_module_field_text_group', 10, 3 );
}
?>