<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field select font.
 */
if ( ! function_exists( 'ux_cb_module_field_select_font' ) ) {
	function ux_cb_module_field_select_font( $item, $post_id ) {
		if ( $item['type'] == 'selectFontsGroup' ) {
			echo '<div class="ux-cb-module-field-fonts">';
						
			//font assignment
			$this_name = $item['name']. '_font';
			$font_family = 0;
			if ( $get_val = get_post_meta( $post_id, $this_name, true ) ) {
				if ( is_array( $get_val ) ) { $get_val = $get_val[0]; }
				$font_family = $get_val;
			}
			
			$fontLists = get_option( 'ux-font-lists' );
			$dataLists = array();
			if ( $fontLists ) {
				$dataLists[] = array( 'name' => 'Default', 'value' => 0 );
				foreach ( $fontLists as $fontItem ) {
					$unique = trim( $fontItem['value'] );
					$fontFields = get_option( 'ux-font-' .$unique );
					$dataLists[] = array( 'name' => $fontFields[0]['value'], 'value' => $fontItem['value'] );
				}
			}
			
			echo '<select name="' .esc_attr( $this_name ). '" id="' .esc_attr( $this_name ). '" style="width: 312px;">';
			if ( count( $dataLists ) ) {
				foreach ( $dataLists as $dataItem ) {
					echo '<option value="' .esc_attr( $dataItem['value'] ). '" ' .selected( $font_family, $dataItem['value'], false ). '>' .esc_html( $dataItem['name'] ). '</option>';
				}
			}else{
				echo '<option selected="selected" value="0">' .esc_html__( 'No options', 'bm-builder' ). '</option>';
			}
			echo '</select>';
			
			//font size
			$this_name = $item['name']. '_size';
			$font_size = $item['fontval']['size'];
			if ( $get_val = get_post_meta( $post_id, $this_name, true ) ) {
				if ( is_array( $get_val ) ) { $get_val = $get_val[0]; }
				$font_size = $get_val;
			}
			
			$item['fields'] = array(
				array( esc_html__( '6px', 'bm-builder' ), '6px' ),
				array( esc_html__( '7px', 'bm-builder' ), '7px' ),
				array( esc_html__( '8px', 'bm-builder' ), '8px' ),
				array( esc_html__( '9px', 'bm-builder' ), '9px' ),
				array( esc_html__( '10px', 'bm-builder' ), '10px' ),
				array( esc_html__( '11px', 'bm-builder' ), '11px' ),
				array( esc_html__( '12px', 'bm-builder' ), '12px' ),
				array( esc_html__( '13px', 'bm-builder' ), '13px' ),
				array( esc_html__( '14px', 'bm-builder' ), '14px' ),
				array( esc_html__( '15px', 'bm-builder' ), '15px' ),
				array( esc_html__( '16px', 'bm-builder' ), '16px' ),
				array( esc_html__( '17px', 'bm-builder' ), '17px' ),
				array( esc_html__( '18px', 'bm-builder' ), '18px' ),
				array( esc_html__( '19px', 'bm-builder' ), '19px' ),
				array( esc_html__( '20px', 'bm-builder' ), '20px' ),
				array( esc_html__( '21px', 'bm-builder' ), '21px' ),
				array( esc_html__( '22px', 'bm-builder' ), '22px' ),
				array( esc_html__( '23px', 'bm-builder' ), '23px' ),
				array( esc_html__( '24px', 'bm-builder' ), '24px' ),
				array( esc_html__( '25px', 'bm-builder' ), '25px' ),
				array( esc_html__( '26px', 'bm-builder' ), '26px' ),
				array( esc_html__( '27px', 'bm-builder' ), '27px' ),
				array( esc_html__( '28px', 'bm-builder' ), '28px' ),
				array( esc_html__( '29px', 'bm-builder' ), '29px' ),
				array( esc_html__( '30px', 'bm-builder' ), '30px' ),
				array( esc_html__( '32px', 'bm-builder' ), '32px' ),
				array( esc_html__( '34px', 'bm-builder' ), '34px' ),
				array( esc_html__( '36px', 'bm-builder' ), '36px' ),
				array( esc_html__( '38px', 'bm-builder' ), '38px' ),
				array( esc_html__( '40px', 'bm-builder' ), '40px' ),
				array( esc_html__( '42px', 'bm-builder' ), '42px' ),
				array( esc_html__( '44px', 'bm-builder' ), '44px' ),
				array( esc_html__( '46px', 'bm-builder' ), '46px' ),
				array( esc_html__( '48px', 'bm-builder' ), '48px' ),
				array( esc_html__( '50px', 'bm-builder' ), '50px' ),
				array( esc_html__( '52px', 'bm-builder' ), '52px' ),
				array( esc_html__( '54px', 'bm-builder' ), '54px' ),
				array( esc_html__( '56px', 'bm-builder' ), '56px' ),
				array( esc_html__( '58px', 'bm-builder' ), '58px' ),
				array( esc_html__( '60px', 'bm-builder' ), '60px' ),
				array( esc_html__( '62px', 'bm-builder' ), '62px' ),
				array( esc_html__( '64px', 'bm-builder' ), '64px' ),
				array( esc_html__( '66px', 'bm-builder' ), '66px' ),
				array( esc_html__( '68px', 'bm-builder' ), '68px' ),
				array( esc_html__( '70px', 'bm-builder' ), '70px' ),
				array( esc_html__( '72px', 'bm-builder' ), '72px' ),
				array( esc_html__( '74px', 'bm-builder' ), '74px' ),
				array( esc_html__( '76px', 'bm-builder' ), '76px' ),
				array( esc_html__( '78px', 'bm-builder' ), '78px' ),
				array( esc_html__( '80px', 'bm-builder' ), '80px' ),
				array( esc_html__( '82px', 'bm-builder' ), '82px' ),
				array( esc_html__( '84px', 'bm-builder' ), '84px' ),
				array( esc_html__( '86px', 'bm-builder' ), '86px' ),
				array( esc_html__( '90px', 'bm-builder' ), '90px' ),
				array( esc_html__( '92px', 'bm-builder' ), '92px' ),
				array( esc_html__( '96px', 'bm-builder' ), '96px' ),
				array( esc_html__( '98px', 'bm-builder' ), '98px' ),
				array( esc_html__( '120px', 'bm-builder' ), '120px' ),
				array( esc_html__( '144px', 'bm-builder' ), '144px' ),
				array( esc_html__( '168px', 'bm-builder' ), '168px' ),
				array( esc_html__( '196px', 'bm-builder' ), '196px' ),
				array( esc_html__( '1vw', 'bm-builder' ), '1vw' ),
				array( esc_html__( '1.2vw', 'bm-builder' ), '1.2vw' ),
				array( esc_html__( '1.4vw', 'bm-builder' ), '1.4vw' ),
				array( esc_html__( '1.6vw', 'bm-builder' ), '1.6vw' ),
				array( esc_html__( '1.8vw', 'bm-builder' ), '1.8vw' ),
				array( esc_html__( '2vw', 'bm-builder' ), '2vw' ),
				array( esc_html__( '2.2vw', 'bm-builder' ), '2.2vw' ),
				array( esc_html__( '2.4vw', 'bm-builder' ), '2.4vw' ),
				array( esc_html__( '2.6vw', 'bm-builder' ), '2.6vw' ),
				array( esc_html__( '2.8vw', 'bm-builder' ), '2.8vw' ),
				array( esc_html__( '3vw', 'bm-builder' ), '3vw' ),
				array( esc_html__( '3.4vw', 'bm-builder' ), '3.4vw' ),
				array( esc_html__( '3.8vw', 'bm-builder' ), '3.8vw' ),
				array( esc_html__( '4vw', 'bm-builder' ), '4vw' ),
				array( esc_html__( '4.4vw', 'bm-builder' ), '4.4vw' ),
				array( esc_html__( '4.8vw', 'bm-builder' ), '4.8vw' ),
				array( esc_html__( '5vw', 'bm-builder' ), '5vw' ),
				array( esc_html__( '5.4vw', 'bm-builder' ), '5.4vw' ),
				array( esc_html__( '5.8vw', 'bm-builder' ), '5.8vw' ),
				array( esc_html__( '6vw', 'bm-builder' ), '6vw' ),
				array( esc_html__( '6.4vw', 'bm-builder' ), '6.4vw' ),
				array( esc_html__( '6.8vw', 'bm-builder' ), '6.8vw' ),
				array( esc_html__( '7vw', 'bm-builder' ), '7vw' ),
				array( esc_html__( '7.4vw', 'bm-builder' ), '7.4vw' ),
				array( esc_html__( '8vw', 'bm-builder' ), '8vw' ),
				array( esc_html__( '8.4vw', 'bm-builder' ), '8.4vw' ),
				array( esc_html__( '8.8vw', 'bm-builder' ), '8.8vw' ),
				array( esc_html__( '9vw', 'bm-builder' ), '9vw' ),
				array( esc_html__( '9.4vw', 'bm-builder' ), '9.4vw' ),
				array( esc_html__( '9.8vw', 'bm-builder' ), '9.8vw' ),
				array( esc_html__( '10vw', 'bm-builder' ), '10vw' ),
			);
			echo '<select name="' .esc_attr( $this_name ). '" id="' .esc_attr( $this_name ). '">';
			echo '<option ' .selected( $font_size, '14px', false ). ' value="14px">' .esc_html__( 'Default Font Size', 'bm-builder' ). '</option>';
			if ( $item['fields'] ) {
				foreach ( $item['fields'] as $field ) {
					echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $font_size, $field[1], false ). '>' .esc_html( $field[0] ). '</option>';
				}
			}
			echo '</select>';
			
			//font line height
			$this_name = $item['name']. '_lineheight';
			$line_height = $item['fontval']['lineheight'];
			if ( $get_val = get_post_meta( $post_id, $this_name, true ) ) {
				if ( is_array( $get_val ) ) { $get_val = $get_val[0]; }
				$line_height = $get_val;
			}
			
			$item['fields'] = array(
				array( esc_html__( '1.0', 'bm-builder' ), '1'),
				array( esc_html__( '1.1', 'bm-builder' ), '1.1'),
				array( esc_html__( '1.2', 'bm-builder' ), '1.2'),
				array( esc_html__( '1.3', 'bm-builder' ), '1.3'),
				array( esc_html__( '1.4', 'bm-builder' ), '1.4'),
				array( esc_html__( '1.5', 'bm-builder' ), '1.5'),
				array( esc_html__( '1.6', 'bm-builder' ), '1.6'),
				array( esc_html__( '1.7', 'bm-builder' ), '1.7'),
				array( esc_html__( '1.8', 'bm-builder' ), '1.8'),
				array( esc_html__( '1.9', 'bm-builder' ), '1'),
				array( esc_html__( '2.0', 'bm-builder' ), '2'),
				array( esc_html__( '2.1', 'bm-builder' ), '2.1'),
				array( esc_html__( '2.2', 'bm-builder' ), '2.2'),
				array( esc_html__( '2.3', 'bm-builder' ), '2.3'),
				array( esc_html__( '2.4', 'bm-builder' ), '2.4'),
				array( esc_html__( '2.5', 'bm-builder' ), '2.5'),
				array( esc_html__( '2.6', 'bm-builder' ), '2.6'),
				array( esc_html__( '2.7', 'bm-builder' ), '2.7'),
				array( esc_html__( '2.8', 'bm-builder' ), '2.8'),
				array( esc_html__( '2.9', 'bm-builder' ), '2.9'),
				array( esc_html__( '3.0', 'bm-builder' ), '3'),
				array( esc_html__( '3.5', 'bm-builder' ), '3.5'),
				array( esc_html__( '4.0', 'bm-builder' ), '4'),
				array( esc_html__( '4.5', 'bm-builder' ), '4.5'),
				array( esc_html__( '5.0', 'bm-builder' ), '5'),
			);
			echo '<select name="' .esc_attr( $this_name ). '" id="' .esc_attr( $this_name ). '">';
			echo '<option ' .selected( $line_height, '24px', false ). ' value="24px">' .esc_html__( 'Default Line Height', 'bm-builder' ). '</option>';
			if ( $item['fields'] ) {
				foreach ( $item['fields'] as $field ) {
					echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $line_height, $field[1], false ).'>' .esc_html( $field[0] ). '</option>';
				}
			}
			echo '</select>';
			
			//font letter spacing
			$this_name = $item['name']. '_letter_spacing';
			$letter_spacing = $item['fontval']['letter_spacing'];
			if ( $get_val = get_post_meta( $post_id, $this_name, true ) ) {
				if ( is_array( $get_val ) ) { $get_val = $get_val[0]; }
				$letter_spacing = $get_val;
			}
			
			$item['fields'] = array(
				array( esc_html__( '1px', 'bm-builder' ),  '1px' ),
				array( esc_html__( '2px', 'bm-builder' ),  '2px' ),
				array( esc_html__( '3px', 'bm-builder' ),  '3px' ),
				array( esc_html__( '4px', 'bm-builder' ),  '4px' ),
				array( esc_html__( '5px', 'bm-builder' ),  '5px' ),
				array( esc_html__( '6px', 'bm-builder' ),  '6px' ),
				array( esc_html__( '7px', 'bm-builder' ),  '7px' ),
				array( esc_html__( '8px', 'bm-builder' ),  '8px' ),
				array( esc_html__( '9px', 'bm-builder' ),  '9px' ),
				array( esc_html__( '10px', 'bm-builder' ), '10px' )
			);
			echo '<select name="' .esc_attr( $this_name ). '" id="' .esc_attr( $this_name ). '">';
			echo '<option ' .selected( $letter_spacing, 'normal', false ). ' value="normal">' .esc_html__( 'Default Letter Spacing', 'bm-builder' ). '</option>';
			if ( $item['fields'] ) {
				foreach ( $item['fields'] as $field ) {
					echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $letter_spacing, $field[1], false ).'>' .esc_html( $field[0] ). '</option>';
				}
			}
			echo '</select>';
	
			//font size Mobile
			$this_name = $item['name']. '_msize';
			$font_msize = $item['fontval']['msize'];
			if ( $get_val = get_post_meta( $post_id, $this_name, true ) ) {
				if ( is_array( $get_val ) ) { $get_val = $get_val[0]; }
				$font_msize = $get_val;
			}
			
			$item['fields'] = array(
				array( esc_html__( '6px', 'bm-builder' ), '6px' ),
				array( esc_html__( '7px', 'bm-builder' ), '7px' ),
				array( esc_html__( '8px', 'bm-builder' ), '8px' ),
				array( esc_html__( '9px', 'bm-builder' ), '9px' ),
				array( esc_html__( '10px', 'bm-builder' ), '10px' ),
				array( esc_html__( '11px', 'bm-builder' ), '11px' ),
				array( esc_html__( '12px', 'bm-builder' ), '12px' ),
				array( esc_html__( '13px', 'bm-builder' ), '13px' ),
				array( esc_html__( '14px', 'bm-builder' ), '14px' ),
				array( esc_html__( '15px', 'bm-builder' ), '15px' ),
				array( esc_html__( '16px', 'bm-builder' ), '16px' ),
				array( esc_html__( '17px', 'bm-builder' ), '17px' ),
				array( esc_html__( '18px', 'bm-builder' ), '18px' ),
				array( esc_html__( '19px', 'bm-builder' ), '19px' ),
				array( esc_html__( '20px', 'bm-builder' ), '20px' ),
				array( esc_html__( '21px', 'bm-builder' ), '21px' ),
				array( esc_html__( '22px', 'bm-builder' ), '22px' ),
				array( esc_html__( '23px', 'bm-builder' ), '23px' ),
				array( esc_html__( '24px', 'bm-builder' ), '24px' ),
				array( esc_html__( '25px', 'bm-builder' ), '25px' ),
				array( esc_html__( '26px', 'bm-builder' ), '26px' ),
				array( esc_html__( '27px', 'bm-builder' ), '27px' ),
				array( esc_html__( '28px', 'bm-builder' ), '28px' ),
				array( esc_html__( '29px', 'bm-builder' ), '29px' ),
				array( esc_html__( '30px', 'bm-builder' ), '30px' ),
				array( esc_html__( '32px', 'bm-builder' ), '32px' ),
				array( esc_html__( '34px', 'bm-builder' ), '34px' ),
				array( esc_html__( '36px', 'bm-builder' ), '36px' ),
				array( esc_html__( '38px', 'bm-builder' ), '38px' ),
				array( esc_html__( '40px', 'bm-builder' ), '40px' ),
				array( esc_html__( '42px', 'bm-builder' ), '42px' ),
				array( esc_html__( '44px', 'bm-builder' ), '44px' ),
				array( esc_html__( '46px', 'bm-builder' ), '46px' ),
				array( esc_html__( '48px', 'bm-builder' ), '48px' ),
				array( esc_html__( '50px', 'bm-builder' ), '50px' ),
				array( esc_html__( '52px', 'bm-builder' ), '52px' ),
				array( esc_html__( '54px', 'bm-builder' ), '54px' ),
				array( esc_html__( '56px', 'bm-builder' ), '56px' ),
				array( esc_html__( '58px', 'bm-builder' ), '58px' ),
				array( esc_html__( '60px', 'bm-builder' ), '60px' ),
				array( esc_html__( '62px', 'bm-builder' ), '62px' ),
				array( esc_html__( '64px', 'bm-builder' ), '64px' ),
				array( esc_html__( '66px', 'bm-builder' ), '66px' ),
				array( esc_html__( '68px', 'bm-builder' ), '68px' ),
				array( esc_html__( '70px', 'bm-builder' ), '70px' ),
				array( esc_html__( '72px', 'bm-builder' ), '72px' ),
				array( esc_html__( '74px', 'bm-builder' ), '74px' ),
				array( esc_html__( '76px', 'bm-builder' ), '76px' ),
				array( esc_html__( '78px', 'bm-builder' ), '78px' ),
				array( esc_html__( '80px', 'bm-builder' ), '80px' ),
				array( esc_html__( '96px', 'bm-builder' ), '96px' )
			);
			echo '<select name="' .esc_attr( $this_name ). '" id="' .esc_attr( $this_name ). '">';
			echo '<option ' .selected( $font_msize, '14px', false ). ' value="14px">' .esc_html__( 'Mobile Font Size', 'bm-builder' ). '</option>';
			if ( $item['fields'] ) {
				foreach ( $item['fields'] as $field ) {
					echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $font_msize, $field[1], false ). '>' .esc_html( $field[0] ). '</option>';
				}
			}
			echo '</select>';
			
			echo '</div>';
		}
	}
	add_action( 'ux_cb_module_fields_field', 'ux_cb_module_field_select_font', 10, 2 );
}

/**
 * UX Content Builder Module output fonts group style.
 */
if ( ! function_exists( 'ux_cb_module_output_fonts_group_style' ) ) {
	function ux_cb_module_output_fonts_group_style( $post_id, $name ) {
		$style = '';
		
		if ( $font = get_post_meta( $post_id, $name. '_font', true ) ) { $style .= ux_cb_fonts_load_font_data( $font ); }
		if ( $size = get_post_meta( $post_id, $name. '_size', true ) ) { $style .= 'font-size: ' .$size. ';'; }
		if ( $sizeM = get_post_meta( $post_id, $name. '_msize', true ) ) { $style .= '--fontsize-mgrid-title: ' .$sizeM. ';'; }
		if ( $lineHeight = get_post_meta( $post_id, $name. '_lineheight', true ) ) { $style .= 'line-height: ' .$lineHeight. ';'; }
		if ( $letterSpacing = get_post_meta( $post_id, $name. '_letter_spacing', true ) ) { $style .= 'letter-spacing: ' .intval( $letterSpacing ). 'px;'; }
		
		return $style;
	}
}
?>