<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder tools export select data ajax.
 */
if ( ! function_exists( 'ux_cb_tools_export_select_data_ajax' ) ) {
	function ux_cb_tools_export_select_data_ajax() {
		$selectData = sanitize_text_field( $_POST['selectData'] );
		$name = sanitize_text_field( $_POST['name'] );
		
		$selectDataArray = array();
		if ( $selectData != 'none' ) {
			if ( $selectData != 'theme-option' ) {
				global $ux_content_builder;
				
				$exportPostType = array( 'post', 'page', 'ux-portfolio' );
				$post_types = $ux_content_builder->export_post_type();
				if ( $selectData != 'all' ) {
					$exportPostType = $selectData;
					$post_types = array( $selectData, 'ux-cb-modules', 'attachment' );
				}
				
				$modulesArray = array();
				$getModuleAttachment = array();
				$getPostModules = get_posts(array(
					'posts_per_page' => -1,
					'post_type' => $exportPostType,
					'meta_key'  => 'modules'
				));
				if ( $getPostModules ) {
					foreach ( $getPostModules as $post ) {
						if ( $modules = get_post_meta( $post->ID, 'modules', true ) ) {
							if ( is_array( $modules ) ) {
								foreach ( $modules as $moduleUnique ) {
									array_push( $modulesArray, $moduleUnique );
									if ( $modulePostID = ux_cb_get_the_module_post_id( $moduleUnique ) ) {
										$customFields = get_post_custom( $modulePostID );
										$moduleID = get_post_meta( $modulePostID, 'module_id', true );
										foreach ( $customFields as $key => $value ) {
											if ( $moduleID ) {
												$fieldType = ux_cb_get_mod_config( $moduleID, $key, 'type' );
												if ( $fieldType == 'upload' ) {
													$moduleFieldValue = get_post_meta( $modulePostID, $key, true );
													if ( $moduleFieldValue != '' ) {
														if ( is_array( $moduleFieldValue ) ) {
															foreach ( $moduleFieldValue as $subImage ) {
																if ( ! in_array( $subImage, $getModuleAttachment ) ) {
																	if ( $processed = get_option( 'ux_cb_tools_ux-cb-modules_' .$subImage ) ) {
																		$subImage = $processed;
																	}

																	if ( $post = get_post( $subImage ) ) {
																		array_push( $getModuleAttachment, $subImage );
																	}
																}
															}
														} else {
															if ( ! in_array( $moduleFieldValue, $getModuleAttachment ) ) {
																if ( $processed = get_option( 'ux_cb_tools_ux-cb-modules_' .$moduleFieldValue ) ) {
																	$moduleFieldValue = $processed;
																}
																
																if ( $post = get_post( $moduleFieldValue ) ) {
																	array_push( $getModuleAttachment, $moduleFieldValue );
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				
				if ( count( $getModuleAttachment ) ) {
					$getModuleAttachment = array_unique( $getModuleAttachment );
				}
				
				foreach ( $post_types as $post_type ) {
					$count_posts = 0;
					if ( $post_type == 'attachment' ) {
						$post_status = 'inherit';
					}else{
						$post_status = 'publish';
					}
					
					$post_ids = array();
					if ( $post_type == 'ux-cb-modules' ) {
						if ( count( $modulesArray ) ) {
							$modulesArray = array_unique( $modulesArray );
							foreach ( $modulesArray as $moduleUnique ) {
								if ( $post_id = ux_cb_get_the_module_post_id( $moduleUnique ) ) {
									array_push( $post_ids, $post_id );	
								}
							}
						}
					} else {
						$get_posts = get_posts( array (
							'posts_per_page' => -1,
							'post_status' => $post_status,
							'post_type' => $post_type
						));
						
						if ( $get_posts ) {
							foreach ( $get_posts as $post ) {
								array_push( $post_ids, $post->ID );
								
								if ( $post->post_type == 'ux-portfolio' || $post->post_type == 'post' ) {
									if ( $uxThemeMeta = get_post_meta( $post->ID, 'ux_theme_meta', true ) ) {
										if ( isset( $uxThemeMeta[ 'theme_meta_portfolio' ] ) ) {
											$portfolio = $uxThemeMeta[ 'theme_meta_portfolio' ];
											if ( ! is_array( $portfolio ) ) { $portfolio = array( $portfolio ); } 
											foreach ( $portfolio as $num => $imageID ) {
												array_push( $getModuleAttachment, $imageID );
											}
										}
									}
								}
							}
						}
						
						if ( count( $getModuleAttachment ) ) {
							if ( $post_type == 'attachment' ) {
								$post_ids = $getModuleAttachment;
							}
						}
					}
					
					$count_posts = count( $post_ids );
					
					$post_type = get_post_type_object( $post_type );
					$selectDataArray[$post_type->name] = sprintf( '%s <sup data-ids="%s">(%s)</sup>', $post_type->label, join(',', $post_ids), $count_posts );
				}
			}
			if ( $selectData == 'theme-option' || $selectData == 'all' ) {
				$selectDataArray['theme-option'] = sprintf( '%s <sup>(%s)</sup>', __( 'Theme Option', 'ux' ), 1 );
			}
		}
		
		if ( count( $selectDataArray ) ) {
			echo '<div class="ux-cb-tools-fields-process-select-data">';
			foreach ( $selectDataArray as $dataName => $data ) {
				echo '<label><input type="checkbox" name="' .esc_attr( $name ). '_select" value="' .esc_attr( $dataName ). '" checked="checked"> <span class="title">' .$data. '</span></label>';
			}
			echo '<span class="loading"><span class="bar"></span></span>';
			echo '</div>';
		}
		
		exit;
		
	}
	add_action( 'wp_ajax_ux_cb_tools_export_select_data_ajax', 'ux_cb_tools_export_select_data_ajax' );
}

/**
 * UX Content Builder tools export ajax.
 */
if ( ! function_exists( 'ux_cb_tools_export_ajax' ) ) {
	function ux_cb_tools_export_ajax() {
		$uq = sanitize_text_field( $_POST['uq'] );
		$demoName = $_POST['demoName'];
		
		//include export file
		require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/export/options.php' );
		require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/export/posts.php' );
		require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/export/terms.php' );
		
		$method = 'direct';
		$url = wp_nonce_url( 'admin.php?page=ux-cb-tools' );
		if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
			return true;
		}
		
		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( $url, $method, true, false, false );
			return true;
		}
		
		global $wp_filesystem;
		
		$exportDir = false;
		$uploadDir = wp_upload_dir();
		$uploadBaseDir = $uploadDir['basedir'];
		
		$exportDir = $uploadBaseDir. '/ux-export';
		$wp_filesystem->rmdir( $exportDir );
		if ( ! $wp_filesystem->is_dir( $exportDir ) ) {
			$wp_filesystem->mkdir( $exportDir, 0777 );
		}
		
		$exportDir = $uploadBaseDir. '/ux-export/' .$uq;
		if ( $demoName != '' ) {
			$exportDir = $uploadBaseDir. '/ux-export/' .$demoName;
			$wp_filesystem->rmdir( $exportDir );
		}
		
		if ( ! $wp_filesystem->is_dir( $exportDir ) ) {
			$wp_filesystem->mkdir( $exportDir );
		}
		
		do_action( 'ux_cb_tools_export_data', $wp_filesystem, $uq, $exportDir );
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_tools_export_ajax', 'ux_cb_tools_export_ajax' );
}

/**
 * UX Content Builder tools import item ajax.
 */
if ( ! function_exists( 'ux_cb_tools_import_item_ajax' ) ) {
	function ux_cb_tools_import_item_ajax() {
		if ( isset( $_POST['demoName'] ) && isset( $_POST['typeSlug'] ) && isset( $_POST['fileSlug'] ) ) {
			$demoName = sanitize_text_field( $_POST['demoName'] );
			$typeSlug = sanitize_text_field( $_POST['typeSlug'] );
			$fileSlug = sanitize_text_field( $_POST['fileSlug'] );
			$wp_upload_dir = wp_upload_dir();
			
			$GLOBALS['ux_cb_import_home_url'] = home_url();
			$error = array();
			
			$method = 'direct';
			$url = wp_nonce_url( 'admin.php?page=ux-cb-tools' );
			if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
				return true;
			}
			
			if ( ! WP_Filesystem( $creds ) ) {
				request_filesystem_credentials( $url, $method, true, false, false );
				return true;
			}
			
			$importDir = get_stylesheet_directory(). '/demo-data/' .$demoName;
			
			require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/import/post.php' );
			require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/import/term.php' );
			require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/import/options.php' );
			
			global $wp_filesystem;
			
			if ( $theme_option = $wp_filesystem->get_contents( $importDir. '/options/options.json' ) ) {
				$theme_option = json_decode( $theme_option, true );
				$GLOBALS['ux_cb_import_home_url'] = $theme_option[ 'home_url' ];
			}
			
			if ( $typeSlug == 'terms' ) {
				if ( $term = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/' .$fileSlug ) ) {
					$term = json_decode( $term, true );
					if ( ! $processTerm = ux_cb_tools_import_process_term( $term ) ) {
						$error[] = 'error process term id: ' .$term[ 'term_id' ];
					}
					
					if ( ! $processSetTerm = ux_cb_tools_import_process_set_term( $term, $importDir, $typeSlug ) ) {
						$error[] = 'error can not set term parent: ' .$term[ 'term_id' ];
					}
					
				}
			} else if ( $typeSlug == 'options' ) {
				if ( $option = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/' .$fileSlug ) ) {
					$option = json_decode( $option, true );
					$processOptions = ux_cb_tools_import_process_options( $option, $importDir, $fileSlug );
					if ( count( $processOptions ) ) {
						foreach ( $processOptions as $errorInfo ) {
							$error[] = $errorInfo;
						}
					}
					
					if ( $fileSlug == 'font-lists.json' ) {
						if ( $fontLists = get_option( 'ux-font-lists' ) ) {
							foreach ( $fontLists as $fontItem ) {
								$unique = trim( $fontItem[ 'value' ] );
								if ( $fontFields = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/fonts/' .$unique. '.json' ) ) {
									$fontFields = json_decode( $fontFields, true );
									update_option( 'ux-font-' .$unique, $fontFields );
									
									if ( $fontFields = get_option( 'ux-font-' .$unique ) ) {
										switch( $fontFields[ 1 ][ 'value' ] ) {
											case 'adobe-typekit':
												$kitID = '';
												$fontFamily = '';
												foreach ( $fontFields as $field ) {
													if ( $field[ 'name' ] == '__ux_cb_module_fonts_resource_adobe-typekit-id' ) {
														$kitID = $field[ 'value' ];
													} else if ( $field[ 'name' ] == '__ux_cb_module_fonts_resource_adobe-typekit_family' ) {
														$fontFamily = $field[ 'value' ];
													} 
												}
												
												if ( $typekitFonts = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/typekit-fonts/' .$kitID. '.json' ) ) {
													$typekitFonts = json_decode( $typekitFonts, true );
													update_option( 'ux_theme_typekit_font_' .$kitID, $typekitFonts );
												}
												
												if ( $typekitFontFamily = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/typekit-fonts/' .$kitID. '_' .$fontFamily. '.json' ) ) {
													$typekitFontFamily = json_decode( $typekitFontFamily, true );
													update_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily, $typekitFontFamily );
													
												}
												
												if ( $typekitFontLanguage = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/typekit-fonts/' .$kitID. '_' .$fontFamily. '_language.json' ) ) {
													$typekitFontLanguage = json_decode( $typekitFontLanguage, true );
													update_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily. '_language', $typekitFontLanguage );
													
												}
											break;
											
											case 'upload-font':
												foreach ( $fontFields as $num => $field ) {
													$pathinfo = pathinfo( $field[ 'value' ] );
													if ( isset( $pathinfo['extension'] ) ) {
														$filename = $pathinfo['filename'];
														
														if ( $postList = $wp_filesystem->dirlist( $importDir. '/attachment' ) ) {
															foreach ( $postList as $postSlug => $postFile ) {
																//if ( $postSlug == $filename ) {
																	if ( $targetPost = $wp_filesystem->get_contents( $importDir. '/attachment/' .$postSlug. '/data.json' ) ) {
																		$targetPost = json_decode( $targetPost, true );
																		if ( $targetPost['guid'] == $field[ 'value' ] ) {
																			if ( $getNewTargetPost = ux_cb_tools_import_get_post( $targetPost['ID'], $importDir, 'attachment' ) ) {
																				$getNewTargetPost = get_post( $getNewTargetPost );
																				$fontFields[$num]['value'] = $getNewTargetPost->guid;
																				
																				
																				update_option( 'ux-font-' .$unique, $fontFields );
																			}
																		}
																	}
																//}
															}
														}
													}
												}
											
											break;
										}
									}
								}
							}
						}
					}
				}
				
				$importDir = get_stylesheet_directory(). '/demo-data/' .$demoName. '/' .$typeSlug. '/images';
				if ( $optionImages = $wp_filesystem->dirlist( $importDir, true, true ) ) {
					foreach ( $optionImages as $imageSlug => $image ) {
						if ( ! $wp_filesystem->get_contents( $wp_upload_dir[ 'path' ]. '/' .$imageSlug ) ) {
							$wp_filesystem->copy( $importDir. '/' .$imageSlug, $wp_upload_dir[ 'path' ]. '/' .$imageSlug );
						}
					}
				}
			} else {
				//process post
				if ( $post = $wp_filesystem->get_contents( $importDir. '/' .$typeSlug. '/' .$fileSlug. '/data.json' ) ) {
					$post = json_decode( $post, true );
					if ( ! $processPost = ux_cb_tools_import_process_post( $post, $importDir ) ) {
						$error[] = 'error process post id: ' .$post[ 'ID' ];
					}
					
					$processSetPost = ux_cb_tools_import_process_set_post( $post, $importDir, $fileSlug );
					if ( count( $processSetPost ) ) {
						foreach ( $processSetPost as $errorInfo ) {
							$error[] = $errorInfo;
						}
					}
				}
			}
			
			if ( count( $error ) == 0 ) {
				echo 'ok';
			} else {
				echo join( ',', $error );
			}
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_tools_import_item_ajax', 'ux_cb_tools_import_item_ajax' );
}

/**
 * UX Content Builder tools import ajax.
 */
if ( ! function_exists( 'ux_cb_tools_import_ajax' ) ) {
	function ux_cb_tools_import_ajax() {
		$GLOBALS['ux_cb_import_error'] = array();
		$GLOBALS['ux_cb_import_posts_processed'] = array();
		$GLOBALS['ux_cb_import_terms_processed'] = array();
		$GLOBALS['ux_cb_import_comments_processed'] = array();
		$GLOBALS['ux_cb_import_home_url'] = home_url();
		
		if ( isset( $_POST['demoName'] ) ) {
			$demoName = sanitize_text_field( $_POST['demoName'] );
			
			$method = 'direct';
			$url = wp_nonce_url( 'admin.php?page=ux-cb-tools' );
			if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
				return true;
			}
			
			if ( ! WP_Filesystem( $creds ) ) {
				request_filesystem_credentials( $url, $method, true, false, false );
				return true;
			}
			
			$importDir = get_stylesheet_directory(). '/demo-data/' .$demoName;
			
			global $wp_filesystem;
			if ( $wp_filesystem->is_dir( $importDir ) ) {
				if ( $fileList = $wp_filesystem->dirlist( $importDir, true, true ) ) {
					$fileTypes = array();
					foreach ( $fileList as $fileSlug => $file ) {
						if ( $file['type'] == 'd' ) {
							if ( $postList = $wp_filesystem->dirlist( $importDir. '/' .$fileSlug ) ) {
								$fileArray = array();
								foreach ( $postList as $postSlug => $postFile ) {
									if ( $postSlug != '.DS_Store' ) {
										if ( $fileSlug == 'terms' ) {
											$fileArray[] = $postSlug;
										} elseif ( $fileSlug == 'options' ) {
											if ( $postSlug != 'images' ) {
												$fileArray[] = $postSlug;
											}
										} else {
											//$fileArray[] = $postSlug;
											if ( $post = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug. '/data.json' ) ) {
												$post = json_decode( $post, true );
												if ( $post['post_mime_type'] != 'application/zip' ) {
													$fileArray[] = $postSlug;
												}
											}
										}
									}
								}
								$fileTypes[ $fileSlug ] = $fileArray;
							}
						}
					}
					
					echo json_encode( $fileTypes );
				}
				
				
				
				/*require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/import/post.php' );
				require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/import/term.php' );
				require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/import/options.php' );
				
				if ( $theme_option = $wp_filesystem->get_contents( $importDir. '/options/options.json' ) ) {
					$theme_option = json_decode( $theme_option, true );
					$GLOBALS['ux_cb_import_home_url'] = $theme_option[ 'home_url' ];
				}
				
				if ( $fileList = $wp_filesystem->dirlist( $importDir, true, true ) ) {
					foreach ( $fileList as $fileSlug => $file ) {
						if ( $file['type'] == 'd' ) {
							if ( $postList = $wp_filesystem->dirlist( $importDir. '/' .$fileSlug, true, true ) ) {
								 if ( $fileSlug == 'terms' ) {
									$termList = $postList;
									foreach ( $termList as $termSlug => $termFile ) {
										if ( $term = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$termSlug ) ) {
											$term = json_decode( $term, true );
											if ( ! $processTerm = ux_cb_tools_import_process_term( $term ) ) {
												$ux_cb_import_error[] = 'error process term id: ' .$term[ 'term_id' ];
											}
										}
									}
									
									foreach ( $termList as $termSlug => $termFile ) {
										if ( $term = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$termSlug ) ) {
											$term = json_decode( $term, true );
											$processSetTerm = ux_cb_tools_import_process_set_term( $term, $importDir, $fileSlug );
										}
									}
								} else if ( $fileSlug == 'options' ) {
									$optionList = $postList;
									$processOptions = ux_cb_tools_import_process_options( $optionList, $importDir );
								} else {
									//process post
									foreach ( $postList as $postSlug => $postFile ) {
										if ( $post = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug. '/data.json' ) ) {
											$post = json_decode( $post, true );
											if ( ! $processPost = ux_cb_tools_import_process_post( $post, $importDir ) ) {
												$ux_cb_import_error[] = 'error process post id: ' .$post[ 'ID' ];
											}
										}
									}
									
									//process post parent/term/post meta/gallery shortcode/thumbnail id/nav menu item/cb module/attachment/ux-portfolio
									foreach ( $postList as $postSlug => $postFile ) {
										if ( $post = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug. '/data.json' ) ) {
											$post = json_decode( $post, true );
											$processSetPost = ux_cb_tools_import_process_set_post( $post, $importDir, $fileSlug );
										}
									}
								}
							}
						}
					}
				}
				do_action( 'ux_cb_tools_import_data', $importDir );*/
			}
		}
		
		//print_r($GLOBALS['ux_cb_import_error']);
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_tools_import_ajax', 'ux_cb_tools_import_ajax' );
}

/**
 * UX Content Builder tools import data check.
 */
if ( ! function_exists( 'ux_cb_tools_import_data_check' ) ) {
	function ux_cb_tools_import_data_check() {
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_tools_import_data_check', 'ux_cb_tools_import_data_check' );
}

/**
 * UX Content Builder tools import data load.
 */
if ( ! function_exists( 'ux_cb_tools_import_data_load' ) ) {
	function ux_cb_tools_import_data_load() {
		if ( isset( $_POST['thisID'] ) ) {
			$thisID = $_POST['thisID'];
			$html = '';
			
			if ( isset( $_POST['demoName'] ) ) {
				$demoName = sanitize_text_field( $_POST['demoName'] );
						
				$method = 'direct';
				$url = wp_nonce_url( 'admin.php?page=ux-cb-tools' );
				if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
					return true;
				}
				
				if ( ! WP_Filesystem( $creds ) ) {
					request_filesystem_credentials( $url, $method, true, false, false );
					return true;
				}
				
				$importDir = get_stylesheet_directory(). '/demo-data/' .$demoName;
				
				global $wp_filesystem;
				
				switch ( $thisID ) {
					case 'source':
						if ( $wp_filesystem->is_dir( $importDir ) ) {
							if ( $fileList = $wp_filesystem->dirlist( $importDir, true, true ) ) {
								$fileTypes = array();
								foreach ( $fileList as $fileSlug => $file ) {
									if ( $file['type'] == 'd' ) {
										if ( $postList = $wp_filesystem->dirlist( $importDir. '/' .$fileSlug ) ) {
											$fileArray = array();
											foreach ( $postList as $postSlug => $postFile ) {
												if ( $fileSlug == 'terms' ) {
													if ( $term = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug ) ) {
														$term = json_decode( $term, true );
														$fileArray[] = $term;
													}
												} else if ( $fileSlug == 'options' ) {
													if ( $postSlug != 'images' ) {
														if ( $option = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug ) ) {
															$option = json_decode( $option, true );
															$fileArray[$postSlug] = $option;
														}
													}
												} else {
													if ( $post = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug. '/data.json' ) ) {
														$post = json_decode( $post, true );
														if ( $post['post_mime_type'] != 'application/zip' ) {
															$fileArray[] = $post;
														}
													}
												}
											}
											$fileTypes[ $fileSlug ] = $fileArray;
										}
									}
								}
								
								echo json_encode( $fileTypes );
							}
							
						}
					break;
					
					case 'local':
						if ( $wp_filesystem->is_dir( $importDir ) ) {
							if ( $fileList = $wp_filesystem->dirlist( $importDir, true, true ) ) {
								$fileTypes = array();
								foreach ( $fileList as $fileSlug => $file ) {
									if ( $file['type'] == 'd' ) {
										$fileArray = array();
										
										if ( $fileSlug == 'terms' ) {
											$taxonomies = get_taxonomies();
											if ( $taxonomies ) {
												foreach ( $taxonomies as $taxonomy ) {
													if ( $taxonomy != 'post_format' ) {
														$terms = get_terms(array(
															'taxonomy' => $taxonomy,
															'hide_empty' => false
														));
														if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
															foreach ( $terms as $term ) {
																$fileArray[] = $term;
															}
														}
													}
												}
											}
										} else if ( $fileSlug == 'options' ) {
											if ( $themeOption = get_option( 'ux_theme_option' ) ) {
												$fileArray[] = $themeOption;
											}
											
											$widgets = array();
											$data = array(
												'sidebars_widgets',
												'widget_text',
												'widget_rss',
												'widget_search',
												'widget_recent-posts',
												'widget_recent-comments',
												'widget_archives',
												'widget_meta',
												'widget_calendar',
												'widget_uxconatactform',
												'widget_nav_menu',
												'widget_pages',
												'widget_uxsocialinons',
												'widget_tag_cloud'
											);
											
											foreach ( $data as $name ) { 
												$widget = get_option( $name );
												if ( $widget ) {
													$widgets[ $name ] = $widget;
												}
											}
											
											if ( count( $widgets ) != 0 ) {
												$fileArray[] = $widgets;
											}
											
											if ( $googlefonts = get_option( 'ux_theme_googlefont' ) ) {
												$fileArray[] = $googlefonts;
											}
											
											if ( $iconsCustom = get_option( 'ux_theme_option_icons_custom' ) ) {
												$fileArray[] = $iconsCustom;
											}
										} else {
											$get_posts = get_posts( array(
												'posts_per_page' => -1,
												'post_type' => $fileSlug,
												'orderby' => 'name',
												'order' => 'ASC'
											) );
											
											if ( $get_posts ) {
												foreach ( $get_posts as $post ) {
													$fileArray[] = $post;
												}
											}
										}
										
										$fileTypes[ $fileSlug ] = $fileArray;
									}
								}
								echo json_encode( $fileTypes );
							}
						}
					break;
				}
			}
			
			//echo $html;
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_tools_import_data_load', 'ux_cb_tools_import_data_load' );
}

/**
 * UX Content Builder tools import data load local.
 */
if ( ! function_exists( 'ux_cb_tools_import_data_load_local' ) ) {
	function ux_cb_tools_import_data_load_local() {
		if ( isset( $_POST['itemType'] ) ) {
			$itemType = $_POST['itemType'];
			$itemID = $_POST['itemID'];
			
			if ( $itemType == 'terms' ) {
				
			} else if ( $itemType == 'options' ) {
				switch ( $itemID ) {
					case 'theme_options':
						if ( $themeOption = get_option( 'ux_theme_option' ) ) {
							$themeOption = json_encode( $themeOption );
							echo $themeOption;
						} else {
							echo 'Data does not exist';
						}
					break;
					case 'sidebars_widgets':
						$widgets = array();
						$data = array(
							'sidebars_widgets',
							'widget_text',
							'widget_rss',
							'widget_search',
							'widget_recent-posts',
							'widget_recent-comments',
							'widget_archives',
							'widget_meta',
							'widget_calendar',
							'widget_uxconatactform',
							'widget_nav_menu',
							'widget_pages',
							'widget_uxsocialinons',
							'widget_tag_cloud'
						);
						
						foreach ( $data as $name ) { 
							$widget = get_option( $name );
							if ( $widget ) {
								$widgets[ $name ] = $widget;
							}
						}
						
						if ( count( $widgets ) != 0 ) {
							//$widgets = json_encode( $widgets );
							//echo $widgets;
							print_r($widgets);
						}
					break;
					case 'google_fonts':
						if ( $googleFonts = get_option( 'ux_theme_googlefont' ) ) {
							$googleFonts = json_encode( $googleFonts );
							echo $googleFonts;
						} else {
							echo 'Data does not exist';
						}
					break;
				}
			} else {
				if ( $processed = get_option( 'ux_cb_tools_' .$itemType. '_' .$itemID ) ) {
					echo 'Data already exists ... ID: ' .$itemID. ' -> ' .$processed;
				} else {
					echo 'Data does not exist';
				}
				
			}
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_tools_import_data_load_local', 'ux_cb_tools_import_data_load_local' );
}

/**
 * UX Content Builder tools mod meta fix button.
 */
if ( ! function_exists( 'ux_cb_module_field_mod_meta_fix_button_ajax' ) ) {
	function ux_cb_module_field_mod_meta_fix_button_ajax() {
		$metaKey = $_POST['metaKey'];
		$moduleID = $_POST['moduleID'];
		$postID = $_POST['postID'];
		
		if ( ( $metaKey != '' ) && ( $moduleID != '' ) && ( $postID != '' ) ) {
			$getPostMeta = get_post_meta( $postID );
			
			foreach ( $getPostMeta as $getMetaKey => $metaValue ) {
				if ( $getMetaKey == $metaKey ) {
					$metaValue = maybe_unserialize( ux_cb_serialize_corrector( $metaValue[0] ) );
					$modFixedVal = false;
					$fieldType = ux_cb_get_mod_config( $moduleID, $metaKey, 'type' );

					if ( is_array( $metaValue ) ) {
						if ( $metaKey == 'module_id' || 
							 $fieldType == 'select' || $fieldType == 'summernote' || $fieldType == 'text' || 
							 $metaKey == '__ux_cb_module_scroll_animation_base' || $metaKey == '__ux_cb_module_scroll_in_animation' ) {

							$metaValue = $metaValue[0];
							if ( update_post_meta( $postID, $metaKey, $metaValue ) ) {
								$modFixedVal = $metaKey;
							}
						} else if ( $fieldType == 'multipleInput' ) {
							$fieldCount = count( $metaValue );
							$valueOne = array();
							$valueTwo = array();

							if ( $fieldCount > 1 ) {
								$valueHalf = $fieldCount / 2;

								foreach ( $metaValue as $num => $value ) {
									if ( $num < $valueHalf ) {
										array_push( $valueOne, $value );
									} else {
										array_push( $valueTwo, $value );
									}
								}
							}

							if ( count( $valueOne ) ) {
								if ( update_post_meta( $postID, $metaKey, $valueOne ) ) {
									$modFixedVal = $metaKey;
								}
							}
						}
					}

					$modFixed = get_post_meta( $postID, 'modFixed', true );
					if ( ! $modFixed ) { $modFixed = array(); }
					if ( $modFixedVal ) {
						array_push( $modFixed, $modFixedVal );
						if ( update_post_meta( $postID, 'modFixed', $modFixed ) ) {
							echo 'ok';
						}
					}
				}
			}
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_module_field_mod_meta_fix_button_ajax', 'ux_cb_module_field_mod_meta_fix_button_ajax' );
}

/**
 * UX Content Builder tools mod meta fix list.
 */
if ( ! function_exists( 'ux_cb_module_field_mod_meta_fix_list_ajax' ) ) {
	function ux_cb_module_field_mod_meta_fix_list_ajax() {
		$getModules = get_posts( array(
			'numberposts' => -1,
			'post_type' => 'ux-cb-modules',
			'meta_key' => 'module_id'
		));
		
		if ( $getModules ) {
			echo '<div class="mod-fix-lists">';
			foreach ( $getModules as $module ) {
				if ( $moduleID = get_post_meta( $module->ID, 'module_id', true ) ) {
					$modFixed = get_post_meta( $module->ID, 'modFixed', true );
					$importPostID = get_post_meta( $module->ID, 'importPostID', true );
					
					if ( is_array( $moduleID ) && $importPostID ) {
						$moduleID = $moduleID[0];
						
						echo '<div class="fix-item">';
						echo '<h6>' .$module->post_title. ': ' .$module->ID. '<span class="dashicons dashicons-arrow-down"></span></h6>';
						echo '<table class="form-table" cellpadding="0" cellspacing="0">';
						
						$getPostMeta = get_post_meta( $module->ID );
						unset( $getPostMeta['modFixed'] );
						unset( $getPostMeta['importPostID'] );
						
						foreach ( $getPostMeta as $metaKey => $metaValue ) {
							$metaValue = maybe_unserialize( ux_cb_serialize_corrector( $metaValue[0] ) );
							$fieldType = ux_cb_get_mod_config( $moduleID, $metaKey, 'type' );
							$itemTitle = ux_cb_get_mod_config( $moduleID, $metaKey, 'title' );
							
							if ( ! $fieldType ) { $fieldType = '--'; }
							if ( ! $itemTitle ) { $itemTitle = '--'; }
								
							$itemInformation = '<span class="normal">normal</div>';
							$itemInformationClass = 'normal';
							$itemButtonDisabled = 'disabled="disabled"';
							if ( is_array( $metaValue ) ) {
								$itemInformation = '<span class="error">error</span>';
								$itemInformationClass = 'error';
								$itemButtonDisabled = '';
							}
							
							if ( $modFixed ) {
								if ( in_array( $metaKey, $modFixed ) ) {
									$itemInformationClass = 'normal';
									$itemButtonDisabled = 'disabled="disabled"';
									$itemInformation = '<span class="normal">normal</div>';
								}
							}
								
							echo '<tr class="' .$itemInformationClass. '">';
							echo '<th scope="row">' .$itemTitle. '</th>';
							echo '<td class="meta_key">' .$metaKey. '</td>';
							echo '<td>' .$fieldType. '</td>';
							echo '<td>' .$itemInformation. '</td>';
							echo '<td><button class="button button-primary" ' .$itemButtonDisabled. ' data-id="' .$moduleID. '" data-postid="' .$module->ID. '">fix it</button></td>';
							echo '</tr>';
						}
						echo '</table>';
						echo '</div>';
					}
				}
			}
			echo '</div>';
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_module_field_mod_meta_fix_list_ajax', 'ux_cb_module_field_mod_meta_fix_list_ajax' );
}



?>