<?php
/**
 * UX Content Builder Module Text Config.
 */

//text config fields
function ux_cb_module_text_fields($fields){
	$fields['text'] = array(
		'id'           => 'text',
		'animation'    => true,
		'title'        => esc_html__('Text','bm-builder'),
		'content'      => '<p>' .esc_html__('I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.','bm-builder'). '</p>',
		'shortcodeTag' => 'ux_cb_text', 
		'shortcode'    => '[ux_cb_text unique="" col="12"][/ux_cb_text]', 
		//'shortcode'  => '[ux_cb_text unique="" bg-color="" inner-width="" padding-top="" padding-bottom="" animation="" animation-base="" col="12"][/ux_cb_text]', //simplify
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array( 
										  
									array('title'   => esc_html__('Content','bm-builder'),
										  'desc'    => esc_html__('Enter some content for this Text Block.','bm-builder'),
										  'type'    => 'summernote',
										  'name'    => '__ux_cb_module_content',
										  'default' => '<p>' .esc_html__('I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.','bm-builder'). '</p>'),
						
									array('title'   => esc_html__('Inner Wrap Width','bm-builder'),
										  'type'    => 'multipleSelect',
										  'name'    => '__ux_cb_module_text_center_width',
										  'default' => '',
										  'style'   => 'min-width: 12em; margin-right: 1em;',
										  'col'     => 2, 
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  ),
										  'fields'  => array(
											  array('100%', ''),
											  array('90%',  '90%'),
											  array('80%',  '80%'),
											  array('70%',  '70%'),
											  array('60%',  '60%'),
											  array('50%',  '50%')
										  )),

									array('title'   => esc_html__( 'Top Padding','bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_text_top_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('',''),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )),

									array('title'   => esc_html__( 'Bottom Padding','bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_text_bottom_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('',''),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )), 

									array('title'   => esc_html__( 'Left Padding','bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_text_left_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('',''),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )),

									array('title'   => esc_html__( 'Right Padding','bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_text_right_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('',''),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )), 

									array('title'   => esc_html__('Container Height','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_text_container_height',
										  'default' => '',
										  'fields'  => array(
											  array('Auto', ''),
											  array('Browser Height', 'fullscreen-ux')
										  )),
									
									array('title'   => esc_html__('Container Height on Mobile','bm-builder'),
										  'desc'    => esc_html__( 'It will work on portrait mode only.', 'bm-builder' ),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_text_container_height_mobile',
										  'default' => '',
										  'ctrl'    => '__ux_cb_module_text_container_height,fullscreen-ux',
										  'fields'  => array( 
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  ))
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('Background','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_text_background',
										  'default' => 'none',
										  'fields'  => array(
											  array(esc_html__('None','bm-builder'),        'none'),
											  array(esc_html__('Color','bm-builder'), 'background_color'),
											  array(esc_html__('Image','bm-builder'), 'background_image'),
											  array(esc_html__('Hosted Video','bm-builder'), 'hosted_video')
										  )),

									//BG color
									array('title'   => esc_html__('Background Color','bm-builder'),
										  'desc'    => esc_html__('Select the Background Color for Text Block.','bm-builder'),
										  'type'    => 'colorPicker',
										  'ctrl'    => '__ux_cb_module_text_background,background_color',
										  'name'    => '__ux_cb_module_text_bg_color'),

									//video url
									array('title'   => esc_html__('MP4 format video URL','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'url',
										  'ctrl'    => '__ux_cb_module_text_background,hosted_video',
										  'place' => esc_html__('.mp4 video url','bm-builder'),
										  'name'    => '__ux_cb_module_embed_video_mp4'),

									array('title'   => esc_html__('WEBM format video URL','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'url',
										  'ctrl'    => '__ux_cb_module_text_background,hosted_video',
										  'place' => esc_html__('.webm video url','bm-builder'),
										  'name'    => '__ux_cb_module_embed_video_webm'),

									array('title'   => esc_html__('OGG format video URL','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'inputType' => 'url',
										  'ctrl'    => '__ux_cb_module_text_background,hosted_video',
										  'place' => esc_html__('.ogg .ogv video url','bm-builder'),
										  'name'    => '__ux_cb_module_embed_video_ogg'),

									//BG image
									array('title'   => esc_html__('Background Image','bm-builder'),
										  'desc'    => esc_html__('Please upload jpb, png or gif format','bm-builder'),
										  'type'    => 'upload',
										  'ctrl'    => '__ux_cb_module_text_background,hosted_video|background_image',
										  'name'    => '__ux_cb_module_text_bg_image')
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_text_background,background_image|hosted_video',
								'items' => array(
									//Effect
									array('title'   => esc_html__('Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_text_img_video_effect',
										  'ctrl'    => '__ux_cb_module_text_background,hosted_video',
										  'fields'  => array(
											  array(esc_html__('Standard','bm-builder'),         'standard'),
											  array(esc_html__('Mask','bm-builder'),             'mask'),
											  array(esc_html__('Standard to Mask','bm-builder'), 'standard-to-mask'),
											  array(esc_html__('Mask to Standard','bm-builder'), 'mask-to-standard')
										)
									),
									//Effect
									array('title'   => esc_html__('Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_text_img_bgimage_effect',
										  'ctrl'    => '__ux_cb_module_text_background,background_image',
										  'fields'  => array(
											  array(esc_html__('Standard','bm-builder'),         'standard'),
											  array(esc_html__('Mask','bm-builder'),             'mask')
										)
									)
								)
							)
						)
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_text_fields');

?>