<?php
/**
 * UX Content Builder Module Single Image Config.
 */

//single image config fields
function ux_cb_module_single_image_fields($fields){
	$fields['single-image'] = array(
		'id'           => 'single-image',
		'animation'    => true,
		'title'        => esc_html__('Single Image','bm-builder'),
		'content'      => '',
		'shortcodeTag' => 'ux_cb_single_image', 
		'shortcode'    => '[ux_cb_single_image unique="" col="12"]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('File Type','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_file_type',
										  'default' => 'image',
										  'fields'  => array(
											  array(esc_html__('Image','bm-builder'), 'image'),
											  array(esc_html__('SVG','bm-builder'), 'svg')
										  ))
								 )
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_single_image_file_type,image',
								'items' => array(
									array('title'   => esc_html__('Image','bm-builder'),
										  'desc'    => esc_html__('Select image','bm-builder'),
										  'type'    => 'upload',
										  'name'    => '__ux_cb_module_single_image_image'),
									  
									array('title'   => esc_html__('Style','bm-builder'),
										  'desc'    => esc_html__('Select a style for the image','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_style',
										  'default' => 'no',
										  'fields'  => array(
											  array(esc_html__('Standard','bm-builder'), 'no'),
											  array(esc_html__('Shadow','bm-builder'),     'shadow')
										  )),

									array('title'   => esc_html__('Shadow Color','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_single_image_shadow_color',
										  'default' => '#cccccc',
										  'ctrl'    => '__ux_cb_module_single_image_style,shadow'),

									array('title'   => esc_html__('Vertical Offset','bm-builder'),
										  'desc'    => esc_html__('Enter a number, negative values allowed','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_single_image_shadow_y',
										  'default' => '10',
										  'ctrl'    => '__ux_cb_module_single_image_style,shadow'),

									array('title'   => esc_html__('Blur Radius','bm-builder'),
										  'desc'    => esc_html__('Enter a number','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_single_image_shadow_blur',
										  'default' => '50',
										  'ctrl'    => '__ux_cb_module_single_image_style,shadow'),

									array('title'   => esc_html__('Fit Image Width to Container','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_single_image_width_full',
										  'default' => 'on'),
						
									array('title'   => esc_html__('Algin','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_align',
										  'default' => 'left-ux',
										  'ctrl'    => '__ux_cb_module_single_image_width_full,off',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),   'left-ux'),
											  array(esc_html__('Center','bm-builder'), 'singleimage-center-ux'),
											  array(esc_html__('Right','bm-builder'),  'right-ux')
										  )),

									array('title'   => esc_html__('Width','bm-builder'),
										  'desc'    => esc_html__('Enter a number','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_single_image_width',
										  'default' => '',
										  'ctrl'    => '__ux_cb_module_single_image_width_full,off'),
										  
									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'desc'    => esc_html__('Enable the mouseover effect','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_effect',
										  'fields'  => array(
											  array(esc_html__('Standard','bm-builder'), 'no'),
											  array(esc_html__('Zoomed','bm-builder'),'zoomed'),
											  array(esc_html__('Grey to Colored','bm-builder'),'gray-to-colored'),
											  array(esc_html__('Colored to Grey','bm-builder'),'colored-to-gray')
										  )),
										  
									array('title'   => esc_html__('Lightbox','bm-builder'),
										  'desc'    => esc_html__('Enable the Lightbox','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_single_image_lightbox',
										  'default' => 'off'),

									array('title'   => esc_html__('Link','bm-builder'),
										  'desc'    => esc_html__('Link url','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'url',
										  'name'    => '__ux_cb_module_single_image_link',
										  'default' => '',
										  'ctrl'    => '__ux_cb_module_single_image_lightbox,off'),
		
									array('title'   => esc_html__('Opened in New Tab or Window','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_single_image_link_target',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_single_image_lightbox,off'),

									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_single_image_link_nofollow',
										  'ctrl'    => '__ux_cb_module_single_image_lightbox,off'),

									array('title'   => esc_html__('Download','bm-builder'),
										  'desc'    => esc_html__('Is it for downloading a file?','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_single_image_link_download',
										  'ctrl'    => '__ux_cb_module_single_image_lightbox,off'),

									array('title'   => esc_html__('Disable Lazyload','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_single_image_no_lazyload',
										  'default' => 'off'),

									array('title'   => esc_html__('Show Caption','bm-builder'),
										  'desc'    => esc_html__('To show the image Caption set in the Media Library','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_single_image_caption',
										  'default' => 'off'),

									array('title'   => esc_html__('Caption Algin','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_caption_align',
										  'default' => 'left-ux',
										  'ctrl'    => '__ux_cb_module_single_image_caption,on',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),   'left-ux'),
											  array(esc_html__('Center','bm-builder'), 'center-ux'),
											  array(esc_html__('Right','bm-builder'),  'right-ux')
										  )),
								 )
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_single_image_file_type,svg',
								'items' => array(
									array('title'   => esc_html__('SVG','bm-builder'),
										  'desc'    => esc_html__('Select SVG','bm-builder'),
										  'type'    => 'upload',
										  'format'  => 'image/svg+xml',
										  'name'    => '__ux_cb_module_single_image_svg'),
										  
									array('title'   => esc_html__('Stoke Color','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_single_image_svg_color',
										  'default' => ''),

									array('title'   => esc_html__('Fill Color','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_single_image_svg_color_fill',
										  'default' => ''),
										  
									array('title'   => esc_html__('Stoke Color Mouseover','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_single_image_svg_color_mouseover',
										  'default' => ''),

									array('title'   => esc_html__('Fill Color Mouseover','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_single_image_svg_color_mouseover_fill',
										  'default' => ''),

									array('title'   => esc_html__('Width','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => '',
										  'name'    => '__ux_cb_module_single_image_svg_width'),
						
									array('title'   => esc_html__('Click to do','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_click_to_do',
										  'default' => 'nothing',
										  'fields'  => array(
											  array(esc_html__('Nothing','bm-builder'), 'nothing'),
											  array(esc_html__('Go to a Page','bm-builder'), 'go-to-page'),
											  array(esc_html__('Page Scrolling','bm-builder'),  'page-scrolling')
										  )),
										  
									array('title'   => esc_html__('Page scroll','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_svg_page_scroll',
										  'default' => 'top-of-page',
										  'ctrl'    => '__ux_cb_module_single_image_click_to_do,page-scrolling',
										  'fields'  => array(
											  array(esc_html__('Top of Page','bm-builder'), 'top-of-page'),
											  array(esc_html__('Scroll top 100% screen height','bm-builder'), 'scroll-top'),
											  array(esc_html__('Scroll down 100% screen height','bm-builder'),  'scroll-down'),
											  array(esc_html__('Bottom of Page','bm-builder'),  'bottom-of-page')
										  )),

									array('title'   => esc_html__('Link','bm-builder'),
										  'desc'    => esc_html__('Link url','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'url',
										  'name'    => '__ux_cb_module_single_svg_link',
										  'default' => '',
										  'ctrl'    => '__ux_cb_module_single_image_click_to_do,go-to-page'),
		
									array('title'   => esc_html__('Opened in New Tab or Window','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_single_svg_link_target',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_single_image_click_to_do,go-to-page'),

									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_single_svg_link_nofollow',
										  'ctrl'    => '__ux_cb_module_single_image_click_to_do,go-to-page'),

									array('title'   => esc_html__('Download','bm-builder'),
										  'desc'    => esc_html__('Is it for downloading a file?','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_single_svg_link_download',
										  'ctrl'    => '__ux_cb_module_single_image_click_to_do,go-to-page'),
										  
									array('title'   => esc_html__('Align in Container','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_single_image_svg_align',
										  'default' => 'left',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'), 'left'),
											  array(esc_html__('Center','bm-builder'), 'center'),
											  array(esc_html__('Right','bm-builder'), 'right'),
										  ))
								 )
							) 
							
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__( 'Padding on Left','bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_single_image_padding_left',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
									array('title'   => esc_html__('Padding on Right','bm-builder'),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_single_image_padding_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
								)
							)
						)
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_single_image_fields');
?>