<?php
/**
 * UX Content Builder Module Grid Config.
 */

//grid config fields
function ux_cb_module_grid_fields($fields){
	$fields['grid'] = array(
		'id'           => 'grid',
		'animation'    => true,
		'title'        => esc_html__('Grid','bm-builder'),
		'content'      => '',
		'shortcodeTag' => 'ux_cb_grid', 
		'shortcode'    => '[ux_cb_grid unique="" col="12"]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('Source','bm-builder'),
										  'desc'    => '',
										  'type'    => 'source',
										  'name'    => '__ux_cb_module_grid_source',
										  'default' => 'attachment',
										  'fields'  => array(
										  	array(esc_html__('Media Library','bm-builder'),        'attachment'),
											  array(esc_html__('Portfolio','bm-builder'),            'ux-portfolio'),
											  array(esc_html__('Post','bm-builder'),                 'post'),
											  array(esc_html__('WooCommerce Product','bm-builder'), 'product'), 
								)),
									// gallery
									array('title'   => esc_html__('Select Images','bm-builder'),
										  'desc'    => '',
										  'type'    => 'gallery',
										  'name'    => '__ux_cb_module_grid_media_images',
										  'ctrl'    => '__ux_cb_module_grid_source,attachment'),
									
									// ux-portfolio-cat
									array('title'   => esc_html__('Choose a Category','bm-builder'),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_grid_category_ux-portfolio',
										  'ptype'   => 'ux-portfolio-cat',
										  'ctrl'    => '__ux_cb_module_grid_source,ux-portfolio'),
								
									// category
									array('title'   => esc_html__('Choose a Category','bm-builder'),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_grid_category_post',
										  'ptype'   => 'category',
										  'ctrl'    => '__ux_cb_module_grid_source,post'),
								
									// product_cat
									array('title'   => esc_html__('Choose a Category','bm-builder'),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_grid_category_product',
										  'ptype'   => 'product_cat',
										  'ctrl'    => '__ux_cb_module_grid_source,product'),
										  
									array('title'   => esc_html__('Order','bm-builder'),
										  'desc'    => '',
										  'type'    => 'category-orderby',
										  'name'    => '__ux_cb_module_grid_orderby',
										  'default' => 'date',
										  'style'   => 'width:30%;margin-right:15px;',
										  'ctrl'    => '__ux_cb_module_grid_source,ux-portfolio|post|product'),
										  
									array('type'    => 'divide'),
								
									array('title'   => esc_html__('Column','bm-builder'),
										  'desc'    => '',
										  'type'    => 'multipleSelect',
										  'name'    => '__ux_cb_module_grid_column',
										  'style'   => 'min-width: 12em; margin-right: 1em;',
										  'col'     => 2, //switch
										  'default' => array('2', '1'), //Desktop, Mobile
										  'fields'  => array(
											  array('1', '1'),
											  array('2', '2'),
											  array('3', '3'),
											  array('4', '4'),
											  array('5', '5'),
											  array('6', '6'),
											  array('7', '7'),
											  array('8', '8'),
											  array('9', '9'),
											  array('10', '10'),
											  array('11', '11'),
											  array('12', '12')
										  ),
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )), 
										  
									array('title'   => esc_html__('Item Spacing Horizontal','bm-builder'),
										  'desc'    => esc_html__('Insert a number, or leave it empty to use the Grid System default spacer','bm-builder'),
										  'type'    => 'multipleInput',
										  'default' => array( '','' ),
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_grid_item_spacing_horizontal',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2, //switch
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Item Spacing Vertical','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_grid_item_spacing_vertical',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2, //switch
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )),
								
									array('title'   => esc_html__('Grid Ratio','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_image_ratio',
										  'default' => '4_3',
										  'fields'  => array(
											  array('4:3', '4_3'),
											  array('3:2', '3_2'),
											  array('16:9', '16_9'),
											  array('2:1', '2_1'),
											  array('1:1', '1_1'),
											  array('2:3', '2_3'),
											  array('3:4', '3_4'),
											  array('1:2', '1_2'),
											  array(esc_html__('Auto', 'bm-builder'), 'auto')
										  )),

									array('title'   => esc_html__('Fit Image into Grid','bm-builder'),
										  'desc'	=> esc_html__('The image will not be cropped','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_img_fit_grid',
										  'default' => 'off'),

									array('title'   => esc_html__('Grid List Type','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_type',
										  'fields'  => array(
											  array(esc_html__('Regular Grid','bm-builder'), 'regular_grid'),
											  array(esc_html__('Waterfall','bm-builder'), 'masonry_grid'),
										  ),
										  'default' => 'regular_grid'),
										  
									array('title'   => esc_html__('Show Filter','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_show_filter',
										  'default' => 'off'),

									array('title'   => esc_html__('Filter Align','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_filter_align',
										  'ctrl'    => '__ux_cb_module_grid_show_filter,on',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'), 'filter_left'),
											  array(esc_html__('Left in Grid','bm-builder'), 'filter_left_in_grid'),
											  array(esc_html__('Center','bm-builder'), 'filter_center'),
											  array(esc_html__('Right','bm-builder'), 'filter_right'),
										  ),
										  'default' => 'filter_left'),

									array('title'   => esc_html__('Filter Text Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_grid_style_image_filter_text_font',
										  'ctrl'    => '__ux_cb_module_grid_show_filter,on',
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '16px', 'lineheight' => '30px', 'letter_spacing' => 'normal', 'msize' => '14px' )),

									array('title'   => esc_html__('Filter Colour','bm-builder'),
											'desc'    => '',
											'type'    => 'colorPicker',
											'name'    => '__ux_cb_module_grid_style_image_text_filter_color',
											'ctrl'    => '__ux_cb_module_grid_show_filter,on'),
										  
									array('title'   => esc_html__('Filter Bottom Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_grid_item_filter_spacing_bottom',
										  'ctrl'    => '__ux_cb_module_grid_show_filter,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									array('title'   => esc_html__('Filter Item Left Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_grid_item_filter_spacing_left',
										  'ctrl'    => '__ux_cb_module_grid_show_filter,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('20', '15'),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									array('title'   => esc_html__('Filter Item Right Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_grid_item_filter_spacing_right',
										  'ctrl'    => '__ux_cb_module_grid_show_filter,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('20', '15'),
										  'place'   => array(
											  esc_html__( '20', 'bm-builder' ),
											  esc_html__( '10',  'bm-builder' )
										  ) 
									)
								)
							),
							array(
								'items' => array(
									array('title'   => esc_html__('Pagination','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_pagination',
										  'default' => 'none',
										  'fields'  => array(
											  array(esc_html__('No Pagination','bm-builder'),    'none'),
											  array(esc_html__('Load More Button','bm-builder'), 'load-more'),
											  array(esc_html__('Infinite Scroll','bm-builder'),  'scroll')
										  )),
										  
									array('title'   => esc_html__('Post Number per Page','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => 999,
										  'name'    => '__ux_cb_module_grid_post_number_perpage'),

									array('title'   => esc_html__('Load More Button Text','bm-builder'),
											'desc'    => '',
											'type'    => 'text',
											'default' => esc_html__('Load More','bm-builder'),
											'name'    => '__ux_cb_module_grid_style_image_text_loadmore_text',
											'ctrl'    => '__ux_cb_module_grid_pagination,load-more'),

									array('title'   => esc_html__('Loading Text','bm-builder'),
											'desc'    => '',
											'type'    => 'text',
											'default' => esc_html__('Loading','bm-builder'),
											'name'    => '__ux_cb_module_grid_style_image_text_loading_text',
											'ctrl'    => '__ux_cb_module_grid_pagination,load-more'),

									array('title'   => esc_html__('Load More Text Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_grid_style_image_loadmore_text_font',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '16px', 'lineheight' => '50px', 'letter_spacing' => 'normal', 'msize' => '14px' )),

									array('title'   => esc_html__('Load More Colour','bm-builder'),
											'desc'    => '',
											'type'    => 'colorPicker',
											'name'    => '__ux_cb_module_grid_style_image_text_loadmore_color',
											'ctrl'    => '__ux_cb_module_grid_pagination,load-more'),

									array('title'   => esc_html__('Load More Button Width','bm-builder'),
											'desc'    => '',
											'type'    => 'select',
											'name'    => '__ux_cb_module_grid_style_loadmore_width_type',
											'default' => 'left-right-padding',
											'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  	'fields'  => array(
											  array(esc_html__('Fixed Width','bm-builder'),           'fixed-width'),
											  array(esc_html__('Padding on Left/Right','bm-builder'), 'left-right-padding')
										  	)),

									array('title'   => esc_html__('Load More Button Width Value','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_loadmore_width_value',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
										  
									array('title'   => esc_html__('Load More Button Padding on Left/Right','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_loadmore_leftright_padding',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array(30, 10),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									array('title'   => esc_html__('Load More Button Height Value','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_loadmore_height_value',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'default' => array(50, 40),
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									array('title'   => esc_html__('Load More Button Border Width','bm-builder'),
										  'type'    => 'numberGroup',
										  'name'    => '__ux_cb_module_grid_style_loadmore_border_width',
										  'style'   => 'width: 80px;',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'default' => array(0, 0, 0, 0),
										  'place'   => array(
											  esc_html__('Top',    'bm-builder'),
											  esc_html__('Right',  'bm-builder'),
											  esc_html__('Bottom', 'bm-builder'),
											  esc_html__('Left',   'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Load More Button Border Width Mouseover','bm-builder'),
										  'type'    => 'numberGroup',
										  'name'    => '__ux_cb_module_grid_style_loadmore_border_width_mouseover',
										  'style'   => 'width: 80px;',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'default' => array(0, 0, 0, 0),
										  'place'   => array(
											  esc_html__('Top',    'bm-builder'),
											  esc_html__('Right',  'bm-builder'),
											  esc_html__('Bottom', 'bm-builder'),
											  esc_html__('Left',   'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Load More Top Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_grid_item_loadmore_spacing_top',
										  'ctrl'    => '__ux_cb_module_grid_pagination,load-more',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									), 
								
									array('title'   => esc_html__('Image Lazy Load','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_image_lazy_load',
										  'default' => 'on')
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('Item Style','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_item_style',
										  'default' => 'image',
										  'fields'  => array(
											  array(esc_html__('Image','bm-builder'),        'image'),
											  array(esc_html__('Image + Text','bm-builder'), 'image-text')
										  ))
								)
							)
						)
					),
					
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,ux-portfolio|post|product',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items'      => array(
									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_mouseover_effect',
										  'default' => 'static-color-mask-text',
										  'ctrl'    => '__ux_cb_module_grid_source,ux-portfolio|post|product',
										  'fields'  => array(
											  array(esc_html__('Static Color Mask+Text','bm-builder'),     	'static-color-mask-text'),
											  array(esc_html__('Second Featured Image','bm-builder'), 		'show-second-featured-image'),
											  array(esc_html__('Second Featured Image+Text','bm-builder'), 	'second-featured-image-text'),
											  array(esc_html__('No Effect','bm-builder'), 'no-effect'),
										  )),

									array('title'   => esc_html__('Transparent for Mask','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_transparent_mask',
										  'default' => '1',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text',
										  'fields'  => array(
											  array(esc_html__('100%','bm-builder'), ''),
											  array(esc_html__('90%','bm-builder'),  '0.9'),
											  array(esc_html__('80%','bm-builder'),  '0.8'),
											  array(esc_html__('70%','bm-builder'),  '0.7'),
											  array(esc_html__('60%','bm-builder'),  '0.6'),
											  array(esc_html__('50%','bm-builder'),  '0.5'),
											  array(esc_html__('40%','bm-builder'),  '0.4'),
											  array(esc_html__('30%','bm-builder'),  '0.3'),
											  array(esc_html__('20%','bm-builder'),  '0.2'),
											  array(esc_html__('10%','bm-builder'),  '0.1'),
											  array(esc_html__('0%','bm-builder'),  '0.00000001'),
										  )),
										  
									array('title'   => esc_html__('Mask Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_grid_style_image_mask_color',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text')

								)
							)
						)
					),

					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,attachment',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items'      => array(
									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
									  'desc'    => '',
									  'type'    => 'select',
									  'name'    => '__ux_cb_module_grid_style_image_mouseover_effect-attachment',
									  'default' => 'no-effect', 
									  'fields'  => array(
										  array(esc_html__('Static Color Mask+Text','bm-builder'), 'static-color-mask-text'),
										  array(esc_html__('No Effect','bm-builder'), 'no-effect'),
										)
									),
									array('title'   => esc_html__('Transparent for Mask','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_transparent_mask_attachment',
										  'default' => '1',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect-attachment,static-color-mask-text',
										  'fields'  => array(
											  array(esc_html__('100%','bm-builder'), ''),
											  array(esc_html__('90%','bm-builder'),  '0.9'),
											  array(esc_html__('80%','bm-builder'),  '0.8'),
											  array(esc_html__('70%','bm-builder'),  '0.7'),
											  array(esc_html__('60%','bm-builder'),  '0.6'),
											  array(esc_html__('50%','bm-builder'),  '0.5'),
											  array(esc_html__('40%','bm-builder'),  '0.4'),
											  array(esc_html__('30%','bm-builder'),  '0.3'),
											  array(esc_html__('20%','bm-builder'),  '0.2'),
											  array(esc_html__('10%','bm-builder'),  '0.1')
										  )
									),
										  
									array('title'   => esc_html__('Mask Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_grid_style_image_mask_color_attachment',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect-attachment,static-color-mask-text'
									),
									
									array('title'   => esc_html__('Title Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_grid_style_image_title_text_font_attachment',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect-attachment,static-color-mask-text'
									),

									array('title'   => esc_html__('Title Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_grid_attachment_style_image_text_color',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect-attachment,static-color-mask-text'
									)
								)
							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,ux-portfolio|post',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image-text',
								'items'      => array(
										  
									array('title'   => esc_html__( 'Text','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'name'    => '__ux_cb_module_grid_style_image_text_text_group',
										  'default' => array( 'title', 'category', 'excerpt', 'date' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Category', 'bm-builder' ), 'category' ),
											  array( esc_html__( 'Excerpt', 'bm-builder' ), 'excerpt' ),
											  array( esc_html__( 'Date', 'bm-builder' ), 'date' )
										  )
									)
								)
							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,ux-portfolio|post',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items'      => array(
										  
									array('title'   => esc_html__( 'Text(Mouseover)','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'name'    => '__ux_cb_module_grid_style_image_text_group',
										  'default' => array( 'title', 'category', 'excerpt', 'date' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Category', 'bm-builder' ), 'category' ),
											  array( esc_html__( 'Excerpt', 'bm-builder' ), 'excerpt' ),
											  array( esc_html__( 'Date', 'bm-builder' ), 'date' )
										  )
									)

								)

							), 
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,attachment',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image-text',
								'items'      => array( 
									
									array('title'   => esc_html__('Caption Text Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_grid_style_image_text_caption_text_font', 
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '24px', 'lineheight' => '40px', 'letter_spacing' => 'normal', 'msize' => '14px' )), //family, weight, size, line height, letter spacing,
									
									array('title'   => esc_html__('Caption Text Colour','bm-builder'),
											'desc'    => '',
											'type'    => 'colorPicker',
											'name'    => '__ux_cb_module_grid_style_image_text_caption_color'),

									array('title'   => esc_html__('Caption Text Top Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_grid_item_caption_spacing_top',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									)
								)

							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_item_style,image',
						'group'        => array(
							array(
								'group-id'   => '', 
								'items' => array(
									array('title'   => esc_html__('Text Padding on Left/Right','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_grid_style_image_text_padding_leftright', 
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									array('title'   => esc_html__('Text Padding on Top','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_grid_style_image_text_padding_topbottom', 
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									array('title'   => esc_html__('Text Padding on Bottom','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_grid_style_image_text_padding_bottom', 
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),
								)
							)
						)
					),

					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,product',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items' => array(

									array('title'   => esc_html__( 'Text(Mouseover)','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'name'    => '__ux_cb_module_grid_product_text_group',
										  'default' => array( 'title', 'price' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Price', 'bm-builder' ), 'price' )
										  )
									)
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image-text',
								'items' => array(
									array('title'   => esc_html__( 'Text','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'name'    => '__ux_cb_module_grid_product_image_text_text_group',
										  'default' => array( 'title', 'price' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Price', 'bm-builder' ), 'price' )
										  )
									)
								)
							)
						)
					),
					array(
						'group' => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items' => array(
									array('title'   => esc_html__('Text Align','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_text_align',
										  'default' => 'center',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),           'left'),
											  array(esc_html__('Center','bm-builder'),         'center'),
											  array(esc_html__('Right','bm-builder'),          'right'),
											  array(esc_html__('Top Left','bm-builder'),       'top-left'),
											  array(esc_html__('Top Center','bm-builder'),     'top-center'),
											  array(esc_html__('Top Right','bm-builder'),      'top-right'),
											  array(esc_html__('Bottom Left','bm-builder'),    'bottom-left'),
											  array(esc_html__('Bottom Center','bm-builder'),  'bottom-center'),
											  array(esc_html__('Bottom Right','bm-builder'),   'bottom-right')
										  ))
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image-text',
								'items' => array(
									array('title'   => esc_html__('Text Align','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_text_text_align',
										  'default' => 'center',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),           'grid-text-left'),
											  array(esc_html__('Center','bm-builder'),         'grid-text-center'),
											  array(esc_html__('Right','bm-builder'),          'grid-text-right')
										  )),
		
									array('title'   => esc_html__('Text Padding on Left/Right','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_grid_style_image_text_text_padding_leftright', 
										  'ctrl'    => '__ux_cb_module_grid_style_image_text_text_align,grid-text-left|grid-text-right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_text_mouseover_effect',
										  'ctrl'    => '__ux_cb_module_grid_source,post|ux-portfolio|product',
										  'default' => 'no-effect',
										  'fields'  => array(
											  array(esc_html__('No Effect','bm-builder'),     'no-effect'),
											  array(esc_html__('Enlarge Image','bm-builder'), 'enlarge-image'),
											  array(esc_html__('Second Featured Image','bm-builder'), 'show-second-featured-image')
										  )
									),

									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_text_mouseover_effect-attachment',
										  'ctrl'    => '__ux_cb_module_grid_source,attachment',
										  'default' => 'no-effect',
										  'fields'  => array(
											  array(esc_html__('No Effect','bm-builder'),     'no-effect'),
											  array(esc_html__('Enlarge Image','bm-builder'), 'enlarge-image')
										  )
									),

									array('type'    => 'divide'),
								)
							),
							array(
								'items' => array(
									array('title'   => esc_html__( 'List Inner Padding','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'inputType'=>'number',
										  'name'    => '__ux_cb_module_grid_style_inner_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
								)
							),
							array(
								'items' => array(
									array('title'   => esc_html__('List Background Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_grid_style_list_bg_color' ), 

									array('type'    => 'divide')

								)
							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,ux-portfolio|post',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items'      => array( 
								
									array('title'   => esc_html__('What Thumbnail Does','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_style_image_what_thumb_does',
										  'default' => 'open-the-portfolio-item',
										  'fields'  => array(
											  array(esc_html__('Open The Portfolio/Post Item','bm-builder'), 'open-the-portfolio-item'),
											  array(esc_html__('Open Lightbox','bm-builder'),           'open-lightbox')
				
										  )
									),
									array('title'   => esc_html__('Open in New Window/Tab','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'ctrl'    => '__ux_cb_module_grid_style_image_what_thumb_does,open-the-portfolio-item',
										  'name'    => '__ux_cb_module_grid_what_thumb_does_new_tab',
										  'default' => 'off'
									),
									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_grid_style_image_what_thumb_does,open-the-portfolio-item',
										  'name'    => '__ux_cb_module_grid_what_thumb_does_nofollow'),

								)

							),

							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_style_image_what_thumb_does,open-lightbox',
								'items' => array(
									array('title'   => esc_html__('Open Second Featured Image in Lightbox','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_style_open_2nd_lighbox',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,show-second-featured-image|second-featured-image-text',
									),
									array('title'   => esc_html__('Click Title to Open the Portfolio/Post Item','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_style_click_title_open_item',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text'
									),
									array('title'   => esc_html__('Video Play Button Color','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_grid_style_videoplay_color',
									),
								),
							), 
						)
					),
					array(		
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,ux-portfolio|post|product',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_style_image_what_thumb_does,open-the-portfolio-item',
								'items' => array(
									array('title'   => esc_html__('Tap Once to Open Item on Touch Screen','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_style_touch_once',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_grid_item_style,image'
									),
									array('type'    => 'divide',
										'ctrl'    => '__ux_cb_module_grid_item_style,image'
									),
								)	
							)
						)
					),
					array(
						'group' => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_source,attachment',
								'items' => array(
									array('title'   => esc_html__('What Thumbnail Does','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_grid_attachment_what_thumb_does',
										  'default' => 'open-lightbox',
										  'fields'  => array(
											  array(esc_html__('Open Lightbox','bm-builder'),   'open-lightbox'),
											  array(esc_html__('Open Custom URL','bm-builder'), 'open-custom-url'),
											  array(esc_html__('Nothing','bm-builder'),         'none')
										  )),

									array('title'   => esc_html__('Open in new window/tab','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										   'ctrl'    => '__ux_cb_module_grid_attachment_what_thumb_does,open-custom-url',
										  'name'    => '__ux_cb_module_grid_attachment_what_thumb_does_new_tab',
										  'default' => 'off'),

									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_grid_attachment_what_thumb_does,open-custom-url',
										  'name'    => '__ux_cb_module_grid_attachment_what_thumb_does_nofollow'),
										  
									array('type'    => 'divide')
								),
							)	
						)
					),
					array(		
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_grid_source,attachment',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_grid_item_style,image',
								'items' => array(
									array('title'   => esc_html__('Tap Once to Open Item on Touch Screen','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_grid_attachment_touch_once',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_grid_attachment_what_thumb_does,open-custom-url'
									),
									array('type'    => 'divide',
										'ctrl'    => '__ux_cb_module_grid_attachment_what_thumb_does,open-custom-url'
									)
								)	
							)
						)
					),
					array(
						'group' => array(
							array(
								'items' => array()	
							)
						)
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_grid_fields');

?>