<?php
/**
 * UX Content Builder Module Button Config.
 */

//button config fields
function ux_cb_module_button_fields( $fields ) {
	$fields['button'] = array(
		'id'           => 'button',
		'animation'    => true,
		'title'        => esc_html__('Button','bm-builder'),
		'content'      => '',
		'shortcodeTag' => 'ux_cb_button', 
		'shortcode'    => '[ux_cb_button unique="" col="12"]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title' => esc_html__('Buttons','bm-builder'),
										  'type' => 'items',
										  'item-text' => esc_html__('Button','bm-builder'),
										  'name' => '_ux_cb_module_button_items',
										  'count' => 1),

									array('title'   => esc_html__('Text Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'fontval' => array( 'family' => '', 'size' => '16px', 'lineheight' => '1.0', 'letter_spacing' => '', 'msize' => '14px' ), 
										  'name'    => '__ux_cb_module_button_text_font'),

									array('title'   => esc_html__('Adjust Vertical Position for Text','bm-builder'),
										  'desc'    => '',
										  'name'    => '__ux_cb_module_button_item_text_vertical_posi',
										  'type'    => 'select',
										  'default' => '0',
										  'fields'  => array(
										  		array(esc_html__('-6','bm-builder'), '-6'),
										  		array(esc_html__('-5','bm-builder'), '-5'),
										  		array(esc_html__('-4','bm-builder'), '-4'),
										  		array(esc_html__('-3','bm-builder'), '-3'),
										  		array(esc_html__('-2','bm-builder'), '-2'),
										  		array(esc_html__('-1','bm-builder'), '-1'),
										  		array(esc_html__('0','bm-builder'), '0'),
												array(esc_html__('1','bm-builder'), '1'),
												array(esc_html__('2','bm-builder'), '2'),
												array(esc_html__('3','bm-builder'), '3'),
												array(esc_html__('4','bm-builder'), '4'),
												array(esc_html__('5','bm-builder'), '5'),
												array(esc_html__('6','bm-builder'), '6')
										  )),
									
									// Align
									array('title'   => __('Align','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_align',
										  'default' => 'btn-left',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),   'btn-left'),
											  array(esc_html__('Center','bm-builder'), 'btn-center'),
											  array(esc_html__('Right','bm-builder'),  'btn-right'),
											  array(esc_html__('Equal Spacing','bm-builder'), 'btn-equal'),
										  )),

									// Arrange Mobile
									array('title'   => __('Arrange on Mobile','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_arrange_mobile',
										  'default' => 'ux-horizontal',
										  'fields'  => array(
											  array(esc_html__('Horizontal','bm-builder'), 'ux-horizontal'),
											  array(esc_html__('Vertical','bm-builder'), 'ux-vertical')
										  )),

									// Align Mobile
									array('title'   => __('Align on Mobile','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_align_mobile',
										  'default' => 'btn-left-m',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),   'btn-left-m'),
											  array(esc_html__('Center','bm-builder'), 'btn-center-m'),
											  array(esc_html__('Right','bm-builder'),  'btn-right-m'),
											  array(esc_html__('Equal Spacing','bm-builder'), 'btn-equal-m'),
										  )),

									//Button Item Left Spacing
									array('title'   => esc_html__('Button Item Left Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_button_item_left_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )),

									//Button Item Right Spacing
									array('title'   => esc_html__('Button Item Right Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_button_item_right_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )),

									//Mobile bottom spacing
									array('title'   => esc_html__('Button Item Bottom Spacing on Mobile','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => 20,
										  'ctrl'    => '__ux_cb_module_button_arrange_mobile,ux-vertical',
										  'name'    => '__ux_cb_module_button_item_bottom_spacing_m'), 
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array()
					)
				)
			),
			array(
				'region-id' => 'item-settings',
				'title'     => esc_html__('Item Settings','bm-builder'),
				'default'   => false,
				'hidden'    => true,
				'class'     => 'ux-cb-item-settings',
				'name'      => '__ux_cb_module_items_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('Button Text','bm-builder'),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_button_item_text'),
										  
									array('title'   => esc_html__('Button Link','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'url',
										  'name'    => '__ux_cb_module_button_item_link'),
		
									array('title'   => esc_html__('Opened in New Tab or Window','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_button_item_link_target'),

									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_button_item_link_nofollow'),

									array('title'   => esc_html__('Download','bm-builder'),
										  'desc'    => esc_html__('Is it for downloading a file?','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_button_item_link_download'),
										  
									array('type'    => 'divide'),
						
									array('title'   => esc_html__('Button Width','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_item_width_type',
										  'default' => 'spacing-left-right',
										  'fields'  => array(
											  array(esc_html__('Fixed Width','bm-builder'),           'fixed-width'),
											  array(esc_html__('Padding on Left/Right','bm-builder'), 'spacing-left-right')
										  )),
										  
									array('title'   => esc_html__('Width Value','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_button_item_width',
										  'ctrl'    => '__ux_cb_module_button_item_width_type,fixed-width'),
										  
									array('title'   => esc_html__('Padding Vaule','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => 40,
										  'name'    => '__ux_cb_module_button_item_spacing',
										  'ctrl'    => '__ux_cb_module_button_item_width_type,spacing-left-right'),
										  
									array('title'   => esc_html__('Button Height','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => 50,
										  'name'    => '__ux_cb_module_button_item_height'), 
										  
									// array('type'    => 'divide'),
								
									// array('title'   => esc_html__('Button Style','bm-builder'),
									// 	  'type'    => 'select',
									// 	  'name'    => '__ux_cb_module_button_item_style',
									// 	  'default' => 'style-1',
									// 	  'fields'  => array(
									// 		  array(esc_html__('Style 1','bm-builder'), 'style-1')
									// 	  ))
								 )
							),
							array( // Style 1
								// 'group-id'   => '',
								// 'group-ctrl' => '__ux_cb_module_button_item_style,style-1',
								'items' => array(
										  
									array('title'   => esc_html__('Text Color','bm-builder'),
										  'desc'    => esc_html__('Choose a text color for the button','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_button_item_text_color'),

									array('title'   => esc_html__('Background Colour','bm-builder'),
										  'desc'    => esc_html__('Choose a background color for the button','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_button_item_bg_color'),

									array('title'   => esc_html__('Text color Mouseover','bm-builder'),
										  'desc'    => esc_html__('Choose a text color for the button mouseover','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_button_item_text_color_mouseover'),
										  
									array('title'   => esc_html__('Background Colour Mouseover','bm-builder'),
										  'desc'    => esc_html__('Choose a background color for the button mouseover','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_button_item_bg_color_mouseover'),
										  
									array('title'   => esc_html__('Border Width','bm-builder'),
										  'type'    => 'numberGroup',
										  'name'    => '__ux_cb_module_button_item_border_width',
										  'style'   => 'width: 80px;',
										  'default' => array('', '', '', ''),
										  'place'   => array(
											  esc_html__('Top',    'bm-builder'),
											  esc_html__('Right',  'bm-builder'),
											  esc_html__('Bottom', 'bm-builder'),
											  esc_html__('Left',   'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Border Width Mouseover','bm-builder'),
										  'type'    => 'numberGroup',
										  'name'    => '__ux_cb_module_button_item_border_width_mouseover',
										  'style'   => 'width: 80px;',
										  'default' => array('', '', '', ''),
										  'place'   => array(
											  esc_html__('Top',    'bm-builder'),
											  esc_html__('Right',  'bm-builder'),
											  esc_html__('Bottom', 'bm-builder'),
											  esc_html__('Left',   'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Corner Radius','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_button_item_border_radius'),
										  
									array('title'   => esc_html__('Border Colour','bm-builder'),
										  'desc'    => esc_html__('Choose a border color for the button','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_button_item_border_color'),
										  
									array('title'   => esc_html__('Border Colour Mouseover','bm-builder'),
										  'desc'    => esc_html__('Choose a border color for the button mouseover','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_button_item_border_color_mouseover'),
								
									array('title'   => esc_html__('Bg Color Mouseover Effect','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_item_bg_color_mouseover_effect',
										  'default' => 'fadeInM',
										  'fields'  => array(
											  array(esc_html__('Fade In','bm-builder'),        'fadeInM'),
											  array(esc_html__('Fade In Top','bm-builder'),    'fadeInTopM'),
											  array(esc_html__('Fade In Left','bm-builder'),   'fadeInLeftM'),
											  array(esc_html__('Fade In Right','bm-builder'),  'fadeInRightM'),
											  array(esc_html__('Fade In Bottom','bm-builder'), 'fadeInBottomM')
										  )),
										  
									array('title' => esc_html__('Show Icon','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_button_items_show_icon',
										  'default' => 'off'),
										  
									array('title'   => esc_html__('Select SVG','bm-builder'),
										  'desc'    => '',
										  'type'    => 'upload',
										  'format'  => 'image/svg+xml',
										  'name'    => '__ux_cb_module_button_items_icon_svg',
										  'ctrl'    => '__ux_cb_module_button_items_show_icon,on'),
									
									array('title'   => esc_html__('Icon Position','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_items_icon_position',
										  'default' => 'left',
										  'fields'  => array(
											  array(esc_html__('On Left','bm-builder'),  'on-left'),
											  array(esc_html__('On Right','bm-builder'), 'on-right')
										  ),
										  'ctrl'    => '__ux_cb_module_button_items_show_icon,on'),
									
									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_button_items_icon_mouseover_effect',
										  'default' => 'default',
										  'fields'  => array(
											  array(esc_html__('Show Icon By Default','bm-builder'),  'default'),
											  array(esc_html__('Show Icon When Mouseover','bm-builder'), 'mouseover')
										  ),
										  'ctrl'    => '__ux_cb_module_button_items_show_icon,on'),
										  
									array('title'   => esc_html__('Icon Width','bm-builder'),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_button_items_icon_width',
										  'ctrl'    => '__ux_cb_module_button_items_show_icon,on'),

									array('title'   => esc_html__('Spacing Between Icon and Text','bm-builder'),
										  'type'    => 'text',
										  'inputType'=>'number',
										  'default' => '0',
										  'name'    => '__ux_cb_module_button_items_icon_spacing_and_text',
										  'ctrl'    => '__ux_cb_module_button_items_show_icon,on'),
										  
									array('title'   => '',
										  'desc'    => '',
										  'class'   => 'item-save-button',
										  'type'    => 'button',
										  'target'  => '.ux-cb-module-field-items',
										  'text'    => esc_html__('Save Item','bm-builder'),
										  'name'    => '__ux_cb_module_button_item_save')
								)
							)
						)
					)
				)
			)	
		)
	);
	return $fields;
	
}
add_filter( 'ux_cb_module_fields', 'ux_cb_module_button_fields' );
?>