(function($){

    "use strict";
	
	//document ready
	$(document).ready(function(){
		var portfolioSetThumbnail = $('.set-portfolio-thumbnail-image');
		if(portfolioSetThumbnail.length){
			portfolioSetThumbnail.each(function(){
				var setBtn = $(this);
				var setText = setBtn.data('title');
				var btnTitle = setBtn.attr('title');
				var thumbnail = '';
				var input = setBtn.parents('.inside').find('input:hidden');
				var btnName = input.attr('name');
				var postID = $('input#post_ID').val();
				
				setBtn.on('click', function(){
					var frame = wp.media({
						title : btnTitle,
						multiple : false,
						library : { type : 'image'},
						button : { text : 'Insert' }
					});
					
					frame.on('select',function() {
							
						var first = frame.state().get('selection').first().toJSON();
		
						input.val(first['id']);
						
						$.post(ajaxurl, {
							'action': 'ux_cb_portfolio_featured_image_set_ajax',
							'thumbnail_id': first['id'],
							'post_id': postID,
							'name': btnName
						}).done(function(result){
							if(result != ''){
								setBtn.html(result);
								setBtn.parents('.inside').find('p.hidden').removeClass('hidden');
							}
						});
					});
						
					frame.open();
				});
			});
		}
		
		var portfolioRemoveThumbnail = $('.remove-portfolio-thumbnail-image');
		if(portfolioRemoveThumbnail.length){
			portfolioRemoveThumbnail.each(function(){
				var removeBtn = $(this);
				var setBtn = removeBtn.parents('.inside').find('.set-portfolio-thumbnail-image');
				var setText = setBtn.data('title');
				var input = setBtn.parents('.inside').find('input:hidden');
				var btnName = input.attr('name');
				var postID = $('input#post_ID').val();
				
				removeBtn.on('click', function(){
					$.post(ajaxurl, {
						'action': 'ux_cb_portfolio_featured_image_remove_ajax',
						'thumbnail_id': input.val(),
						'post_id': postID,
						'name': btnName
					}).done(function(result){
						if(result == 'ok'){
							input.val('');
							setBtn.html('Set ' +setText);
							setBtn.parents('.inside').find('p').each(function(){
								if(!$(this).find('.set-portfolio-thumbnail-image').length){
									$(this).addClass('hidden');
								}
							});
						}
					});
					return false;
				});
			});
		}
	});
	
	
})(jQuery);