(function($){

    "use strict";
	
	var uxTools        = [];
	
	//document
	uxTools.doc        = $(document);
	
	//selector
	uxTools.wrap       = $('.__ux_theme_wrap[data-module-id="ux-cb-tools"]');
	uxTools.pluginPage = $('#ux-cb-current-plugin_page');
	
	uxTools.exportDataProgress = 0;
	uxTools.importDataProgress = 0;
	uxTools.importDataStatus = 'pending';
	uxTools.importLocalData = [];
	uxTools.importSourceData = [];
	uxTools.importCheckItemType = false;
	uxTools.importCheckItemID = false;
	uxTools.importCheckItemIndex = false;
	uxTools.importErrorData = [];
	
	//functions
	uxTools.fnParseQuery = function(query){
		var reg = /([^=&\s]+)[=\s]*([^=&\s]*)/g;
		var obj = {};
		while(reg.exec(query)){
			obj[RegExp.$1] = RegExp.$2;
		}
		return obj;
	}
	
	//fn clear trim
	uxTools.fnClearTrim = function(s){
		s = s.replace(/<\/?.+?>/g, ""); 
        s = s.replace(/[\r\n]/g, ""); 
		s = s.replace(/^\s*/g,"");
		s = s.replace(/\s*$/g,""); 
		s = s.replace(/(^\s*)|(\s*$)/g, ""); 
		
		return s;
	}
	
	//fn export ajax
	uxTools.fnExportAjax = function(ajaxData, processingWrap){
		if(ajaxData.id){
			var ajaxDataID = ajaxData.id;
			$.ajax({
				url: ajaxurl,
				method: 'POST',
				data: {
					'action': 'ux_cb_tools_export_ajax',
					'exportData': ajaxData.data,
					'uq': ajaxData.uq,
					'postId': ajaxData.id,
					'demoName': ajaxData.demoName
				},
				success: function(result){
					result = uxTools.fnClearTrim(result);
					if(result == 'ok'){
						uxTools.exportDataProgress++;
						ajaxData.barWidth = ( uxTools.exportDataProgress / ajaxData.count ) * 100;
						ajaxData.bar.css('width', ajaxData.barWidth+ '%');
						processingWrap.html('Done!!');
						processingWrap.fadeOut(300, function(){
							processingWrap.remove();
						});
						
						if(ajaxData.barWidth >= 100){
							ajaxData.select.removeAttr('disabled');
							ajaxData.btn.removeAttr('disabled');
						}
					}else if(result == 'no post'){
						console.log('No post: ' +ajaxDataID);
						processingWrap.html('No post: ' +ajaxDataID);
					}else{
						console.log('Error: ' +ajaxDataID);
						processingWrap.append('Retry after 1 seconds');
						setTimeout(function(){
							ajaxData.id = ajaxDataID;
							uxTools.fnExportAjax(ajaxData, processingWrap);
							//processingWrap.remove();
						}, 1000);
					}
				},
				error: function(){
					console.log('Error: ' +ajaxDataID);
					processingWrap.append('Retry after 1 seconds');
					setTimeout(function(){
						ajaxData.id = ajaxDataID;
						uxTools.fnExportAjax(ajaxData, processingWrap);
						//processingWrap.remove();
					}, 1000);
				}
			});
		}
	}
	
	//fn import ajax
	uxTools.fnImportAjax = function(ajaxData){
		var errorCount = Number(uxTools.importErrorData[ajaxData.typeSlug][ajaxData.index]);
		$.ajax({
			url: ajaxurl,
			method: 'POST',
			data: {
				'action': 'ux_cb_tools_import_item_ajax',
				'typeSlug': ajaxData.typeSlug,
				'fileSlug': ajaxData.fileSlug,
				'demoName': ajaxData.demoName
			},
			success: function(result){
				result = uxTools.fnClearTrim(result);
				if(result == 'ok'){
					uxTools.importDataProgress++;
					ajaxData.barWidth = ( uxTools.importDataProgress / ajaxData.count ) * 100;
					ajaxData.bar.css('width', ajaxData.barWidth+ '%');
						
					if(ajaxData.barWidth >= 100){
						ajaxData.btn.text('Import completed');
						if(ajaxData.btn.hasClass('ux-importing')) {
							ajaxData.btn.removeClass('ux-importing');
						}
					}
				}else{
					console.log('Error: ' +ajaxData.typeSlug+ '/' +ajaxData.fileSlug);
					if(errorCount < 3){
						setTimeout(function(){
							errorCount++;
							uxTools.importErrorData[ajaxData.typeSlug][ajaxData.index] = errorCount;
							uxTools.fnImportAjax(ajaxData);
						}, 1000);
					}else{
						uxTools.importDataProgress++;
						ajaxData.barWidth = ( uxTools.importDataProgress / ajaxData.count ) * 100;
						ajaxData.bar.css('width', ajaxData.barWidth+ '%');
						
						if(ajaxData.barWidth >= 100){
							ajaxData.btn.text('Import completed');
							if(ajaxData.btn.hasClass('ux-importing')) {
								ajaxData.btn.removeClass('ux-importing');
							}
						}
					}
				}
			},
			error: function(){
				console.log('Error: ' +ajaxData.typeSlug+ '/' +ajaxData.fileSlug);
				if(errorCount < 3){
					setTimeout(function(){
						errorCount++;
						uxTools.importErrorData[ajaxData.typeSlug][ajaxData.index] = errorCount;
						uxTools.fnImportAjax(ajaxData);
					}, 1000);
				}else{
					uxTools.importDataProgress++;
					ajaxData.barWidth = ( uxTools.importDataProgress / ajaxData.count ) * 100;
					ajaxData.bar.css('width', ajaxData.barWidth+ '%');
						
					if(ajaxData.barWidth >= 100){
						ajaxData.btn.text('Import completed');
						if(ajaxData.btn.hasClass('ux-importing')) {
							ajaxData.btn.removeClass('ux-importing');
						}
					}
				}
			}
		});
	}
	
	//document ready
	uxTools.doc.ready(function(){
		
	});
	
	//document ajax success
	uxTools.doc.ajaxSuccess(function(event, xhr, settings) {
		var data = uxTools.fnParseQuery(settings.data);
		
		if(data['action'] == 'ux_cb_ajax_load_module_fields' && data['moduleID'] == 'ux-cb-tools'){
			if(uxTools.pluginPage.val() == 'ux-cb-tools'){
				var exportData = uxTools.wrap.find('select#export_data'),
					exportDataBtn = uxTools.wrap.find('button.export-data-btn');
				
				exportDataBtn.on('click', function(){
					var exportDemoName = uxTools.wrap.find('input#export_demo_name'),
						exportDataVal = $(this).val(),
						exportDataSelect = exportData.next().find('input[type="checkbox"]'),
						exportDataCount = 0,
						exportDataProgress = 0,
						exportSelectDataBarWidth = 0,
						exportSelectDataLoading = exportData.next().find('span.loading'),
						exportSelectDataBar = exportSelectDataLoading.find('.bar'),
						date = new Date(),
						uq = date.getTime(),
						ajaxOutput = exportData.next('.ajax-output'),
						processWrap = $('<div class="ux-cb-tools-process-wrap"></div>');
				
					if(ajaxOutput.find('.ux-cb-tools-process-wrap').length){
						ajaxOutput.find('.ux-cb-tools-process-wrap').remove();
					}
					
					uxTools.exportDataProgress = 0;
					ajaxOutput.append(processWrap);
					if(exportDataVal != 'none'){
						exportDataBtn.attr('disabled', 'disabled');
						
						exportDataSelect.each(function(){
							var checkbox = $(this),
								thisSup = checkbox.next().find('sup'),
								dateCount = thisSup.text().replace('(', ''),
								dateCount = Number(dateCount.replace(')', ''));
								
							if($(this).is(':checked')){
								exportDataCount = exportDataCount + dateCount;
							}
							$(this).attr('disabled', 'disabled');
						});
						
						exportDataSelect.each(function(){
							var checkbox = $(this),
								data = checkbox.val(),
								title = checkbox.next('.title').text(),
								thisSup = checkbox.next().find('sup'),
								thisIds = thisSup.attr('data-ids'),
								ajaxData = [];
							
							if($(this).is(':checked')){
								ajaxData.data = data;
								ajaxData.uq = uq;
								
								ajaxData.demoName = exportDemoName.val();
								ajaxData.bar = exportSelectDataBar;
								ajaxData.barWidth = exportSelectDataBarWidth;
								ajaxData.count = exportDataCount;
								ajaxData.select = exportDataSelect;
								ajaxData.btn = exportDataBtn;
								
								if(thisIds){
									thisIds = thisIds.split(',');
									$.each(thisIds, function(num, id) {
										var processingWrap = $('<div class="process-information" data-id="' +id+ '">Processing ' +title+ ': ' +num+ '->(post id) ' +id+ ';</div>');
										
										ajaxData.id = id;
										processWrap.append(processingWrap);
										uxTools.fnExportAjax(ajaxData, processingWrap);
									});
								}
								
								if(data == 'theme-option'){
									var processingWrap = $('<div class="process-information" data-id="theme-option">Processing theme option;</div>');
									
									ajaxData.id = 'theme-option';
									processWrap.append(processingWrap);
									uxTools.fnExportAjax(ajaxData, processingWrap);
								}
							}
						});
						
						uxTools.exportTermsAjax = $.ajax({
							url: ajaxurl,
							method: 'POST',
							data: {
								'action': 'ux_cb_tools_export_ajax',
								'exportData': 'terms',
								'uq': uq,
								'demoName': exportDemoName.val()
							},
							success: function(result){
								result = uxTools.fnClearTrim(result);
								if(result == 'ok'){
									
								}else if(result == 'error'){
									uxTools.exportTermsAjax.abort();
									console.log('Error: term');
								}
							},
							error: function(){
								uxTools.exportTermsAjax.abort();
								console.log('Error: term');
							}
						})
					}
				});
				
				if(exportData.length){
					exportData.after('<div class="ajax-output"></div>');
					exportData.change(function(){
						var ajaxOutput = exportData.next('.ajax-output'),
						    exportDataVal = $(this).val(),
							name = $(this).attr('name');
						
						if(exportDataVal != 'none'){
							exportDataBtn.attr('disabled', 'disabled');
							ajaxOutput.html('<div class="ux-cb-tools-fields-process-select-data">Loading...</div>');
							ajaxOutput.find('[type="checkbox"]').attr('disabled', 'disabled');
							$.post(ajaxurl, {
								'action': 'ux_cb_tools_export_select_data_ajax',
								'selectData': exportDataVal,
								'name': name
							}).done(function(result){
								ajaxOutput.html(result);
								exportDataBtn.removeAttr('disabled');
							});
						}else{
							ajaxOutput.html('');
							exportDataBtn.attr('disabled', 'disabled');
						}
					});
				}
				
				var importDataBtn = uxTools.wrap.find('button.improt-data-btn');
				var importSection = uxTools.wrap.find('ul.module-template-section');
				
				if(importDataBtn.length){
					importDataBtn.on('click', function(){
						var activeSection = importSection.find('> li.active'),
							activeSectionVal = activeSection.data('name'),
							importDataCount = Number(activeSection.attr('data-count')),
							importDataProgress = 0,
							importSelectDataBarWidth = 0,
							importSelectDataLoading = activeSection.find('span.loading'),
							importSelectDataBar = importSelectDataLoading.find('.bar'),
							ajaxData = {};
							
						ajaxData.action = 'ux_cb_tools_import_ajax';
						ajaxData.demoName = activeSectionVal;
						
						//activeSection.find('span.loading').addClass('import-process');
						importDataBtn.attr('disabled', 'disabled').text('Importing');
						if(!importDataBtn.hasClass('ux-importing')) {
							importDataBtn.addClass('ux-importing');
						}
						uxTools.importDataStatus = 'importing';
						
						//console.log(activeSectionVal);
						//uxTools.fnImportAjax(ajaxData, importDataBtn);
						
						$.ajax({
							url: ajaxurl,
							method: 'POST',
							data: ajaxData,
							dataType: 'json',
							success: function(result){
								var ajaxDataCount = 0;
								$.each(result, function(typeSlug, fileTypes){
									$.each(fileTypes, function(index, fileSlug){
										ajaxDataCount++;
									});
								});
							
								$.each(result, function(typeSlug, fileTypes){
									uxTools.importErrorData[typeSlug] = [];
									//console.log(typeSlug);
									$.each(fileTypes, function(index, fileSlug){
										var ajaxData = [],
										    data = [];
										
										uxTools.importErrorData[typeSlug][index] = 0;
										ajaxData.demoName = activeSectionVal;
										ajaxData.typeSlug = typeSlug;
										ajaxData.fileSlug = fileSlug;
										ajaxData.index = index;
										ajaxData.count = ajaxDataCount;
										ajaxData.bar = importSelectDataBar;
										ajaxData.barWidth = importSelectDataBarWidth;
										ajaxData.btn = importDataBtn;
										
										uxTools.fnImportAjax(ajaxData);
									});
								});
							},
							error: function(){
								console.log('error');
							}
						});
					});
				}
				
				if(importSection.length){
					importSection.find('> li').each(function(){
						$(this).on('click', function(){
							if($(this).hasClass('active')){
								importDataBtn.attr('disabled', 'disabled');
								$(this).removeClass('active');
							}else{
								if(uxTools.importDataStatus == 'pending'){
									importDataBtn.removeAttr('disabled');
								}
							
								importSection.find('> li').removeClass('active');
								$(this).addClass('active');
							}
						});
					});
				}
				
				var regionTrigger = $('#import-options .region-trigger');
				if(regionTrigger.length){
					var modal = new wp.media.view.Modal({ controller: { trigger: function() {} } });
						modal.$el.addClass('ux-cb-media-modal-layout');
					
					modal.on('open', function(event){
						modal.$el.addClass('opened');
						var dataCheckBtn = modal.$el.find('button.import-data-check'),
							dataLoadBtn = modal.$el.find('th[data-id]');
						
						dataCheckBtn.on('click', function(){
							/*$.post(ajaxurl, {
								'action': 'ux_cb_tools_import_data_check'
							}).done(function(result){
								
							});*/
							$.each(uxTools.importSourceData, function(typeSlug, fileTypes){
								$.each(fileTypes, function(index, fileSlug){
									$.each(uxTools.importLocalData, function(localTypeSlug, localFileTypes){
										$.each(localFileTypes, function(localIndex, localFileSlug){
											if(typeSlug == 'terms'){
												var termSlug = fileSlug['slug'],
													termTaxonomy = fileSlug['taxonomy'],
													localTermSlug = localFileSlug['slug'],
													localTermTaxonomy = localFileSlug['taxonomy'];
												
												if((termSlug == localTermSlug) && (termTaxonomy == localTermTaxonomy)){
													modal.$el.find('td.import-local-data dd[data-id="' +localTypeSlug+ '_' +localIndex+ '"]').remove();
													modal.$el.find('td.import-source-data dd[data-id="' +typeSlug+ '_' +index+ '"]').remove();
												}
											}else if(typeSlug == 'options'){
												if(fileSlug == localFileSlug){
													modal.$el.find('td.import-local-data dd[data-id="' +localTypeSlug+ '_' +localIndex+ '"]').remove();
													modal.$el.find('td.import-source-data dd[data-id="' +typeSlug+ '_' +index+ '"]').remove();
												}
											}else{
												var postTitle = fileSlug['post_title'],
													postDate = fileSlug['post_date'],
													localPostTitle = localFileSlug['post_title'],
													localPostDate = localFileSlug['post_date'];
												
												if(postTitle == ''){
													postTitle = '(slug) ' +fileSlug['post_name'];
													localPostTitle = '(slug) ' +localFileSlug['post_name'];
												}
												
												if((postTitle == localPostTitle) && (postDate == localPostDate)){
													modal.$el.find('td.import-local-data dd[data-id="' +localTypeSlug+ '_' +localIndex+ '"]').remove();
													modal.$el.find('td.import-source-data dd[data-id="' +typeSlug+ '_' +index+ '"]').remove();
												}else{
													
												}
											}
										});
									});
								});
							});
							
							modal.$el.find('td.import-source-data dd').off('click');
							modal.$el.find('td.import-source-data dd').on('click', function(){
								var ModalContentView = wp.Backbone.View.extend({ template: wp.template('import-data-check-pop') });
								
								modalPop.content( new ModalContentView() );
								modalPop.open();
								modalPop.$el.addClass('import-data-check-pop');
								
								uxTools.importCheckItemType = $(this).data('type');
								uxTools.importCheckItemID = $(this).data('item-id');
								uxTools.importCheckItemIndex = $(this).data('index');
							});
							
							console.log(uxTools.importLocalData);
							console.log(uxTools.importSourceData );
						});
						
						dataLoadBtn.dblclick(function(){
							var thisID = $(this).data('id'),
								targetWrap = modal.$el.find('td.import-' +thisID+ '-data'),
								activeSection = importSection.find('> li.active'),
								activeSectionVal = activeSection.data('name'),
								ajaxData = {};
							
							ajaxData.action = 'ux_cb_tools_import_data_load';
							ajaxData.thisID = thisID;
							ajaxData.demoName = activeSectionVal;
							
							/*$.post(ajaxurl, {
								'action': 'ux_cb_tools_import_data_load',
								'thisID': thisID,
								'demoName': activeSectionVal
							}).done(function(result){
								
							});*/
							
							$.ajax({
								url: ajaxurl,
								method: 'POST',
								data: ajaxData,
								dataType: 'json',
								success: function(result){
									switch(ajaxData.thisID){
										case 'local': uxTools.importLocalData = result; break;
										case 'source': uxTools.importSourceData = result; break;
									}
									
									var html = '<dl>';
									$.each(result, function(typeSlug, fileTypes){
										html += '<dt><span class="dashicons dashicons-leftright"></span> ' +typeSlug+ '</dt>';
										if(fileTypes != null){
											$.each(fileTypes, function(index, fileSlug){
												var itemTitle = '',
													itemID = 0;
													
												if(fileSlug != null){
													if(typeSlug == 'terms'){
														itemTitle = fileSlug['name'],
														itemID = fileSlug['term_id'];
														
														if(itemTitle == ''){
															itemTitle = '(slug) ' +fileSlug['slug'];
														}
															
													}else if(typeSlug == 'options'){
														if(fileSlug['theme_option_enable_text_logo']){
															itemTitle = 'Theme Options';
															itemID = 'theme_options';
														}else if(fileSlug['sidebars_widgets']){
															itemTitle = 'Sidebars Widgets';
															itemID = 'sidebars_widgets';
														}else if(fileSlug[0]['value'] == 'ux-cb-fonts-assignment'){
															itemTitle = 'Fonts Assignment';
															itemID = 'fonts_assignment';
														}else if(fileSlug[0]['name'] == '_ux_cb_module_fonts_items'){
															itemTitle = 'Fonts Lists';
															itemID = 'fonts_lists';
														}else{
															if(fileSlug['kind'] == 'webfonts#webfontList'){
																itemTitle = 'Google Fonts';
																itemID = 'google_fonts';
															}
														}
													}else{
														itemTitle = fileSlug['post_title'],
														itemID = fileSlug['ID'];
														
														if(itemTitle == ''){
															itemTitle = '(slug) ' +fileSlug['post_name'];
														}
													}
													html += '<dd data-id="' +typeSlug+ '_' +index+ '" data-type="' +typeSlug+ '" data-item-id="' +itemID+ '" data-index="' +index+ '">';
													html += '<span class="dashicons dashicons-arrow-right"></span>' +itemTitle+ ' <span class="post_id">ID: ' +itemID+ '</span>';
													
													if(typeSlug == 'attachment'){
														var mineType = false;
														
														switch(fileSlug['post_mime_type']){
															case 'image/png': mineType = '.png'; break;
															case 'video/mp4': mineType = '.mp4'; break;
															case 'image/jpeg': mineType = '.jpg'; break;
															case 'image/svg+xml': mineType = '.svg'; break;
															case 'application/x-font-woff2': mineType = '.woff2'; break;
															case 'application/zip': mineType = '.zip'; break;
														}
														
														if(mineType){
															html += ' <span class="post_id">' +mineType+ '</span>';
														}
													}
													
													html += '</dd>';
												}
											});
										}
									});
									html += '</dl>';
									
									targetWrap.html(html);
									
									modal.$el.find('td.import-local-data dt, td.import-source-data dt').on('click', function(){
										var typeSlug = uxTools.fnClearTrim($(this).text()),
											wrapParent = $(this).parent();
										
										if(!$(this).hasClass('close')){
											$(this).addClass('close');
											wrapParent.find('dd[data-id^="' +typeSlug+ '_"]').hide();
										}else{
											$(this).removeClass('close');
											wrapParent.find('dd[data-id^="' +typeSlug+ '_"]').show();
										}
										
									});
								},
								error: function(){
									console.log('error');
								}
							});
						});
					}).on('close', function(){
						modal.$el.removeClass('opened import-data-check');
					});
					
					//modal pop
					var modalPop = new wp.media.view.Modal({ controller: { trigger: function() {} } });
						modalPop.$el.addClass('ux-cb-media-modal-layout');
						
					modalPop.on('open', function(event){
						modalPop.$el.addClass('opened');
						
						var textarea = modalPop.$el.find('textarea[name="import-data-check-pop"]');
						
						modalPop.$el.find('button[data-click]').each(function(){
							var btn = $(this),
								btnClick = btn.data('click');
							
							btn.on('click', function(){
								var ajaxData = {};
								
								switch(btnClick){
									case 'check-local':
										ajaxData.action = 'ux_cb_tools_import_data_load_local';
										ajaxData.itemType = uxTools.importCheckItemType;
										ajaxData.itemID = uxTools.importCheckItemID;
										ajaxData.itemIndex = uxTools.importCheckItemIndex;
										
										$.ajax({
											url: ajaxurl,
											method: 'POST',
											data: ajaxData,
											success: function(result){
												textarea.html(result+ '\n');
											},
											error: function(){
												textarea.html('error');
											}
										});
									break;
									case 'check-source':
										var itemSource = uxTools.importSourceData[uxTools.importCheckItemType][uxTools.importCheckItemIndex],
											html = '';
										
										if(uxTools.importCheckItemType == 'terms'){
											
										}else if(uxTools.importCheckItemType == 'options'){
											if(itemSource['theme_option_enable_text_logo']){
												$.each(itemSource, function(name, value){
													html += name+ ': ' +value+ '\n';
												});
												console.log(itemSource);
											}else if(itemSource['sidebars_widgets']){
												$.each(itemSource, function(name, value){
													html += name+ ': ' +value+ '\n';
												});
												console.log(itemSource);
											}else{
												html += itemSource.toString();
											}
										}else{
											$.each(itemSource, function(name, value){
												html += name+ ': ' +value+ '\n';
											});
										}
										
										textarea.append(html);
										
									break;
									case 'reimport':
										var activeSection = importSection.find('> li.active'),
											activeSectionVal = activeSection.data('name'),
											itemSource = uxTools.importSourceData[uxTools.importCheckItemType][uxTools.importCheckItemIndex],
											fileSlug = false;
										
										
										if(uxTools.importCheckItemType == 'terms'){
											
										}else if(uxTools.importCheckItemType == 'options'){
											if(itemSource['theme_option_enable_text_logo']){
												fileSlug = 'options.json';
											}else if(itemSource['sidebars_widgets']){
												fileSlug = 'widgets.json';
											}else if(itemSource[0]['value'] == 'ux-cb-fonts-assignment'){
												fileSlug = 'font-assignment.json';
											}else if(itemSource[0]['name'] == '_ux_cb_module_fonts_items'){
												fileSlug = 'font-lists.json';
											}else{
												if(itemSource['kind'] == 'webfonts#webfontList'){
													fileSlug = 'googlefonts.json';
												}
											}
										}else{
											fileSlug = itemSource.post_name;
										}
										
										$.ajax({
											url: ajaxurl,
											method: 'POST',
											data: {
												'action': 'ux_cb_tools_import_item_ajax',
												'typeSlug': uxTools.importCheckItemType,
												'fileSlug': fileSlug,
												'demoName': activeSectionVal
											},
											success: function(result){
												result = uxTools.fnClearTrim(result);
												if(result == 'ok'){
													textarea.html('Import completed, please check again');
												}else{
													console.log('Error: ' +uxTools.importCheckItemType+ '/' +itemSource.post_name);
												}
											},
											error: function(){
												console.log('Error: ' +uxTools.importCheckItemType+ '/' +itemSource.post_name);
											}
										});
									break;
								}
							});
						});
					}).on('close', function(){
						modalPop.$el.removeClass('opened import-data-check-pop');
					});
					
					regionTrigger.dblclick(function(){
						var thisTrigger = $(this),
							exportTabBtn = $('.ux-cb-module-field-region-tab[data-id="export-options"]');
						
						if(thisTrigger.hasClass('left')){
							var ModalContentView = wp.Backbone.View.extend({ template: wp.template('import-data-check') }),
								activeSection = importSection.find('> li.active'),
								activeSectionVal = activeSection.data('name');
							
							if(activeSection.length){
								modal.content( new ModalContentView() );
								modal.open();
								modal.$el.addClass('import-data-check');
								
								modal.$el.find('.import-data-name').html(activeSectionVal);
							}
							
							uxTools.importLocalData = [];
							uxTools.importSourceData = [];
							
						}else{
							if(exportTabBtn.length){
								exportTabBtn.removeClass('hidden').trigger('click');
							}
						}
					});
				}
			}
		}
		
		if(data['action'] == 'ux_cb_ajax_load_module_fields' && data['moduleID'] == 'ux-cb-tools-system-status'){
			if(uxTools.pluginPage.val() == 'ux-cb-tools-system-status'){
				uxTools.wrap = $('.__ux_theme_wrap[data-module-id="ux-cb-tools-system-status"]');
				console.log(uxTools.wrap);
				
				uxTools.wrap.find('.ux-cb-module-field-region-tab').remove();
				uxTools.wrap.find('.ux-cb-module-field-region-content').removeClass('hidden').show();
			}
		}
	});
	
})(jQuery);