<?php 
/* Template for Search Results */

get_header();
global $theme_options; ?>

	<div id="page-banner">
		<div class="container">
			<h1><?php printf(__( 'Search Results for: %s' , 'sntheme'), '<span>' . get_search_query() . '</span>'); ?></h1>
		</div>
	</div>
		
	<div id="main">
		<div class="container">
		
	<?php if (have_posts()) : ?>
		
		<div id="content" class="<?php if(isset($theme_options['sidebar_on_archive'])) { if($theme_options['sidebar_on_archive']) { } else { echo ' fullwidth'; } } if(!is_active_sidebar('sidebar')) { echo ' fullwidth'; } ?>">

		<?php while ( have_posts() ) : the_post(); ?>
			
			<article class="search-archive<?php if(has_post_thumbnail()) { echo ' search-archive-has-thumbnail'; } ?>">
				<?php
				/* Featured Image */
				if(has_post_thumbnail()) { ?>
				<div class="post-thumbnail">
					<a href="<?php the_permalink(); ?>">
						<?php the_post_thumbnail('thumbnail'); ?>
					</a>
				</div>
				<?php } ?>
				
				<span class="search-post-type">
				<?php if(get_post_type() == "post") { _e('Post', 'sntheme'); }
				else if(get_post_type() == "player") { _e('Player', 'sntheme'); }
				else if(get_post_type() == "fixture") { _e('Fixture', 'sntheme'); }
				else if(get_post_type() == "sn_gallery") { _e('Gallery', 'sntheme'); }
				else if(get_post_type() == "page") { _e('Page', 'sntheme'); } ?>
				</span>
				<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
				<?php the_excerpt(); ?>
				<a href="<?php the_permalink(); ?>"><?php _e('View More', 'sntheme'); ?></a>
				
			</article>
		
		<?php endwhile; ?>
	
		<?php get_template_part('parts/pagination', ''); ?>
				
	<?php else : ?>
		
		<div id="content" class="fullwidth">
		
			<?php get_template_part('parts/notfound', ''); ?>
			
		</div>
					
	<?php endif; ?>
		
	</div>
	
<?php if(isset($theme_options['sidebar_on_archive'])) { if($theme_options['sidebar_on_archive']) { get_sidebar(); } } ?>
<?php get_footer(); ?>