<?php
/* Template for Homepage if custom page not set */

get_header(); 
global $theme_options; ?>

	<div id="main">
		<div class="container">

		<div id="content" class="<?php if(isset($theme_options['sidebar_on_archive'])) { if($theme_options['sidebar_on_archive']) { } else { echo ' fullwidth'; } } if(!is_active_sidebar('sidebar')) { echo ' fullwidth'; } ?>">

	<?php if ( have_posts() ) : ?>

		<?php while ( have_posts() ) : the_post(); ?>
			
		<article id="post-<?php the_ID(); ?>" <?php post_class('post-archive'); ?>>
			
			<?php
			/* Featured Image */
			if(has_post_thumbnail()) { ?>
			<div class="post-thumbnail">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail('post-image'); ?>
				</a>
			</div>
			<?php } ?>
			
			<h2><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(sprintf(__('Permalink to %s', 'sntheme'), the_title_attribute('echo=0'))); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
			
			<?php if(get_post_type() == "post") { ?>
			<p class="entry-meta">
				<i class="fa fa-icon-time"></i> <?php the_time(get_option('date_format')); ?>
				&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;
				<i class="fa fa-icon-user"></i> <?php the_author(); ?> 
				&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;
				<i class="fa fa-icon-folder-open"></i> <?php the_category(', '); ?> 
				<?php if($post->comment_status == 'open') { ?>
				&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;
				<i class="fa fa-icon-comments"></i> <?php comments_popup_link(__('No Comments', 'sntheme'), __('1 Comment', 'sntheme'), __('% Comments', 'sntheme'), 'comments-link', __('Comments are disabled', 'sntheme')); ?>
				<?php } ?>
			</p>
			<?php } ?>
			
			<?php the_content(__('Continue Reading', 'sntheme')); ?>
			
		</article>
		
		<?php endwhile; ?>
		
		<?php get_template_part('parts/pagination', ''); ?>
	
	<?php else : 
		
		get_template_part('parts/notfound', '');
		
	endif; ?>
	
	</div>
	
<?php if(isset($theme_options['sidebar_on_archive'])) { if($theme_options['sidebar_on_archive']) { get_sidebar(); } } ?>
<?php get_footer(); ?>