<!doctype html>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" lang="en"> <![endif]-->
<!--[if IE 9]>    <html class="no-js ie9" lang="en"> <![endif]-->
<!--[if gt IE 9]><!--><html <?php language_attributes(); ?>><!--<![endif]-->
<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	
	<title><?php bloginfo('name'); ?> <?php wp_title(); ?></title>
	
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	
	<?php wp_head(); ?>
	
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/modernizr.js" type="text/javascript"></script>
	<link href="<?php echo get_template_directory_uri(); ?>/css/ie.css" rel="stylesheet" type="text/css" media="screen" title="stylesheet" />
	<![endif]-->
        <script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-37617753-1', 'auto');
  ga('send', 'pageview');

</script>
<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<script>
  (adsbygoogle = window.adsbygoogle || []).push({
    google_ad_client: "ca-pub-4819545192423860",
    enable_page_level_ads: true
  });
</script>
</head>
<body <?php body_class(); ?>>
<?php global $theme_options; ?>

	<header id="site-header">
		<div class="container">
		
		<?php if($theme_options['site_logo']) { 
		/* Show Logo */ ?>
		
			<a href="<?php echo home_url(); ?>" class="logo">
				<img src="<?php echo $theme_options['site_logo']; ?>" alt="<?php bloginfo('name'); ?>" />
			</a>
		
		<?php } else if($theme_options['alternative_site_title']) {
		/* Show Alternative Title */ ?>
		
			<<?php if(is_front_page()) { echo 'h1'; } else { echo 'h2'; } ?> class="site-title"><a href="<?php echo home_url(); ?>"><?php echo $theme_options['alternative_site_title']; ?></a></<?php if(is_front_page()) { echo 'h1'; } else { echo 'h2'; } ?>>
		
		<?php } else {
		/* Show Site Title */ ?>
		
			<<?php if(is_front_page()) { echo 'h1'; } else { echo 'h2'; } ?> class="site-title"><a href="<?php echo home_url(); ?>"><?php bloginfo('name'); ?></a></<?php if(is_front_page()) { echo 'h1'; } else { echo 'h2'; } ?>>
		
		<?php } ?>		
		
			<div class="right">
			
			<?php
				/* Search */
				if(isset($theme_options['disable_search'])) {
					if($theme_options['disable_search'] == 1) { $disable_search = 1; }
				}
				if(isset($disable_search)) { } else { ?>
				<form class="search-form" method="get" action="<?php echo home_url(); ?>">
					<input type="text" name="s" value="" placeholder="<?php _e('Search', 'sntheme'); ?>" />
					<input type="submit" value="<?php _e('Search', 'sntheme'); ?>" />
				</form>
				<a href="#" class="show-search"><i class="fa fa-search"></i></a>
				<?php }
				
				/* Social Icons */
				$repeater_prefix = 'header_social_link_';
				$i = 0; while($i < 100) { $i++;
					
					if(isset($theme_options[$repeater_prefix.'service'.'__'.$i])) {
						
						$link = 'http://'.str_replace('http://', '', $theme_options['header_social_link_link__'.$i]);
						$service = $theme_options['header_social_link_service__'.$i];
						
						echo '<a target="_blank" href="'.$link.'" class="social-'.str_replace('fontello-', '', $service).'"><i class="'.$service.'"></i></a>';
						
					}
					
				}
				
				/* Show Menu for mobile */
				if(has_nav_menu('main-menu')) { ?>
				<a href="#" class="toggle-nav"><i class="fa fa-bars"></i></a>
				<?php } ?>
			</div>
		</div>
		<div class="clearfix"></div>
	</header><!-- end site header -->
	
	
	<nav id="site-nav">
		<div class="container">
		
			<?php
			/* Nav Menu */
			if(has_nav_menu('main-menu')) {
				wp_nav_menu( array( 'container_class' => 'menu', 'theme_location' => 'main-menu', 'menu_class' => 'the-menu' ) ); 
			}
			
			/* Next Fixure */
			$fixtures = get_posts('post_type=fixture&posts_per_page=-1&orderby=meta_value&meta_key=fixture_date&order=ASC');
			$show_fixture = 1;
			$next_fixtures = array();
			foreach($fixtures as $fixture) {
				if(get_post_meta($fixture->ID, 'fixture_date', true) >= date('Ymd')) {
					$fixture_seconds = date("U", strtotime(get_post_meta($fixture->ID, 'fixture_date', true).' '.get_post_meta($fixture->ID, 'fixture_time', true)));
					$next_fixtures[$fixture_seconds] = array($fixture_seconds, $fixture->ID);
				}
			}
			ksort($next_fixtures);
			if(isset($next_fixtures)) {
				$i = 0;
				foreach($next_fixtures as $next_fixture) {
				$fixture_seconds = date("U", strtotime(get_post_meta($next_fixture[1], 'fixture_date', true).' '.get_post_meta($next_fixture[1], 'fixture_time', true)));
				if($fixture_seconds > date('U')) {
				$i++; if($i == 1) {
				query_posts('post_type=fixture&p='.$next_fixture[1]);
				while(have_posts()) : the_post();
					$fixture = $post;
					//$show_fixture = 0; ?>
					<a href="<?php echo get_permalink($fixture->ID); ?>" class="next-fixture">
						<span class="label"><?php if(isset($theme_options['next_fixture_heading'])) { echo $theme_options['next_fixture_heading']; } else { _e('Next Fixture', 'sntheme'); } ?></span>
						<span class="teams">
							<?php echo get_post_meta($fixture->ID, 'fixture_home_team_name', true); ?> 
							<?php if(sn_evergreen_sports_date_is_vs()) { ?>
							<span>vs.</span> <?php echo get_post_meta($fixture->ID, 'fixture_away_team_name', true); ?>
							<?php } ?>
							</span>
						<?php if(get_post_meta($fixture->ID, 'fixture_date', true)) {
							$fixture_date = str_split(get_post_meta($fixture->ID, 'fixture_date', true));
							$fixture_date = date(sn_evergreen_sports_date_format(), strtotime($fixture_date[0].$fixture_date[1].$fixture_date[2].$fixture_date[3].'-'.$fixture_date[4].$fixture_date[5].'-'.$fixture_date[6].$fixture_date[7]));
						} ?>
						<span class="sub"><?php
							if(isset($fixture_date)) { echo $fixture_date; }
							if(get_post_meta($fixture->ID, 'fixture_time', true)) {
								echo ', '.get_post_meta($fixture->ID, 'fixture_time', true);
							}
							if(get_post_meta($fixture->ID, 'fixture_location', true)) {
								_e(' at ', 'sntheme'); echo get_post_meta($fixture->ID, 'fixture_location', true);
							} ?>
						</span>
					</a>
			<?php endwhile; wp_reset_query(); } } } } ?>
			
		</div>
	</nav><!-- end site nav -->