<?php 
/* Template for Archives, eg, categories, tags, dates etc. */

get_header(); 
global $theme_options; ?>
	
	<?php if ( have_posts() ) : ?>

	<div id="page-banner">
		<div class="container">
		<h1><?php
		if(is_category()) {
			single_cat_title();
		} else if(is_tag()) {
			_e('Posts Tagged', 'sntheme'); echo '&#8216;'; single_tag_title(); echo '&#8217;';
		} else if(is_author()) {
			_e( 'Author Archive', 'sntheme' );
		} else if(is_day()) {
			printf(__('Daily Archives: %s', 'sntheme'), get_the_date());
		} else if(is_month()) {
			printf(__('Monthly Archives: %s', 'sntheme'), get_the_date(_x( 'F Y', 'monthly archives date format', 'sntheme')));
		} else if(is_year()) {
			printf(__('Yearly Archives: %s', 'sntheme'), get_the_date(_x('Y', 'yearly archives date format', 'sntheme')));
		} else {
			_e('Archives', 'sntheme');	
		} ?></h1>
		<?php if(category_description()) { echo '<p>'.category_description().'</p>'; } ?>
		</div>
	</div>

	<div id="main">
		<div class="container">

		<div id="content" class="<?php if(isset($theme_options['sidebar_on_archive'])) { if($theme_options['sidebar_on_archive']) { } else { echo ' fullwidth'; } } if(!is_active_sidebar('sidebar')) { echo ' fullwidth'; } ?>">

		<?php while ( have_posts() ) : the_post(); ?>
			
		<article id="post-<?php the_ID(); ?>" <?php post_class('post-archive'); ?>>
			
			<?php
			/* Featured Image */
			if(has_post_thumbnail()) { ?>
			<div class="post-thumbnail">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail('post-image'); ?>
				</a>
			</div>
			<?php } ?>
			
			<h2><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(sprintf(__('Permalink to %s', 'sntheme'), the_title_attribute('echo=0'))); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
			
			<?php if(get_post_type() == "post") { ?>
			<p class="entry-meta">
				<span class="entry-meta-date">
					<i class="fa fa-icon-time"></i> <?php the_time(get_option('date_format')); ?>
					<span>&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;</span>
				</span>
				<span class="entry-meta-author">
					<i class="fa fa-icon-user"></i> <?php the_author(); ?> 
					<span>&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;</span>
				</span>
				<span class="entry-meta-category">
					<i class="fa fa-icon-folder-open"></i> <?php the_category(', '); ?> 
				</span>
				<span class="entry-meta-comments">				
					<?php if($post->comment_status == 'open') { ?>
						<span>&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;</span>
						<i class="fa fa-icon-comments"></i> <?php comments_popup_link(__('No Comments', 'sntheme'), __('1 Comment', 'sntheme'), __('% Comments', 'sntheme'), 'comments-link', __('Comments are disabled', 'sntheme')); ?>
					<?php } ?>
				</span>
			</p>
			<?php } ?>
			
			<?php the_content(__('Continue Reading', 'sntheme')); ?>
			
		</article>
		
		<?php endwhile; ?>
		
		<?php get_template_part('parts/pagination', ''); ?>
	
	<?php else : 
		
		get_template_part('parts/notfound', '');
		
	endif; ?>
	
	</div>
	
<?php if(isset($theme_options['sidebar_on_archive'])) { if($theme_options['sidebar_on_archive']) { get_sidebar(); } } ?>
<?php get_footer(); ?>