<?php 

/* Create Widget Ready Areas */

	function sntheme_widgets_init() {
		register_sidebar(array(
			'name'          => __( 'General Sidebar', 'sntheme' ),
			'id'            => 'sidebar',
			'description'   => __( 'Shows on all pages, posts etc. except the home page', 'sntheme' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>'
		));
		register_sidebar(array(
			'name'          => __( 'Home Sidebar', 'sntheme' ),
			'id'            => 'home-sidebar',
			'description'   => __( 'Shows on the right of the home page content', 'sntheme' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>'
		));
		register_sidebar(array(
			'name'          => __( 'Home Widgets', 'sntheme' ),
			'id'            => 'home-widgets',
			'description'   => __( 'Shows underneath the home page content', 'sntheme' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>'
		));
		register_sidebar(array(
			'name'          => __( 'Home Widgets1', 'sntheme' ),
			'id'            => 'home-widgets1',
			'description'   => __( 'Shows underneath the home page content', 'sntheme' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>'
		));
		register_sidebar(array(
			'name'          => __( 'Bottom Widgets', 'sntheme' ),
			'id'            => 'bottom-widgets',
			'description'   => __( 'Shows in the footer area throughout the website', 'sntheme' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>'
		));
	}
	add_action( 'widgets_init', 'sntheme_widgets_init' );
	

/* Add Scripts */

	function sntheme_widgets_scripts() {
		if(isset(get_current_screen()->base)) { if(get_current_screen()->base == "widgets") {
			sn_include_scripts(array('sortable', 'admin'));
		} }
	}
	add_action( 'admin_enqueue_scripts', 'sntheme_widgets_scripts' );
	

/* Top Players */
	class sntheme_top_players_widget extends WP_Widget {
	
		public function __construct() {
			parent::__construct(
		 		'sntheme_top_players_widget',
				__( 'ES - Top Players', 'sntheme' ), 
				array( 'description' => __( '', 'sntheme' ) )
			);
		}
	
		public function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'sntheme_top_players_widget', $instance['title'] );
			$player_names = array();
			$player_scores = array();
			$i = 0;
			while($i < 10) { $i++;
				$player_names[$i] = apply_filters( 'sntheme_top_players_widget', $instance['player_'.$i] );
				$player_scores[$i] = apply_filters( 'sntheme_top_players_widget', $instance['player_'.$i.'_number'] );
			}
			
			echo $before_widget;
			
				if(!empty($title)) { echo $before_title . $title . $after_title; } ?>
					
				<ul class="top-scorers">
				<?php $i = 0; foreach($player_names as $player) { $i++; if($player) { ?>
					<li><span><?php echo $player; ?></span><?php if(isset($player_scores[$i])) { echo $player_scores[$i]; } ?></li>
				<?php } } ?>
				</ul>	
					
				<?php 
			
			echo $after_widget;
		}
	
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = strip_tags( $new_instance['title'] );
			$i = 0;
			while($i < 10) { $i++;
				$instance['player_'.$i] = strip_tags( $new_instance['player_'.$i] );
				$instance['player_'.$i.'_number'] = strip_tags( $new_instance['player_'.$i.'_number'] );
			}
			return $instance;
		}
	
		public function form( $instance ) {
			// Form Data
			if(isset($instance['title'])) { $title = $instance[ 'title' ]; } else { $title = __( 'Top Players', 'snplugin' ); }
			
			$player_names = array();
			$player_scores = array();
			$i = 0;
			while($i < 10) { $i++;
				if(isset($instance['player_'.$i])) { $player_names[$i] = $instance['player_'.$i]; } else { $player_names[$i] = ''; }
				if(isset($instance['player_'.$i.'_number'])) { $player_scores[$i] = $instance['player_'.$i.'_number']; } else { $player_scores[$i] = ''; }
			}
			
			$random_string = "sn-widget-sortable-".rand(10,10000);
			
			// Form
			?>
			
			<script type="text/javascript">
				jQuery(function() {
					jQuery('.<?php echo $random_string; ?> ul').sortable({handle: ".handle", stop: function( event, ui ) {
						var input_name = jQuery(this).parentsUntil('.widget-content').parent('.widget-content').find('input.widefat').eq(0).attr('name');
						var sort_id = 0;
						jQuery('.<?php echo $random_string; ?> ul li').each(function() {
							sort_id++;
							jQuery(this).find('input').eq(0).attr({"name":input_name.replace('title', 'player_'+sort_id)});
							jQuery(this).find('input').eq(1).attr({"name":input_name.replace('title', 'player_'+sort_id+'_number')});
						});
					}});
				});
			</script>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'sntheme' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			
			
			<label><?php _e( 'Players:', 'sntheme' ); ?></label>
			<div class="sn-widget-sortable sn-widget-sortable-top-players <?php echo $random_string; ?>">
				<ul>
				<?php
				
				$i = 0;
				while($i < 10) { $i++; ?>
				
					<li>
						<span class="handle"></span>
						<input type="text" name="<?php echo $this->get_field_name( 'player_'.$i ); ?>" value="<?php if(isset($player_names[$i])) { echo $player_names[$i]; } ?>" placeholder="Player Name" />
						<input type="text" name="<?php echo $this->get_field_name( 'player_'.$i.'_number' ); ?>" class="number" value="<?php if(isset($player_scores[$i])) { echo $player_scores[$i]; } ?>" />
					</li>
				
				<?php } ?>
				</ul>
			</div>
			
			<?php
			
		}
	
	}
	add_action( 'widgets_init', create_function( '', 'register_widget( "sntheme_top_players_widget" );' ) );
	

/* Latest Posts */

	class sntheme_latest_posts_widget extends WP_Widget {
	
		public function __construct() {
			parent::__construct(
		 		'sntheme_latest_posts_widget',
				__( 'ES - Latest Posts', 'sntheme' ), 
				array( 'description' => __( '', 'sntheme' ) )
			);
		}
	
		public function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'sntheme_latest_posts_widget', $instance['title'] );
			$number = apply_filters( 'sntheme_latest_posts_widget', $instance['number'] );
			
			echo $before_widget;
			
				if($number == "") { $number = 3; }
				if(!empty($title)) { echo $before_title . $title . $after_title; } ?>
					
				<ul class="latest-posts">
				<?php $posts = get_posts('posts_per_page='.$number.'');
				foreach($posts as $post) { ?>
					<li>
						<?php $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail' );
						if($thumb[0]) { ?>
							<a href="<?php echo get_permalink($post->ID); ?>"><img src="<?php echo $thumb[0]; ?>" alt="" /></a>
						<?php } ?>
						<span class="date"><?php echo get_the_time(get_option('date_format'), $post->ID); ?></span>
						<a href="<?php echo get_permalink($post->ID); ?>"><?php echo $post->post_title; ?></a>
					</li>
				<?php } ?>
				</ul>	
					
				<?php			
			echo $after_widget;
		}
	
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['number'] = strip_tags( $new_instance['number'] );
			return $instance;
		}
	
		public function form( $instance ) {
			// Form Data
			if(isset($instance['title'])) { $title = $instance[ 'title' ]; } else { $title = __( 'Latest Posts', 'snplugin' ); }
			if(isset($instance['number'])) { $number = $instance[ 'number' ]; } else { $number = 3; }
			
			// Form
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'sntheme' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number to show:', 'sntheme' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
			</p>
			<?php
		}
	
	}
	add_action( 'widgets_init', create_function( '', 'register_widget( "sntheme_latest_posts_widget" );' ) );


/* Upcoming Fixtures */

	class sntheme_upcoming_fixtures_widget extends WP_Widget {
	
		public function __construct() {
			parent::__construct(
		 		'sntheme_upcoming_fixtures_widget',
				__( 'ES - Upcoming Fixtures', 'sntheme' ), 
				array( 'description' => __( '', 'sntheme' ) )
			);
		}
	
		public function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'sntheme_upcoming_fixtures_widget', $instance['title'] );
			$season = apply_filters( 'sntheme_upcoming_fixtures_widget', $instance['season'] );
			$team = apply_filters( 'sntheme_upcoming_fixtures_widget', $instance['team'] );
			
			echo $before_widget;
			
				if(!empty($title)) { echo $before_title . $title . $after_title; }
				
				echo '<div class="upcoming-fixtures" current="0"><ul>';
				
				$args = array(
					'post_type' => 'fixture',
					'posts_per_page' => -1,
					'order_by' => 'meta_value',
					'meta_key' => 'fixture_date',
					'order' => 'ASC'
				);
				if($season && $team) {
					$args['tax_query'] = array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'season',
							'field' => 'id',
							'terms' => $season
						), 
						array(
							'taxonomy' => 'team',
							'field' => 'id',
							'terms' => $team
						)
					);
				} else if($season) {
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'season',
							'field' => 'id',
							'terms' => $season
						)
					);
				} else if($team) {
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'team',
							'field' => 'id',
							'terms' => $team
						)
					);
				}
				$fixtures = get_posts($args);
				$next_fixtures = array();
				foreach($fixtures as $fixture) {
					if(get_post_meta($fixture->ID, 'fixture_date', true) >= date('Ymd')) {
						$fixture_seconds = date("U", strtotime(get_post_meta($fixture->ID, 'fixture_date', true).' '.get_post_meta($fixture->ID, 'fixture_time', true)));
						$next_fixtures[$fixture_seconds] = array($fixture_seconds, $fixture->ID);
					}
				}
				ksort($next_fixtures);
				if(isset($next_fixtures)) {
				$i = 0;
				foreach($next_fixtures as $next_fixture) {
				$fixture_seconds = date("U", strtotime(get_post_meta($next_fixture[1], 'fixture_date', true).' '.get_post_meta($next_fixture[1], 'fixture_time', true)));
				if($fixture_seconds > date('U')) {
				$i++;
				query_posts('post_type=fixture&p='.$next_fixture[1]);
				while(have_posts()) : the_post(); global $post;
					$fixture = $post;
					
				?>
				<li>	
					
					<?php if(get_post_meta($fixture->ID, 'fixture_date', true)) {
						$fixture_date = str_split(get_post_meta($fixture->ID, 'fixture_date', true));
						$fixture_date = date(sn_evergreen_sports_date_format(), strtotime($fixture_date[0].$fixture_date[1].$fixture_date[2].$fixture_date[3].'-'.$fixture_date[4].$fixture_date[5].'-'.$fixture_date[6].$fixture_date[7]));
					} ?>
				
					<a href="<?php echo get_permalink(); ?>"><span class="team-name"><?php echo get_post_meta($fixture->ID, 'fixture_home_team_name', true); ?></span>
					<span class="vs">vs.</span>
					<span class="team-name away-team"><?php echo get_post_meta($fixture->ID, 'fixture_away_team_name', true); ?></span></a>
					
					<?php if(get_post_meta($fixture->ID, 'fixture_location', true)) { ?>
					<span class="location"><i class="fa fa-map-marker"></i> <?php echo get_post_meta($fixture->ID, 'fixture_location', true); ?></span>
					<?php } ?>
					<span class="date"><i class="fa fa-clock-o"></i> 
					<?php if(isset($fixture_date)) { echo $fixture_date; }
					if(get_post_meta($fixture->ID, 'fixture_time', true)) {
						echo ', '.get_post_meta($fixture->ID, 'fixture_time', true);
					} ?></span>
									
				</li>
				
				<?php
				endwhile; wp_reset_query();
				} } }
				
				if(empty($next_fixtures)) {
					echo '<li class="none">No upcoming fixtures</li></ul></div>';
				} else {
				
				echo '</ul>
						<div class="fixtures-nav">
							<a href="#" class="sn-button fixture-prev"><i class="fa fa-angle-left"></i></a>
							<span class="divider"></span>
							<a href="#" class="sn-button fixture-next"><i class="fa fa-angle-right"></i></a>
						</div>
					</div>';
				
				}
				
			echo $after_widget;
		}
	
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['season'] = strip_tags( $new_instance['season'] );
			$instance['team'] = strip_tags( $new_instance['team'] );
			$instance['button_text'] = strip_tags( $new_instance['button_text'] );
			return $instance;
		}
	
		public function form( $instance ) {
			// Form Data
			if(isset($instance['title'])) { $title = $instance[ 'title' ]; } else { $title = __( 'Upcoming Fixtures', 'sntheme' ); }
			if(isset($instance['season'])) { $season = $instance[ 'season' ]; } else { $season = ''; }
			if(isset($instance['team'])) { $team = $instance[ 'team' ]; } else { $team = ''; }
			if(isset($instance['button_text'])) { $button_text = $instance[ 'button_text' ]; } else { $button_text = 'View Details'; }
			
			// Form
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'sntheme' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'season' ); ?>"><?php _e( 'Season:', 'sntheme' ); ?></label> 
				<select class="widefat" id="<?php echo $this->get_field_id( 'season' ); ?>" name="<?php echo $this->get_field_name( 'season' ); ?>">
					<option value="">All Seasons</option>
				<?php
				$terms = get_terms("season");
				$count = count($terms);
				if($count > 0) { foreach ( $terms as $term ) {
					if($season == $term->term_id) {
						echo '<option selected="selected" value="'.$term->term_id.'">'.$term->name.'</option>';
					} else {
						echo '<option value="'.$term->term_id.'">'.$term->name.'</option>';
					}
				} } ?>
				</select>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'team' ); ?>"><?php _e( 'Team:', 'sntheme' ); ?></label> 
				<select class="widefat" id="<?php echo $this->get_field_id( 'team' ); ?>" name="<?php echo $this->get_field_name( 'team' ); ?>">
					<option value="">All Teams</option>
				<?php
				$terms = get_terms("team");
				$count = count($terms);
				if($count > 0) { foreach ( $terms as $term ) {
					if($team == $term->term_id) {
						echo '<option selected="selected" value="'.$term->term_id.'">'.$term->name.'</option>';
					} else {
						echo '<option value="'.$term->term_id.'">'.$term->name.'</option>';
					}
				} } ?>
				</select>
			</p>
			<?php
		}
	
	}
	add_action( 'widgets_init', create_function( '', 'register_widget( "sntheme_upcoming_fixtures_widget" );' ) );



/* Players */

	class sntheme_players_widget extends WP_Widget {
	
		public function __construct() {
			parent::__construct(
		 		'sntheme_players_widget',
				__( 'ES - Players', 'sntheme' ), 
				array( 'description' => __( '', 'sntheme' ) )
			);
		}
	
		public function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'sntheme_players_widget', $instance['title'] );
			$team = apply_filters( 'sntheme_players_widget', $instance['team'] );
			
			echo $before_widget;
			
				if(!empty($title)) { echo $before_title . $title . $after_title; } ?>
			
				<div class="players" current="0">
					<ul>
					<?php
					$args = array(
						'posts_per_page' => -1,
						'post_type' => 'player',
						'order_by' => 'name',
						'order' => 'ASC'
					);
					if($team) {
						$args['tax_query'] = array(
							array(
								'taxonomy' => 'team',
								'field' => 'id',
								'terms' => $team
							)
						);
					}
					$players = get_posts($args);
					foreach($players as $player) {
						if(has_post_thumbnail($player->ID)) {
							$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($player->ID), 'large-thumb' );
							$image = $thumb['0'];
						} else {
							global $sn_sports_club_manager_directory;
							$image = $sn_sports_club_manager_directory.'/images/player-thumb.jpg';
						} ?>
						<li>
							<a class="player-photo">
								<img src="<?php echo $image; ?>" alt="" />
								<span class="player-text">
									<span class="player-name"><?php echo $player->post_title; ?></span>
									<span class="player-position"><?php echo get_post_meta($player->ID, 'player_position', true); ?></span>								
								</span>
							</a>
						</li>
					<?php } ?>
					</ul>
					<div class="players-nav">
						<a href="#" class="sn-button player-nav player-prev"><i class="fa fa-angle-left"></i></a>
						<span class="divider"></span>
						<a href="#" class="sn-button player-nav player-next"><i class="fa fa-angle-right"></i></a>
					</div>
				</div>
				
			<?php
			echo $after_widget;
		}
	
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['team'] = strip_tags( $new_instance['team'] );
			return $instance;
		}
	
		public function form( $instance ) {
			// Form Data
			if(isset($instance['title'])) { $title = $instance[ 'title' ]; } else { $title = __( 'Players', 'sntheme' ); }
			if(isset($instance['team'])) { $team = $instance[ 'team' ]; } else { $team = ''; }
			
			// Form
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'sntheme' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'team' ); ?>"><?php _e( 'Team:', 'sntheme' ); ?></label> 
				<select class="widefat" id="<?php echo $this->get_field_id( 'team' ); ?>" name="<?php echo $this->get_field_name( 'team' ); ?>">
					<option value="">All Teams</option>
				<?php
				$terms = get_terms("team");
				$count = count($terms);
				if($count > 0) { foreach ( $terms as $term ) {
					if($team == $term->term_id) {
						echo '<option selected="selected" value="'.$term->term_id.'">'.$term->name.'</option>';
					} else {
						echo '<option value="'.$term->term_id.'">'.$term->name.'</option>';
					}
				} } ?>
				</select>
			</p>

			<?php
		}
	
	}
	add_action( 'widgets_init', create_function( '', 'register_widget( "sntheme_players_widget" );' ) );


/* Gallery */

	class sntheme_gallery_widget extends WP_Widget {
	
		public function __construct() {
			parent::__construct(
		 		'sntheme_gallery_widget',
				__( 'ES - Gallery', 'sntheme' ), 
				array( 'description' => __( '', 'sntheme' ) )
			);
		}
	
		public function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'sntheme_gallery_widget', $instance['title'] );
			$gallery_id = apply_filters( 'sntheme_gallery_widget', $instance['gallery'] );
			
			echo $before_widget;
			
				if(!empty($title)) { echo $before_title . $title . $after_title; }

				if($gallery_id) {
					$gallery = get_posts('post_type=sn_gallery&posts_per_page=1&p='.$gallery_id);
				} else {
					$gallery = get_posts('post_type=sn_gallery&posts_per_page=1');
				}
				$gallery = $gallery[0];
				
				if(has_post_thumbnail($gallery->ID)) {
					$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($gallery->ID), 'large-thumb' );
					$image = $thumb['0'];
				} else {
					$post_content = $gallery->post_content;
					preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $gallery_ids);
					if(isset($gallery_ids[1])) {
						$gallery_images = explode(",", $gallery_ids[1]);
						if(!empty($gallery_images)) { $gallery_count = count($gallery_images); }
					} else {
						$gallery_atts = array(
							'post_parent' => $gallery->ID, 
							'post_mime_type' => 'image', 
							'order'=> 'ASC'
						);
						$gallery_images = array();
						$gallery_image_posts = get_children($gallery_atts);
						foreach($gallery_image_posts as $gallery_image_post) {
							$gallery_images = $gallery_image_post->ID;
						}
						if(!empty($gallery_images)) { $gallery_count = count($gallery_images); }
					}
					$gallery_image = $gallery_images[0];
					$gallery_image = get_post($gallery_image); 
					if(isset($gallery_image->ID)) {
						$image = wp_get_attachment_image_src($gallery_image->ID, 'large-thumb');
						$image = $image[0];
					}
				} 
				
				?>
				
				<div class="sn-gallery-widget">
					<a href="<?php echo get_permalink($gallery->ID); ?>">
						<img src="<?php echo $image; ?>" alt="" />
						<span class="gallery-text">
							<span class="gallery-title"><?php echo $gallery->post_title; ?></span>
							<?php if(isset($gallery_count)) { ?><span class="gallery-count"><i class="fa fa-camera"></i> <?php echo $gallery_count; _e(' images', 'sntheme'); ?></span><?php } ?>							
						</span>
					</a>
				</div>
				
				<?php
			
			echo $after_widget;
		}
	
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['gallery'] = strip_tags( $new_instance['gallery'] );
			return $instance;
		}
	
		public function form( $instance ) {
			// Form Data
			if(isset($instance['title'])) { $title = $instance[ 'title' ]; } else { $title = __( 'Latest Gallery', 'sntheme' ); }
			if(isset($instance['gallery'])) { $gallery = $instance[ 'gallery' ]; } else { $gallery = ''; }
			
			// Form
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'sntheme' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'gallery' ); ?>"><?php _e( 'Gallery:', 'sntheme' ); ?></label> 
				<select class="widefat" id="<?php echo $this->get_field_id( 'gallery' ); ?>" name="<?php echo $this->get_field_name( 'gallery' ); ?>">
					<option value="">Latest Gallery</option>
				<?php
				$galleries = get_posts('post_type=sn_gallery&posts_per_page=-1&orderby=name&order=ASC');
				foreach($galleries as $list_gallery) {
					if($gallery == $list_gallery->ID) {
						echo '<option selected="selected" value="'.$list_gallery->ID.'">'.$list_gallery->post_title.'</option>';
					} else {
						echo '<option value="'.$list_gallery->ID.'">'.$list_gallery->post_title.'</option>';
					}
				} ?>
				</select>
			</p>
			<?php
		}
	
	}
	add_action( 'widgets_init', create_function( '', 'register_widget( "sntheme_gallery_widget" );' ) );
